/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.ChildCodecRegistry;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class RootCodecRegistry
implements CodecRegistry {
    private final ConcurrentMap<Class<?>, Codec<?>> codecs = new ConcurrentHashMap();
    private final List<CodecProvider> codecProviders;
    private final Map<Class<?>, Codec<?>> codecMap;

    public RootCodecRegistry(List<? extends CodecProvider> codecProviders) {
        this(new ArrayList<CodecProvider>(codecProviders), Collections.emptyMap());
    }

    private RootCodecRegistry(List<CodecProvider> codecProviders, Map<Class<?>, Codec<?>> codecMap) {
        this.codecProviders = codecProviders;
        this.codecMap = codecMap;
    }

    public <T> RootCodecRegistry withCodec(Codec<T> codec) {
        HashMap newCodecMap = new HashMap(this.codecMap);
        newCodecMap.put(codec.getEncoderClass(), codec);
        return new RootCodecRegistry(this.codecProviders, newCodecMap);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz) {
        return this.get(new ChildCodecRegistry<T>(this, clazz));
    }

    <T> Codec<T> get(ChildCodecRegistry context) {
        if (!this.codecs.containsKey(context.getCodecClass())) {
            Codec<Object> codec = this.codecMap.get(context.getCodecClass());
            if (codec == null) {
                codec = this.getCodecFromProviders(context);
            }
            if (codec == null) {
                throw new CodecConfigurationException(String.format("Can't find a codec for %s.", context.getCodecClass()));
            }
            this.codecs.putIfAbsent(context.getCodecClass(), codec);
        }
        return (Codec)this.codecs.get(context.getCodecClass());
    }

    private <T> Codec<T> getCodecFromProviders(ChildCodecRegistry<T> context) {
        for (CodecProvider provider : this.codecProviders) {
            Codec<T> result = provider.get(context.getCodecClass(), context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootCodecRegistry that = (RootCodecRegistry)o;
        if (!this.codecProviders.equals(that.codecProviders)) {
            return false;
        }
        return this.codecMap.equals(that.codecMap);
    }

    public int hashCode() {
        int result = this.codecProviders.hashCode();
        result = 31 * result + this.codecMap.hashCode();
        return result;
    }
}

