/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java.metadata;

import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.modeshape.sequencer.java.AbstractJavaMetadata;
import org.modeshape.sequencer.java.CompilationUnitParser;
import org.modeshape.sequencer.java.JavaMetadataUtil;
import org.modeshape.sequencer.java.metadata.ImportMetadata;
import org.modeshape.sequencer.java.metadata.PackageMetadata;
import org.modeshape.sequencer.java.metadata.TypeMetadata;

public class JavaMetadata
extends AbstractJavaMetadata {
    private PackageMetadata packageMetadata;
    private List<ImportMetadata> imports;
    private List<TypeMetadata> types;

    private JavaMetadata() {
    }

    public static JavaMetadata instance(InputStream inputStream, long length, String encoding) {
        JavaMetadata javaMetadata = new JavaMetadata();
        char[] source = null;
        try {
            source = JavaMetadataUtil.getJavaSourceFromTheInputStream(inputStream, length, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        CompilationUnit unit = (CompilationUnit)CompilationUnitParser.runJLS3Conversion(source, true);
        if (unit != null) {
            javaMetadata.packageMetadata = javaMetadata.createPackageMetadata(unit);
            javaMetadata.imports = javaMetadata.createImportMetadata(unit);
            javaMetadata.types = javaMetadata.createTypeMetadata(unit);
        }
        return javaMetadata;
    }

    public final PackageMetadata getPackageMetadata() {
        return this.packageMetadata;
    }

    public List<ImportMetadata> getImports() {
        return this.imports;
    }

    public List<TypeMetadata> getTypeMetadata() {
        return this.types;
    }
}

