/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Bson;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.internal.document.ArrayEditor;
import org.infinispan.schematic.internal.document.BsonUtils;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.ImmutableField;
import org.infinispan.schematic.internal.document.IndexSequence;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.schema.DocumentTransformer;

public class BasicArray
implements MutableArray {
    private static final long serialVersionUID = 1L;
    private final List<Object> values;

    public BasicArray() {
        this.values = new ArrayList<Object>();
    }

    public BasicArray(int initialCapacity) {
        this.values = initialCapacity > 0 ? new ArrayList<Object>(initialCapacity) : new ArrayList();
    }

    public BasicArray(List<Object> values) {
        this.values = values;
    }

    public BasicArray(Object ... values) {
        this.values = new ArrayList<Object>(Arrays.asList(values));
    }

    @Override
    public Object get(String name) {
        int index = this.indexFrom(name);
        return this.isValidIndex(index) ? this.values.get(index) : null;
    }

    @Override
    public boolean containsField(String name) {
        int index = this.indexFrom(name);
        return this.isValidIndex(index);
    }

    @Override
    public boolean containsAll(Document document) {
        if (document instanceof org.infinispan.schematic.document.Array) {
            return this.containsAll((List)((Object)document));
        }
        if (document != null) {
            for (Document.Field field : document.fields()) {
                Object thatValue;
                Object thisValue = this.get(field.getName());
                if (BsonUtils.valuesAreEqual(thisValue, thatValue = field.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        return new IndexSequence(this.size());
    }

    public Map<String, ?> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        for (String index : this.keySet()) {
            result.put(index, this.values.get(i++));
        }
        return result;
    }

    @Override
    public Iterable<Document.Field> fields() {
        return new Iterable<Document.Field>(){

            @Override
            public Iterator<Document.Field> iterator() {
                final Iterator<String> indexIter = IndexSequence.infiniteSequence();
                final Iterator valueIter = BasicArray.this.values.iterator();
                return new Iterator<Document.Field>(){

                    @Override
                    public boolean hasNext() {
                        return valueIter.hasNext();
                    }

                    @Override
                    public Document.Field next() {
                        return new ImmutableField((String)indexIter.next(), valueIter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.values.containsAll(c);
    }

    @Override
    public Object get(int index) {
        return this.values.get(index);
    }

    @Override
    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Iterable) {
            Iterable that = (Iterable)obj;
            Iterator<Object> thisIter = this.values.iterator();
            Iterator<Object> thatIter = null;
            if (obj instanceof List) {
                List thatList = (List)that;
                if (this.size() != thatList.size()) {
                    return false;
                }
                thatIter = thatList instanceof BasicArray ? ((BasicArray)thatList).values.iterator() : that.iterator();
            }
            assert (thatIter != null);
            while (thisIter.hasNext() && thatIter.hasNext()) {
                Object thatValue;
                Object thisValue = thisIter.next();
                if (BsonUtils.valuesAreEqual(thisValue, thatValue = thatIter.next())) continue;
                return false;
            }
            return !thisIter.hasNext() && !thatIter.hasNext();
        }
        if (obj.getClass().isArray()) {
            if (this.size() != Array.getLength(obj)) {
                return false;
            }
            Iterator<Object> thisIter = this.values.iterator();
            int index = 0;
            while (thisIter.hasNext()) {
                Object thatValue;
                Object thisValue = thisIter.next();
                if (BsonUtils.valuesAreEqual(thisValue, thatValue = Array.get(obj, index++))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Json.write(this);
    }

    @Override
    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return new BasicArray(this.values.subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.values.toArray(a);
    }

    @Override
    public Iterator<Object> iterator() {
        final Iterator<Object> delegate = this.values.iterator();
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public Object next() {
                return delegate.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterable<Array.Entry> getEntries() {
        return new Iterable<Array.Entry>(){

            @Override
            public Iterator<Array.Entry> iterator() {
                return new Iterator<Array.Entry>(){
                    private final Iterator<Object> valueIter;
                    private int index;
                    {
                        this.valueIter = BasicArray.this.values.iterator();
                        this.index = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.valueIter.hasNext();
                    }

                    @Override
                    public Array.Entry next() {
                        Object value = this.valueIter.next();
                        return new BasicEntry(this.index++, value);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Boolean getBoolean(String name) {
        Object value = this.get(name);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Object value = this.get(name);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    @Override
    public Integer getInteger(String name) {
        Object value = this.get(name);
        return value instanceof Integer ? (Integer)value : null;
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        Object value = this.get(name);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    @Override
    public Long getLong(String name) {
        Object value = this.get(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return new Long(((Integer)value).longValue());
        }
        return null;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Object value = this.get(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return defaultValue;
    }

    @Override
    public Double getDouble(String name) {
        Object value = this.get(name);
        return value instanceof Double ? (Double)value : null;
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Object value = this.get(name);
        return value instanceof Double ? (Double)value : defaultValue;
    }

    @Override
    public Number getNumber(String name) {
        Object value = this.get(name);
        return value instanceof Number ? (Number)((Number)value) : (Number)null;
    }

    @Override
    public Number getNumber(String name, Number defaultValue) {
        Object value = this.get(name);
        return value instanceof Number ? (Number)((Number)value) : (Number)defaultValue;
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public String getString(String name, String defaultValue) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Symbol) {
                return ((Symbol)value).getSymbol();
            }
        }
        return defaultValue;
    }

    @Override
    public List<?> getArray(String name) {
        Object value = this.get(name);
        return value instanceof List ? (List)value : null;
    }

    @Override
    public Document getDocument(String name) {
        Object value = this.get(name);
        return value instanceof Document ? (Document)value : null;
    }

    @Override
    public boolean isNull(String name) {
        return this.get(name) instanceof Null;
    }

    @Override
    public boolean isNullOrMissing(String name) {
        return Null.matches(this.get(name));
    }

    @Override
    public MaxKey getMaxKey(String name) {
        Object value = this.get(name);
        return value instanceof MaxKey ? (MaxKey)value : null;
    }

    @Override
    public MinKey getMinKey(String name) {
        Object value = this.get(name);
        return value instanceof MinKey ? (MinKey)value : null;
    }

    @Override
    public Code getCode(String name) {
        Object value = this.get(name);
        return value instanceof Code ? (Code)value : null;
    }

    @Override
    public CodeWithScope getCodeWithScope(String name) {
        Object value = this.get(name);
        return value instanceof CodeWithScope ? (CodeWithScope)value : null;
    }

    @Override
    public ObjectId getObjectId(String name) {
        Object value = this.get(name);
        return value instanceof ObjectId ? (ObjectId)value : null;
    }

    @Override
    public Binary getBinary(String name) {
        Object value = this.get(name);
        return value instanceof Binary ? (Binary)value : null;
    }

    @Override
    public Symbol getSymbol(String name) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof Symbol) {
                return (Symbol)value;
            }
            if (value instanceof String) {
                return new Symbol((String)value);
            }
        }
        return null;
    }

    @Override
    public Pattern getPattern(String name) {
        Object value = this.get(name);
        return value instanceof Pattern ? (Pattern)value : null;
    }

    @Override
    public UUID getUuid(String name) {
        return this.getUuid(name, null);
    }

    @Override
    public UUID getUuid(String name, UUID defaultValue) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof UUID) {
                return (UUID)value;
            }
            if (value instanceof String) {
                try {
                    return UUID.fromString((String)value);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @Override
    public int getType(String name) {
        return Bson.getTypeForValue(this.get(name));
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new UnmodifiableListIterator(this.values.listIterator());
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new UnmodifiableListIterator(this.values.listIterator(index));
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    protected final int indexFrom(String name) {
        return Integer.parseInt(name);
    }

    protected final boolean isValidIndex(int index) {
        return index >= 0 && index < this.size();
    }

    protected Object unwrap(Object value) {
        if (value instanceof DocumentEditor) {
            return this.unwrap(((DocumentEditor)value).unwrap());
        }
        if (value instanceof ArrayEditor) {
            return this.unwrap(((ArrayEditor)value).unwrap());
        }
        return value;
    }

    @Override
    public boolean addValueIfAbsent(Object value) {
        return !this.values.contains(value = this.unwrap(value)) ? this.values.add(value) : false;
    }

    @Override
    public int addValue(Object value) {
        value = this.unwrap(value);
        int index = this.values.size();
        this.values.add(index, value);
        return index;
    }

    @Override
    public void addValue(int index, Object value) {
        value = this.unwrap(value);
        this.values.add(index, value);
    }

    @Override
    public Object setValue(int index, Object value) {
        value = this.unwrap(value);
        return this.values.set(index, value);
    }

    @Override
    public boolean removeValue(Object value) {
        value = this.unwrap(value);
        return this.values.remove(value);
    }

    @Override
    public Object removeValue(int index) {
        return this.values.remove(index);
    }

    @Override
    public boolean addAllValues(Collection<?> values) {
        return this.values.addAll(values);
    }

    @Override
    public boolean addAllValues(int index, Collection<?> values) {
        return this.values.addAll(index, values);
    }

    @Override
    public List<Array.Entry> removeAllValues(Collection<?> valuesToBeRemoved) {
        return this.removeValues(valuesToBeRemoved, true);
    }

    @Override
    public List<Array.Entry> retainAllValues(Collection<?> valuesToBeRetained) {
        return this.removeValues(valuesToBeRetained, false);
    }

    private List<Array.Entry> removeValues(Collection<?> values, boolean ifMatch) {
        List<Array.Entry> results = null;
        ListIterator<Object> iter = this.values.listIterator(this.size());
        while (iter.hasNext()) {
            int index = iter.previousIndex();
            Object value = iter.previous();
            if (ifMatch != values.contains(value)) continue;
            iter.remove();
            if (results == null) {
                results = new LinkedList<Array.Entry>();
            }
            ((LinkedList)results).addFirst(new BasicEntry(index, value));
        }
        return results != null ? results : Collections.emptyList();
    }

    @Override
    public Object remove(String name) {
        int index = this.indexFrom(name);
        return this.isValidIndex(index) ? this.values.remove(index) : null;
    }

    @Override
    public void removeAll() {
        this.values.clear();
    }

    @Override
    public Object put(String name, Object value) {
        return this.put(this.indexFrom(name), value);
    }

    protected final Object put(int index, Object value) {
        int size = this.size();
        if (index == size) {
            this.values.add(value);
            return value;
        }
        return this.values.set(index, value);
    }

    @Override
    public void putAll(Document object) {
        if (object instanceof BasicArray) {
            BasicArray that = (BasicArray)object;
            this.values.addAll(that.values);
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        ArrayList<IndexEntry> sortableEntries = new ArrayList<IndexEntry>(map.size());
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            int index = this.indexFrom(entry.getKey());
            sortableEntries.add(new IndexEntry(index, entry.getValue()));
        }
        Collections.sort(sortableEntries);
        for (IndexEntry indexEntry : sortableEntries) {
            this.put(indexEntry.index, indexEntry.value);
        }
    }

    @Override
    public org.infinispan.schematic.document.Array clone() {
        BasicArray clone = new BasicArray();
        for (Object value : this) {
            if (value instanceof org.infinispan.schematic.document.Array) {
                value = ((org.infinispan.schematic.document.Array)value).clone();
            } else if (value instanceof Document) {
                value = ((Document)value).clone();
            }
            clone.addValue(value);
        }
        return clone;
    }

    @Override
    public org.infinispan.schematic.document.Array with(Map<String, Object> changedFields) {
        BasicArray clone = new BasicArray();
        for (Document.Field field : this.fields()) {
            String name = field.getName();
            Object newValue = changedFields.get(name);
            if (newValue != null) {
                clone.put(name, newValue);
                continue;
            }
            Object oldValue = field.getValue();
            clone.put(name, oldValue);
        }
        return clone;
    }

    @Override
    public org.infinispan.schematic.document.Array with(Document.ValueTransformer transformer) {
        boolean transformed = false;
        BasicArray clone = new BasicArray();
        for (Document.Field field : this.fields()) {
            String name = field.getName();
            Object oldValue = field.getValue();
            Object newValue = null;
            newValue = oldValue instanceof Document ? ((Document)oldValue).with(transformer) : transformer.transform(name, oldValue);
            if (newValue != oldValue) {
                transformed = true;
            }
            clone.put(name, newValue);
        }
        return transformed ? clone : this;
    }

    @Override
    public org.infinispan.schematic.document.Array withVariablesReplaced(Properties properties) {
        return this.with(new DocumentTransformer.PropertiesTransformer(properties));
    }

    @Override
    public org.infinispan.schematic.document.Array withVariablesReplacedWithSystemProperties() {
        return this.with(new DocumentTransformer.SystemPropertiesTransformer());
    }

    @Immutable
    protected static final class IndexEntry
    implements Comparable<IndexEntry> {
        protected final int index;
        protected final Object value;

        protected IndexEntry(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IndexEntry that) {
            return this.index - that.index;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IndexEntry) {
                IndexEntry that = (IndexEntry)obj;
                if (this.index != that.index) {
                    return false;
                }
                if (this.value == null) {
                    return that.value == null;
                }
                return this.value.equals(that.value);
            }
            return false;
        }

        public String toString() {
            return "[" + this.index + ',' + this.value + ']';
        }
    }

    @Immutable
    public static final class BasicEntry
    implements Array.Entry {
        private final int index;
        private final Object value;

        public BasicEntry(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Array.Entry o) {
            return o == this ? 0 : (o == null ? 1 : o.getIndex() - this.getIndex());
        }
    }

    protected static final class UnmodifiableListIterator
    implements ListIterator<Object> {
        private final ListIterator<Object> delegate;

        protected UnmodifiableListIterator(ListIterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public Object previous() {
            return this.delegate.previous();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }
    }
}

