/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.util.Util;

public class RemoveAllValuesOperation
extends ArrayOperation {
    protected final Collection<?> values;
    protected transient int[] actualIndexes;

    public RemoveAllValuesOperation(Path path, Collection<?> values) {
        super(path);
        this.values = values;
    }

    public Collection<?> getValuesToRemove() {
        return this.values;
    }

    public synchronized List<Array.Entry> getRemovedEntries() {
        ArrayList<Array.Entry> entries = new ArrayList<Array.Entry>(this.values.size());
        Iterator<?> valueIter = this.values.iterator();
        for (int i = 0; i != this.actualIndexes.length; ++i) {
            int index = this.actualIndexes[i];
            Object value = valueIter.next();
            entries.add(new BasicArray.BasicEntry(index, value));
        }
        return entries;
    }

    @Override
    public synchronized void rollback(MutableDocument delegate) {
        if (this.actualIndexes != null) {
            MutableArray array = this.mutableParent(delegate);
            int i = 0;
            for (Object value : this.values) {
                int index;
                if ((index = this.actualIndexes[i++]) == -1) continue;
                array.add(index, value);
            }
        }
    }

    @Override
    public synchronized void replay(MutableDocument delegate) {
        if (!this.values.isEmpty()) {
            this.actualIndexes = new int[this.values.size()];
            int i = 0;
            MutableArray array = this.mutableParent(delegate);
            for (Object value : this.values) {
                int actualIndex = array.indexOf(value);
                array.remove(actualIndex);
                this.actualIndexes[i++] = actualIndex;
            }
        } else {
            this.actualIndexes = null;
        }
    }

    public String toString() {
        return "Remove at '" + this.parentPath + "' the values: " + this.values;
    }

    public static class Externalizer
    extends AbstractExternalizer<RemoveAllValuesOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, RemoveAllValuesOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.values);
        }

        public RemoveAllValuesOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            Collection values = (Collection)input.readObject();
            return new RemoveAllValuesOperation(path, values);
        }

        public Integer getId() {
            return 1610;
        }

        public Set<Class<? extends RemoveAllValuesOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{RemoveAllValuesOperation.class});
        }
    }
}

