/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.util.Util;

public class PutOperation
extends Operation {
    protected final String fieldName;
    protected final Object oldValue;
    protected final Object newValue;

    public PutOperation(Path parentPath, String fieldName, Object oldValue, Object newValue) {
        super(parentPath);
        this.fieldName = fieldName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        if (this.oldValue == null) {
            parent.remove(this.fieldName);
        } else {
            parent.put(this.fieldName, this.oldValue);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        parent.put(this.fieldName, this.newValue);
    }

    public String toString() {
        return "Put at '" + this.parentPath + "' the '" + this.fieldName + "' field value '" + this.newValue + (this.oldValue != null ? "' (replaces '" + this.oldValue + "')" : "");
    }

    public static class Externalizer
    extends AbstractExternalizer<PutOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, PutOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeUTF(put.fieldName);
            output.writeObject(put.newValue);
        }

        public PutOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            String fieldName = input.readUTF();
            Object newValue = input.readObject();
            return new PutOperation(path, fieldName, null, newValue);
        }

        public Integer getId() {
            return 1602;
        }

        public Set<Class<? extends PutOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{PutOperation.class});
        }
    }
}

