/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.CorrespondenceId;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrMultiValueProperty;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrPropertyIterator;
import org.modeshape.jcr.JcrSingleValueProperty;
import org.modeshape.jcr.SessionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class JcrSharedNode
extends JcrNode {
    private AbstractJcrNode original;
    private AbstractJcrNode proxy;

    JcrSharedNode(AbstractJcrNode proxy, AbstractJcrNode original) {
        super(proxy.cache, original.nodeId, original.location);
        this.proxy = proxy;
        this.original = original;
        assert (proxy.cache == original.cache) : "Only able to share nodes within the same cache";
        assert (!proxy.isRoot()) : "The root node can never be a shared node";
        assert (!original.isRoot()) : "The root node can never be shareable";
    }

    AbstractJcrNode proxyNode() {
        return this.proxy;
    }

    AbstractJcrNode originalNode() {
        return this.original;
    }

    @Override
    boolean isShareable() {
        return this.original != null;
    }

    @Override
    boolean isShared() {
        return true;
    }

    @Override
    void setLocation(Location location) {
        this.proxyNode().setLocation(location);
    }

    @Override
    protected Location locationToDestroy() {
        return this.proxyNode().location();
    }

    @Override
    protected void doDestroy() throws AccessDeniedException, RepositoryException {
        this.proxyNode().editor().destroy();
    }

    @Override
    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> nodeInfo() throws InvalidItemStateException, AccessDeniedException, RepositoryException {
        return this.original.nodeInfo();
    }

    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> proxyInfo() throws InvalidItemStateException, AccessDeniedException, RepositoryException {
        return this.proxy.nodeInfo();
    }

    @Override
    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parentNodeInfo() throws InvalidItemStateException, AccessDeniedException, RepositoryException {
        return this.proxyInfo().getParent();
    }

    @Override
    Path path() throws RepositoryException {
        return this.proxyInfo().getPath();
    }

    @Override
    Path.Segment segment() throws RepositoryException {
        return this.proxyInfo().getSegment();
    }

    @Override
    protected CorrespondenceId getCorrespondenceId() throws RepositoryException {
        return this.original.getCorrespondenceId();
    }

    @Override
    public void removeMixin(String mixinName) throws RepositoryException {
        if (((String)this.cache.stringFactory().create(JcrMixLexicon.SHAREABLE)).equals(mixinName)) {
            throw new ConstraintViolationException();
        }
        super.removeMixin(mixinName);
    }

    @Override
    public Property getProperty(String relativePath) throws RepositoryException {
        return this.adapt(super.getProperty(relativePath));
    }

    @Override
    public PropertyIterator getProperties() throws RepositoryException {
        return this.adapt(super.getProperties());
    }

    @Override
    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        return this.adapt(super.getProperties(namePattern));
    }

    @Override
    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        return this.adapt(super.getProperties(nameGlobs));
    }

    protected Property adapt(Property property) {
        if (property instanceof JcrSingleValueProperty) {
            JcrSingleValueProperty original = (JcrSingleValueProperty)property;
            return new JcrSingleValueProperty(this.cache, this, original.name());
        }
        if (property instanceof JcrMultiValueProperty) {
            JcrMultiValueProperty original = (JcrMultiValueProperty)property;
            return new JcrMultiValueProperty(this.cache, this, original.name());
        }
        return property;
    }

    protected PropertyIterator adapt(PropertyIterator propertyIter) {
        ArrayList<Property> props = new ArrayList<Property>((int)propertyIter.getSize());
        while (propertyIter.hasNext()) {
            props.add(this.adapt(propertyIter.nextProperty()));
        }
        return new JcrPropertyIterator(props);
    }
}

