/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.modeshape.common.annotation.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class JcrNodeTypeIterator
implements NodeTypeIterator {
    private int size;
    private int position;
    private Iterator<NodeType> iterator;

    JcrNodeTypeIterator(Collection<? extends NodeType> values) {
        this.iterator = Collections.unmodifiableCollection(values).iterator();
        this.size = values.size();
        this.position = 0;
    }

    public NodeType nextNodeType() {
        ++this.position;
        return this.iterator.next();
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.size;
    }

    public void skip(long count) {
        this.position = (int)((long)this.position + count);
        while (count-- > 0L) {
            this.iterator.next();
        }
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        ++this.position;
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("Node types cannot be removed through their iterator");
    }
}

