/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.jcr.JcrRepository;

public class JcrTools {
    public int removeAllChildren(Node node) throws RepositoryException {
        CheckArg.isNotNull((Object)node, (String)"node");
        int childrenRemoved = 0;
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            child.remove();
            ++childrenRemoved;
        }
        return childrenRemoved;
    }

    public Node getNode(Node node, String relativePath, boolean required) throws RepositoryException {
        Node result;
        block2: {
            CheckArg.isNotNull((Object)node, (String)"node");
            CheckArg.isNotNull((Object)relativePath, (String)"relativePath");
            result = null;
            try {
                result = node.getNode(relativePath);
            }
            catch (PathNotFoundException e) {
                if (!required) break block2;
                throw e;
            }
        }
        return result;
    }

    public String getReadable(Node node) {
        if (node == null) {
            return "";
        }
        try {
            return node.getPath();
        }
        catch (RepositoryException err) {
            return node.toString();
        }
    }

    public MimeTypeDetector mimeTypeDetector(Session session) {
        Repository repository = session.getRepository();
        ExecutionContext context = null;
        if (repository instanceof JcrRepository) {
            JcrRepository jcrRepository = (JcrRepository)repository;
            context = jcrRepository.getExecutionContext();
        } else {
            context = new ExecutionContext();
        }
        return context.getMimeTypeDetector();
    }

    public String detectMimeType(Session session, String fileName) {
        try {
            return this.mimeTypeDetector(session).mimeTypeOf(fileName, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String detectMimeType(Session session, File file, boolean useContent) throws IOException {
        InputStream stream = null;
        boolean error = false;
        try {
            if (useContent) {
                stream = new BufferedInputStream(new FileInputStream(file));
            }
            String string = this.mimeTypeDetector(session).mimeTypeOf(file.getName(), stream);
            return string;
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        finally {
            block11: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (error) break block11;
                        throw e;
                    }
                }
            }
        }
    }

    public String detectMimeType(Session session, URL url, boolean useContent) throws IOException {
        InputStream stream = null;
        boolean error = false;
        try {
            if (useContent) {
                stream = url.openStream();
            }
            String string = this.mimeTypeDetector(session).mimeTypeOf(url.getPath(), stream);
            return string;
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        finally {
            block11: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (error) break block11;
                        throw e;
                    }
                }
            }
        }
    }

    public Node uploadFile(Session session, String path, InputStream stream) throws RepositoryException, IOException {
        CheckArg.isNotNull((Object)session, (String)"session");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)stream, (String)"stream");
        Node fileNode = null;
        boolean error = false;
        try {
            fileNode = this.findOrCreateNode(session.getRootNode(), path, "nt:folder", "nt:file");
            Node contentNode = this.findOrCreateChild(fileNode, "jcr:content", "nt:resource");
            Binary binary = session.getValueFactory().createBinary(stream);
            contentNode.setProperty("jcr:data", binary);
        }
        catch (RepositoryException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block11: {
                try {
                    stream.close();
                }
                catch (RuntimeException e) {
                    if (error) break block11;
                    throw e;
                }
            }
        }
        return fileNode;
    }

    public Node uploadFile(Session session, String path, URL contentUrl) throws RepositoryException, IOException {
        CheckArg.isNotNull((Object)session, (String)"session");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)contentUrl, (String)"contentUrl");
        InputStream stream = contentUrl.openStream();
        return this.uploadFile(session, path, stream);
    }

    public Node uploadFile(Session session, String path, File file) throws RepositoryException, IOException {
        CheckArg.isNotNull((Object)session, (String)"session");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)file, (String)"file");
        if (!file.exists()) {
            throw new IllegalArgumentException("The file \"" + file.getCanonicalPath() + "\" does not exist");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("The file \"" + file.getCanonicalPath() + "\" is not readable");
        }
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(file.lastModified());
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        return this.uploadFile(session, path, stream);
    }

    public Node findOrCreateNode(Session session, String path) throws RepositoryException {
        return this.findOrCreateNode(session, path, null, null);
    }

    public Node findOrCreateNode(Session session, String path, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(session, path, nodeType, nodeType);
    }

    public Node findOrCreateNode(Session session, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        CheckArg.isNotNull((Object)session, (String)"session");
        Node root = session.getRootNode();
        return this.findOrCreateNode(root, path, defaultNodeType, finalNodeType);
    }

    public Node findOrCreateNode(Node parentNode, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        CheckArg.isNotNull((Object)path, (String)"path");
        String relPath = path.replaceAll("^/+", "").replaceAll("/+$", "");
        try {
            return parentNode.getNode(relPath);
        }
        catch (PathNotFoundException e) {
            String[] pathSegments = relPath.split("/");
            Node node = parentNode;
            int len = pathSegments.length;
            for (int i = 0; i != len; ++i) {
                String pathSegment = pathSegments[i];
                if ((pathSegment = pathSegment.trim()).length() == 0) continue;
                if (node.hasNode(pathSegment)) {
                    node = node.getNode(pathSegment);
                    continue;
                }
                String pathSegmentWithNoIndex = pathSegment.replaceAll("(\\[\\d+\\])+$", "");
                String nodeType = defaultNodeType;
                if (i == len - 1 && finalNodeType != null) {
                    nodeType = finalNodeType;
                }
                node = nodeType != null ? node.addNode(pathSegmentWithNoIndex, nodeType) : node.addNode(pathSegmentWithNoIndex);
            }
            return node;
        }
    }

    public Node findOrCreateChild(Node parent, String name) throws RepositoryException {
        return this.findOrCreateChild(parent, name, null);
    }

    public Node findOrCreateChild(Node parent, String name, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(parent, name, nodeType, nodeType);
    }

    public void printSubgraph(Node node) throws RepositoryException {
        this.printSubgraph(node, Integer.MAX_VALUE);
    }

    public void printSubgraph(Node node, int maxDepth) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), maxDepth);
    }

    public void printNode(Node node) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), 1);
    }

    public void printSubgraph(Node node, String lead, int depthOfSubgraph, int maxDepthOfSubgraph) throws RepositoryException {
        int currentDepth = node.getDepth() - depthOfSubgraph + 1;
        if (currentDepth > maxDepthOfSubgraph) {
            return;
        }
        if (lead == null) {
            lead = "";
        }
        String nodeLead = lead + StringUtil.createString((char)' ', (int)((currentDepth - 1) * 2));
        StringBuilder sb = new StringBuilder();
        sb.append(nodeLead);
        if (node.getDepth() == 0) {
            sb.append("/");
        } else {
            sb.append(node.getName());
            if (node.getIndex() != 1) {
                sb.append('[').append(node.getIndex()).append(']');
            }
        }
        sb.append(" jcr:primaryType=" + node.getPrimaryNodeType().getName());
        boolean referenceable = false;
        if (node.getMixinNodeTypes().length != 0) {
            sb.append(" jcr:mixinTypes=[");
            boolean first = true;
            for (NodeType mixin : node.getMixinNodeTypes()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(mixin.getName());
                if (!mixin.getName().equals("mix:referenceable")) continue;
                referenceable = true;
            }
            sb.append(']');
        }
        if (referenceable) {
            sb.append(" jcr:uuid=" + node.getIdentifier());
        }
        System.out.println(sb);
        LinkedList<String> propertyNames = new LinkedList<String>();
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            String name = property.getName();
            if (name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes") || name.equals("jcr:uuid")) continue;
            propertyNames.add(property.getName());
        }
        Collections.sort(propertyNames);
        for (String propertyName : propertyNames) {
            boolean binary;
            Property property = node.getProperty(propertyName);
            sb = new StringBuilder();
            sb.append(nodeLead).append("  - ").append(propertyName).append('=');
            boolean bl = binary = property.getType() == 2;
            if (property.isMultiple()) {
                sb.append('[');
                boolean first = true;
                for (Value value : property.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    if (binary) {
                        sb.append(value.getBinary());
                        continue;
                    }
                    sb.append(value.getString());
                }
                sb.append(']');
            } else {
                Value value = property.getValue();
                if (binary) {
                    sb.append(value.getBinary());
                } else {
                    sb.append(value.getString());
                }
            }
            System.out.println(sb);
        }
        if (currentDepth < maxDepthOfSubgraph) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                this.printSubgraph(child, lead, depthOfSubgraph, maxDepthOfSubgraph);
            }
        }
    }
}

