/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.Location;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.SessionCache;

@Immutable
final class JcrRootNode
extends AbstractJcrNode {
    JcrRootNode(SessionCache cache, GraphSession.NodeId nodeId, Location location) {
        super(cache, nodeId, location);
    }

    @Override
    boolean isRoot() {
        return true;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    public int getIndex() {
        return 1;
    }

    public String getName() {
        return "";
    }

    @Override
    public AbstractJcrNode getParent() throws ItemNotFoundException {
        throw new ItemNotFoundException(JcrI18n.rootNodeHasNoParent.text(new Object[0]));
    }

    public String getPath() {
        return "/";
    }

    @Override
    public final Item getAncestor(int depth) throws RepositoryException {
        if (depth == 0) {
            return this;
        }
        if (depth < 0) {
            throw new ItemNotFoundException(JcrI18n.noNegativeDepth.text(new Object[]{depth}));
        }
        throw new ItemNotFoundException(JcrI18n.tooDeep.text(new Object[]{depth}));
    }

    @Override
    protected void doRemove() throws ConstraintViolationException, RepositoryException {
        String msg = JcrI18n.unableToRemoveRootNode.text(new Object[]{this.cache.workspaceName()});
        throw new ConstraintViolationException(msg);
    }

    @Override
    public void remove() throws ConstraintViolationException {
        String msg = JcrI18n.unableToRemoveRootNode.text(new Object[]{this.cache.workspaceName()});
        throw new ConstraintViolationException(msg);
    }

    @Override
    public void removeShare() throws ConstraintViolationException, RepositoryException {
        String msg = JcrI18n.unableToRemoveRootNode.text(new Object[]{this.cache.workspaceName()});
        throw new ConstraintViolationException(msg);
    }

    @Override
    public void removeSharedSet() throws ConstraintViolationException, RepositoryException {
        String msg = JcrI18n.unableToRemoveRootNode.text(new Object[]{this.cache.workspaceName()});
        throw new ConstraintViolationException(msg);
    }
}

