/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import com.google.common.collect.LinkedListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.collection.UnmodifiableProperties;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.JaasSecurityContext;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.Workspace;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.federation.FederatedRepositorySource;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProjectionParser;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.basic.GraphNamespaceRegistry;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.parse.QueryParsers;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.FullTextSearchParser;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSystemObserver;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.RepositoryQueryManager;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.api.SecurityContext;
import org.modeshape.jcr.api.SecurityContextCredentials;
import org.modeshape.jcr.query.JcrQomQueryParser;
import org.modeshape.jcr.query.JcrSql2QueryParser;
import org.modeshape.jcr.query.JcrSqlQueryParser;
import org.modeshape.jcr.xpath.XPathQueryParser;

@ThreadSafe
public class JcrRepository
implements Repository {
    static final boolean WORKSPACES_SHARE_SYSTEM_BRANCH = true;
    static final String ANONYMOUS_USER_NAME = "<anonymous>";
    private static final Logger LOGGER = Logger.getLogger(JcrRepository.class);
    private static Properties bundleProperties = null;
    protected static final Map<Option, String> DEFAULT_OPTIONS;
    private final String sourceName;
    private final Map<String, Object> descriptors;
    private final ExecutionContext executionContext;
    private final RepositoryConnectionFactory connectionFactory;
    private final RepositoryNodeTypeManager repositoryTypeManager;
    private final RepositoryLockManager repositoryLockManager;
    private final Map<Option, String> options;
    private final String systemSourceName;
    private final String systemWorkspaceName;
    private final Projection systemSourceProjection;
    private final FederatedRepositorySource federatedSource;
    private final GraphNamespaceRegistry persistentRegistry;
    private final RepositoryObservationManager repositoryObservationManager;
    private final org.modeshape.graph.SecurityContext anonymousUserContext;
    private final QueryParsers queryParsers;
    private final RepositoryQueryManager queryManager;
    final WeakHashMap<JcrSession, Object> activeSessions = new WeakHashMap();

    JcrRepository(ExecutionContext executionContext, RepositoryConnectionFactory connectionFactory, String repositorySourceName, Observable repositoryObservable, RepositorySourceCapabilities repositorySourceCapabilities, Map<String, String> descriptors, Map<Option, String> options) throws RepositoryException {
        CheckArg.isNotNull((Object)executionContext, (String)"executionContext");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        CheckArg.isNotNull((Object)repositorySourceName, (String)"repositorySourceName");
        CheckArg.isNotNull((Object)repositoryObservable, (String)"repositoryObservable");
        if (options == null) {
            this.options = DEFAULT_OPTIONS;
        } else {
            EnumMap<Option, String> localOptions = new EnumMap<Option, String>(DEFAULT_OPTIONS);
            localOptions.putAll(options);
            this.options = Collections.unmodifiableMap(localOptions);
        }
        String systemSourceNameValue = this.options.get((Object)Option.SYSTEM_SOURCE_NAME);
        String systemSourceName = null;
        String systemWorkspaceName = null;
        RepositoryConnectionFactory connectionFactoryWithSystem = connectionFactory;
        if (systemSourceNameValue != null) {
            I18n msg;
            try {
                SourceWorkspacePair pair = new SourceWorkspacePair(systemSourceNameValue);
                RepositoryConnection conn = connectionFactory.createConnection(pair.getSourceName());
                if (conn != null) {
                    systemSourceName = pair.getSourceName();
                    if (pair.getWorkspaceName() != null) {
                        Graph temp = Graph.create((RepositoryConnection)conn, (ExecutionContext)executionContext);
                        temp.useWorkspace(pair.getWorkspaceName());
                        systemWorkspaceName = pair.getWorkspaceName();
                    }
                } else {
                    I18n msg2 = JcrI18n.systemSourceNameOptionValueDoesNotReferenceExistingSource;
                    LOGGER.warn(msg2, new Object[]{systemSourceNameValue, systemSourceName});
                }
            }
            catch (InvalidWorkspaceException e) {
                systemSourceName = null;
                msg = JcrI18n.systemSourceNameOptionValueDoesNotReferenceValidWorkspace;
                LOGGER.warn(msg, new Object[]{systemSourceNameValue, systemSourceName});
            }
            catch (IllegalArgumentException e) {
                systemSourceName = null;
                msg = JcrI18n.systemSourceNameOptionValueIsNotFormattedCorrectly;
                LOGGER.warn(msg, new Object[]{systemSourceNameValue});
            }
        }
        InMemoryRepositorySource transientSystemSource = null;
        if (systemSourceName == null) {
            systemWorkspaceName = "jcr:system";
            systemSourceName = "jcr:system source";
            transientSystemSource = new InMemoryRepositorySource();
            transientSystemSource.setName(systemSourceName);
            transientSystemSource.setDefaultWorkspaceName(systemWorkspaceName);
            connectionFactoryWithSystem = new DelegatingConnectionFactory(connectionFactory, (RepositorySource)transientSystemSource);
        }
        this.queryParsers = new QueryParsers(new QueryParser[]{new JcrSql2QueryParser(), new XPathQueryParser(), new FullTextSearchParser(), new JcrSqlQueryParser(), new JcrQomQueryParser()});
        assert (this.queryParsers.getParserFor("xpath") != null);
        assert (this.queryParsers.getParserFor("sql") != null);
        assert (this.queryParsers.getParserFor("JCR-SQL2") != null);
        assert (this.queryParsers.getParserFor("JCR-JQOM") != null);
        assert (this.queryParsers.getParserFor("Search") != null);
        this.systemWorkspaceName = systemWorkspaceName;
        this.systemSourceName = systemSourceName;
        this.connectionFactory = connectionFactoryWithSystem;
        assert (this.systemSourceName != null);
        assert (this.connectionFactory != null);
        this.sourceName = repositorySourceName;
        Graph systemGraph = Graph.create((String)this.systemSourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)executionContext);
        systemGraph.useWorkspace(systemWorkspaceName);
        this.initializeSystemContent(systemGraph);
        Name uriProperty = ModeShapeLexicon.URI;
        PathFactory pathFactory = executionContext.getValueFactories().getPathFactory();
        Path systemPath = (Path)pathFactory.create(JcrLexicon.SYSTEM);
        final Path namespacesPath = pathFactory.create(systemPath, new Name[]{ModeShapeLexicon.NAMESPACES});
        PropertyFactory propertyFactory = executionContext.getPropertyFactory();
        Property namespaceType = propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.NAMESPACE});
        this.persistentRegistry = new GraphNamespaceRegistry(systemGraph, namespacesPath, uriProperty, new Property[]{namespaceType});
        this.executionContext = executionContext.with((NamespaceRegistry)this.persistentRegistry);
        for (Map.Entry<String, String> builtIn : JcrNamespaceRegistry.STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX.entrySet()) {
            this.persistentRegistry.register(builtIn.getKey(), builtIn.getValue());
        }
        Path parentOfTypeNodes = null;
        if (Boolean.valueOf(this.options.get((Object)Option.PROJECT_NODE_TYPES)).booleanValue()) {
            parentOfTypeNodes = pathFactory.create(systemPath, new Name[]{JcrLexicon.NODE_TYPES});
        }
        try {
            boolean includeInheritedProperties = Boolean.valueOf(this.options.get((Object)Option.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES));
            boolean includePseudoColumnInSelectStar = true;
            this.repositoryTypeManager = new RepositoryNodeTypeManager(this, parentOfTypeNodes, includeInheritedProperties, includePseudoColumnInSelectStar);
            CndNodeTypeReader nodeTypeReader = new CndNodeTypeReader(this.executionContext);
            nodeTypeReader.readBuiltInTypes();
            this.repositoryTypeManager.registerNodeTypes(nodeTypeReader);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
        ProjectionParser projectionParser = ProjectionParser.getInstance();
        String rule = "/jcr:system => /jcr:system";
        Projection.Rule[] systemProjectionRules = projectionParser.rulesFromString(this.executionContext, rule);
        this.systemSourceProjection = new Projection(systemSourceName, systemWorkspaceName, true, systemProjectionRules);
        this.federatedSource = new FederatedRepositorySource();
        this.federatedSource.setName("JCR " + repositorySourceName);
        this.federatedSource.initialize((RepositoryContext)new FederatedRepositoryContext(this.connectionFactory));
        Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)connectionFactory, (ExecutionContext)executionContext);
        String defaultWorkspaceName = graph.getCurrentWorkspaceName();
        for (String workspaceName : graph.getWorkspaces()) {
            boolean isDefault = workspaceName.equals(defaultWorkspaceName);
            this.addWorkspace(workspaceName, isDefault);
        }
        if (descriptors == null) {
            descriptors = new HashMap<String, String>();
        }
        if (repositorySourceCapabilities != null && repositorySourceCapabilities.supportsCreatingWorkspaces()) {
            if (!descriptors.containsKey("option.workspace.management.supported")) {
                descriptors.put("option.workspace.management.supported", Boolean.TRUE.toString());
            }
        } else {
            descriptors.put("option.workspace.management.supported", Boolean.FALSE.toString());
        }
        this.descriptors = JcrRepository.initializeDescriptors(executionContext.getValueFactories(), descriptors);
        if (Boolean.valueOf(this.options.get((Object)Option.QUERY_EXECUTION_ENABLED)).booleanValue()) {
            boolean canQueryFederated;
            RepositorySourceCapabilities fedCapabilities = this.federatedSource != null ? this.federatedSource.getCapabilities() : null;
            boolean canQuerySource = repositorySourceCapabilities != null && repositorySourceCapabilities.supportsSearches() && repositorySourceCapabilities.supportsQueries();
            boolean bl = canQueryFederated = fedCapabilities != null && fedCapabilities.supportsSearches() && fedCapabilities.supportsQueries();
            if (canQuerySource && canQueryFederated) {
                this.queryManager = new RepositoryQueryManager.PushDown(this.sourceName, this.executionContext, connectionFactory);
            } else {
                String indexDirectory = this.options.get((Object)Option.QUERY_INDEX_DIRECTORY);
                boolean updateIndexesSynchronously = Boolean.valueOf(this.options.get((Object)Option.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY));
                int maxDepthToRead = Integer.valueOf(this.options.get((Object)Option.INDEX_READ_DEPTH));
                this.queryManager = new RepositoryQueryManager.SelfContained(this.executionContext, this.sourceName, connectionFactory, repositoryObservable, this.repositoryTypeManager, indexDirectory, updateIndexesSynchronously, maxDepthToRead);
            }
        } else {
            this.queryManager = new RepositoryQueryManager.Disabled(this.sourceName);
        }
        this.repositoryObservationManager = new RepositoryObservationManager(repositoryObservable);
        if (transientSystemSource != null) {
            final RepositoryObservationManager observer = this.repositoryObservationManager;
            final ExecutionContext context = executionContext;
            transientSystemSource.initialize(new RepositoryContext(){

                public Observer getObserver() {
                    return observer;
                }

                public ExecutionContext getExecutionContext() {
                    return context;
                }

                public Subgraph getConfiguration(int depth) {
                    return null;
                }

                public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                    return null;
                }
            });
        }
        org.modeshape.graph.SecurityContext anonymousUserContext = null;
        String rawAnonRoles = this.options.get((Object)Option.ANONYMOUS_USER_ROLES);
        if (rawAnonRoles != null) {
            final HashSet<String> roles = new HashSet<String>();
            for (String role : rawAnonRoles.split("\\s*,\\s*")) {
                roles.add(role);
            }
            if (roles.size() > 0) {
                anonymousUserContext = new org.modeshape.graph.SecurityContext(){

                    public String getUserName() {
                        return JcrRepository.ANONYMOUS_USER_NAME;
                    }

                    public boolean hasRole(String roleName) {
                        return roles.contains(roleName);
                    }

                    public void logout() {
                    }
                };
            }
        }
        this.anonymousUserContext = anonymousUserContext;
        this.repositoryLockManager = new RepositoryLockManager(this);
        final GraphNamespaceRegistry persistentRegistry = this.persistentRegistry;
        JcrSystemObserver namespaceObserver = new JcrSystemObserver(){

            @Override
            public Path getObservedPath() {
                return namespacesPath;
            }

            public void notify(Changes changes) {
                persistentRegistry.refresh();
            }
        };
        this.repositoryObservationManager.register(new SystemChangeObserver(Arrays.asList(this.repositoryLockManager, namespaceObserver, this.repositoryTypeManager)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWorkspace(String workspaceName, boolean isDefault) {
        FederatedRepositorySource federatedRepositorySource = this.federatedSource;
        synchronized (federatedRepositorySource) {
            if (this.federatedSource == null) {
                return;
            }
            assert (this.systemSourceProjection != null);
            if (!this.federatedSource.hasWorkspace(workspaceName)) {
                if (workspaceName.equals(this.systemWorkspaceName)) {
                    return;
                }
                ProjectionParser projectionParser = ProjectionParser.getInstance();
                Projection.Rule[] mirrorRules = projectionParser.rulesFromString(this.executionContext, "/ => /");
                ArrayList<Projection> projections = new ArrayList<Projection>(2);
                projections.add(new Projection(this.sourceName, workspaceName, false, mirrorRules));
                projections.add(this.systemSourceProjection);
                this.federatedSource.addWorkspace(workspaceName, projections, isDefault);
            }
        }
    }

    protected void createWorkspace(String workspaceName, String clonedFromWorkspaceNamed) throws InvalidWorkspaceException, UnsupportedRepositoryOperationException {
        assert (workspaceName != null);
        if (!Boolean.parseBoolean(this.getDescriptor("option.workspace.management.supported"))) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (workspaceName.equals(this.systemWorkspaceName)) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{workspaceName, this.systemSourceName});
            throw new InvalidWorkspaceException(msg);
        }
        Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.executionContext);
        Workspace graphWorkspace = null;
        graphWorkspace = clonedFromWorkspaceNamed != null ? graph.createWorkspace().clonedFrom(clonedFromWorkspaceNamed).named(workspaceName) : graph.createWorkspace().named(workspaceName);
        String actualName = graphWorkspace.getName();
        this.addWorkspace(actualName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyWorkspace(String workspaceName, JcrWorkspace currentWorkspace) throws InvalidWorkspaceException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositorySourceException {
        assert (workspaceName != null);
        assert (currentWorkspace != null);
        if (!Boolean.parseBoolean(this.getDescriptor("option.workspace.management.supported"))) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (workspaceName.equals(this.systemWorkspaceName)) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{workspaceName, this.sourceName});
            throw new InvalidWorkspaceException(msg);
        }
        if (currentWorkspace.getName().equals(workspaceName)) {
            String msg = GraphI18n.currentWorkspaceCannotBeDeleted.text(new Object[]{workspaceName, this.sourceName});
            throw new InvalidWorkspaceException(msg);
        }
        Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.executionContext);
        graph.useWorkspace(currentWorkspace.getName());
        if (!graph.getWorkspaces().contains(workspaceName)) {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{workspaceName, this.sourceName});
            throw new NoSuchWorkspaceException(msg);
        }
        if (this.federatedSource != null) {
            FederatedRepositorySource federatedRepositorySource = this.federatedSource;
            synchronized (federatedRepositorySource) {
                this.federatedSource.removeWorkspace(workspaceName);
            }
        }
        graph.destroyWorkspace().named(workspaceName);
    }

    protected void initializeSystemContent(Graph systemGraph) {
        ExecutionContext context = systemGraph.getContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path systemPath = pathFactory.create(pathFactory.createRootPath(), new Name[]{JcrLexicon.SYSTEM});
        Property systemPrimaryType = context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.SYSTEM});
        systemGraph.create(systemPath, systemPrimaryType).ifAbsent().and();
        Path versionPath = pathFactory.createAbsolutePath(new Name[]{JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE});
        Property versionPrimaryType = context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.VERSION_STORAGE});
        systemGraph.create(versionPath, versionPrimaryType).ifAbsent().and();
    }

    JcrGraph createWorkspaceGraph(String workspaceName, ExecutionContext workspaceContext) {
        JcrGraph graph = null;
        assert (this.federatedSource != null);
        graph = JcrGraph.create((RepositorySource)this.federatedSource, workspaceContext);
        graph.useWorkspace(workspaceName);
        return graph;
    }

    JcrGraph createSystemGraph(ExecutionContext sessionContext) {
        assert (this.systemSourceName != null);
        assert (this.connectionFactory != null);
        assert (sessionContext != null);
        JcrGraph result = JcrGraph.create(this.systemSourceName, this.connectionFactory, sessionContext);
        if (this.systemWorkspaceName != null) {
            result.useWorkspace(this.systemWorkspaceName);
        }
        return result;
    }

    QueryParsers queryParsers() {
        return this.queryParsers;
    }

    RepositoryQueryManager queryManager() {
        return this.queryManager;
    }

    RepositoryNodeTypeManager getRepositoryTypeManager() {
        return this.repositoryTypeManager;
    }

    RepositoryLockManager getRepositoryLockManager() {
        return this.repositoryLockManager;
    }

    public Map<Option, String> getOptions() {
        return this.options;
    }

    String getRepositorySourceName() {
        return this.sourceName;
    }

    String getSystemSourceName() {
        return this.systemSourceName;
    }

    String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    String getObservableSourceName() {
        return this.federatedSource.getName();
    }

    ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    NamespaceRegistry getPersistentRegistry() {
        return this.persistentRegistry;
    }

    Observer getObserver() {
        return this.repositoryObservationManager;
    }

    Observable getRepositoryObservable() {
        return this.repositoryObservationManager;
    }

    public String getDescriptor(String key) {
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        JcrValue value = (JcrValue)this.descriptors.get(key);
        try {
            return value.getString();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public JcrValue getDescriptorValue(String key) {
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        return (JcrValue)this.descriptors.get(key);
    }

    public JcrValue[] getDescriptorValues(String key) {
        Object value = this.descriptors.get(key);
        if (value instanceof JcrValue[]) {
            return (JcrValue[])value;
        }
        if (value instanceof JcrValue) {
            return new JcrValue[]{(JcrValue)value};
        }
        return null;
    }

    public boolean isSingleValueDescriptor(String key) {
        CheckArg.isNotEmpty((String)key, (String)"key");
        return this.descriptors.get(key) instanceof JcrValue;
    }

    public boolean isStandardDescriptor(String key) {
        return STANDARD_DESCRIPTORS.contains(key);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.size()]);
    }

    public synchronized Session login() throws RepositoryException {
        return this.login(null, null);
    }

    public synchronized Session login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null);
    }

    public synchronized Session login(String workspaceName) throws RepositoryException {
        return this.login(null, workspaceName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Session login(Credentials credentials, String workspaceName) throws RepositoryException {
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        ExecutionContext execContext = null;
        if (credentials == null) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null) {
                execContext = this.executionContext.with((org.modeshape.graph.SecurityContext)new JaasSecurityContext(subject));
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            } else {
                if (this.anonymousUserContext == null) throw new LoginException(JcrI18n.mustBeInPrivilegedAction.text(new Object[0]));
                execContext = this.executionContext.with(this.anonymousUserContext);
            }
            return this.sessionForContext(execContext, workspaceName, sessionAttributes);
        }
        try {
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials simple = (SimpleCredentials)credentials;
                execContext = this.executionContext.with((org.modeshape.graph.SecurityContext)new JaasSecurityContext(this.options.get((Object)Option.JAAS_LOGIN_CONFIG_NAME), simple.getUserID(), simple.getPassword()));
                for (String attributeName : simple.getAttributeNames()) {
                    Object attributeValue = simple.getAttribute(attributeName);
                    sessionAttributes.put(attributeName, attributeValue);
                }
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            }
            if (credentials instanceof SecurityContextCredentials) {
                execContext = this.executionContext.with(this.contextFor((SecurityContextCredentials)credentials));
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            }
            if (credentials instanceof JcrSecurityContextCredentials) {
                execContext = this.executionContext.with(((JcrSecurityContextCredentials)credentials).getSecurityContext());
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            }
            try {
                Method method = credentials.getClass().getMethod("getLoginContext", new Class[0]);
                if (method.getReturnType() != LoginContext.class) {
                    throw new IllegalArgumentException(JcrI18n.credentialsMustReturnLoginContext.text(new Object[]{credentials.getClass()}));
                }
                LoginContext loginContext = (LoginContext)method.invoke((Object)credentials, new Object[0]);
                if (loginContext == null) {
                    throw new IllegalArgumentException(JcrI18n.credentialsMustReturnLoginContext.text(new Object[]{credentials.getClass()}));
                }
                execContext = this.executionContext.with((org.modeshape.graph.SecurityContext)new JaasSecurityContext(loginContext));
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            }
            catch (NoSuchMethodException error) {
                throw new IllegalArgumentException(JcrI18n.credentialsMustProvideJaasMethod.text(new Object[]{credentials.getClass()}), error);
            }
        }
        catch (RuntimeException error) {
            throw error;
        }
        catch (Exception error) {
            throw new LoginException((Throwable)error);
        }
    }

    private org.modeshape.graph.SecurityContext contextFor(SecurityContextCredentials credentials) {
        assert (credentials != null);
        final SecurityContext jcrSecurityContext = credentials.getSecurityContext();
        assert (jcrSecurityContext != null);
        return new org.modeshape.graph.SecurityContext(){

            public String getUserName() {
                return jcrSecurityContext.getUserName();
            }

            public boolean hasRole(String roleName) {
                return jcrSecurityContext.hasRole(roleName);
            }

            public void logout() {
                jcrSecurityContext.logout();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JcrSession sessionForContext(ExecutionContext execContext, String workspaceName, Map<String, Object> sessionAttributes) throws RepositoryException {
        CheckArg.isNotNull((Object)execContext.getSecurityContext(), (String)"execContext.securityContext");
        boolean isDefault = false;
        Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.executionContext);
        if (workspaceName == null) {
            try {
                workspaceName = graph.getCurrentWorkspace().getName();
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(JcrI18n.errorObtainingDefaultWorkspaceName.text(new Object[]{this.sourceName, e.getMessage()}), (Throwable)e);
            }
            isDefault = true;
        } else {
            try {
                Set workspaces = graph.getWorkspaces();
                if (!workspaces.contains(workspaceName)) {
                    this.federatedSource.removeWorkspace(workspaceName);
                    throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.sourceName, workspaceName}));
                }
                graph.useWorkspace(workspaceName);
            }
            catch (InvalidWorkspaceException e) {
                throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.sourceName, workspaceName}), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                String msg = JcrI18n.errorVerifyingWorkspaceName.text(new Object[]{this.sourceName, workspaceName, e.getMessage()});
                throw new NoSuchWorkspaceException(msg, (Throwable)e);
            }
        }
        this.addWorkspace(workspaceName, isDefault);
        sessionAttributes = Collections.unmodifiableMap(sessionAttributes);
        JcrWorkspace workspace = new JcrWorkspace(this, workspaceName, execContext, sessionAttributes);
        JcrSession session = (JcrSession)workspace.getSession();
        try {
            session.checkPermission(workspaceName, null, "read");
        }
        catch (AccessControlException ace) {
            throw new LoginException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.sourceName, workspaceName}), (Throwable)ace);
        }
        WeakHashMap<JcrSession, Object> weakHashMap = this.activeSessions;
        synchronized (weakHashMap) {
            this.activeSessions.put(session, null);
        }
        return session;
    }

    void close() {
        if (this.federatedSource != null) {
            this.federatedSource.close();
        }
        this.repositoryObservationManager.shutdown();
    }

    Set<String> workspaceNames() {
        return Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.executionContext).getWorkspaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionLoggedOut(JcrSession session) {
        WeakHashMap<JcrSession, Object> weakHashMap = this.activeSessions;
        synchronized (weakHashMap) {
            this.activeSessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<JcrSession> activeSessions() {
        HashSet<JcrSession> activeSessions;
        WeakHashMap<JcrSession, Object> weakHashMap = this.activeSessions;
        synchronized (weakHashMap) {
            activeSessions = new HashSet<JcrSession>(this.activeSessions.keySet());
        }
        Iterator iter = activeSessions.iterator();
        while (iter.hasNext()) {
            JcrSession session = (JcrSession)iter.next();
            if (session == null || session.isLive()) continue;
            iter.remove();
        }
        return activeSessions;
    }

    public Metrics getMetrics() {
        return new Metrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateAllSessions() {
        WeakHashMap<JcrSession, Object> weakHashMap = this.activeSessions;
        synchronized (weakHashMap) {
            for (JcrSession session : this.activeSessions.keySet()) {
                session.terminate(false);
            }
            this.activeSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getBundleProperties() {
        if (bundleProperties == null) {
            InputStream stream = null;
            try {
                stream = JcrRepository.class.getClassLoader().getResourceAsStream("org/modeshape/jcr/repository.properties");
                assert (stream != null);
                Properties props = new Properties();
                props.load(stream);
                bundleProperties = new UnmodifiableProperties(props);
            }
            catch (IOException e) {
                throw new IllegalStateException(JcrI18n.failedToReadPropertiesFromManifest.text(new Object[]{e.getLocalizedMessage()}), e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                    }
                    finally {
                        stream = null;
                    }
                }
            }
        }
        return bundleProperties;
    }

    protected static String getBundleProperty(String propertyName, boolean required) {
        String value = JcrRepository.getBundleProperties().getProperty(propertyName);
        if (value == null && required) {
            throw new IllegalStateException(JcrI18n.failedToReadPropertyFromManifest.text(new Object[]{propertyName}));
        }
        return value;
    }

    private static Map<String, Object> initializeDescriptors(ValueFactories factories, Map<String, String> customDescriptors) {
        if (customDescriptors == null) {
            customDescriptors = Collections.emptyMap();
        }
        HashMap<String, Object> repoDescriptors = new HashMap<String, Object>(customDescriptors.size() + 60);
        for (Map.Entry<String, String> entry : customDescriptors.entrySet()) {
            repoDescriptors.put(entry.getKey(), JcrRepository.valueFor(factories, entry.getValue()));
        }
        repoDescriptors.put("level.1.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("level.2.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.locking.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.observation.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.query.sql.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.transactions.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.versioning.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("query.xpath.doc.order", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("query.xpath.pos.index", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("write.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("identifier.stability", JcrRepository.valueFor(factories, "identifier.stability.method.duration"));
        repoDescriptors.put("option.xml.import.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.xml.export.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.unfiled.content.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.simple.versioning.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.activities.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.baselines.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.access.control.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.journaled.observation.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.retention.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.lifecycle.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.node.and.property.with.same.name.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.update.primary.node.type.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.update.mixin.node.types.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.shareable.nodes.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.node.type.management.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.inheritance", JcrRepository.valueFor(factories, "node.type.management.inheritance.multiple"));
        repoDescriptors.put("node.type.management.primary.item.name.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.orderable.child.nodes.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.residual.definitions.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.autocreated.definitions.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.same.name.siblings.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.property.types", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.overrides.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.multivalued.properties.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.multiple.binary.properties.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.value.constraints.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.update.in.use.suported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("query.languages", new JcrValue[]{JcrRepository.valueFor(factories, "xpath"), JcrRepository.valueFor(factories, "JCR-SQL2"), JcrRepository.valueFor(factories, "sql"), JcrRepository.valueFor(factories, "JCR-JQOM")});
        repoDescriptors.put("query.stored.queries.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("query.full.text.search.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("query.joins", JcrRepository.valueFor(factories, "query.joins.inner.outer"));
        repoDescriptors.put("jcr.specification.name", JcrRepository.valueFor(factories, JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
        repoDescriptors.put("jcr.specification.version", JcrRepository.valueFor(factories, "2.0"));
        if (!repoDescriptors.containsKey("jcr.repository.name")) {
            repoDescriptors.put("jcr.repository.name", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.name", true)));
        }
        if (!repoDescriptors.containsKey("jcr.repository.vendor")) {
            repoDescriptors.put("jcr.repository.vendor", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor", true)));
        }
        if (!repoDescriptors.containsKey("jcr.repository.vendor.url")) {
            repoDescriptors.put("jcr.repository.vendor.url", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor.url", true)));
        }
        if (!repoDescriptors.containsKey("jcr.repository.version")) {
            repoDescriptors.put("jcr.repository.version", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.version", true)));
        }
        if (!repoDescriptors.containsKey("jcr.repository.version")) {
            repoDescriptors.put("jcr.repository.version", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.version", true)));
        }
        if (!repoDescriptors.containsKey("option.workspace.management.supported")) {
            repoDescriptors.put("option.workspace.management.supported", JcrRepository.valueFor(factories, true));
        }
        return Collections.unmodifiableMap(repoDescriptors);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, int type, Object value) {
        return new JcrValue(valueFactories, null, type, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, String value) {
        return JcrRepository.valueFor(valueFactories, 1, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, boolean value) {
        return JcrRepository.valueFor(valueFactories, 6, value);
    }

    static {
        EnumMap<Option, String> defaults = new EnumMap<Option, String>(Option.class);
        defaults.put(Option.PROJECT_NODE_TYPES, DefaultOption.PROJECT_NODE_TYPES);
        defaults.put(Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        defaults.put(Option.READ_DEPTH, "1");
        defaults.put(Option.INDEX_READ_DEPTH, "4");
        defaults.put(Option.ANONYMOUS_USER_ROLES, "admin");
        defaults.put(Option.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES, DefaultOption.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES);
        defaults.put(Option.QUERY_EXECUTION_ENABLED, DefaultOption.QUERY_EXECUTION_ENABLED);
        defaults.put(Option.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY, DefaultOption.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY);
        defaults.put(Option.QUERY_INDEX_DIRECTORY, DefaultOption.QUERY_INDEX_DIRECTORY);
        defaults.put(Option.PERFORM_REFERENTIAL_INTEGRITY_CHECKS, DefaultOption.PERFORM_REFERENTIAL_INTEGRITY_CHECKS);
        DEFAULT_OPTIONS = Collections.unmodifiableMap(defaults);
    }

    class SystemChangeObserver
    implements Observer {
        private final Collection<JcrSystemObserver> jcrSystemObservers;
        private final String processId;
        private final String systemSourceName;
        private final String systemWorkspaceName;

        SystemChangeObserver(Collection<JcrSystemObserver> jcrSystemObservers) {
            this.jcrSystemObservers = Collections.unmodifiableCollection(jcrSystemObservers);
            this.processId = JcrRepository.this.getExecutionContext().getProcessId();
            this.systemSourceName = JcrRepository.this.getSystemSourceName();
            this.systemWorkspaceName = JcrRepository.this.getSystemWorkspaceName();
            assert (this.processId != null);
            assert (this.systemSourceName != null);
            assert (this.systemWorkspaceName != null);
        }

        public void notify(Changes changes) {
            if (!changes.getSourceName().equals(this.systemSourceName) && !this.systemSourceName.equals(JcrRepository.this.getRepositorySourceName())) {
                return;
            }
            if (changes.getProcessId().equals(this.processId)) {
                return;
            }
            LinkedListMultimap systemChanges = LinkedListMultimap.create();
            for (ChangeRequest change : changes.getChangeRequests()) {
                Path changedPath;
                if (!this.systemWorkspaceName.equals(change.changedWorkspace()) || (changedPath = change.changedLocation().getPath()) == null) continue;
                for (JcrSystemObserver jcrSystemObserver : this.jcrSystemObservers) {
                    if (!changedPath.isAtOrBelow(jcrSystemObserver.getObservedPath())) continue;
                    systemChanges.put((Object)jcrSystemObserver, (Object)change);
                }
            }
            for (JcrSystemObserver jcrSystemObserver : systemChanges.keySet()) {
                List changesForObserver = (List)systemChanges.get((Object)jcrSystemObserver);
                Changes filteredChanges = new Changes(changes.getProcessId(), changes.getContextId(), changes.getUserName(), this.systemSourceName, changes.getTimestamp(), changesForObserver, changes.getData());
                jcrSystemObserver.notify(filteredChanges);
            }
        }
    }

    public class Metrics {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getActiveSessionCount() {
            WeakHashMap<JcrSession, Object> weakHashMap = JcrRepository.this.activeSessions;
            synchronized (weakHashMap) {
                return JcrRepository.this.activeSessions.size();
            }
        }
    }

    protected class RepositoryObservationManager
    implements Observable,
    Observer {
        private final ExecutorService observerService = Executors.newSingleThreadExecutor();
        private final CopyOnWriteArrayList<Observer> observers = new CopyOnWriteArrayList();
        private final Observable repositoryObservable;
        private final String sourceName;
        private final String systemSourceName;
        private final String repositorySourceName;
        private final String processId;

        protected RepositoryObservationManager(Observable repositoryObservable) {
            this.repositoryObservable = repositoryObservable;
            this.repositoryObservable.register((Observer)this);
            this.sourceName = JcrRepository.this.getObservableSourceName();
            this.systemSourceName = JcrRepository.this.getSystemSourceName();
            this.repositorySourceName = JcrRepository.this.getRepositorySourceName();
            this.processId = JcrRepository.this.getExecutionContext().getProcessId();
        }

        public void notify(Changes changes) {
            final Changes acceptableChanges = this.filter(changes);
            if (acceptableChanges != null) {
                if (this.observers.isEmpty()) {
                    return;
                }
                final Iterator<Observer> observerIterator = this.observers.iterator();
                Runnable sender = new Runnable(){

                    @Override
                    public void run() {
                        while (observerIterator.hasNext()) {
                            Observer observer = (Observer)observerIterator.next();
                            assert (observer != null);
                            observer.notify(acceptableChanges);
                        }
                    }
                };
                this.observerService.execute(sender);
            }
        }

        private Changes filter(Changes changes) {
            String changedSourceName = changes.getSourceName();
            if (this.sourceName.equals(changedSourceName)) {
                return changes;
            }
            if (this.repositorySourceName.equals(changedSourceName)) {
                if (this.processId.equals(changes.getProcessId())) {
                    return null;
                }
                return new Changes(changes.getProcessId(), changes.getContextId(), changes.getUserName(), this.sourceName, changes.getTimestamp(), changes.getChangeRequests(), changes.getData());
            }
            assert (!changedSourceName.equals(this.repositorySourceName));
            if (this.systemSourceName.equals(changedSourceName)) {
                return changes;
            }
            return null;
        }

        public boolean register(Observer observer) {
            if (observer == null) {
                return false;
            }
            return this.observers.addIfAbsent(observer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            RepositoryObservationManager repositoryObservationManager = this;
            synchronized (repositoryObservationManager) {
                this.repositoryObservable.unregister((Observer)this);
                this.observers.clear();
                this.observerService.shutdown();
            }
        }

        public boolean unregister(Observer observer) {
            if (observer == null) {
                return false;
            }
            return this.observers.remove(observer);
        }
    }

    @Immutable
    protected static class SourceWorkspacePair {
        private final String sourceName;
        private final String workspaceName;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected SourceWorkspacePair(String sourceAndWorkspaceName) {
            assert (sourceAndWorkspaceName != null);
            sourceAndWorkspaceName = sourceAndWorkspaceName.trim();
            assert (sourceAndWorkspaceName.length() != 0);
            sourceAndWorkspaceName = sourceAndWorkspaceName.trim();
            int maxIndex = sourceAndWorkspaceName.length() - 1;
            int index = sourceAndWorkspaceName.indexOf(64);
            while (index > 0 && index < maxIndex && sourceAndWorkspaceName.charAt(index - 1) == '\\') {
                index = sourceAndWorkspaceName.indexOf(64, index + 1);
            }
            if (index > 0) {
                this.workspaceName = sourceAndWorkspaceName.substring(0, index).trim().replaceAll("\\\\@", "@");
                if (index >= maxIndex) throw new IllegalArgumentException("The source name is invalid");
                this.sourceName = sourceAndWorkspaceName.substring(index + 1).trim().replaceAll("\\\\@", "@");
            } else if (index == 0) {
                this.sourceName = sourceAndWorkspaceName.length() == 1 ? "" : sourceAndWorkspaceName.substring(1).trim().replaceAll("\\\\@", "@");
                this.workspaceName = "";
            } else {
                this.workspaceName = null;
                this.sourceName = sourceAndWorkspaceName.replaceAll("\\\\@", "@");
            }
            assert (this.sourceName != null);
            return;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public String toString() {
            if (this.sourceName == null) {
                return "";
            }
            if (this.workspaceName != null) {
                return this.workspaceName + '@' + this.sourceName;
            }
            return this.sourceName;
        }
    }

    protected class DelegatingConnectionFactory
    implements RepositoryConnectionFactory {
        private final RepositoryConnectionFactory delegate;
        private final RepositorySource source;

        protected DelegatingConnectionFactory(RepositoryConnectionFactory delegate, RepositorySource source) {
            assert (delegate != null);
            this.delegate = delegate;
            this.source = source;
        }

        public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
            if (this.source.getName().equals(sourceName)) {
                return this.source.getConnection();
            }
            return this.delegate.createConnection(sourceName);
        }
    }

    protected class FederatedRepositoryContext
    implements RepositoryContext {
        private final RepositoryConnectionFactory connectionFactory;

        protected FederatedRepositoryContext(RepositoryConnectionFactory nonFederatingConnectionFactory) {
            this.connectionFactory = nonFederatingConnectionFactory;
        }

        public Subgraph getConfiguration(int depth) {
            throw new UnsupportedOperationException();
        }

        public ExecutionContext getExecutionContext() {
            return JcrRepository.this.getExecutionContext();
        }

        public Observer getObserver() {
            return JcrRepository.this.getObserver();
        }

        public RepositoryConnectionFactory getRepositoryConnectionFactory() {
            return this.connectionFactory;
        }
    }

    public static final class QueryLanguage {
        public static final String XPATH = "xpath";
        public static final String JCR_SQL = "sql";
        public static final String JCR_SQL2 = "JCR-SQL2";
        public static final String JCR_JQOM = "JCR-JQOM";
        public static final String SEARCH = "Search";
    }

    public static class DefaultOption {
        public static final String PROJECT_NODE_TYPES = Boolean.TRUE.toString();
        public static final String JAAS_LOGIN_CONFIG_NAME = "modeshape-jcr";
        public static final String READ_DEPTH = "1";
        public static final String INDEX_READ_DEPTH = "4";
        public static final String ANONYMOUS_USER_ROLES = "admin";
        public static final String TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES = Boolean.TRUE.toString();
        public static final String QUERY_EXECUTION_ENABLED = Boolean.TRUE.toString();
        public static final String QUERY_INDEXES_UPDATED_SYNCHRONOUSLY = Boolean.TRUE.toString();
        public static final String QUERY_INDEX_DIRECTORY = null;
        public static final String PERFORM_REFERENTIAL_INTEGRITY_CHECKS = Boolean.TRUE.toString();
    }

    public static enum Option {
        PROJECT_NODE_TYPES,
        JAAS_LOGIN_CONFIG_NAME,
        SYSTEM_SOURCE_NAME,
        READ_DEPTH,
        INDEX_READ_DEPTH,
        ANONYMOUS_USER_ROLES,
        TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES,
        QUERY_EXECUTION_ENABLED,
        QUERY_INDEX_DIRECTORY,
        QUERY_INDEXES_UPDATED_SYNCHRONOUSLY,
        PERFORM_REFERENTIAL_INTEGRITY_CHECKS;


        public static Option findOption(String option) {
            if (option == null) {
                return null;
            }
            try {
                return Option.valueOf(option);
            }
            catch (IllegalArgumentException e) {
                try {
                    return Option.valueOf(option.toUpperCase());
                }
                catch (IllegalArgumentException e2) {
                    String underscored = Inflector.getInstance().underscore(option, new char[]{'_'});
                    if (underscored == null) {
                        throw e2;
                    }
                    return Option.valueOf(underscored.toUpperCase());
                }
            }
        }
    }
}

