/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextExtractorContext
extends ExecutionContext {
    private final Path inputPath;
    private final Map<Name, Property> inputPropertiesByName;
    private final Set<Property> inputProperties;
    private final Problems problems;
    private final String mimeType;

    public TextExtractorContext(ExecutionContext context, Path inputPath, Set<Property> inputProperties, String mimeType, Problems problems) {
        super(context);
        this.inputPath = inputPath;
        this.inputProperties = inputProperties != null ? new HashSet<Property>(inputProperties) : new HashSet();
        this.mimeType = mimeType;
        this.problems = problems != null ? problems : new SimpleProblems();
        HashMap<Name, Property> inputPropertiesByName = new HashMap<Name, Property>();
        for (Property property : this.inputProperties) {
            inputPropertiesByName.put(property.getName(), property);
        }
        this.inputPropertiesByName = Collections.unmodifiableMap(inputPropertiesByName);
    }

    public Path getInputPath() {
        return this.inputPath;
    }

    public Set<Property> getInputProperties() {
        return this.inputProperties;
    }

    public Property getInputProperty(Name name) {
        return this.inputPropertiesByName.get(name);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Problems getProblems() {
        return this.problems;
    }

    @Override
    public TextExtractorContext with(ClassLoaderFactory classLoaderFactory) {
        return new TextExtractorContext(super.with(classLoaderFactory), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public TextExtractorContext with(Map<String, String> data) {
        return new TextExtractorContext(super.with(data), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public TextExtractorContext with(MimeTypeDetector mimeTypeDetector) {
        return new TextExtractorContext(super.with(mimeTypeDetector), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public TextExtractorContext with(NamespaceRegistry namespaceRegistry) {
        return new TextExtractorContext(super.with(namespaceRegistry), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public TextExtractorContext with(SecurityContext securityContext) {
        return new TextExtractorContext(super.with(securityContext), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public TextExtractorContext with(String key, String value) {
        return new TextExtractorContext(super.with(key, value), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }

    @Override
    public TextExtractorContext with(String processId) {
        return new TextExtractorContext(super.with(processId), this.inputPath, this.inputProperties, this.mimeType, this.problems);
    }
}

