/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Query
implements QueryCommand {
    private static final long serialVersionUID = 1L;
    public static final boolean IS_DISTINCT_DEFAULT = false;
    private final List<? extends Ordering> orderings;
    private final Limit limits;
    private final Source source;
    private final Constraint constraint;
    private final List<? extends Column> columns;
    private final boolean distinct;
    private final int hc;

    public Query(Source source) {
        CheckArg.isNotNull((Object)source, (String)"source");
        this.orderings = Collections.emptyList();
        this.limits = Limit.NONE;
        this.source = source;
        this.constraint = null;
        this.columns = Collections.emptyList();
        this.distinct = false;
        this.hc = HashCode.compute((Object[])new Object[]{this.source, this.constraint, this.columns, this.distinct});
    }

    public Query(Source source, Constraint constraint, List<? extends Ordering> orderings, List<? extends Column> columns, Limit limit, boolean isDistinct) {
        CheckArg.isNotNull((Object)source, (String)"source");
        this.source = source;
        this.constraint = constraint;
        this.columns = columns != null ? columns : Collections.emptyList();
        this.distinct = isDistinct;
        this.orderings = orderings != null ? orderings : Collections.emptyList();
        this.limits = limit != null ? limit : Limit.NONE;
        this.hc = HashCode.compute((Object[])new Object[]{this.source, this.constraint, this.columns, this.distinct});
    }

    @Override
    public Limit limits() {
        return this.limits;
    }

    @Override
    public List<? extends Ordering> orderings() {
        return this.orderings;
    }

    public Source source() {
        return this.source;
    }

    public Constraint constraint() {
        return this.constraint;
    }

    @Override
    public List<? extends Column> columns() {
        return this.columns;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Query distinct() {
        return new Query(this.source, this.constraint, this.orderings(), this.columns, this.limits(), true);
    }

    public Query noDistinct() {
        return new Query(this.source, this.constraint, this.orderings(), this.columns, this.limits(), false);
    }

    public Query constrainedBy(Constraint constraint) {
        return new Query(this.source, constraint, this.orderings(), this.columns, this.limits(), this.distinct);
    }

    public Query orderedBy(List<Ordering> orderings) {
        return new Query(this.source, this.constraint, orderings, this.columns, this.limits(), this.distinct);
    }

    @Override
    public Query withLimit(int rowLimit) {
        if (this.limits().rowLimit() == rowLimit) {
            return this;
        }
        return new Query(this.source, this.constraint, this.orderings(), this.columns, this.limits().withRowLimit(rowLimit), this.distinct);
    }

    @Override
    public Query withOffset(int offset) {
        if (this.limits().offset() == offset) {
            return this;
        }
        return new Query(this.source, this.constraint, this.orderings(), this.columns, this.limits().withOffset(offset), this.distinct);
    }

    public Query returning(List<Column> columns) {
        return new Query(this.source, this.constraint, this.orderings(), columns, this.limits(), this.distinct);
    }

    public Query adding(Ordering ... orderings) {
        List<Ordering> newOrderings = null;
        if (this.orderings() != null) {
            newOrderings = new ArrayList<Ordering>(this.orderings());
            for (Ordering ordering : orderings) {
                newOrderings.add(ordering);
            }
        } else {
            newOrderings = Arrays.asList(orderings);
        }
        return new Query(this.source, this.constraint, newOrderings, this.columns, this.limits(), this.distinct);
    }

    public Query adding(Column ... columns) {
        List<Column> newColumns = null;
        if (this.columns != null) {
            newColumns = new ArrayList<Column>(this.columns);
            for (Column column : columns) {
                newColumns.add(column);
            }
        } else {
            newColumns = Arrays.asList(columns);
        }
        return new Query(this.source, this.constraint, this.orderings(), newColumns, this.limits(), this.distinct);
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Query) {
            Query that = (Query)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (this.distinct != that.distinct) {
                return false;
            }
            if (!this.source.equals(that.source)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.limits(), (Object)that.limits())) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.constraint, (Object)that.constraint)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls(this.columns, that.columns)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls(this.orderings(), that.orderings());
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

