/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicEmptyProperty;
import org.modeshape.graph.property.basic.BasicMultiValueProperty;
import org.modeshape.graph.property.basic.BasicPropertyFactory;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SystemPropertyFactory
extends BasicPropertyFactory {
    private final ValueFactories factories;
    private static final String CURLY_PREFIX = "${";
    private static final String CURLY_SUFFIX = "}";
    private static final String VAR_DELIM = ",";
    private static final String DEFAULT_DELIM = ":";

    public SystemPropertyFactory(ValueFactories valueFactories) {
        super(valueFactories);
        this.factories = valueFactories;
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Object ... values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (values == null || values.length == 0) {
            return new BasicEmptyProperty(name);
        }
        int len = values.length;
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        if (values.length == 1) {
            Object value = values[0];
            if (value instanceof Path) {
                value = factory.create(value);
                return new BasicSingleValueProperty(name, value);
            }
            if (value instanceof Collection) {
                return this.create(name, desiredType, (Iterable)value);
            }
            if (value instanceof Iterator) {
                return this.create(name, desiredType, (Iterator)value);
            }
            if (value instanceof Object[]) {
                return this.create(name, desiredType, (Object[])value);
            }
            if (value instanceof String) {
                value = factory.create(this.getSubstitutedProperty((String)value));
                return new BasicSingleValueProperty(name, value);
            }
            value = factory.create(value);
            return new BasicSingleValueProperty(name, value);
        }
        ArrayList<Object> valueList = new ArrayList<Object>(len);
        for (int i = 0; i != len; ++i) {
            Object value = factory.create(values[i]);
            valueList.add(value);
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterable<?> values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        ArrayList<Object> valueList = null;
        if (values instanceof Collection) {
            Collection originalValues = (Collection)values;
            if (originalValues.isEmpty()) {
                return new BasicEmptyProperty(name);
            }
            valueList = new ArrayList(originalValues.size());
        } else {
            valueList = new ArrayList<Object>();
        }
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        for (Object value : values) {
            valueList.add(factory.create(value));
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        if (valueList.size() == 1) {
            Object o = valueList.get(0);
            if (o instanceof String) {
                o = this.getSubstitutedProperty((String)o);
            }
            return new BasicSingleValueProperty(name, o);
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterator<?> values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        while (values.hasNext()) {
            Object value = values.next();
            value = factory.create(value);
            valueList.add(value);
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        if (valueList.size() == 1) {
            Object o = valueList.get(0);
            if (o instanceof String) {
                o = this.getSubstitutedProperty((String)o);
            }
            return new BasicSingleValueProperty(name, o);
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    protected String getSubstitutedProperty(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        StringBuffer sb = null;
        sb = new StringBuffer(value);
        int startName = sb.indexOf(CURLY_PREFIX);
        if (startName == -1) {
            return value;
        }
        while (startName != -1) {
            String defaultValue = null;
            int endName = sb.indexOf(CURLY_SUFFIX, startName);
            if (endName == -1) {
                return sb.toString();
            }
            String varString = sb.substring(startName + 2, endName);
            if (varString.indexOf(DEFAULT_DELIM) > -1) {
                List<String> defaults = SystemPropertyFactory.split(varString, DEFAULT_DELIM);
                varString = defaults.get(0);
                if (defaults.size() == 2) {
                    defaultValue = defaults.get(1);
                }
            }
            String constValue = null;
            List<String> vars = SystemPropertyFactory.split(varString, VAR_DELIM);
            for (final String var : vars) {
                constValue = System.getenv(var);
                if (constValue == null) {
                    constValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty(var);
                        }
                    });
                }
                if (constValue == null) continue;
                break;
            }
            if (constValue == null && defaultValue != null) {
                constValue = defaultValue;
            }
            if (constValue != null) {
                sb = sb.replace(startName, endName + 1, constValue);
                startName = sb.indexOf(CURLY_PREFIX);
                continue;
            }
            startName = sb.indexOf(CURLY_PREFIX, endName);
        }
        return sb.toString();
    }

    private static List<String> split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }
}

