/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapNode
implements Node,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private UUID uuid;
    private Path.Segment name;
    private UUID parent;
    private Map<Name, Property> properties;
    private List<UUID> children;
    private int version = 1;
    protected transient Changes changes;

    public MapNode(UUID uuid, Path.Segment name, UUID parent, Map<Name, Property> properties, List<UUID> children) {
        this.uuid = uuid;
        this.name = name;
        this.parent = parent;
        this.properties = properties != null ? properties : Collections.emptyMap();
        List<UUID> list = this.children = children != null ? children : Collections.emptyList();
        assert (this.uuid != null);
        assert (this.properties != null);
        assert (this.children != null);
        assert (this.name == null ? this.parent == null : this.parent != null);
    }

    protected MapNode(UUID uuid, Path.Segment name, UUID parent, Map<Name, Property> properties, List<UUID> children, int version) {
        this.uuid = uuid;
        this.name = name;
        this.parent = parent;
        this.properties = properties != null ? properties : Collections.emptyMap();
        this.children = children != null ? children : Collections.emptyList();
        this.version = version;
        assert (this.uuid != null);
        assert (this.properties != null);
        assert (this.children != null);
        assert (this.name == null ? this.parent == null : this.parent != null);
    }

    public MapNode(UUID uuid, Path.Segment name, UUID parent, Iterable<Property> properties, List<UUID> children) {
        this.uuid = uuid;
        this.name = name;
        this.parent = parent;
        if (properties != null) {
            HashMap<Name, Property> props = new HashMap<Name, Property>();
            for (Property prop : properties) {
                props.put(prop.getName(), prop);
            }
            this.properties = props.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(props);
        } else {
            this.properties = Collections.emptyMap();
        }
        List<UUID> list = this.children = children != null ? children : Collections.emptyList();
        assert (this.uuid != null);
        assert (this.properties != null);
        assert (this.children != null);
        assert (this.name == null ? this.parent == null : this.parent != null);
    }

    public MapNode(UUID uuid) {
        this.uuid = uuid;
        this.name = null;
        this.parent = null;
        this.properties = Collections.emptyMap();
        this.children = Collections.emptyList();
        assert (this.uuid != null);
        assert (this.properties != null);
        assert (this.children != null);
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Path.Segment getName() {
        return this.changes != null ? this.changes.getName() : this.name;
    }

    @Override
    public Map<Name, Property> getProperties() {
        return this.changes != null ? this.changes.getProperties(false) : this.properties;
    }

    @Override
    public Property getProperty(Name name) {
        return this.getProperties().get(name);
    }

    public UUID getParent() {
        return this.changes != null ? this.changes.getParent() : this.parent;
    }

    public List<UUID> getChildren() {
        return this.changes != null ? this.changes.getChildren(false) : this.children;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            Node that = (Node)obj;
            return this.getUuid().equals(that.getUuid());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name == null) {
            sb.append("(");
        } else {
            sb.append(this.name).append(" (");
        }
        sb.append(this.uuid).append(")");
        return sb.toString();
    }

    public MapNode clone() {
        return new MapNode(this.uuid, this.name, this.parent, this.properties, this.children);
    }

    protected boolean hasChanges() {
        return this.changes != null;
    }

    protected Changes newChanges() {
        return new Changes();
    }

    public MapNode freeze() {
        if (!this.hasChanges()) {
            return this;
        }
        return new MapNode(this.uuid, this.changes.getName(), this.changes.getParent(), this.changes.getUnmodifiableProperties(), this.changes.getUnmodifiableChildren(), this.version + 1);
    }

    public MapNode withParent(UUID parent) {
        if (this.changes == null) {
            MapNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setParent(parent);
            return copy;
        }
        this.changes.setParent(parent);
        return this;
    }

    public MapNode withName(Path.Segment name) {
        if (this.changes == null) {
            MapNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setName(name);
            return copy;
        }
        this.changes.setName(name);
        return this;
    }

    public MapNode withChild(UUID child) {
        assert (child != null);
        if (this.getChildren().indexOf(child) != -1) {
            return this;
        }
        if (this.changes == null) {
            MapNode copy = this.clone();
            ArrayList<UUID> children = new ArrayList<UUID>(this.getChildren());
            assert (!children.contains(child));
            children.add(child);
            copy.changes = this.newChanges();
            copy.changes.setChildren(children);
            return copy;
        }
        this.changes.getChildren(true).add(child);
        return this;
    }

    public MapNode withChild(int index, UUID child) {
        assert (child != null);
        assert (index >= 0);
        int existingIndex = this.getChildren().indexOf(child);
        if (existingIndex == index) {
            return this;
        }
        if (this.changes == null) {
            MapNode copy = this.clone();
            ArrayList<UUID> children = new ArrayList<UUID>(this.getChildren());
            if (existingIndex >= 0) {
                children.remove(existingIndex);
                if (existingIndex < index) {
                    --index;
                }
            }
            children.add(index, child);
            copy.changes = this.newChanges();
            copy.changes.setChildren(children);
            return copy;
        }
        List<UUID> children = this.changes.getChildren(true);
        if (existingIndex >= 0) {
            children.remove(existingIndex);
            if (existingIndex < index) {
                --index;
            }
        }
        children.add(index, child);
        return this;
    }

    public MapNode withoutChild(UUID child) {
        assert (child != null);
        if (this.changes == null) {
            MapNode copy = this.clone();
            ArrayList<UUID> children = new ArrayList<UUID>(this.getChildren());
            children.remove(child);
            copy.changes = this.newChanges();
            copy.changes.setChildren(children);
            return copy;
        }
        this.changes.getChildren(true).remove(child);
        return this;
    }

    public MapNode withoutChildren() {
        if (this.getChildren().isEmpty()) {
            return this;
        }
        if (this.changes == null) {
            MapNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setChildren(new ArrayList<UUID>());
            return copy;
        }
        this.changes.getChildren(true).clear();
        return this;
    }

    public MapNode withProperties(Iterable<Property> propertiesToSet, Iterable<Name> propertiesToRemove, boolean removeAllExisting) {
        if (propertiesToSet == null && propertiesToRemove == null && !removeAllExisting) {
            return this;
        }
        Map<Name, Property> newProperties = null;
        MapNode result = this;
        if (this.changes == null) {
            MapNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setProperties(new HashMap<Name, Property>(this.properties));
            newProperties = copy.changes.getProperties(true);
            result = copy;
        } else {
            newProperties = this.changes.getProperties(true);
        }
        if (removeAllExisting) {
            newProperties.clear();
        } else if (propertiesToRemove != null) {
            for (Name name : propertiesToRemove) {
                if (JcrLexicon.UUID.equals(name) || ModeShapeLexicon.UUID.equals(name)) continue;
                newProperties.remove(name);
            }
        } else if (propertiesToSet == null) {
            return this;
        }
        if (propertiesToSet != null) {
            for (Property property : propertiesToSet) {
                newProperties.put(property.getName(), property);
            }
        }
        return result;
    }

    public MapNode withProperty(Property property) {
        if (property == null) {
            return this;
        }
        if (this.changes == null) {
            MapNode copy = this.clone();
            copy.changes = this.newChanges();
            HashMap<Name, Property> newProps = new HashMap<Name, Property>(this.properties);
            newProps.put(property.getName(), property);
            copy.changes.setProperties(newProps);
            return copy;
        }
        this.changes.getProperties(true).put(property.getName(), property);
        return this;
    }

    public MapNode withoutProperty(Name propertyName) {
        if (propertyName == null || !this.getProperties().containsKey(propertyName)) {
            return this;
        }
        if (this.changes == null) {
            MapNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setProperties(new HashMap<Name, Property>(this.properties));
            return copy;
        }
        this.changes.getProperties(true).remove(propertyName);
        return this;
    }

    public MapNode withoutProperties() {
        if (this.getProperties().isEmpty()) {
            return this;
        }
        if (this.changes == null) {
            MapNode copy = this.clone();
            copy.changes = this.newChanges();
            copy.changes.setProperties(new HashMap<Name, Property>());
            return copy;
        }
        this.changes.getProperties(true).clear();
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Changes {
        private Path.Segment name;
        private UUID parent;
        private Map<Name, Property> properties;
        private List<UUID> children;

        protected Changes() {
        }

        public Path.Segment getName() {
            return this.name != null ? this.name : MapNode.this.name;
        }

        public void setName(Path.Segment name) {
            this.name = name;
        }

        public UUID getParent() {
            return this.parent != null ? this.parent : MapNode.this.parent;
        }

        public void setParent(UUID parent) {
            this.parent = parent;
        }

        public Map<Name, Property> getProperties(boolean createIfMissing) {
            if (this.properties == null) {
                if (createIfMissing) {
                    this.properties = new HashMap<Name, Property>(MapNode.this.properties);
                    return this.properties;
                }
                return MapNode.this.properties;
            }
            return this.properties;
        }

        public Map<Name, Property> getUnmodifiableProperties() {
            return this.properties != null ? Collections.unmodifiableMap(this.properties) : MapNode.this.properties;
        }

        public void setProperties(Map<Name, Property> properties) {
            this.properties = properties;
        }

        public List<UUID> getChildren(boolean createIfMissing) {
            if (this.children == null) {
                if (createIfMissing) {
                    this.children = new ArrayList<UUID>();
                    return this.children;
                }
                return MapNode.this.children;
            }
            return this.children;
        }

        public List<UUID> getUnmodifiableChildren() {
            return this.children != null ? Collections.unmodifiableList(this.children) : MapNode.this.children;
        }

        public void setChildren(List<UUID> children) {
            this.children = children;
        }
    }
}

