/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.security.AccessController;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.xa.XAResource;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.request.Request;

@ThreadSafe
public class RepositoryConnectionPool {
    public static final long DEFAULT_TIME_TO_WAIT = 10L;
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_CORE_POOL_SIZE = 1;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 10;
    public static final long DEFAULT_KEEP_ALIVE_TIME_IN_SECONDS = 30L;
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private final RepositorySource source;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final BlockingQueue<ConnectionWrapper> availableConnections = new LinkedBlockingQueue<ConnectionWrapper>();
    private final Set<ConnectionWrapper> inUseConnections = new HashSet<ConnectionWrapper>();
    @Description(i18n=GraphI18n.class, value="poolKeepAliveTimeDescription")
    @Label(i18n=GraphI18n.class, value="poolKeepAliveTimeLabel")
    @Category(i18n=GraphI18n.class, value="poolKeepAliveTimeCategory")
    private volatile long keepAliveTime;
    @Description(i18n=GraphI18n.class, value="poolCorePoolSizeDescription")
    @Label(i18n=GraphI18n.class, value="poolCorePoolSizeLabel")
    @Category(i18n=GraphI18n.class, value="poolCorePoolSizeCategory")
    private volatile int corePoolSize;
    @Description(i18n=GraphI18n.class, value="poolMaxiumumPoolSizeDescription")
    @Label(i18n=GraphI18n.class, value="poolMaxiumumPoolSizeLabel")
    @Category(i18n=GraphI18n.class, value="poolMaxiumumPoolSizeCategory")
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    private volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    @Description(i18n=GraphI18n.class, value="poolValidateConnectionBeforeUseDescription")
    @Label(i18n=GraphI18n.class, value="poolValidateConnectionBeforeUseLabel")
    @Category(i18n=GraphI18n.class, value="poolValidateConnectionBeforeUseCategory")
    private final AtomicBoolean validateConnectionBeforeUse = new AtomicBoolean(false);
    @Description(i18n=GraphI18n.class, value="poolPingTimeoutDescription")
    @Label(i18n=GraphI18n.class, value="poolPingTimeoutLabel")
    @Category(i18n=GraphI18n.class, value="poolPingTimeoutCategory")
    private final AtomicLong pingTimeout = new AtomicLong(0L);
    @Description(i18n=GraphI18n.class, value="poolMaximumFailedAttemptsBeforeErrorDescription")
    @Label(i18n=GraphI18n.class, value="poolMaximumFailedAttemptsBeforeErrorLabel")
    @Category(i18n=GraphI18n.class, value="poolMaximumFailedAttemptsBeforeErrorCategory")
    private final AtomicInteger maxFailedAttemptsBeforeError = new AtomicInteger(10);
    private final AtomicLong totalConnectionsCreated = new AtomicLong(0L);
    private final AtomicLong totalConnectionsUsed = new AtomicLong(0L);
    private static final Logger LOGGER = Logger.getLogger(RepositoryConnectionPool.class);

    public RepositoryConnectionPool(RepositorySource source) {
        this(source, 1, 10, 30L, TimeUnit.SECONDS);
    }

    public RepositoryConnectionPool(RepositorySource source, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        CheckArg.isNonNegative((int)corePoolSize, (String)"corePoolSize");
        CheckArg.isPositive((int)maximumPoolSize, (String)"maximumPoolSize");
        CheckArg.isNonNegative((long)keepAliveTime, (String)"keepAliveTime");
        CheckArg.isNotNull((Object)source, (String)"source");
        if (maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException(GraphI18n.maximumPoolSizeMayNotBeSmallerThanCorePoolSize.text(new Object[0]));
        }
        this.source = source;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.setPingTimeout(100L, TimeUnit.MILLISECONDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ping(long time, TimeUnit unit) throws InterruptedException {
        boolean bl;
        if (!this.isRunning()) return false;
        RepositoryConnection connection = null;
        Exception error = null;
        try {
            try {
                connection = this.getConnection();
                bl = connection.ping(time, unit);
                Object var8_8 = null;
                if (connection == null) return bl;
            }
            catch (RuntimeException t) {
                error = t;
                throw t;
            }
            catch (InterruptedException t) {
                error = t;
                throw t;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (RuntimeException e) {
                if (error != null) throw throwable;
                throw e;
            }
        }
        try {}
        catch (RuntimeException e) {
            if (error != null) return bl;
            throw e;
        }
        connection.close();
        return bl;
    }

    public boolean ping() throws InterruptedException {
        return this.ping(10L, DEFAULT_TIME_UNIT);
    }

    public final RepositorySource getRepositorySource() {
        return this.source;
    }

    protected String getSourceName() {
        return this.source.getName();
    }

    public boolean getValidateConnectionBeforeUse() {
        return this.validateConnectionBeforeUse.get();
    }

    public void setValidateConnectionBeforeUse(boolean validateConnectionBeforeUse) {
        this.validateConnectionBeforeUse.set(validateConnectionBeforeUse);
    }

    public long getPingTimeoutInNanos() {
        return this.pingTimeout.get();
    }

    public void setPingTimeout(long pingTimeout, TimeUnit unit) {
        CheckArg.isNonNegative((long)pingTimeout, (String)"time");
        this.pingTimeout.set(unit.toNanos(pingTimeout));
    }

    public long getPingTimeout() {
        return TimeUnit.NANOSECONDS.toSeconds(this.pingTimeout.get());
    }

    public void setPingTimeout(long pingTimeoutInSeconds) {
        this.setPingTimeout(pingTimeoutInSeconds, TimeUnit.SECONDS);
    }

    public int getMaxFailedAttemptsBeforeError() {
        return this.maxFailedAttemptsBeforeError.get();
    }

    public void setMaxFailedAttemptsBeforeError(int maxFailedAttemptsBeforeError) {
        this.maxFailedAttemptsBeforeError.set(maxFailedAttemptsBeforeError);
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        CheckArg.isNonNegative((long)time, (String)"time");
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        assert (unit != null);
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public long getKeepAliveTime() {
        return this.getKeepAliveTime(TimeUnit.SECONDS);
    }

    public void setKeepAliveTime(long time) {
        this.setKeepAliveTime(time, TimeUnit.SECONDS);
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        CheckArg.isPositive((int)maximumPoolSize, (String)"maximum pool size");
        if (maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException(GraphI18n.maximumPoolSizeMayNotBeSmallerThanCorePoolSize.text(new Object[0]));
        }
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int extra = this.maximumPoolSize - maximumPoolSize;
            this.maximumPoolSize = maximumPoolSize;
            if (extra > 0 && this.poolSize > maximumPoolSize) {
                this.drainUnusedConnections(extra);
            }
            Object var5_4 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) throws RepositorySourceException, InterruptedException {
        CheckArg.isNonNegative((int)corePoolSize, (String)"core pool size");
        if (this.maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException(GraphI18n.maximumPoolSizeMayNotBeSmallerThanCorePoolSize.text(new Object[0]));
        }
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int extra = this.corePoolSize - corePoolSize;
            this.corePoolSize = corePoolSize;
            if (extra < 0) {
                this.addConnectionsIfUnderCorePoolSize();
            } else if (extra > 0 && this.poolSize > corePoolSize) {
                this.drainUnusedConnections(extra);
            }
            Object var5_4 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInUseCount() {
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int n = this.inUseConnections.size();
            Object var4_3 = null;
            mainLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public long getTotalConnectionsCreated() {
        return this.totalConnectionsCreated.get();
    }

    public long getTotalConnectionsUsed() {
        return this.totalConnectionsUsed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prestartCoreConnection() throws RepositorySourceException, InterruptedException {
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            boolean bl = this.addConnectionIfUnderCorePoolSize();
            Object var4_3 = null;
            mainLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prestartAllCoreConnections() throws RepositorySourceException, InterruptedException {
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int n = this.addConnectionsIfUnderCorePoolSize();
            Object var4_3 = null;
            mainLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        LOGGER.debug("Shutting down repository connection pool for {0}", new Object[]{this.getSourceName()});
        boolean fullyTerminated = false;
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int state = this.runState;
            if (state == 0) {
                this.runState = 1;
            }
            if (!this.availableConnections.isEmpty()) {
                this.drainUnusedConnections(this.availableConnections.size());
            }
            if (this.inUseConnections.isEmpty()) {
                fullyTerminated = true;
                LOGGER.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                this.runState = 3;
                this.termination.signalAll();
                LOGGER.debug("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
            }
            Object var6_5 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            mainLock.unlock();
            throw throwable;
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        LOGGER.debug("Shutting down (immediately) repository connection pool for {0}", new Object[]{this.getSourceName()});
        boolean fullyTerminated = false;
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int state = this.runState;
            if (state != 3) {
                this.runState = 2;
            }
            if (!this.availableConnections.isEmpty()) {
                this.drainUnusedConnections(this.availableConnections.size());
            }
            if (!this.inUseConnections.isEmpty()) {
                for (ConnectionWrapper connectionInUse : this.inUseConnections) {
                    LOGGER.trace("Closing repository connection to {0}", new Object[]{this.getSourceName()});
                    connectionInUse.getOriginal().close();
                }
                this.poolSize -= this.inUseConnections.size();
            } else {
                fullyTerminated = true;
                LOGGER.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                this.runState = 3;
                this.termination.signalAll();
                LOGGER.debug("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
            }
            Object var8_7 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            mainLock.unlock();
            throw throwable;
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    public boolean isRunning() {
        return this.runState == 0;
    }

    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    public boolean isTerminated() {
        return this.runState == 3;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        LOGGER.trace("Awaiting termination", new Object[0]);
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            while (true) {
                if (this.runState != 3) break block5;
                bl = true;
                Object var9_7 = null;
                mainLock.unlock();
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            mainLock.unlock();
            LOGGER.trace("Finished awaiting termination", new Object[0]);
            throw throwable;
        }
        {
            block6: {
                block5: {
                    LOGGER.trace("Finished awaiting termination", new Object[0]);
                    return bl;
                }
                if (nanos > 0L) break block6;
                boolean bl2 = false;
                Object var9_8 = null;
                mainLock.unlock();
                LOGGER.trace("Finished awaiting termination", new Object[0]);
                return bl2;
            }
            nanos = this.termination.awaitNanos(nanos);
            continue;
        }
    }

    protected void terminated() {
    }

    protected void finalize() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection getConnection() throws RepositorySourceException {
        int attemptsAllowed = this.maxFailedAttemptsBeforeError.get();
        ConnectionWrapper connection = null;
        int attemptsRemaining = attemptsAllowed;
        while (connection == null && attemptsRemaining > 0) {
            Object var6_5;
            --attemptsRemaining;
            ReentrantLock mainLock = this.mainLock;
            try {
                mainLock.lock();
                if (this.runState != 0) {
                    throw new IllegalStateException(GraphI18n.repositoryConnectionPoolIsNotRunning.text(new Object[0]));
                }
                if (this.poolSize < this.corePoolSize) {
                    connection = this.newWrappedConnection();
                } else {
                    connection = (ConnectionWrapper)this.availableConnections.poll();
                    if (connection == null && this.poolSize < this.maximumPoolSize) {
                        connection = this.newWrappedConnection();
                    }
                }
                if (connection != null) {
                    this.inUseConnections.add(connection);
                }
                var6_5 = null;
                mainLock.unlock();
            }
            catch (Throwable throwable) {
                var6_5 = null;
                mainLock.unlock();
                throw throwable;
            }
            if (connection == null) {
                Object var8_6;
                LOGGER.trace("Waiting for a repository connection from pool {0}", new Object[]{this.getSourceName()});
                try {
                    connection = this.availableConnections.take();
                }
                catch (InterruptedException e) {
                    LOGGER.trace("Cancelled obtaining a repository connection from pool {0}", new Object[]{this.getSourceName()});
                    Thread.interrupted();
                    throw new RepositorySourceException(this.getSourceName(), e);
                }
                mainLock = this.mainLock;
                mainLock.lock();
                try {
                    if (connection != null) {
                        this.inUseConnections.add(connection);
                    }
                    var8_6 = null;
                    mainLock.unlock();
                }
                catch (Throwable throwable) {
                    var8_6 = null;
                    mainLock.unlock();
                    throw throwable;
                }
                LOGGER.trace("Recieved a repository connection from pool {0}", new Object[]{this.getSourceName()});
            }
            if (connection == null || !this.validateConnectionBeforeUse.get()) continue;
            try {
                connection = this.validateConnection(connection);
            }
            catch (InterruptedException e) {
                LOGGER.trace("Cancelled validating a repository connection obtained from pool {0}", new Object[]{this.getSourceName()});
                this.returnConnection(connection);
                Thread.interrupted();
                throw new RepositorySourceException(this.getSourceName(), e);
            }
        }
        if (connection == null) {
            throw new RepositorySourceException(GraphI18n.unableToObtainValidRepositoryAfterAttempts.text(new Object[]{attemptsAllowed}));
        }
        this.totalConnectionsUsed.incrementAndGet();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(ConnectionWrapper wrapper) {
        assert (wrapper != null);
        ConnectionWrapper wrapperToClose = null;
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            boolean removed = this.inUseConnections.remove(wrapper);
            assert (removed);
            if (this.runState != 0) {
                wrapperToClose = wrapper;
            } else if (this.poolSize > this.maximumPoolSize) {
                wrapperToClose = wrapper;
            } else if (!this.availableConnections.offer(new ConnectionWrapper(wrapper.getOriginal()))) {
                wrapperToClose = wrapper;
            }
            Object var6_5 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            mainLock.unlock();
            throw throwable;
        }
        if (wrapperToClose != null) {
            this.closeConnection(wrapperToClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ConnectionWrapper validateConnection(ConnectionWrapper connection) throws InterruptedException {
        assert (connection != null);
        ConnectionWrapper invalidConnection = null;
        try {
            if (!connection.ping(this.pingTimeout.get(), TimeUnit.NANOSECONDS)) {
                invalidConnection = connection;
            }
            Object var4_3 = null;
            if (invalidConnection == null) return connection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (invalidConnection == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_8 = null;
                this.mainLock.unlock();
                throw throwable2;
            }
            this.mainLock.lock();
            connection = null;
            --this.poolSize;
            this.inUseConnections.remove(connection);
            Object var6_7 = null;
            this.mainLock.unlock();
            throw throwable;
        }
        try {
            this.mainLock.lock();
            connection = null;
            --this.poolSize;
            this.inUseConnections.remove(connection);
            Object var6_5 = null;
            this.mainLock.unlock();
            return connection;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mainLock.unlock();
            throw throwable;
        }
    }

    protected ConnectionWrapper newWrappedConnection() throws RepositorySourceException {
        RepositoryConnection connection = this.source.getConnection();
        ++this.poolSize;
        this.totalConnectionsCreated.incrementAndGet();
        return new ConnectionWrapper(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(ConnectionWrapper wrapper) {
        ReentrantLock mainLock2;
        assert (wrapper != null);
        RepositoryConnection original = wrapper.getOriginal();
        assert (original != null);
        try {
            LOGGER.debug("Closing repository connection to {0} ({1} open connections remain)", new Object[]{this.getSourceName(), this.poolSize});
            original.close();
            Object var4_3 = null;
            mainLock2 = this.mainLock;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ReentrantLock mainLock2 = this.mainLock;
            try {
                mainLock2.lock();
                --this.poolSize;
                if ((this.runState == 1 || this.runState == 2) && this.poolSize <= 0) {
                    LOGGER.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                    this.runState = 3;
                    this.termination.signalAll();
                    LOGGER.trace("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
                }
                Object var7_9 = null;
                mainLock2.unlock();
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                mainLock2.unlock();
                throw throwable2;
            }
            throw throwable;
        }
        try {
            mainLock2.lock();
            --this.poolSize;
            if ((this.runState == 1 || this.runState == 2) && this.poolSize <= 0) {
                LOGGER.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                this.runState = 3;
                this.termination.signalAll();
                LOGGER.trace("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
            }
            Object var7_7 = null;
            mainLock2.unlock();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            mainLock2.unlock();
            throw throwable;
        }
    }

    protected int drainUnusedConnections(int count) {
        if (count <= 0) {
            return 0;
        }
        LOGGER.trace("Draining up to {0} unused repository connections to {1}", new Object[]{count, this.getSourceName()});
        LinkedList extraConnections = new LinkedList();
        this.availableConnections.drainTo(extraConnections, count);
        for (ConnectionWrapper connection : extraConnections) {
            LOGGER.trace("Closing repository connection to {0}", new Object[]{this.getSourceName()});
            connection.getOriginal().close();
        }
        int numClosed = extraConnections.size();
        this.poolSize -= numClosed;
        LOGGER.trace("Drained {0} unused connections ({1} open connections remain)", new Object[]{numClosed, this.poolSize});
        return numClosed;
    }

    protected boolean addConnectionIfUnderCorePoolSize() throws RepositorySourceException {
        if (this.poolSize < this.corePoolSize) {
            this.availableConnections.offer(this.newWrappedConnection());
            LOGGER.trace("Added connection to {0} in undersized pool", new Object[]{this.getSourceName()});
            return true;
        }
        return false;
    }

    protected int addConnectionsIfUnderCorePoolSize() throws RepositorySourceException {
        int n = 0;
        while (this.poolSize < this.corePoolSize) {
            this.availableConnections.offer(this.newWrappedConnection());
            ++n;
        }
        LOGGER.trace("Added {0} connection(s) to {1} in undersized pool", new Object[]{n, this.getSourceName()});
        return n;
    }

    protected class ConnectionWrapper
    implements RepositoryConnection {
        private final RepositoryConnection original;
        private final long timeCreated;
        private long lastUsed;
        private boolean closed = false;

        protected ConnectionWrapper(RepositoryConnection connection) {
            assert (connection != null);
            this.original = connection;
            this.timeCreated = System.currentTimeMillis();
        }

        protected RepositoryConnection getOriginal() {
            return this.original;
        }

        public long getTimeLastUsed() {
            return this.lastUsed;
        }

        public long getTimeCreated() {
            return this.timeCreated;
        }

        public String getSourceName() {
            return this.original.getSourceName();
        }

        public XAResource getXAResource() {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            return this.original.getXAResource();
        }

        public CachePolicy getDefaultCachePolicy() {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            return this.original.getDefaultCachePolicy();
        }

        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            this.original.execute(context, request);
        }

        public boolean ping(long time, TimeUnit unit) throws InterruptedException {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            return this.original.ping(time, unit);
        }

        public void close() {
            if (!this.closed) {
                this.lastUsed = System.currentTimeMillis();
                this.closed = true;
                RepositoryConnectionPool.this.returnConnection(this);
            }
        }
    }
}

