/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.ArithmeticOperand;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.BindVariableName;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Join;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.LowerCase;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.SetQuery;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.Subquery;
import org.modeshape.graph.query.model.UpperCase;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visitors {
    public static <StrategyVisitor extends Visitor> StrategyVisitor visitAll(Visitable visitable, StrategyVisitor strategyVisitor) {
        if (visitable != null) {
            visitable.accept(new WalkAllVisitor(strategyVisitor));
        }
        return strategyVisitor;
    }

    public static <GeneralVisitor extends Visitor> GeneralVisitor visit(Visitable visitable, GeneralVisitor visitor) {
        if (visitable != null) {
            visitable.accept(visitor);
        }
        return visitor;
    }

    public static String readable(Visitable visitable) {
        return Visitors.visit(visitable, new ReadableVisitor()).getString();
    }

    public static Collection<Subquery> subqueries(Visitable visitable, final boolean includeNestedSubqueries) {
        final LinkedList<Subquery> subqueries = new LinkedList<Subquery>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            public void visit(Subquery subquery) {
                subqueries.add(subquery);
                if (includeNestedSubqueries) {
                    subquery.query().accept(this);
                }
            }
        });
        return subqueries;
    }

    public static Map<SelectorName, SelectorName> getSelectorNamesByAlias(Visitable visitable) {
        final HashMap<SelectorName, SelectorName> result = new HashMap<SelectorName, SelectorName>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            public void visit(AllNodes allNodes) {
                if (allNodes.hasAlias()) {
                    result.put(allNodes.alias(), allNodes.name());
                }
            }

            public void visit(NamedSelector selector) {
                if (selector.hasAlias()) {
                    result.put(selector.alias(), selector.name());
                }
            }
        });
        return result;
    }

    public static Map<SelectorName, SelectorName> getSelectorAliasesByName(Visitable visitable) {
        final HashMap<SelectorName, SelectorName> result = new HashMap<SelectorName, SelectorName>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            public void visit(AllNodes allNodes) {
                if (allNodes.hasAlias()) {
                    result.put(allNodes.name(), allNodes.aliasOrName());
                }
            }

            public void visit(NamedSelector selector) {
                if (selector.hasAlias()) {
                    result.put(selector.name(), selector.aliasOrName());
                }
            }
        });
        return result;
    }

    public static Set<SelectorName> getSelectorsReferencedBy(Visitable visitable) {
        final HashSet<SelectorName> symbols = new HashSet<SelectorName>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            public void visit(AllNodes allNodes) {
                if (allNodes.hasAlias()) {
                    symbols.add(allNodes.alias());
                } else {
                    symbols.add(allNodes.name());
                }
            }

            public void visit(ChildNode childNode) {
                symbols.add(childNode.selectorName());
            }

            public void visit(ChildNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.childSelectorName());
                symbols.add(joinCondition.parentSelectorName());
            }

            public void visit(Column column) {
                symbols.add(column.selectorName());
            }

            public void visit(DescendantNode descendant) {
                symbols.add(descendant.selectorName());
            }

            public void visit(DescendantNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.ancestorSelectorName());
                symbols.add(joinCondition.descendantSelectorName());
            }

            public void visit(EquiJoinCondition joinCondition) {
                symbols.add(joinCondition.selector1Name());
                symbols.add(joinCondition.selector2Name());
            }

            public void visit(FullTextSearch fullTextSearch) {
                symbols.add(fullTextSearch.selectorName());
            }

            public void visit(FullTextSearchScore fullTextSearchScore) {
                symbols.add(fullTextSearchScore.selectorName());
            }

            public void visit(Length length) {
                symbols.add(length.selectorName());
            }

            public void visit(NodeDepth depth) {
                symbols.add(depth.selectorName());
            }

            public void visit(NodePath path) {
                symbols.add(path.selectorName());
            }

            public void visit(NodeLocalName node) {
                symbols.add(node.selectorName());
            }

            public void visit(NodeName node) {
                symbols.add(node.selectorName());
            }

            public void visit(NamedSelector node) {
                if (node.hasAlias()) {
                    symbols.add(node.alias());
                } else {
                    symbols.add(node.name());
                }
            }

            public void visit(PropertyExistence prop) {
                symbols.add(prop.selectorName());
            }

            public void visit(PropertyValue prop) {
                symbols.add(prop.selectorName());
            }

            public void visit(Subquery obj) {
            }

            public void visit(ReferenceValue ref) {
                symbols.add(ref.selectorName());
            }

            public void visit(SameNode node) {
                symbols.add(node.selectorName());
            }

            public void visit(SameNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.selector1Name());
                symbols.add(joinCondition.selector2Name());
            }
        });
        return symbols;
    }

    public static class ReadableVisitor
    implements Visitor {
        private final StringBuilder sb = new StringBuilder();
        private final ExecutionContext context;
        private final NamespaceRegistry registry;

        public ReadableVisitor(ExecutionContext context) {
            CheckArg.isNotNull((Object)context, (String)"context");
            this.context = context;
            this.registry = context == null ? null : context.getNamespaceRegistry();
        }

        public ReadableVisitor() {
            this.context = null;
            this.registry = null;
        }

        protected final ReadableVisitor append(String string) {
            this.sb.append(string);
            return this;
        }

        protected final ReadableVisitor append(char character) {
            this.sb.append(character);
            return this;
        }

        protected final ReadableVisitor append(int value) {
            this.sb.append(value);
            return this;
        }

        protected final ReadableVisitor append(SelectorName name) {
            this.sb.append(name.getString());
            return this;
        }

        protected final ReadableVisitor append(Name name) {
            this.sb.append(name.getString(this.registry, null, null));
            return this;
        }

        protected final ReadableVisitor append(Path path) {
            this.sb.append('\'');
            this.sb.append(path.getString(this.registry));
            this.sb.append('\'');
            return this;
        }

        public final ExecutionContext getContext() {
            return this.context;
        }

        public final String getString() {
            return this.sb.toString();
        }

        public String toString() {
            return this.sb.toString();
        }

        public void visit(AllNodes allNodes) {
            this.append(allNodes.name());
            if (allNodes.hasAlias()) {
                this.append(" AS ").append(allNodes.alias());
            }
        }

        public void visit(And and) {
            this.append('(');
            and.left().accept(this);
            this.append(" AND ");
            and.right().accept(this);
            this.append(')');
        }

        public void visit(ArithmeticOperand arithmeticOperand) {
            this.append('(');
            arithmeticOperand.left().accept(this);
            this.append(' ');
            this.append(arithmeticOperand.operator().symbol());
            this.append(' ');
            arithmeticOperand.right().accept(this);
            this.append(')');
        }

        public void visit(Between between) {
            between.operand().accept(this);
            this.append(" BETWEEN ");
            between.lowerBound().accept(this);
            if (!between.isLowerBoundIncluded()) {
                this.append(" EXCLUSIVE");
            }
            this.append(" AND ");
            between.upperBound().accept(this);
            if (!between.isUpperBoundIncluded()) {
                this.append(" EXCLUSIVE");
            }
        }

        public void visit(BindVariableName variable) {
            this.append('$').append(variable.variableName());
        }

        public void visit(ChildNode child) {
            this.append("ISCHILDNODE(");
            this.append(child.selectorName());
            this.append(',');
            this.append(child.parentPath());
            this.append(')');
        }

        public void visit(ChildNodeJoinCondition condition) {
            this.append("ISCHILDNODE(");
            this.append(condition.childSelectorName());
            this.append(',');
            this.append(condition.parentSelectorName());
            this.append(')');
        }

        public void visit(Column column) {
            this.append(column.selectorName());
            if (column.propertyName() == null) {
                this.append(".*");
            } else {
                String propertyName = column.propertyName();
                this.append('.').append(propertyName);
                if (!propertyName.equals(column.columnName()) && !propertyName.equals(column.columnName())) {
                    this.append(" AS ").append(column.columnName());
                }
            }
        }

        public void visit(Comparison comparison) {
            comparison.operand1().accept(this);
            this.append(' ').append(comparison.operator().symbol()).append(' ');
            comparison.operand2().accept(this);
        }

        public void visit(DescendantNode descendant) {
            this.append("ISDESCENDANTNODE(");
            this.append(descendant.selectorName());
            this.append(',');
            this.append(descendant.ancestorPath());
            this.append(')');
        }

        public void visit(DescendantNodeJoinCondition condition) {
            this.append("ISDESCENDANTNODE(");
            this.append(condition.descendantSelectorName());
            this.append(',');
            this.append(condition.ancestorSelectorName());
            this.append(')');
        }

        public void visit(EquiJoinCondition condition) {
            this.append(condition.selector1Name()).append('.').append(condition.property1Name());
            this.append(" = ");
            this.append(condition.selector2Name()).append('.').append(condition.property2Name());
        }

        public void visit(FullTextSearch fullText) {
            this.append("CONTAINS(").append(fullText.selectorName());
            if (fullText.propertyName() != null) {
                this.append('.').append(fullText.propertyName());
            }
            this.sb.append(",'").append(fullText.fullTextSearchExpression()).append("')");
        }

        public void visit(FullTextSearchScore score) {
            this.append("SCORE(").append(score.selectorName()).append(')');
        }

        public void visit(Join join) {
            join.left().accept(this);
            this.sb.append(' ').append(join.type().symbol());
            this.append(' ');
            join.right().accept(this);
            this.append(" ON ");
            join.joinCondition().accept(this);
        }

        public void visit(Length length) {
            this.append("LENGTH(");
            length.propertyValue().accept(this);
            this.append(')');
        }

        public void visit(Limit limit) {
            this.append("LIMIT ").append(limit.rowLimit());
            if (limit.offset() != 0) {
                this.append(" OFFSET ").append(limit.offset());
            }
        }

        public void visit(Literal literal) {
            boolean quote;
            Object value = literal.value();
            boolean bl = quote = value instanceof String || value instanceof Path || value instanceof Name;
            if (quote) {
                this.append('\'');
            }
            if (this.context == null) {
                this.append(literal.value().toString());
            } else {
                this.append(this.context.getValueFactories().getStringFactory().create(literal.value()));
            }
            if (quote) {
                this.append('\'');
            }
        }

        public void visit(LowerCase lowerCase) {
            this.append("LOWER(");
            lowerCase.operand().accept(this);
            this.append(')');
        }

        public void visit(NodeDepth depth) {
            this.append("DEPTH(").append(depth.selectorName()).append(')');
        }

        public void visit(NodePath path) {
            this.append("PATH(").append(path.selectorName()).append(')');
        }

        public void visit(NodeLocalName name) {
            this.append("LOCALNAME(").append(name.selectorName()).append(')');
        }

        public void visit(NodeName name) {
            this.append("NAME(").append(name.selectorName()).append(')');
        }

        public void visit(NamedSelector selector) {
            this.append(selector.name());
            if (selector.hasAlias()) {
                this.append(" AS ").append(selector.alias());
            }
        }

        public void visit(Not not) {
            this.append('(');
            this.append("NOT ");
            not.constraint().accept(this);
            this.append(')');
        }

        public void visit(Or or) {
            this.append('(');
            or.left().accept(this);
            this.append(" OR ");
            or.right().accept(this);
            this.append(')');
        }

        public void visit(Ordering ordering) {
            ordering.operand().accept(this);
            this.append(' ').append(ordering.order().symbol());
        }

        public void visit(PropertyExistence existence) {
            this.append(existence.selectorName()).append('.').append(existence.propertyName()).append(" IS NOT NULL");
        }

        public void visit(PropertyValue value) {
            this.append(value.selectorName()).append('.').append(value.propertyName());
        }

        public void visit(ReferenceValue value) {
            this.append(value.selectorName());
            if (value.propertyName() != null) {
                this.append('.').append(value.propertyName());
            }
        }

        public void visit(Query query) {
            boolean isFirst;
            this.append("SELECT ");
            if (query.isDistinct()) {
                this.append("DISTINCT ");
            }
            if (query.columns().isEmpty()) {
                this.append('*');
            } else {
                isFirst = true;
                for (Column column : query.columns()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(',');
                    }
                    column.accept(this);
                }
            }
            this.append(" FROM ");
            query.source().accept(this);
            if (query.constraint() != null) {
                this.append(" WHERE ");
                query.constraint().accept(this);
            }
            if (!query.orderings().isEmpty()) {
                this.append(" ORDER BY ");
                isFirst = true;
                for (Ordering ordering : query.orderings()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(',');
                    }
                    ordering.accept(this);
                }
            }
            if (!query.limits().isUnlimited()) {
                this.append(' ');
                query.limits().accept(this);
            }
        }

        public void visit(Subquery subquery) {
            this.append('(');
            subquery.query().accept(this);
            this.append(')');
        }

        public void visit(SameNode sameNode) {
            this.append("ISSAMENODE(").append(sameNode.selectorName()).append(',').append(sameNode.path()).append(')');
        }

        public void visit(SameNodeJoinCondition condition) {
            this.append("ISSAMENODE(").append(condition.selector1Name()).append(',').append(condition.selector2Name());
            if (condition.selector2Path() != null) {
                this.append(',').append(condition.selector2Path());
            }
            this.append(')');
        }

        public void visit(SetCriteria criteria) {
            criteria.leftOperand().accept(this);
            this.append(" IN (");
            Iterator<? extends StaticOperand> iter = criteria.rightOperands().iterator();
            if (iter.hasNext()) {
                iter.next().accept(this);
                while (iter.hasNext()) {
                    this.append(',');
                    iter.next().accept(this);
                }
            }
            this.append(')');
        }

        public void visit(SetQuery query) {
            query.left().accept(this);
            this.append(' ').append(query.operation().getSymbol()).append(' ');
            if (query.isAll()) {
                this.append("ALL ");
            }
            query.right().accept(this);
        }

        public void visit(UpperCase upperCase) {
            this.append("UPPER(");
            upperCase.operand().accept(this);
            this.append(')');
        }
    }

    public static class WalkAllVisitor
    extends NavigationVisitor {
        public WalkAllVisitor(Visitor strategy) {
            super(strategy);
        }

        public void visit(AllNodes allNodes) {
            this.strategy.visit(allNodes);
            this.visitNext();
        }

        public void visit(And and) {
            this.strategy.visit(and);
            this.enqueue(and.left());
            this.enqueue(and.right());
            this.visitNext();
        }

        public void visit(ArithmeticOperand arithmeticOperation) {
            this.strategy.visit(arithmeticOperation);
            this.enqueue(arithmeticOperation.left());
            this.enqueue(arithmeticOperation.right());
            this.visitNext();
        }

        public void visit(Between between) {
            this.strategy.visit(between);
            this.enqueue(between.operand());
            this.enqueue(between.lowerBound());
            this.enqueue(between.upperBound());
            this.visitNext();
        }

        public void visit(BindVariableName variableName) {
            this.strategy.visit(variableName);
            this.visitNext();
        }

        public void visit(ChildNode child) {
            this.strategy.visit(child);
            this.visitNext();
        }

        public void visit(ChildNodeJoinCondition joinCondition) {
            this.strategy.visit(joinCondition);
            this.visitNext();
        }

        public void visit(Column column) {
            this.strategy.visit(column);
            this.visitNext();
        }

        public void visit(Comparison comparison) {
            this.strategy.visit(comparison);
            this.enqueue(comparison.operand1());
            this.enqueue(comparison.operand2());
            this.visitNext();
        }

        public void visit(DescendantNode descendant) {
            this.strategy.visit(descendant);
            this.visitNext();
        }

        public void visit(DescendantNodeJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        public void visit(EquiJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        public void visit(FullTextSearch fullTextSearch) {
            this.strategy.visit(fullTextSearch);
            this.visitNext();
        }

        public void visit(FullTextSearchScore score) {
            this.strategy.visit(score);
            this.visitNext();
        }

        public void visit(Join join) {
            this.strategy.visit(join);
            this.enqueue(join.left());
            this.enqueue(join.joinCondition());
            this.enqueue(join.right());
            this.visitNext();
        }

        public void visit(Length length) {
            this.strategy.visit(length);
            this.visitNext();
        }

        public void visit(Limit limit) {
            this.strategy.visit(limit);
            this.visitNext();
        }

        public void visit(Literal literal) {
            this.strategy.visit(literal);
            this.visitNext();
        }

        public void visit(LowerCase lowerCase) {
            this.strategy.visit(lowerCase);
            this.enqueue(lowerCase.operand());
            this.visitNext();
        }

        public void visit(NodeDepth depth) {
            this.strategy.visit(depth);
            this.visitNext();
        }

        public void visit(NodePath path) {
            this.strategy.visit(path);
            this.visitNext();
        }

        public void visit(NodeName nodeName) {
            this.strategy.visit(nodeName);
            this.visitNext();
        }

        public void visit(NodeLocalName nodeLocalName) {
            this.strategy.visit(nodeLocalName);
            this.visitNext();
        }

        public void visit(NamedSelector selector) {
            this.strategy.visit(selector);
            this.visitNext();
        }

        public void visit(Not not) {
            this.strategy.visit(not);
            this.enqueue(not.constraint());
            this.visitNext();
        }

        public void visit(Or or) {
            this.strategy.visit(or);
            this.enqueue(or.left());
            this.enqueue(or.right());
            this.visitNext();
        }

        public void visit(Ordering ordering) {
            this.strategy.visit(ordering);
            this.enqueue(ordering.operand());
            this.visitNext();
        }

        public void visit(PropertyExistence existence) {
            this.strategy.visit(existence);
            this.visitNext();
        }

        public void visit(PropertyValue propertyValue) {
            this.strategy.visit(propertyValue);
            this.visitNext();
        }

        public void visit(Query query) {
            this.strategy.visit(query);
            this.enqueue(query.source());
            this.enqueue(query.columns());
            this.enqueue(query.constraint());
            this.enqueue(query.orderings());
            this.visitNext();
        }

        public void visit(Subquery subquery) {
            this.strategy.visit(subquery);
            this.enqueue(subquery.query());
            this.visitNext();
        }

        public void visit(ReferenceValue referenceValue) {
            this.strategy.visit(referenceValue);
            this.visitNext();
        }

        public void visit(SameNode sameNode) {
            this.strategy.visit(sameNode);
            this.visitNext();
        }

        public void visit(SameNodeJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        public void visit(SetCriteria setCriteria) {
            this.strategy.visit(setCriteria);
            this.enqueue(setCriteria.leftOperand());
            for (StaticOperand staticOperand : setCriteria.rightOperands()) {
                this.enqueue(staticOperand);
            }
            this.visitNext();
        }

        public void visit(SetQuery setQuery) {
            this.strategy.visit(setQuery);
            this.enqueue(setQuery.left());
            this.enqueue(setQuery.right());
            this.visitNext();
        }

        public void visit(UpperCase upperCase) {
            this.strategy.visit(upperCase);
            this.enqueue(upperCase.operand());
            this.visitNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NavigationVisitor
    implements Visitor {
        protected final Visitor strategy;
        private final LinkedList<? super Visitable> itemQueue = new LinkedList();

        protected NavigationVisitor(Visitor strategy) {
            assert (strategy != null);
            this.strategy = strategy;
        }

        protected void enqueue(Visitable objectToBeVisited) {
            if (objectToBeVisited != null) {
                this.itemQueue.add(objectToBeVisited);
            }
        }

        protected void enqueue(Iterable<? extends Visitable> objectsToBeVisited) {
            for (Visitable visitable : objectsToBeVisited) {
                this.enqueue(visitable);
            }
        }

        protected final void visitNext() {
            if (!this.itemQueue.isEmpty()) {
                Visitable first = this.itemQueue.removeFirst();
                assert (first != null);
                first.accept(this);
            }
        }
    }

    public static class AbstractVisitor
    implements Visitor {
        public void visit(AllNodes obj) {
        }

        public void visit(And obj) {
        }

        public void visit(ArithmeticOperand obj) {
        }

        public void visit(Between obj) {
        }

        public void visit(BindVariableName obj) {
        }

        public void visit(ChildNode obj) {
        }

        public void visit(ChildNodeJoinCondition obj) {
        }

        public void visit(Column obj) {
        }

        public void visit(Comparison obj) {
        }

        public void visit(DescendantNode obj) {
        }

        public void visit(DescendantNodeJoinCondition obj) {
        }

        public void visit(EquiJoinCondition obj) {
        }

        public void visit(FullTextSearch obj) {
        }

        public void visit(FullTextSearchScore obj) {
        }

        public void visit(Join obj) {
        }

        public void visit(Length obj) {
        }

        public void visit(Limit limit) {
        }

        public void visit(Literal obj) {
        }

        public void visit(LowerCase obj) {
        }

        public void visit(NodeDepth obj) {
        }

        public void visit(NodePath obj) {
        }

        public void visit(NodeName obj) {
        }

        public void visit(NodeLocalName obj) {
        }

        public void visit(NamedSelector obj) {
        }

        public void visit(Not obj) {
        }

        public void visit(Or obj) {
        }

        public void visit(Ordering obj) {
        }

        public void visit(PropertyExistence obj) {
        }

        public void visit(PropertyValue obj) {
        }

        public void visit(Query obj) {
        }

        public void visit(Subquery obj) {
        }

        public void visit(ReferenceValue obj) {
        }

        public void visit(SameNode obj) {
        }

        public void visit(SameNodeJoinCondition obj) {
        }

        public void visit(SetCriteria obj) {
        }

        public void visit(SetQuery obj) {
        }

        public void visit(UpperCase obj) {
        }
    }
}

