/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.basic.AbstractBinary;

@Immutable
public class FileSystemBinary
extends AbstractBinary {
    private static final long serialVersionUID = 1L;
    private File file;
    private byte[] sha1hash;
    private int hc;

    public FileSystemBinary(File file) {
        CheckArg.isNotNull((Object)file, (String)"file");
        this.file = file;
    }

    public int hashCode() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.file);
            this.hc = this.sha1hash.hashCode();
        }
        return this.hc;
    }

    public long getSize() {
        return this.file.length();
    }

    public byte[] getHash() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.file);
            this.hc = this.sha1hash.hashCode();
        }
        return this.sha1hash;
    }

    public byte[] getBytes() {
        try {
            return IoUtil.readBytes((File)this.file);
        }
        catch (IOException e) {
            throw new IoException(e);
        }
    }

    public InputStream getStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new IoException(e);
        }
    }

    public void acquire() {
    }

    public void release() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.file.getPath());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        String path = in.readUTF();
        this.file = new File(path);
    }
}

