/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.xml.XmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class GraphImporter {
    private final Graph graph;

    public GraphImporter(Graph graph) {
        CheckArg.isNotNull((Object)graph, (String)"graph");
        this.graph = graph;
    }

    public ExecutionContext getContext() {
        return this.graph.getContext();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graph.Batch importXml(URI uri, Location location) throws IOException, SAXException, RepositorySourceException {
        return this.importXml(uri, location, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph.Batch importXml(URI uri, Location location, boolean skip) throws IOException, SAXException, RepositorySourceException {
        Graph.Batch batch;
        block2: {
            CheckArg.isNotNull((Object)uri, (String)"uri");
            CheckArg.isNotNull((Object)location, (String)"location");
            CheckArg.isNotNull((Object)location.getPath(), (String)"location.getPath()");
            InputStream stream = null;
            try {
                stream = uri.toURL().openStream();
                batch = this.importXml(stream, location, skip);
                Object var7_6 = null;
                if (stream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (stream == null) break block3;
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return batch;
    }

    public Graph.Batch importXml(InputStream stream, Location location) throws IOException, SAXException, RepositorySourceException {
        return this.importXml(stream, location, false);
    }

    public Graph.Batch importXml(InputStream stream, Location location, boolean skip) throws IOException, SAXException, RepositorySourceException {
        CheckArg.isNotNull((Object)stream, (String)"uri");
        CheckArg.isNotNull((Object)location, (String)"location");
        CheckArg.isNotNull((Object)location.getPath(), (String)"location.getPath()");
        Graph.Batch batch = this.graph.batch();
        GraphBatchDestination destination = new GraphBatchDestination(batch, true);
        Path parentPath = location.getPath();
        Name nameAttribute = this.getNameAttribute();
        Name typeAttribute = this.getTypeAttribute();
        Name typeAttributeValue = null;
        NamespaceRegistry reg = this.graph.getContext().getNamespaceRegistry();
        if (reg.isRegisteredNamespaceUri("http://www.jcp.org/jcr/nt/1.0")) {
            typeAttributeValue = JcrNtLexicon.UNSTRUCTURED;
        }
        TextDecoder decoder = null;
        XmlHandler.AttributeScoping scoping = XmlHandler.AttributeScoping.USE_DEFAULT_NAMESPACE;
        XmlHandler handler = new XmlHandler(destination, skip, parentPath, decoder, nameAttribute, typeAttribute, typeAttributeValue, scoping);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.parse(new InputSource(stream));
        if (stream != null) {
            stream.close();
        }
        return batch;
    }

    public XmlHandler getHandlerForImportingXml(Location location, boolean skip) {
        CheckArg.isNotNull((Object)location, (String)"location");
        CheckArg.isNotNull((Object)location.getPath(), (String)"location.getPath()");
        Graph.Batch batch = this.graph.batch();
        GraphBatchDestination destination = new GraphBatchDestination(batch, false);
        Path parentPath = location.getPath();
        Name nameAttribute = this.getNameAttribute();
        Name typeAttribute = this.getTypeAttribute();
        Name typeAttributeValue = null;
        NamespaceRegistry reg = this.graph.getContext().getNamespaceRegistry();
        if (reg.isRegisteredNamespaceUri("http://www.jcp.org/jcr/nt/1.0")) {
            typeAttributeValue = JcrNtLexicon.UNSTRUCTURED;
        }
        TextDecoder decoder = null;
        XmlHandler.AttributeScoping scoping = XmlHandler.AttributeScoping.USE_DEFAULT_NAMESPACE;
        XmlHandler handler = new XmlHandler(destination, skip, parentPath, decoder, nameAttribute, typeAttribute, typeAttributeValue, scoping);
        return handler;
    }

    protected Name getNameAttribute() {
        return JcrLexicon.NAME;
    }

    protected Name getTypeAttribute() {
        return JcrLexicon.PRIMARY_TYPE;
    }
}

