/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.connector.federation.Projection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ProjectionParser {
    private static final ProjectionParser INSTANCE;
    private static final Logger LOGGER;
    private final List<Method> parserMethods = new CopyOnWriteArrayList<Method>();

    public static ProjectionParser getInstance() {
        return INSTANCE;
    }

    public void addRuleParser(Method method) {
        if (method != null) {
            this.parserMethods.add(method);
        }
    }

    public void addRuleParser(Class<?> clazz, String methodName) throws SecurityException, NoSuchMethodException {
        CheckArg.isNotNull(clazz, (String)"clazz");
        CheckArg.isNotEmpty((String)methodName, (String)"methodName");
        this.parserMethods.add(clazz.getMethod(methodName, String.class, ExecutionContext.class));
    }

    public void addRuleParser(ClassLoader classLoader, String className, String methodName) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        CheckArg.isNotNull((Object)classLoader, (String)"classLoader");
        CheckArg.isNotEmpty((String)className, (String)"className");
        CheckArg.isNotEmpty((String)methodName, (String)"methodName");
        Class<?> clazz = Class.forName(className, true, classLoader);
        this.parserMethods.add(clazz.getMethod(methodName, String.class, ExecutionContext.class));
    }

    public boolean removeRuleParser(Method method) {
        return this.parserMethods.remove(method);
    }

    public boolean removeRuleParser(String declaringClassName, String methodName) {
        CheckArg.isNotEmpty((String)declaringClassName, (String)"declaringClassName");
        CheckArg.isNotEmpty((String)methodName, (String)"methodName");
        for (Method method : this.parserMethods) {
            if (!method.getName().equals(methodName) || !method.getDeclaringClass().getName().equals(declaringClassName)) continue;
            return this.parserMethods.remove(method);
        }
        return false;
    }

    List<Method> getParserMethods() {
        return Collections.unmodifiableList(this.parserMethods);
    }

    public Projection.Rule ruleFromString(String definition, ExecutionContext context) {
        CheckArg.isNotNull((Object)context, (String)"env");
        String string = definition = definition != null ? definition.trim() : "";
        if (definition.length() == 0) {
            return null;
        }
        Logger logger = context.getLogger(this.getClass());
        for (Method method : this.parserMethods) {
            String msg;
            try {
                Projection.Rule rule = (Projection.Rule)method.invoke(null, definition, context);
                if (rule != null) {
                    if (logger.isTraceEnabled()) {
                        msg = "Success parsing project rule definition \"{0}\" using {1}";
                        logger.trace(msg, new Object[]{definition, method});
                    }
                    return rule;
                }
                if (!logger.isTraceEnabled()) continue;
                msg = "Unable to parse project rule definition \"{0}\" using {1}";
                logger.trace(msg, new Object[]{definition, method});
            }
            catch (Throwable err) {
                msg = "Error while parsing project rule definition \"{0}\" using {1}";
                logger.trace(err, msg, new Object[]{definition, method});
            }
        }
        return null;
    }

    public Projection.Rule[] rulesFromStrings(ExecutionContext context, String ... definitions) {
        LinkedList<Projection.Rule> rules = new LinkedList<Projection.Rule>();
        for (String definition : definitions) {
            Projection.Rule rule = this.ruleFromString(definition, context);
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules.toArray(new Projection.Rule[rules.size()]);
    }

    public Projection.Rule[] rulesFromString(ExecutionContext context, String definitions) {
        List lines = StringUtil.splitLines((String)definitions);
        LinkedList<Projection.Rule> rules = new LinkedList<Projection.Rule>();
        for (String definition : lines) {
            Projection.Rule rule = this.ruleFromString(definition, context);
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules.toArray(new Projection.Rule[rules.size()]);
    }

    static {
        LOGGER = Logger.getLogger(Projection.class);
        INSTANCE = new ProjectionParser();
        try {
            INSTANCE.addRuleParser(Projection.class, "parsePathRule");
            assert (ProjectionParser.INSTANCE.parserMethods.size() == 1);
        }
        catch (Throwable err) {
            LOGGER.error(err, GraphI18n.errorAddingProjectionRuleParseMethod, new Object[0]);
        }
    }
}

