/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRequest;
import org.modeshape.graph.connector.federation.JoinMirrorRequestProcessor;
import org.modeshape.graph.connector.federation.NoMoreFederatedRequests;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueComparators;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestType;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class JoinRequestProcessor
extends RequestProcessor {
    private final PathFactory pathFactory;
    private final PropertyFactory propertyFactory;
    private final JoinMirrorRequestProcessor mirrorProcessor;
    protected FederatedRequest federatedRequest;

    public JoinRequestProcessor(FederatedRepository repository, ExecutionContext context, Observer observer, DateTime now) {
        super(repository.getSourceName(), context, observer, now, repository.getDefaultCachePolicy());
        this.propertyFactory = context.getPropertyFactory();
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.mirrorProcessor = new JoinMirrorRequestProcessor(repository.getSourceName(), context, null, now, repository.getDefaultCachePolicy());
    }

    public void process(Iterable<FederatedRequest> completedFederatedRequests) {
        for (FederatedRequest federatedRequest : completedFederatedRequests) {
            this.process(federatedRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(BlockingQueue<FederatedRequest> federatedRequestQueue) {
        FederatedRequest forked = null;
        try {
            while (true) {
                if ((forked = federatedRequestQueue.take()) instanceof NoMoreFederatedRequests) {
                    return;
                }
                forked.await();
                this.process(forked);
            }
        }
        catch (InterruptedException e) {
            try {
                if (forked != null) {
                    forked.original().cancel();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Thread.interrupted();
                throw throwable;
            }
            Thread.interrupted();
            return;
        }
    }

    protected final void process(FederatedRequest forked) {
        boolean sameLocation;
        Request original = forked.original();
        FederatedRequest.ProjectedRequest projectedRequest = forked.getFirstProjectedRequest();
        boolean bl = sameLocation = projectedRequest != null && !projectedRequest.hasNext() && projectedRequest.isSameLocation();
        if (original instanceof CacheableRequest) {
            CacheableRequest cacheableOriginal = (CacheableRequest)original;
            cacheableOriginal.setCachePolicy(this.getDefaultCachePolicy());
            while (projectedRequest != null) {
                Request requestToSource = projectedRequest.getRequest();
                this.setCacheableInfo(cacheableOriginal, ((CacheableRequest)requestToSource).getCachePolicy());
                projectedRequest = projectedRequest.next();
            }
        }
        if (sameLocation) {
            Request sourceRequest = forked.getFirstProjectedRequest().getRequest();
            if (sourceRequest.hasError()) {
                original.setError(sourceRequest.getError());
            } else if (sourceRequest.isCancelled()) {
                original.cancel();
            }
            this.mirrorProcessor.setFederatedRequest(forked);
            this.mirrorProcessor.process(original);
            if (original instanceof ChangeRequest && !original.hasError() && !original.isCancelled()) {
                this.recordChange((ChangeRequest)original);
            }
        } else {
            this.federatedRequest = forked;
            this.process(original);
        }
    }

    @Override
    public void process(VerifyNodeExistsRequest request) {
        FederatedRequest.ProjectedRequest projectedRequest = this.federatedRequest.getFirstProjectedRequest();
        request.setCachePolicy(this.getDefaultCachePolicy());
        Location actualLocation = request.at();
        int numMerged = 0;
        while (projectedRequest != null) {
            VerifyNodeExistsRequest readFromSource = (VerifyNodeExistsRequest)projectedRequest.getRequest();
            if (readFromSource.hasError()) {
                projectedRequest = projectedRequest.next();
                continue;
            }
            if (readFromSource.isCancelled()) {
                request.cancel();
                return;
            }
            Location sourceLocation = readFromSource.getActualLocationOfNode();
            actualLocation = this.determineActualLocation(actualLocation, sourceLocation, projectedRequest.getProjection());
            if (sourceLocation.hasIdProperties()) {
                for (Property propertyInSource : sourceLocation.getIdProperties()) {
                    Name name = propertyInSource.getName();
                    Property existing = actualLocation.getIdProperty(name);
                    if (existing != null) {
                        propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                    }
                    actualLocation = actualLocation.with(propertyInSource);
                }
            }
            this.setCacheableInfo(request, readFromSource.getCachePolicy());
            projectedRequest = projectedRequest.next();
            ++numMerged;
        }
        if (numMerged == 0) {
            this.setPathNotFound(request, request.at(), this.federatedRequest.getFirstProjectedRequest());
        } else {
            request.setActualLocationOfNode(actualLocation);
        }
    }

    @Override
    public void process(ReadNodeRequest request) {
        Path federatedPath = request.at().getPath();
        Map<Name, Property> properties = request.getPropertiesByName();
        HashMap<Name, Integer> childSnsIndexes = new HashMap<Name, Integer>();
        FederatedRequest.ProjectedRequest projectedRequest = this.federatedRequest.getFirstProjectedRequest();
        request.setCachePolicy(this.getDefaultCachePolicy());
        Location actualLocation = request.at();
        int numMerged = 0;
        while (projectedRequest != null) {
            Request sourceRequest = projectedRequest.getRequest();
            if (sourceRequest.hasError()) {
                projectedRequest = projectedRequest.next();
                continue;
            }
            if (sourceRequest.isCancelled()) {
                request.cancel();
                return;
            }
            Projection projection = projectedRequest.getProjection();
            if (RequestType.VERIFY_NODE_EXISTS == sourceRequest.getType()) {
                VerifyNodeExistsRequest verify = (VerifyNodeExistsRequest)sourceRequest;
                Location childInSource = verify.getActualLocationOfNode();
                Location childInRepos = this.getChildLocationWithCorrectSnsIndex(childInSource, federatedPath, childSnsIndexes, projection);
                request.addChild(childInRepos);
                if (federatedPath == null) {
                    federatedPath = childInRepos.getPath().getParent();
                }
            } else {
                Property existing;
                Name name;
                ReadNodeRequest readFromSource = (ReadNodeRequest)sourceRequest;
                Location sourceLocation = readFromSource.getActualLocationOfNode();
                if (sourceLocation.hasIdProperties()) {
                    for (Property propertyInSource : sourceLocation.getIdProperties()) {
                        name = propertyInSource.getName();
                        existing = actualLocation.getIdProperty(name);
                        if (existing != null) {
                            propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                        }
                        actualLocation = actualLocation.with(propertyInSource);
                    }
                }
                actualLocation = this.determineActualLocation(actualLocation, sourceLocation, projection);
                if (federatedPath == null) {
                    federatedPath = actualLocation.getPath();
                }
                for (Location childInSource : readFromSource.getChildren()) {
                    request.addChild(this.getChildLocationWithCorrectSnsIndex(childInSource, federatedPath, childSnsIndexes, projection));
                }
                for (Property propertyInSource : readFromSource.getProperties()) {
                    name = propertyInSource.getName();
                    existing = properties.get(name);
                    if (existing != null) {
                        propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                    }
                    properties.put(name, propertyInSource);
                }
                this.setCacheableInfo(request, readFromSource.getCachePolicy());
            }
            projectedRequest = projectedRequest.next();
            ++numMerged;
        }
        if (numMerged == 0) {
            this.setPathNotFound(request, request.at(), this.federatedRequest.getFirstProjectedRequest());
        } else {
            if (!actualLocation.hasPath()) {
                assert (federatedPath != null);
                actualLocation = actualLocation.with(federatedPath);
            }
            assert (actualLocation.getPath() != null);
            request.setActualLocationOfNode(actualLocation);
        }
    }

    protected Location getChildLocationWithCorrectSnsIndex(Location childInSource, Path federatedPath, Map<Name, Integer> childSnsIndexes, Projection projection) {
        Name childName;
        Integer snsIndex;
        Iterator<Path> i$;
        Path childPath = childInSource.getPath();
        if ((childPath.isRoot() || federatedPath == null) && (i$ = projection.getPathsInRepository(childInSource.getPath(), this.pathFactory).iterator()).hasNext()) {
            Path path;
            childPath = path = i$.next();
            if (federatedPath == null) {
                federatedPath = path.getParent();
            }
        }
        if ((snsIndex = childSnsIndexes.get(childName = childPath.getLastSegment().getName())) == null) {
            snsIndex = new Integer(1);
            childSnsIndexes.put(childName, snsIndex);
        } else {
            snsIndex = new Integer(snsIndex + 1);
            childSnsIndexes.put(childName, snsIndex);
        }
        Path newPath = this.pathFactory.create(federatedPath, childName, (int)snsIndex);
        return childInSource.with(newPath);
    }

    protected void setPathNotFound(Request original, Location originalLocation, FederatedRequest.ProjectedRequest projected) {
        Path lowestExistingInFederated = this.pathFactory.createRootPath();
        while (projected != null) {
            Request projectedRequest = projected.getRequest();
            Throwable error = projectedRequest.getError();
            if (error instanceof PathNotFoundException) {
                PathNotFoundException notFound = (PathNotFoundException)error;
                Path lowestExisting = notFound.getLowestAncestorThatDoesExist();
                for (Path federatedPath : projected.getProjection().getPathsInRepository(lowestExisting, this.pathFactory)) {
                    if (!federatedPath.isAtOrBelow(lowestExistingInFederated)) continue;
                    lowestExistingInFederated = federatedPath;
                }
            }
            projected = projected.next();
        }
        original.setError(new PathNotFoundException(originalLocation, lowestExistingInFederated));
    }

    @Override
    public void process(ReadAllChildrenRequest request) {
        Path federatedPath = request.of().getPath();
        HashMap<Name, Integer> childSnsIndexes = new HashMap<Name, Integer>();
        FederatedRequest.ProjectedRequest projectedRequest = this.federatedRequest.getFirstProjectedRequest();
        request.setCachePolicy(this.getDefaultCachePolicy());
        Location actualLocation = request.of();
        int numMerged = 0;
        while (projectedRequest != null) {
            Request sourceRequest = projectedRequest.getRequest();
            if (sourceRequest.hasError()) {
                projectedRequest = projectedRequest.next();
                continue;
            }
            if (sourceRequest.isCancelled()) {
                request.cancel();
                return;
            }
            Projection projection = projectedRequest.getProjection();
            if (RequestType.VERIFY_NODE_EXISTS == sourceRequest.getType()) {
                VerifyNodeExistsRequest verify = (VerifyNodeExistsRequest)sourceRequest;
                Location childInSource = verify.getActualLocationOfNode();
                Location childInRepos = this.getChildLocationWithCorrectSnsIndex(childInSource, federatedPath, childSnsIndexes, projection);
                request.addChild(childInRepos);
                if (federatedPath == null) {
                    federatedPath = childInRepos.getPath().getParent();
                }
            } else {
                ReadAllChildrenRequest readFromSource = (ReadAllChildrenRequest)sourceRequest;
                Location sourceLocation = readFromSource.getActualLocationOfNode();
                if (sourceLocation.hasIdProperties()) {
                    for (Property propertyInSource : sourceLocation.getIdProperties()) {
                        Name name = propertyInSource.getName();
                        Property existing = actualLocation.getIdProperty(name);
                        if (existing != null) {
                            propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                        }
                        actualLocation = actualLocation.with(propertyInSource);
                    }
                }
                actualLocation = this.determineActualLocation(actualLocation, readFromSource.getActualLocationOfNode(), projection);
                if (federatedPath == null) {
                    federatedPath = actualLocation.getPath();
                }
                for (Location childInSource : readFromSource.getChildren()) {
                    request.addChild(this.getChildLocationWithCorrectSnsIndex(childInSource, federatedPath, childSnsIndexes, projection));
                }
                this.setCacheableInfo(request, readFromSource.getCachePolicy());
            }
            projectedRequest = projectedRequest.next();
            ++numMerged;
        }
        if (numMerged == 0) {
            this.setPathNotFound(request, request.of(), this.federatedRequest.getFirstProjectedRequest());
        } else {
            if (!actualLocation.hasPath()) {
                assert (federatedPath != null);
                actualLocation = actualLocation.with(federatedPath);
            }
            request.setActualLocationOfNode(actualLocation);
        }
    }

    protected Location determineActualLocation(Location actual, Location inSource, Projection projection) {
        if (actual.getPath() == null) {
            if (projection == null) {
                return inSource;
            }
            Path pathInSource = inSource.getPath();
            Iterator<Path> i$ = projection.getPathsInRepository(pathInSource, this.pathFactory).iterator();
            if (i$.hasNext()) {
                Path path = i$.next();
                return actual.with(path);
            }
        }
        return actual;
    }

    protected Location determineActualLocation(Location actualInSource, Projection projection) {
        assert (projection != null);
        Path pathInSource = actualInSource.getPath();
        Iterator<Path> i$ = projection.getPathsInRepository(pathInSource, this.pathFactory).iterator();
        if (i$.hasNext()) {
            Path path = i$.next();
            return actualInSource.with(path);
        }
        return actualInSource;
    }

    @Override
    public void process(ReadAllPropertiesRequest request) {
        Map<Name, Property> properties = request.getPropertiesByName();
        FederatedRequest.ProjectedRequest projectedRequest = this.federatedRequest.getFirstProjectedRequest();
        request.setCachePolicy(this.getDefaultCachePolicy());
        Location actualLocation = request.at();
        int numMerged = 0;
        while (projectedRequest != null) {
            Property existing;
            Name name;
            ReadAllPropertiesRequest readFromSource = (ReadAllPropertiesRequest)projectedRequest.getRequest();
            if (readFromSource.hasError()) {
                projectedRequest = projectedRequest.next();
                continue;
            }
            if (readFromSource.isCancelled()) {
                request.cancel();
                return;
            }
            Location sourceLocation = readFromSource.getActualLocationOfNode();
            actualLocation = this.determineActualLocation(actualLocation, sourceLocation, projectedRequest.getProjection());
            if (sourceLocation.hasIdProperties()) {
                for (Property propertyInSource : sourceLocation.getIdProperties()) {
                    name = propertyInSource.getName();
                    existing = actualLocation.getIdProperty(name);
                    if (existing != null) {
                        propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                    }
                    actualLocation = actualLocation.with(propertyInSource);
                }
            }
            for (Property propertyInSource : readFromSource.getProperties()) {
                name = propertyInSource.getName();
                existing = properties.get(name);
                if (existing != null) {
                    propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                }
                properties.put(name, propertyInSource);
            }
            this.setCacheableInfo(request, readFromSource.getCachePolicy());
            projectedRequest = projectedRequest.next();
            ++numMerged;
        }
        if (numMerged == 0) {
            this.setPathNotFound(request, request.at(), this.federatedRequest.getFirstProjectedRequest());
        } else {
            request.setActualLocationOfNode(actualLocation);
        }
    }

    @Override
    public void process(ReadPropertyRequest request) {
        FederatedRequest.ProjectedRequest projectedRequest = this.federatedRequest.getFirstProjectedRequest();
        request.setCachePolicy(this.getDefaultCachePolicy());
        Location actualLocation = request.on();
        int numMerged = 0;
        while (projectedRequest != null) {
            Property read;
            ReadPropertyRequest readFromSource = (ReadPropertyRequest)projectedRequest.getRequest();
            if (readFromSource.hasError()) {
                projectedRequest = projectedRequest.next();
                continue;
            }
            if (readFromSource.isCancelled()) {
                request.cancel();
                return;
            }
            Location sourceLocation = readFromSource.getActualLocationOfNode();
            actualLocation = this.determineActualLocation(actualLocation, sourceLocation, projectedRequest.getProjection());
            if (sourceLocation.hasIdProperties()) {
                for (Property propertyInSource : sourceLocation.getIdProperties()) {
                    Name name = propertyInSource.getName();
                    Property existing = actualLocation.getIdProperty(name);
                    if (existing != null) {
                        propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                    }
                    actualLocation = actualLocation.with(propertyInSource);
                }
            }
            if ((read = readFromSource.getProperty()) != null) {
                Property existing = request.getProperty();
                if (existing != null) {
                    request.setProperty(this.merge(existing, read, this.propertyFactory, true));
                } else {
                    request.setProperty(read);
                }
            }
            this.setCacheableInfo(request, readFromSource.getCachePolicy());
            projectedRequest = projectedRequest.next();
            ++numMerged;
        }
        if (numMerged == 0) {
            this.setPathNotFound(request, request.on(), this.federatedRequest.getFirstProjectedRequest());
        } else {
            request.setActualLocationOfNode(actualLocation);
        }
    }

    @Override
    public void process(ReadBranchRequest request) {
        CacheableRequest readFromSource;
        Projection projection;
        CacheableRequest fromSource;
        FederatedRequest.ProjectedRequest projectedRequest = this.federatedRequest.getFirstProjectedRequest();
        request.setCachePolicy(this.getDefaultCachePolicy());
        Location actualLocation = request.at();
        int numMerged = 0;
        HashMap<Path, Location> actualLocationsOfProxyNodes = new HashMap<Path, Location>();
        while (projectedRequest != null) {
            fromSource = (CacheableRequest)projectedRequest.getRequest();
            if (fromSource.hasError()) {
                projectedRequest = projectedRequest.next();
                continue;
            }
            if (fromSource.isCancelled()) {
                request.cancel();
                return;
            }
            projection = projectedRequest.getProjection();
            if (RequestType.READ_BRANCH == fromSource.getType()) {
                readFromSource = (ReadBranchRequest)fromSource;
                Iterator<Location> i$ = ((ReadBranchRequest)readFromSource).iterator();
                while (i$.hasNext()) {
                    Location parent = i$.next();
                    List<Location> children = ((ReadBranchRequest)readFromSource).getChildren(parent);
                    Map<Name, Property> properties = ((ReadBranchRequest)readFromSource).getPropertiesFor(parent);
                    this.projectToFederated(actualLocation, projection, request, parent, children, properties);
                }
                Location locationOfProxy = ((ReadBranchRequest)readFromSource).getActualLocationOfNode();
                locationOfProxy = this.determineActualLocation(locationOfProxy, projection);
                actualLocationsOfProxyNodes.put(locationOfProxy.getPath(), locationOfProxy);
            }
            this.setCacheableInfo(request, fromSource.getCachePolicy());
            projectedRequest = projectedRequest.next();
            ++numMerged;
        }
        for (projectedRequest = this.federatedRequest.getFirstProjectedRequest(); projectedRequest != null; projectedRequest = projectedRequest.next()) {
            fromSource = (CacheableRequest)projectedRequest.getRequest();
            projection = projectedRequest.getProjection();
            if (RequestType.READ_NODE == fromSource.getType()) {
                readFromSource = (ReadNodeRequest)fromSource;
                Location parent = ((ReadNodeRequest)readFromSource).getActualLocationOfNode();
                List<Location> children = ((ReadNodeRequest)readFromSource).getChildren();
                for (int i = 0; i != children.size(); ++i) {
                    Location child = children.get(i);
                    if (child.hasIdProperties()) continue;
                    Location actual = (Location)actualLocationsOfProxyNodes.get(child.getPath());
                    assert (actual != null);
                    children.set(i, actual);
                }
                Map<Name, Property> properties = ((ReadNodeRequest)readFromSource).getPropertiesByName();
                this.projectToFederated(actualLocation, projection, request, parent, children, properties);
            }
            this.setCacheableInfo(request, fromSource.getCachePolicy());
        }
        if (numMerged == 0) {
            this.setPathNotFound(request, request.at(), this.federatedRequest.getFirstProjectedRequest());
        } else {
            request.setActualLocationOfNode(actualLocation);
        }
    }

    protected void projectToFederated(Location ancestorInFederation, Projection projection, ReadBranchRequest request, Location parent, List<Location> children, Map<Name, Property> propertiesByName) {
        Path ancestorPath = ancestorInFederation.getPath();
        if (projection == null) {
            if (children != null) {
                List<Location> existing = request.getChildren(parent);
                if (existing == null) {
                    existing = new ArrayList<Location>(children.size());
                }
                for (Location child : children) {
                    existing.add(child);
                }
                request.setChildren(parent, existing);
            }
            if (propertiesByName != null) {
                Map<Name, Property> propsByName = request.getPropertiesFor(parent);
                if (propsByName == null) {
                    propsByName = new HashMap<Name, Property>();
                }
                for (Property property : propertiesByName.values()) {
                    Property existingProperty = propsByName.get(property.getName());
                    if (existingProperty != null) {
                        property = this.merge(existingProperty, property, this.propertyFactory, true);
                    }
                    propsByName.put(property.getName(), property);
                }
                request.setProperties(parent, propsByName.values());
            }
            return;
        }
        for (Path path : projection.getPathsInRepository(parent.getPath(), this.pathFactory)) {
            if (!path.isAtOrBelow(ancestorPath)) continue;
            Location parentInFederation = parent.with(path);
            if (children != null) {
                List<Location> existing = request.getChildren(parentInFederation);
                if (existing == null) {
                    existing = new ArrayList<Location>(children.size());
                }
                for (Location child : children) {
                    Path childPath = this.pathFactory.create(path, child.getPath().getLastSegment());
                    existing.add(child.with(childPath));
                }
                request.setChildren(parentInFederation, existing);
            }
            if (propertiesByName != null) {
                Map<Name, Property> propsByName = request.getPropertiesFor(parentInFederation);
                if (propsByName == null) {
                    propsByName = new HashMap<Name, Property>();
                }
                for (Property property : propertiesByName.values()) {
                    Property existingProperty = propsByName.get(property.getName());
                    if (existingProperty != null) {
                        property = this.merge(existingProperty, property, this.propertyFactory, true);
                    }
                    propsByName.put(property.getName(), property);
                }
                request.setProperties(parentInFederation, propsByName.values());
            }
            return;
        }
    }

    protected Location projectToFederated(Location ancestorInFederation, Projection projection, Location actualSourceLocation, Request originalRequest) {
        Path ancestorPath = ancestorInFederation.getPath();
        Path actualPathInSource = actualSourceLocation.getPath();
        for (Path path : projection.getPathsInRepository(actualPathInSource, this.pathFactory)) {
            if (!path.isAtOrBelow(ancestorPath)) continue;
            return actualSourceLocation.with(path);
        }
        String whereInSource = actualSourceLocation.getString(this.getExecutionContext().getNamespaceRegistry());
        String msg = GraphI18n.unableToProjectSourceInformationIntoWorkspace.text(new Object[]{whereInSource, this.getSourceName(), projection});
        originalRequest.setError(new InvalidRequestException(msg));
        return null;
    }

    protected Location projectToFederated(Projection projection, Location actualSourceLocation, Request originalRequest) {
        Path actualPathInSource = actualSourceLocation.getPath();
        Iterator<Path> i$ = projection.getPathsInRepository(actualPathInSource, this.pathFactory).iterator();
        if (i$.hasNext()) {
            Path path = i$.next();
            return actualSourceLocation.with(path);
        }
        String whereInSource = actualSourceLocation.getString(this.getExecutionContext().getNamespaceRegistry());
        String msg = GraphI18n.unableToProjectSourceInformationIntoWorkspace.text(new Object[]{whereInSource, this.getSourceName(), projection});
        originalRequest.setError(new InvalidRequestException(msg));
        return null;
    }

    @Override
    public void process(CreateNodeRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        Request projectedRequest = projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, projectedRequest)) {
            return;
        }
        Location sourceLocation = null;
        if (RequestType.CREATE_NODE == projectedRequest.getType()) {
            CreateNodeRequest source = (CreateNodeRequest)projectedRequest;
            sourceLocation = source.getActualLocationOfNode();
        } else if (RequestType.READ_NODE == projectedRequest.getType()) {
            ReadNodeRequest source = (ReadNodeRequest)projectedRequest;
            sourceLocation = source.getActualLocationOfNode();
        }
        request.setActualLocationOfNode(this.projectToFederated(request.under(), projected.getProjection(), sourceLocation, request));
    }

    @Override
    public void process(UpdatePropertiesRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        UpdatePropertiesRequest source = (UpdatePropertiesRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location sourceLocation = source.getActualLocationOfNode();
        request.setActualLocationOfNode(this.projectToFederated(request.on(), projected.getProjection(), sourceLocation, request));
        request.setNewProperties(source.getNewPropertyNames());
    }

    @Override
    public void process(SetPropertyRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        SetPropertyRequest source = (SetPropertyRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location sourceLocation = source.getActualLocationOfNode();
        request.setActualLocationOfNode(this.projectToFederated(request.on(), projected.getProjection(), sourceLocation, request));
        request.setNewProperty(source.isNewProperty());
    }

    @Override
    public void process(RemovePropertyRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        SetPropertyRequest source = (SetPropertyRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location sourceLocation = source.getActualLocationOfNode();
        request.setActualLocationOfNode(this.projectToFederated(request.from(), projected.getProjection(), sourceLocation, request));
    }

    @Override
    public void process(LockBranchRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        LockBranchRequest source = (LockBranchRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location sourceLocation = source.getActualLocation();
        request.setActualLocation(this.projectToFederated(request.at(), projected.getProjection(), sourceLocation, request));
    }

    @Override
    public void process(DeleteBranchRequest request) {
        FederatedRequest.ProjectedRequest projected;
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        Request projectedSource = projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, projectedSource)) {
            return;
        }
        Location highest = null;
        for (projected = this.federatedRequest.getFirstProjectedRequest(); projected != null; projected = projected.next()) {
            ChangeRequest source;
            Location actual = null;
            Request sourceRequest = projected.getRequest();
            if (RequestType.DELETE_BRANCH == sourceRequest.getType()) {
                source = (DeleteBranchRequest)projected.getRequest();
                actual = ((DeleteBranchRequest)source).getActualLocationOfNode();
            } else {
                source = (DeleteChildrenRequest)projected.getRequest();
                actual = ((DeleteChildrenRequest)source).getActualLocationOfNode();
            }
            if (this.checkErrorOrCancel((Request)request, sourceRequest)) {
                return;
            }
            if (!projected.isSameLocation() && projected.getProjection() != null) {
                actual = this.projectToFederated(request.at(), projected.getProjection(), actual, request);
            }
            if (highest == null) {
                highest = actual;
                continue;
            }
            if (!highest.getPath().isDecendantOf(actual.getPath())) continue;
            highest = actual;
        }
        assert (highest != null);
        request.setActualLocationOfNode(highest);
    }

    @Override
    public void process(DeleteChildrenRequest request) {
        FederatedRequest.ProjectedRequest projected;
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        Request projectedSource = projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, projectedSource)) {
            return;
        }
        Location highest = null;
        for (projected = this.federatedRequest.getFirstProjectedRequest(); projected != null; projected = projected.next()) {
            Request sourceRequest = projected.getRequest();
            DeleteChildrenRequest source = (DeleteChildrenRequest)projected.getRequest();
            Location actual = source.getActualLocationOfNode();
            if (this.checkErrorOrCancel((Request)request, sourceRequest)) {
                return;
            }
            if (!projected.isSameLocation() && projected.getProjection() != null) {
                actual = this.projectToFederated(request.at(), projected.getProjection(), actual, request);
            }
            if (highest == null) {
                highest = actual;
                continue;
            }
            if (!highest.getPath().isDecendantOf(actual.getPath())) continue;
            highest = actual;
        }
        assert (highest != null);
        request.setActualLocationOfNode(highest);
    }

    @Override
    public void process(RenameNodeRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        RenameNodeRequest source = (RenameNodeRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location locationBefore = source.getActualLocationBefore();
        Location locationAfter = source.getActualLocationBefore();
        locationBefore = this.projectToFederated(request.at(), projected.getProjection(), locationBefore, request);
        locationAfter = this.projectToFederated(request.at(), projected.getSecondProjection(), locationAfter, request);
        request.setActualLocations(locationBefore, locationAfter);
    }

    @Override
    public void process(CopyBranchRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        CopyBranchRequest source = (CopyBranchRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location locationBefore = source.getActualLocationBefore();
        Location locationAfter = source.getActualLocationBefore();
        locationBefore = this.projectToFederated(request.from(), projected.getProjection(), locationBefore, request);
        locationAfter = this.projectToFederated(request.into(), projected.getSecondProjection(), locationAfter, request);
        request.setActualLocations(locationBefore, locationAfter);
    }

    @Override
    public void process(CloneBranchRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        CloneBranchRequest source = (CloneBranchRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location locationBefore = source.getActualLocationBefore();
        Location locationAfter = source.getActualLocationBefore();
        locationBefore = this.projectToFederated(request.from(), projected.getProjection(), locationBefore, request);
        locationAfter = this.projectToFederated(request.into(), projected.getSecondProjection(), locationAfter, request);
        request.setActualLocations(locationBefore, locationAfter);
        if (source.removeExisting()) {
            HashSet<Location> removed = new HashSet<Location>();
            for (Location location : request.getRemovedNodes()) {
                removed.add(this.projectToFederated(projected.getSecondProjection(), location, request));
            }
            request.setRemovedNodes(Collections.unmodifiableSet(removed));
        }
    }

    @Override
    public void process(MoveBranchRequest request) {
        FederatedRequest.ProjectedRequest projected = this.federatedRequest.getFirstProjectedRequest();
        if (this.checkErrorOrCancel((Request)request, this.federatedRequest)) {
            return;
        }
        MoveBranchRequest source = (MoveBranchRequest)projected.getRequest();
        if (this.checkErrorOrCancel((Request)request, source)) {
            return;
        }
        Location locationBefore = source.getActualLocationBefore();
        Location locationAfter = source.getActualLocationBefore();
        locationBefore = this.projectToFederated(request.from(), projected.getProjection(), locationBefore, request);
        Projection afterProjection = projected.getSecondProjection();
        if (afterProjection == null) {
            projected.getProjection();
        }
        locationAfter = this.projectToFederated(request.into(), afterProjection, locationAfter, request);
        request.setActualLocations(locationBefore, locationAfter);
    }

    @Override
    public void process(VerifyWorkspaceRequest request) {
        Location actualLocation = Location.create(this.getExecutionContext().getValueFactories().getPathFactory().createRootPath());
        for (FederatedRequest.ProjectedRequest projectedRequest = this.federatedRequest.getFirstProjectedRequest(); projectedRequest != null; projectedRequest = projectedRequest.next()) {
            VerifyNodeExistsRequest readFromSource = (VerifyNodeExistsRequest)projectedRequest.getRequest();
            if (readFromSource.hasError()) {
                request.setError(readFromSource.getError());
                return;
            }
            request.setError(null);
            if (readFromSource.isCancelled()) {
                request.cancel();
                return;
            }
            Location sourceLocation = readFromSource.getActualLocationOfNode();
            if (!sourceLocation.hasIdProperties()) continue;
            for (Property propertyInSource : sourceLocation.getIdProperties()) {
                Name name = propertyInSource.getName();
                Property existing = actualLocation.getIdProperty(name);
                if (existing != null) {
                    propertyInSource = this.merge(existing, propertyInSource, this.propertyFactory, true);
                }
                actualLocation = actualLocation.with(propertyInSource);
            }
        }
        request.setActualRootLocation(actualLocation);
    }

    @Override
    public void process(GetWorkspacesRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void process(CreateWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void process(CloneWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void process(DestroyWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void process(AccessQueryRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void process(FullTextSearchRequest request) {
        throw new UnsupportedOperationException();
    }

    protected boolean checkErrorOrCancel(Request request, FederatedRequest federatedRequest) {
        if (federatedRequest.getFirstProjectedRequest() == null) {
            Request original = federatedRequest.original();
            if (original.hasError()) {
                request.setError(original.getError());
                return true;
            }
            assert (original.isCancelled());
            request.cancel();
            return true;
        }
        return false;
    }

    protected boolean checkErrorOrCancel(Request request, Request sourceRequest) {
        if (sourceRequest.hasError()) {
            request.setError(sourceRequest.getError());
            return true;
        }
        if (sourceRequest.isCancelled()) {
            request.cancel();
            return true;
        }
        return false;
    }

    protected Property merge(Property property1, Property property2, PropertyFactory factory, boolean removeDuplicates) {
        assert (property1 != null);
        assert (property2 != null);
        assert (property1.getName().equals(property2.getName()));
        if (property1.isEmpty()) {
            return property2;
        }
        if (property2.isEmpty()) {
            return property1;
        }
        if (property1.isSingle() && property2.isSingle()) {
            Object value1 = property1.getValues().next();
            Object value2 = property2.getValues().next();
            if (removeDuplicates && ValueComparators.OBJECT_COMPARATOR.compare(value1, value2) == 0) {
                return property1;
            }
            return factory.create(property1.getName(), value1, value2);
        }
        if (!removeDuplicates) {
            DualIterator valueIterator = new DualIterator(property1.getValues(), property2.getValues());
            return factory.create(property1.getName(), valueIterator);
        }
        Object[] values = new Object[property1.size() + property2.size()];
        int index = 0;
        for (Object property1Value : property1) {
            values[index++] = property1Value;
        }
        assert (index == property1.size());
        for (Object property2Value : property2) {
            boolean matched = false;
            for (Object property1Value : property1) {
                if (ValueComparators.OBJECT_COMPARATOR.compare(property1Value, property2Value) != 0) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            values[index++] = property2Value;
        }
        if (index != values.length) {
            Object[] newValues = new Object[index];
            System.arraycopy(values, 0, newValues, 0, index);
            values = newValues;
        }
        return factory.create(property1.getName(), values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DualIterator
    implements Iterator<Object> {
        private final Iterator<?>[] iterators;
        private Iterator<?> current;
        private int index = 0;

        protected DualIterator(Iterator<?> ... iterators) {
            assert (iterators != null);
            assert (iterators.length > 0);
            this.iterators = iterators;
            this.current = this.iterators[0];
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return this.current.hasNext();
            }
            return false;
        }

        @Override
        public Object next() {
            while (this.current != null) {
                if (this.current.hasNext()) {
                    return this.current.next();
                }
                if (++this.index < this.iterators.length) {
                    this.current = this.iterators[this.index];
                    continue;
                }
                this.current = null;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

