/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.filesystem.CustomPropertiesFactory;
import org.modeshape.connector.filesystem.FileSystemI18n;
import org.modeshape.connector.filesystem.FileSystemRepository;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.NodeCachingWorkspace;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.connector.base.cache.NodeCache;
import org.modeshape.graph.connector.base.cache.NodeCachePolicy;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedEvent;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedListener;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.FileSystemBinary;

class FileSystemWorkspace
extends PathWorkspace<PathNode>
implements NodeCachingWorkspace<Path, PathNode> {
    private static final Map<Name, Property> NO_PROPERTIES = Collections.emptyMap();
    private static final String DEFAULT_MIME_TYPE = "application/octet";
    private static final Set<Name> VALID_PRIMARY_TYPES = new HashSet<Name>(Arrays.asList(JcrNtLexicon.FOLDER, JcrNtLexicon.FILE, JcrNtLexicon.RESOURCE, ModeShapeLexicon.RESOURCE));
    private final FileSystemSource source;
    protected final FileSystemRepository repository;
    private final ExecutionContext context;
    private final File workspaceRoot;
    private final boolean eagerLoading;
    private final boolean contentUsedToDetermineMimeType;
    private final Logger logger;
    private final ValueFactory<String> stringFactory;
    private final NameFactory nameFactory;
    private NodeCache<Path, PathNode> cache;
    private NodeCachePolicy<Path, PathNode> policy;

    public FileSystemWorkspace(ExecutionContext context, String name, FileSystemWorkspace originalToClone, File workspaceRoot) {
        super(context, name, originalToClone.getRootNodeUuid());
        this.source = originalToClone.source;
        this.context = originalToClone.context;
        this.workspaceRoot = workspaceRoot;
        this.repository = originalToClone.repository;
        this.eagerLoading = this.source.isEagerFileLoading();
        this.contentUsedToDetermineMimeType = this.source.isContentUsedToDetermineMimeType();
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.stringFactory = context.getValueFactories().getStringFactory();
        this.nameFactory = context.getValueFactories().getNameFactory();
        this.repository.source().addNodeCachePolicyChangedListener((NodeCachePolicyChangedListener)this);
        this.cloneWorkspace(originalToClone);
    }

    public FileSystemWorkspace(ExecutionContext context, FileSystemRepository repository, String name) {
        super(context, name, repository.getRootNodeUuid());
        this.workspaceRoot = repository.getWorkspaceDirectory(name);
        this.repository = repository;
        this.context = repository.getContext();
        this.source = repository.source;
        this.eagerLoading = this.source.isEagerFileLoading();
        this.contentUsedToDetermineMimeType = this.source.isContentUsedToDetermineMimeType();
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.stringFactory = context.getValueFactories().getStringFactory();
        this.nameFactory = context.getValueFactories().getNameFactory();
        repository.source().addNodeCachePolicyChangedListener((NodeCachePolicyChangedListener)this);
    }

    private void cloneWorkspace(FileSystemWorkspace original) {
        File originalRoot = this.repository.getWorkspaceDirectory(original.getName());
        File newRoot = this.repository.getWorkspaceDirectory(this.getName());
        try {
            FileUtil.copy((File)originalRoot, (File)newRoot, (FilenameFilter)this.source.filenameFilter(false));
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public void cachePolicyChanged(NodeCachePolicyChangedEvent<Path, PathNode> event) {
        this.policy = event.getNewPolicy();
        this.cache = this.policy.newCache();
    }

    public NodeCache<Path, PathNode> getCache() {
        return this.cache;
    }

    protected void moveFile(File originalFileOrDirectory, File newFileOrDirectory) {
        if (originalFileOrDirectory.renameTo(newFileOrDirectory)) {
            return;
        }
        try {
            FileUtil.copy((File)originalFileOrDirectory, (File)newFileOrDirectory);
            FileUtil.delete((File)originalFileOrDirectory);
        }
        catch (IOException ioe) {
            throw new RepositorySourceException(FileSystemI18n.couldNotCopyData.text(new Object[]{this.source.getName(), originalFileOrDirectory.getAbsolutePath(), newFileOrDirectory.getAbsolutePath()}), (Throwable)ioe);
        }
    }

    public PathNode moveNode(PathNode node, PathNode newNode) {
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        Path newPath = pathFactory.create(newNode.getParent(), new Path.Segment[]{newNode.getName()});
        Path oldPath = pathFactory.create(node.getParent(), new Path.Segment[]{node.getName()});
        File originalFile = this.fileFor(oldPath);
        File newFile = this.fileFor(newPath, false);
        if (newFile.exists()) {
            newFile.delete();
        }
        CustomPropertiesFactory customPropertiesFactory = this.source.customPropertiesFactory();
        Collection<Property> existingProps = null;
        Collection<Property> existingResourceProps = null;
        String sourceName = this.source.getName();
        Location originalLocation = Location.create((Path)oldPath);
        if (originalFile.isDirectory()) {
            existingProps = customPropertiesFactory.getDirectoryProperties(this.context, originalLocation, originalFile);
            customPropertiesFactory.recordDirectoryProperties(this.context, sourceName, originalLocation, originalFile, NO_PROPERTIES);
        } else {
            Path resourcePath = pathFactory.create(oldPath, new Name[]{JcrLexicon.CONTENT});
            Location originalResourceLocation = Location.create((Path)resourcePath);
            existingProps = customPropertiesFactory.getFileProperties(this.context, originalLocation, originalFile);
            existingResourceProps = customPropertiesFactory.getResourceProperties(this.context, originalResourceLocation, originalFile, null);
            customPropertiesFactory.recordFileProperties(this.context, sourceName, originalLocation, originalFile, NO_PROPERTIES);
            customPropertiesFactory.recordResourceProperties(this.context, sourceName, originalResourceLocation, originalFile, NO_PROPERTIES);
        }
        this.moveFile(originalFile, newFile);
        Location newLocation = Location.create((Path)newPath);
        if (originalFile.isDirectory()) {
            customPropertiesFactory.recordDirectoryProperties(this.context, sourceName, newLocation, newFile, this.extraFolder(this.mapOf(existingProps)));
        } else {
            Path resourcePath = pathFactory.create(newPath, new Name[]{JcrLexicon.CONTENT});
            Location resourceLocation = Location.create((Path)resourcePath);
            customPropertiesFactory.recordFileProperties(this.context, sourceName, newLocation, newFile, this.extraFile(this.mapOf(existingProps)));
            customPropertiesFactory.recordResourceProperties(this.context, sourceName, resourceLocation, newFile, this.extraResource(this.mapOf(existingResourceProps)));
        }
        return this.getNode(newPath);
    }

    protected Map<Name, Property> mapOf(Collection<Property> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Name, Property> result = new HashMap<Name, Property>();
        for (Property property : properties) {
            result.put(property.getName(), property);
        }
        return result;
    }

    public PathNode putNode(PathNode node) {
        Name primaryType;
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        CustomPropertiesFactory customPropertiesFactory = this.source.customPropertiesFactory();
        Map properties = node.getProperties();
        if (node.getParent() == null) {
            Path rootPath = pathFactory.createRootPath();
            Location rootLocation = Location.create((Path)rootPath, (UUID)this.repository.getRootNodeUuid());
            customPropertiesFactory.recordDirectoryProperties(this.context, this.source.getName(), rootLocation, this.workspaceRoot, this.extraFolder(node.getProperties()));
            return this.getNode(rootPath);
        }
        Path parentPath = node.getParent();
        boolean isRoot = parentPath == null;
        File parentFile = this.fileFor(parentPath);
        Path newPath = isRoot ? pathFactory.createRootPath() : pathFactory.create(parentPath, new Path.Segment[]{node.getName()});
        Name name = node.getName().getName();
        String newName = name.getString(registry);
        File newFile = new File(parentFile, newName);
        Property primaryTypeProp = (Property)properties.get(JcrLexicon.PRIMARY_TYPE);
        Name name2 = primaryType = primaryTypeProp == null ? JcrNtLexicon.FOLDER : (Name)this.nameFactory.create(primaryTypeProp.getFirstValue());
        if (JcrNtLexicon.FILE.equals(primaryType)) {
            if (!parentFile.canWrite()) {
                I18n msg = FileSystemI18n.parentIsReadOnly;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
            }
            try {
                this.ensureValidPathLength(newFile);
                if (!newFile.exists() && !newFile.createNewFile()) {
                    I18n msg = FileSystemI18n.fileAlreadyExists;
                    throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
                }
            }
            catch (IOException ioe) {
                I18n msg = FileSystemI18n.couldNotCreateFile;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), ioe.getMessage()}), (Throwable)ioe);
            }
            customPropertiesFactory.recordFileProperties(this.context, this.source.getName(), Location.create((Path)newPath), newFile, this.extraFile(properties));
        } else if (JcrNtLexicon.RESOURCE.equals(primaryType) || ModeShapeLexicon.RESOURCE.equals(primaryType)) {
            assert (parentFile != null);
            if (!JcrLexicon.CONTENT.equals(name)) {
                I18n msg = FileSystemI18n.invalidNameForResource;
                String nodeName = name.getString();
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), nodeName}));
            }
            if (!parentFile.isFile()) {
                I18n msg = FileSystemI18n.invalidPathForResource;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
            }
            if (!parentFile.canWrite()) {
                I18n msg = FileSystemI18n.parentIsReadOnly;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
            }
            Property dataProp = (Property)properties.get(JcrLexicon.DATA);
            BinaryFactory binaryFactory = this.context.getValueFactories().getBinaryFactory();
            Binary binary = null;
            if (dataProp == null) {
                binary = (Binary)binaryFactory.create(new byte[0]);
                dataProp = this.context.getPropertyFactory().create(JcrLexicon.DATA, new Object[]{binary});
            } else {
                binary = (Binary)binaryFactory.create(((Property)properties.get(JcrLexicon.DATA)).getFirstValue());
            }
            try {
                PendingFile temp = new PendingFile(parentFile);
                temp.write(binary);
                temp.commit();
            }
            catch (IOException ioe) {
                I18n msg = FileSystemI18n.couldNotWriteData;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), ioe.getMessage()}), (Throwable)ioe);
            }
            customPropertiesFactory.recordResourceProperties(this.context, this.source.getName(), Location.create((Path)parentPath), parentFile, this.extraResource(properties));
        } else if (JcrNtLexicon.FOLDER.equals(primaryType) || primaryType == null) {
            this.ensureValidPathLength(newFile);
            if (!newFile.exists() && !newFile.mkdir()) {
                I18n msg = FileSystemI18n.couldNotCreateFile;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), primaryType == null ? "null" : primaryType.getString(registry)}));
            }
            customPropertiesFactory.recordDirectoryProperties(this.context, this.source.getName(), Location.create((Path)newPath), newFile, this.extraFolder(properties));
        } else {
            I18n msg = FileSystemI18n.unsupportedPrimaryType;
            throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{primaryType.getString(registry), parentPath, this.getName(), this.source.getName()}));
        }
        node = this.getNode(newPath);
        return node;
    }

    public PathNode removeNode(Path nodePath) {
        File propertiesFile;
        CustomPropertiesFactory customPropertiesFactory = this.source.customPropertiesFactory();
        if (!nodePath.isRoot() && JcrLexicon.CONTENT.equals(nodePath.getLastSegment().getName())) {
            File nodeFile = this.fileFor(nodePath.getParent());
            customPropertiesFactory.recordResourceProperties(this.context, this.source.getName(), Location.create((Path)nodePath), nodeFile, NO_PROPERTIES);
            File propertiesFile2 = customPropertiesFactory.propertiesFileForResource(nodeFile);
            if (propertiesFile2 != null) {
                FileUtil.delete((File)propertiesFile2);
            }
            if (!nodeFile.exists()) {
                return null;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(nodeFile);
                IoUtil.write((String)"", (OutputStream)fos);
            }
            catch (IOException ioe) {
                throw new RepositorySourceException(this.source.getName(), FileSystemI18n.deleteFailed.text(new Object[]{nodePath, this.getName(), this.source.getName()}));
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        PathNode node = this.getNode(nodePath);
        if (node == null) {
            return null;
        }
        File nodeFile = this.fileFor(nodePath);
        for (Path.Segment segment : node.getChildren()) {
            Path childPath = this.pathFactory.create(nodePath, new Path.Segment[]{segment});
            this.removeNode(childPath);
        }
        Name primaryType = (Name)this.nameFactory.create(node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue());
        if (JcrNtLexicon.FILE.equals(primaryType)) {
            customPropertiesFactory.recordFileProperties(this.context, this.source.getName(), Location.create((Path)nodePath), nodeFile, NO_PROPERTIES);
            propertiesFile = customPropertiesFactory.propertiesFileForFile(nodeFile);
            if (propertiesFile != null && propertiesFile.exists()) {
                FileUtil.delete((File)propertiesFile);
            }
        } else if (JcrNtLexicon.FOLDER.equals(primaryType)) {
            customPropertiesFactory.recordDirectoryProperties(this.context, this.source.getName(), Location.create((Path)nodePath), nodeFile, NO_PROPERTIES);
            propertiesFile = customPropertiesFactory.propertiesFileForFolder(nodeFile);
            if (propertiesFile != null && propertiesFile.exists()) {
                FileUtil.delete((File)propertiesFile);
            }
        } else {
            customPropertiesFactory.recordResourceProperties(this.context, this.source.getName(), Location.create((Path)nodePath), nodeFile, NO_PROPERTIES);
            propertiesFile = customPropertiesFactory.propertiesFileForResource(nodeFile);
            if (propertiesFile != null && propertiesFile.exists()) {
                FileUtil.delete((File)propertiesFile);
            }
        }
        FileUtil.delete((File)nodeFile);
        return null;
    }

    public PathNode getRootNode() {
        return this.getNode(this.context.getValueFactories().getPathFactory().createRootPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathNode getNode(Path path) {
        PathNode pathNode;
        File file;
        Location location;
        CustomPropertiesFactory customPropertiesFactory;
        UuidFactory uuidFactory;
        DateTimeFactory dateFactory;
        PathFactory pathFactory;
        PropertyFactory factory;
        Name nodeType;
        long startTime;
        HashMap<Name, Property> properties;
        block45: {
            ArrayList<Path.Segment> childSegments;
            block47: {
                String[] childNames;
                block46: {
                    NamespaceRegistry registry;
                    block44: {
                        block41: {
                            Property primaryType;
                            File file2;
                            MimeTypeDetector mimeTypeDetector;
                            block42: {
                                properties = new HashMap<Name, Property>();
                                startTime = System.nanoTime();
                                nodeType = null;
                                factory = this.context.getPropertyFactory();
                                pathFactory = this.context.getValueFactories().getPathFactory();
                                dateFactory = this.context.getValueFactories().getDateFactory();
                                mimeTypeDetector = this.context.getMimeTypeDetector();
                                uuidFactory = this.context.getValueFactories().getUuidFactory();
                                customPropertiesFactory = this.source.customPropertiesFactory();
                                registry = this.context.getNamespaceRegistry();
                                location = Location.create((Path)path);
                                if (path.isRoot() || !JcrLexicon.CONTENT.equals(path.getLastSegment().getName())) break block41;
                                file2 = this.fileFor(path.getParent());
                                if (file2 != null) break block42;
                                PathNode pathNode2 = null;
                                if (nodeType != null && this.logger.isTraceEnabled()) {
                                    long stopTime = System.nanoTime();
                                    long ms = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
                                    String pathStr = (String)this.stringFactory.create(path);
                                    String typeStr = (String)this.stringFactory.create(nodeType);
                                    this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr, ms});
                                }
                                return pathNode2;
                            }
                            Collection<Property> customProps = customPropertiesFactory.getResourceProperties(this.context, location, file2, null);
                            for (Property customProp : customProps) {
                                properties.put(customProp.getName(), customProp);
                            }
                            if (!properties.containsKey(JcrLexicon.MIMETYPE)) {
                                String mimeType = null;
                                InputStream contents = null;
                                try {
                                    mimeType = mimeTypeDetector.mimeTypeOf(file2.getName(), null);
                                    if (mimeType == null && this.contentUsedToDetermineMimeType) {
                                        contents = new BufferedInputStream(new FileInputStream(file2));
                                        mimeType = mimeTypeDetector.mimeTypeOf(null, contents);
                                    }
                                    if (mimeType == null) {
                                        mimeType = DEFAULT_MIME_TYPE;
                                    }
                                    properties.put(JcrLexicon.MIMETYPE, factory.create(JcrLexicon.MIMETYPE, new Object[]{mimeType}));
                                }
                                catch (IOException e) {
                                    I18n msg = FileSystemI18n.couldNotReadData;
                                    throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{this.source.getName(), this.getName(), path.getString(registry)}));
                                }
                                finally {
                                    if (contents != null) {
                                        try {
                                            contents.close();
                                        }
                                        catch (IOException e) {}
                                    }
                                }
                            }
                            if ((primaryType = (Property)properties.get(JcrLexicon.PRIMARY_TYPE)) == null) {
                                nodeType = JcrNtLexicon.RESOURCE;
                                properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}));
                            } else {
                                nodeType = this.nameValueFor(primaryType);
                            }
                            properties.put(JcrLexicon.LAST_MODIFIED, factory.create(JcrLexicon.LAST_MODIFIED, new Object[]{dateFactory.create(file2.lastModified())}));
                            Binary binary = this.binaryForContent(file2);
                            properties.put(JcrLexicon.DATA, factory.create(JcrLexicon.DATA, new Object[]{binary}));
                            Property uuidProperty = (Property)properties.get(JcrLexicon.UUID);
                            UUID uuid = uuidProperty != null ? (UUID)uuidFactory.create(uuidProperty.getFirstValue()) : null;
                            PathNode pathStr = new PathNode(uuid, path.getParent(), path.getLastSegment(), properties, Collections.emptyList());
                            if (nodeType != null && this.logger.isTraceEnabled()) {
                                long stopTime = System.nanoTime();
                                long ms = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
                                String pathStr2 = (String)this.stringFactory.create(path);
                                String typeStr = (String)this.stringFactory.create(nodeType);
                                this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr2, ms});
                            }
                            return pathStr;
                        }
                        file = this.fileFor(path);
                        if (file != null) break block44;
                        PathNode customProps = null;
                        if (nodeType != null && this.logger.isTraceEnabled()) {
                            long stopTime = System.nanoTime();
                            long ms = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
                            String pathStr = (String)this.stringFactory.create(path);
                            String typeStr = (String)this.stringFactory.create(nodeType);
                            this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr, ms});
                        }
                        return customProps;
                    }
                    if (!file.isDirectory()) break block45;
                    childNames = null;
                    int attempts = 5;
                    while (childNames == null && --attempts >= 0) {
                        childNames = file.list(this.source.filenameFilter(true));
                    }
                    if (childNames != null) break block46;
                    Logger.getLogger(((Object)((Object)this)).getClass()).error(FileSystemI18n.couldNotReadListOfFilesInDirectory, new Object[]{file.getAbsolutePath(), path.getString(registry)});
                    PathNode binary = null;
                    if (nodeType != null && this.logger.isTraceEnabled()) {
                        long stopTime = System.nanoTime();
                        long ms = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
                        String pathStr = (String)this.stringFactory.create(path);
                        String typeStr = (String)this.stringFactory.create(nodeType);
                        this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr, ms});
                    }
                    return binary;
                }
                Arrays.sort(childNames);
                childSegments = new ArrayList<Path.Segment>(childNames.length);
                for (String childName : childNames) {
                    childSegments.add(pathFactory.createSegment(childName));
                }
                Collection<Property> customProps = customPropertiesFactory.getDirectoryProperties(this.context, location, file);
                for (Property customProp : customProps) {
                    properties.put(customProp.getName(), customProp);
                }
                if (!path.isRoot()) break block47;
                nodeType = ModeShapeLexicon.ROOT;
                properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.ROOT}));
                PathNode i$ = new PathNode(this.source.getRootNodeUuidObject(), path.getParent(), path.getLastSegment(), properties, childSegments);
                if (nodeType != null && this.logger.isTraceEnabled()) {
                    long stopTime = System.nanoTime();
                    long ms = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
                    String pathStr = (String)this.stringFactory.create(path);
                    String typeStr = (String)this.stringFactory.create(nodeType);
                    this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr, ms});
                }
                return i$;
            }
            Property primaryType = (Property)properties.get(JcrLexicon.PRIMARY_TYPE);
            if (primaryType == null) {
                nodeType = JcrNtLexicon.FOLDER;
                properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER}));
            } else {
                nodeType = this.nameValueFor(primaryType);
            }
            Property uuidProperty = (Property)properties.get(JcrLexicon.UUID);
            UUID uuid = uuidProperty != null ? (UUID)uuidFactory.create(uuidProperty.getFirstValue()) : null;
            PathNode ms = new PathNode(uuid, path.getParent(), path.getLastSegment(), properties, childSegments);
            if (nodeType != null && this.logger.isTraceEnabled()) {
                long stopTime = System.nanoTime();
                long ms2 = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
                String pathStr = (String)this.stringFactory.create(path);
                String typeStr = (String)this.stringFactory.create(nodeType);
                this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr, ms2});
            }
            return ms;
        }
        try {
            Property uuidProperty;
            Collection<Property> customProps = customPropertiesFactory.getFileProperties(this.context, location, file);
            for (Property customProp : customProps) {
                properties.put(customProp.getName(), customProp);
            }
            Property primaryType = (Property)properties.get(JcrLexicon.PRIMARY_TYPE);
            if (primaryType == null) {
                nodeType = JcrNtLexicon.FILE;
                properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}));
            } else {
                nodeType = this.nameValueFor(primaryType);
            }
            if (!properties.containsKey(JcrLexicon.CREATED)) {
                properties.put(JcrLexicon.CREATED, factory.create(JcrLexicon.CREATED, new Object[]{dateFactory.create(file.lastModified())}));
            }
            UUID uuid = (uuidProperty = (Property)properties.get(JcrLexicon.UUID)) != null ? (UUID)uuidFactory.create(uuidProperty.getFirstValue()) : null;
            pathNode = new PathNode(uuid, path.getParent(), path.getLastSegment(), properties, Collections.singletonList(pathFactory.createSegment(JcrLexicon.CONTENT)));
        }
        catch (Throwable throwable) {
            if (nodeType != null && this.logger.isTraceEnabled()) {
                long stopTime = System.nanoTime();
                long ms = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
                String pathStr = (String)this.stringFactory.create(path);
                String typeStr = (String)this.stringFactory.create(nodeType);
                this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr, ms});
            }
            throw throwable;
        }
        if (nodeType != null && this.logger.isTraceEnabled()) {
            long stopTime = System.nanoTime();
            long ms = TimeUnit.MICROSECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
            String pathStr = (String)this.stringFactory.create(path);
            String typeStr = (String)this.stringFactory.create(nodeType);
            this.logger.trace("Loaded '{0}' node '{1}' in {2}microsec", new Object[]{typeStr, pathStr, ms});
        }
        return pathNode;
    }

    public Location verifyNodeExists(Path path) {
        File file = this.fileFor(path, true);
        return file != null ? Location.create((Path)path) : null;
    }

    protected Binary binaryForContent(File file) {
        if (file == null) {
            return null;
        }
        if (this.eagerLoading) {
            BinaryFactory binaryFactory = this.context.getValueFactories().getBinaryFactory();
            return binaryFactory.create(file);
        }
        return new FileSystemBinary(file);
    }

    protected File fileFor(Path path) {
        return this.fileFor(path, true);
    }

    protected File fileFor(Path path, boolean existingFilesOnly) {
        if (path == null || path.isRoot()) {
            return this.workspaceRoot;
        }
        if (path.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
            path = path.getParent();
        }
        File file = this.workspaceRoot;
        for (Path.Segment segment : path) {
            String localName = segment.getName().getLocalName();
            if (segment.getIndex() > 1) {
                I18n msg = FileSystemI18n.sameNameSiblingsAreNotAllowed;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{this.source.getName()}));
            }
            String defaultNamespaceUri = this.context.getNamespaceRegistry().getDefaultNamespaceUri();
            if (!segment.getName().getNamespaceUri().equals(defaultNamespaceUri)) {
                I18n msg = FileSystemI18n.onlyTheDefaultNamespaceIsAllowed;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{this.source.getName()}));
            }
            file = new File(file, localName);
            if (!existingFilesOnly || file.canRead() && file.exists()) continue;
            return null;
        }
        assert (file != null);
        return file;
    }

    protected void validate(PathNode node) {
        Name primaryType;
        if (node.getParent() == null) {
            return;
        }
        Map properties = node.getProperties();
        Property primaryTypeProp = (Property)properties.get(JcrLexicon.PRIMARY_TYPE);
        Name name = primaryType = primaryTypeProp == null ? JcrNtLexicon.FOLDER : (Name)this.nameFactory.create(primaryTypeProp.getFirstValue());
        if (!VALID_PRIMARY_TYPES.contains(primaryType)) {
            I18n msg = FileSystemI18n.unsupportedPrimaryType;
            NamespaceRegistry registry = this.context.getNamespaceRegistry();
            Path parentPath = node.getParent();
            throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{primaryType.getString(registry), parentPath, this.getName(), this.source.getName()}));
        }
        Path nodePath = this.context.getValueFactories().getPathFactory().create(node.getParent(), new Path.Segment[]{node.getName()});
        this.ensureValidPathLength(this.fileFor(nodePath, false));
    }

    protected void ensureValidPathLength(File file) {
        this.ensureValidPathLength(file, 0);
    }

    protected void ensureValidPathLength(File root, int delta) {
        try {
            int len = root.getCanonicalPath().length();
            if (len > this.source.getMaxPathLength() - delta) {
                String msg = FileSystemI18n.maxPathLengthExceeded.text(new Object[]{this.source.getMaxPathLength(), this.source.getName(), root.getCanonicalPath(), delta});
                throw new RepositorySourceException(this.source.getName(), msg);
            }
            if (root.isDirectory()) {
                for (File child : root.listFiles(this.source.filenameFilter(false))) {
                    this.ensureValidPathLength(child, delta);
                }
            }
        }
        catch (IOException ioe) {
            throw new RepositorySourceException(this.source.getName(), FileSystemI18n.getCanonicalPathFailed.text(new Object[0]), (Throwable)ioe);
        }
    }

    protected Map<Name, Property> extraFolder(Map<Name, Property> properties) {
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return properties;
        }
        HashMap<Name, Property> extra = new HashMap<Name, Property>();
        for (Property property : properties.values()) {
            Name name = property.getName();
            if (name.equals(JcrLexicon.PRIMARY_TYPE) && this.primaryTypeIs(property, JcrNtLexicon.FOLDER)) continue;
            extra.put(name, property);
        }
        return extra;
    }

    protected Map<Name, Property> extraFile(Map<Name, Property> properties) {
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return properties;
        }
        HashMap<Name, Property> extra = new HashMap<Name, Property>();
        for (Property property : properties.values()) {
            Name name = property.getName();
            if (name.equals(JcrLexicon.PRIMARY_TYPE) && this.primaryTypeIs(property, JcrNtLexicon.FILE)) continue;
            extra.put(name, property);
        }
        return extra;
    }

    protected Map<Name, Property> extraResource(Map<Name, Property> properties) {
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return properties;
        }
        HashMap<Name, Property> extra = new HashMap<Name, Property>();
        for (Property property : properties.values()) {
            Name name = property.getName();
            if (name.equals(JcrLexicon.PRIMARY_TYPE) && this.primaryTypeIs(property, JcrNtLexicon.RESOURCE) || name.equals(JcrLexicon.DATA)) continue;
            extra.put(name, property);
        }
        return extra;
    }

    protected boolean primaryTypeIs(Property property, Name primaryType) {
        Name actualPrimaryType = this.nameValueFor(property);
        return actualPrimaryType.equals(primaryType);
    }

    protected Name nameValueFor(Property property) {
        return (Name)this.nameFactory.create(property.getFirstValue());
    }

    class PendingFile {
        private File targetFile;
        private File pendingFile;

        PendingFile(File targetFile) {
            this.targetFile = targetFile;
            this.pendingFile = new File(FileSystemWorkspace.this.repository.pendingFileDir(), UUID.randomUUID().toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long write(Binary binary) throws IOException {
            int BUFF_SIZE = 4096;
            byte[] buff = new byte[4096];
            InputStream in = binary.getStream();
            FileOutputStream out = new FileOutputStream(this.pendingFile);
            try {
                long count = 0L;
                int chunk = 0;
                while (-1 != (chunk = in.read(buff, 0, buff.length))) {
                    out.write(buff, 0, chunk);
                    count += (long)chunk;
                }
                long l = count;
                return l;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception ignore) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ignore) {}
            }
        }

        public void commit() {
            FileSystemWorkspace.this.moveFile(this.pendingFile, this.targetFile);
        }
    }
}

