/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;

public abstract class AbstractProblems
implements Problems {
    private static final long serialVersionUID = 1L;
    protected static final List<Problem> EMPTY_PROBLEMS = Collections.emptyList();

    @Override
    public void addError(I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, params, null, null, null));
    }

    @Override
    public void addError(Throwable throwable, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, params, null, null, throwable));
    }

    @Override
    public void addError(String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, params, resource, location, null));
    }

    @Override
    public void addError(Throwable throwable, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, params, resource, location, throwable));
    }

    @Override
    public void addError(int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, params, null, null, null));
    }

    @Override
    public void addError(Throwable throwable, int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, params, null, null, throwable));
    }

    @Override
    public void addError(int code, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, params, resource, location, null));
    }

    @Override
    public void addError(Throwable throwable, int code, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, params, resource, location, throwable));
    }

    @Override
    public void addWarning(I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, params, null, null, null));
    }

    @Override
    public void addWarning(Throwable throwable, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, params, null, null, throwable));
    }

    @Override
    public void addWarning(String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, params, resource, location, null));
    }

    @Override
    public void addWarning(Throwable throwable, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, params, resource, location, throwable));
    }

    @Override
    public void addWarning(int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, params, null, null, null));
    }

    @Override
    public void addWarning(Throwable throwable, int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, params, null, null, throwable));
    }

    @Override
    public void addWarning(int code, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, params, resource, location, null));
    }

    @Override
    public void addWarning(Throwable throwable, int code, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, params, resource, location, throwable));
    }

    @Override
    public void addInfo(I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, params, null, null, null));
    }

    @Override
    public void addInfo(Throwable throwable, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, params, null, null, throwable));
    }

    @Override
    public void addInfo(String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, params, resource, location, null));
    }

    @Override
    public void addInfo(Throwable throwable, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, params, resource, location, throwable));
    }

    @Override
    public void addInfo(int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, params, null, null, null));
    }

    @Override
    public void addInfo(Throwable throwable, int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, params, null, null, throwable));
    }

    @Override
    public void addInfo(int code, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, params, resource, location, null));
    }

    @Override
    public void addInfo(Throwable throwable, int code, String resource, String location, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, params, resource, location, throwable));
    }

    @Override
    public boolean hasProblems() {
        return this.getProblems().size() > 0;
    }

    @Override
    public boolean hasErrors() {
        for (Problem problem : this.getProblems()) {
            if (problem.getStatus() != Problem.Status.ERROR) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarnings() {
        for (Problem problem : this.getProblems()) {
            if (problem.getStatus() != Problem.Status.WARNING) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInfo() {
        for (Problem problem : this.getProblems()) {
            if (problem.getStatus() != Problem.Status.INFO) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getProblems().isEmpty();
    }

    @Override
    public int size() {
        return this.getProblems().size();
    }

    @Override
    public Iterator<Problem> iterator() {
        return this.getProblems().iterator();
    }

    protected abstract void addProblem(Problem var1);

    protected abstract List<Problem> getProblems();

    @Override
    public void writeTo(Logger logger) {
        if (this.hasProblems()) {
            for (Problem problem : this) {
                Logger.Level level = this.logLevelFor(problem.getStatus());
                logger.log(level, problem.getMessage(), problem.getParameters());
            }
        }
    }

    @Override
    public void writeTo(Logger logger, Problem.Status firstStatus, Problem.Status ... additionalStatuses) {
        EnumSet<Problem.Status[]> stats = EnumSet.of(firstStatus, additionalStatuses);
        if (this.hasProblems()) {
            for (Problem problem : this) {
                Problem.Status status = problem.getStatus();
                if (!stats.contains((Object)status)) continue;
                Logger.Level level = this.logLevelFor(status);
                logger.log(level, problem.getMessage(), problem.getParameters());
            }
        }
    }

    protected final Logger.Level logLevelFor(Problem.Status status) {
        switch (status) {
            case ERROR: {
                return Logger.Level.ERROR;
            }
            case WARNING: {
                return Logger.Level.WARNING;
            }
            case INFO: {
                return Logger.Level.INFO;
            }
        }
        assert (false) : "Should not happen";
        return Logger.Level.INFO;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Problem> iter = this.getProblems().iterator();
        if (iter.hasNext()) {
            sb.append(iter.next());
            while (iter.hasNext()) {
                sb.append("\n");
                sb.append(iter.next());
            }
        }
        return sb.toString();
    }
}

