/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.naming.SingletonInitialContext;

public class SingletonInitialContextFactory
implements InitialContextFactory {
    private static SingletonInitialContext SINGLETON;

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) {
        return SingletonInitialContextFactory.getInstance(environment);
    }

    public static synchronized Context getInstance(Hashtable<?, ?> environment) {
        if (SINGLETON == null) {
            SINGLETON = new SingletonInitialContext(environment);
        }
        return SINGLETON;
    }

    public static synchronized Context getInstance() {
        if (SINGLETON == null) {
            throw new SystemFailureException();
        }
        return SINGLETON;
    }

    public static void initialize() {
        System.setProperty("java.naming.factory.initial", SingletonInitialContextFactory.class.getName());
    }

    public static synchronized void tearDown() {
        SINGLETON = null;
    }
}

