/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Set;
import org.modelmapper.internal.util.Lists;
import org.modelmapper.spi.ValueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonElementValueReader
implements ValueReader<JsonElement> {
    public Object get(JsonElement source, String memberName) {
        if (source.isJsonObject()) {
            JsonObject subjObj = source.getAsJsonObject();
            JsonElement propertyElement = subjObj.get(memberName);
            if (propertyElement == null) {
                throw new IllegalArgumentException();
            }
            if (propertyElement.isJsonObject()) {
                return propertyElement.getAsJsonObject();
            }
            if (propertyElement.isJsonArray()) {
                return propertyElement.getAsJsonArray();
            }
            if (propertyElement.isJsonPrimitive()) {
                JsonPrimitive jsonPrim = propertyElement.getAsJsonPrimitive();
                if (jsonPrim.isBoolean()) {
                    return jsonPrim.getAsBoolean();
                }
                if (jsonPrim.isNumber()) {
                    return jsonPrim.getAsNumber();
                }
                if (jsonPrim.isString()) {
                    return jsonPrim.getAsString();
                }
            }
        }
        return null;
    }

    public ValueReader.Member<JsonElement> getMember(JsonElement source, String memberName) {
        Object value = this.get(source, memberName);
        if (value == null) {
            return null;
        }
        if (value instanceof JsonElement) {
            return new ValueReader.Member((ValueReader)this, JsonElement.class, (Object)((JsonElement)value));
        }
        return new ValueReader.Member((ValueReader)this, value.getClass());
    }

    public Collection<String> memberNames(JsonElement source) {
        if (source.isJsonObject()) {
            return Lists.from((Set)((JsonObject)source).entrySet());
        }
        return null;
    }

    public String toString() {
        return "Gson";
    }
}

