/*
 * Decompiled with CFR 0.152.
 */
package javanet.staxutils;

import java.util.Iterator;
import javanet.staxutils.StAXReaderToContentHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLEventReaderToContentHandler
implements StAXReaderToContentHandler {
    private final XMLEventReader staxEventReader;
    private final ContentHandler saxHandler;

    public XMLEventReaderToContentHandler(XMLEventReader staxCore, ContentHandler saxCore) {
        this.staxEventReader = staxCore;
        this.saxHandler = saxCore;
    }

    public void bridge() throws XMLStreamException {
        try {
            int depth = 0;
            XMLEvent event = this.staxEventReader.peek();
            if (!event.isStartDocument() && !event.isStartElement()) {
                throw new IllegalStateException();
            }
            while (!event.isStartElement()) {
                event = this.staxEventReader.nextEvent();
            }
            this.handleStartDocument(event);
            do {
                switch (event.getEventType()) {
                    case 1: {
                        ++depth;
                        this.handleStartElement(event.asStartElement());
                        break;
                    }
                    case 2: {
                        this.handleEndElement(event.asEndElement());
                        --depth;
                        break;
                    }
                    case 4: {
                        this.handleCharacters(event.asCharacters());
                        break;
                    }
                    case 9: {
                        this.handleEntityReference();
                        break;
                    }
                    case 3: {
                        this.handlePI((ProcessingInstruction)event);
                        break;
                    }
                    case 5: {
                        this.handleComment();
                        break;
                    }
                    case 11: {
                        this.handleDTD();
                        break;
                    }
                    case 10: {
                        this.handleAttribute();
                        break;
                    }
                    case 13: {
                        this.handleNamespace();
                        break;
                    }
                    case 12: {
                        this.handleCDATA();
                        break;
                    }
                    case 15: {
                        this.handleEntityDecl();
                        break;
                    }
                    case 14: {
                        this.handleNotationDecl();
                        break;
                    }
                    case 6: {
                        this.handleSpace();
                        break;
                    }
                    default: {
                        throw new InternalError("processing event: " + event);
                    }
                }
                event = this.staxEventReader.nextEvent();
            } while (depth != 0);
            this.handleEndDocument();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void handleEndDocument() throws SAXException {
        this.saxHandler.endDocument();
    }

    private void handleStartDocument(final XMLEvent event) throws SAXException {
        this.saxHandler.setDocumentLocator(new Locator(){

            public int getColumnNumber() {
                return event.getLocation().getColumnNumber();
            }

            public int getLineNumber() {
                return event.getLocation().getLineNumber();
            }

            public String getPublicId() {
                return event.getLocation().getPublicId();
            }

            public String getSystemId() {
                return event.getLocation().getSystemId();
            }
        });
        this.saxHandler.startDocument();
    }

    private void handlePI(ProcessingInstruction event) throws XMLStreamException {
        try {
            this.saxHandler.processingInstruction(event.getTarget(), event.getData());
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void handleCharacters(Characters event) throws XMLStreamException {
        try {
            this.saxHandler.characters(event.getData().toCharArray(), 0, event.getData().length());
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void handleEndElement(EndElement event) throws XMLStreamException {
        QName qName = event.getName();
        try {
            this.saxHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.toString());
            Iterator<Namespace> i = event.getNamespaces();
            while (i.hasNext()) {
                String prefix = (String)((Object)i.next());
                if (prefix == null) {
                    prefix = "";
                }
                this.saxHandler.endPrefixMapping(prefix);
            }
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void handleStartElement(StartElement event) throws XMLStreamException {
        try {
            String prefix;
            Iterator<Namespace> i = event.getNamespaces();
            while (i.hasNext()) {
                prefix = i.next().getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                this.saxHandler.startPrefixMapping(prefix, event.getNamespaceURI(prefix));
            }
            QName qName = event.getName();
            prefix = qName.getPrefix();
            String rawname = prefix == null || prefix.length() == 0 ? qName.getLocalPart() : prefix + ':' + qName.getLocalPart();
            Attributes saxAttrs = this.getAttributes(event);
            this.saxHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), rawname, saxAttrs);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private Attributes getAttributes(StartElement event) {
        AttributesImpl attrs = new AttributesImpl();
        if (!event.isStartElement()) {
            throw new InternalError("getAttributes() attempting to process: " + event);
        }
        Iterator<Attribute> i = event.getAttributes();
        while (i.hasNext()) {
            Attribute staxAttr = i.next();
            String uri = staxAttr.getName().getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            String localName = staxAttr.getName().getLocalPart();
            String prefix = staxAttr.getName().getPrefix();
            String qName = prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
            String type = staxAttr.getDTDType();
            String value = staxAttr.getValue();
            attrs.addAttribute(uri, localName, qName, type, value);
        }
        return attrs;
    }

    private void handleNamespace() {
    }

    private void handleAttribute() {
    }

    private void handleDTD() {
    }

    private void handleComment() {
    }

    private void handleEntityReference() {
    }

    private void handleSpace() {
    }

    private void handleNotationDecl() {
    }

    private void handleEntityDecl() {
    }

    private void handleCDATA() {
    }
}

