/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.library.integerfunctions;

import fuml.Debug;
import fuml.semantics.commonbehavior.OpaqueBehaviorExecution;
import fuml.semantics.commonbehavior.ParameterValueList;
import fuml.semantics.simpleclassifiers.IntegerValue;
import fuml.semantics.simpleclassifiers.StringValue;
import fuml.semantics.values.Value;
import org.modeldriven.fuml.library.LibraryFunctions;

public class IntegerToIntegerFunctionBehaviorExecution
extends OpaqueBehaviorExecution {
    @Override
    public void doBody(ParameterValueList inputParameters, ParameterValueList outputParameters) {
        int resultInt;
        StringValue sv = (StringValue)inputParameters.getValue((int)0).values.getValue(0);
        String value = sv.value;
        Debug.println("[doBody] argument = " + value);
        try {
            resultInt = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Debug.println("[doBody] string does not specify an integer: " + value);
            LibraryFunctions.addEmptyValueListToOutputList(outputParameters);
            return;
        }
        IntegerValue result = new IntegerValue();
        result.value = resultInt;
        result.type = this.locus.factory.getBuiltInType("Integer");
        Debug.println("[doBody] Integer ToInteger result = " + result.value);
        LibraryFunctions.addValueToOutputList(result, outputParameters);
    }

    @Override
    public Value new_() {
        return new IntegerToIntegerFunctionBehaviorExecution();
    }
}

