/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.environment;

import UMLPrimitiveTypes.UnlimitedNatural;
import fuml.Debug;
import fuml.semantics.commonbehavior.FIFOGetNextEventStrategy;
import fuml.semantics.loci.Executor;
import fuml.semantics.loci.FirstChoiceStrategy;
import fuml.semantics.loci.Locus;
import fuml.semantics.simpleclassifiers.BooleanValue;
import fuml.semantics.simpleclassifiers.DataValue;
import fuml.semantics.simpleclassifiers.EnumerationValue;
import fuml.semantics.simpleclassifiers.FeatureValueList;
import fuml.semantics.simpleclassifiers.IntegerValue;
import fuml.semantics.simpleclassifiers.PrimitiveValue;
import fuml.semantics.simpleclassifiers.RealValue;
import fuml.semantics.simpleclassifiers.SignalInstance;
import fuml.semantics.simpleclassifiers.StringValue;
import fuml.semantics.simpleclassifiers.StructuredValue;
import fuml.semantics.simpleclassifiers.UnlimitedNaturalValue;
import fuml.semantics.structuredclassifiers.RedefinitionBasedDispatchStrategy;
import fuml.semantics.structuredclassifiers.Reference;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.classification.Classifier;
import fuml.syntax.classification.Property;
import fuml.syntax.classification.StructuralFeature;
import fuml.syntax.commonbehavior.Behavior;
import fuml.syntax.simpleclassifiers.DataType;
import fuml.syntax.simpleclassifiers.Enumeration;
import fuml.syntax.simpleclassifiers.PrimitiveType;
import fuml.syntax.simpleclassifiers.Signal;
import fuml.syntax.structuredclassifiers.Class_;
import org.modeldriven.fuml.environment.EnvironmentException;
import org.modeldriven.fuml.environment.ExecutionFactory;
import org.modeldriven.fuml.repository.Element;
import org.modeldriven.fuml.repository.Repository;

public class Environment {
    private static Environment instance = null;
    public Locus locus = new Locus();
    private PrimitiveType Boolean = null;
    private PrimitiveType String = null;
    private PrimitiveType Integer = null;
    private PrimitiveType Real = null;
    private PrimitiveType UnlimitedNatural = null;

    private Environment(ExecutionFactory factory) {
        this.locus.setFactory(factory);
        this.locus.setExecutor(new Executor());
        this.locus.factory.setStrategy(new RedefinitionBasedDispatchStrategy());
        this.locus.factory.setStrategy(new FIFOGetNextEventStrategy());
        this.locus.factory.setStrategy(new FirstChoiceStrategy());
        this.Boolean = this.addBuiltInType("Boolean");
        this.String = this.addBuiltInType("String");
        this.Integer = this.addBuiltInType("Integer");
        this.Real = this.addBuiltInType("Real");
        this.UnlimitedNatural = this.addBuiltInType("UnlimitedNatural");
    }

    private PrimitiveType addBuiltInType(String name) {
        PrimitiveType type = (PrimitiveType)Repository.INSTANCE.getClassifierByName(name).getDelegate();
        this.locus.factory.addBuiltInType(type);
        return type;
    }

    public static Environment getInstance() {
        return Environment.getInstance(new ExecutionFactory());
    }

    public static Environment getInstance(ExecutionFactory factory) {
        if (instance == null) {
            Environment.initializeInstance(factory);
        }
        return instance;
    }

    private static synchronized void initializeInstance(ExecutionFactory factory) {
        if (instance == null) {
            instance = new Environment(factory);
        }
    }

    public Behavior findBehavior(String name) {
        Element elem = Repository.INSTANCE.findElementByName(name);
        if (elem != null) {
            if (elem.getDelegate() instanceof Behavior) {
                return (Behavior)elem.getDelegate();
            }
            throw new EnvironmentException("Element '" + name + "' is not a Behavior, it is a '" + elem.getDelegate().getClass().getSimpleName() + "'");
        }
        return null;
    }

    public fuml.syntax.commonstructure.Element findElementById(String id) {
        Element elem = Repository.INSTANCE.findElementById(id);
        if (elem != null) {
            return elem.getDelegate();
        }
        return null;
    }

    public int getBehaviorCount() {
        return Repository.INSTANCE.getElementCount(Behavior.class);
    }

    public String[] getBehaviorNames() {
        return Repository.INSTANCE.getElementNames(Behavior.class);
    }

    public PrimitiveType getBoolean() {
        return this.Boolean;
    }

    public PrimitiveType getString() {
        return this.String;
    }

    public PrimitiveType getInteger() {
        return this.Integer;
    }

    public PrimitiveType getReal() {
        return this.Real;
    }

    public PrimitiveType getUnlimitedNatural() {
        return this.UnlimitedNatural;
    }

    public PrimitiveValue makePrimitiveValue(Classifier classifier) {
        PrimitiveType type = (PrimitiveType)classifier;
        PrimitiveValue primitiveValue = null;
        if (type == this.Boolean) {
            primitiveValue = new BooleanValue();
        } else if (type == this.Integer) {
            primitiveValue = new IntegerValue();
        } else if (type == this.Real) {
            primitiveValue = new RealValue();
        } else if (type == this.String) {
            primitiveValue = new StringValue();
        } else if (type == this.UnlimitedNatural) {
            primitiveValue = new UnlimitedNaturalValue();
            ((UnlimitedNaturalValue)primitiveValue).value = new UnlimitedNatural();
        }
        if (primitiveValue != null) {
            primitiveValue.type = type;
        } else {
            Debug.println("[makePrimitiveValue] " + type.name + " not understood.");
        }
        return primitiveValue;
    }

    public EnumerationValue makeEnumerationValue(Classifier classifier) {
        Enumeration type = (Enumeration)classifier;
        EnumerationValue enumerationValue = new EnumerationValue();
        enumerationValue.type = type;
        enumerationValue.literal = type.ownedLiteral.getValue(0);
        return enumerationValue;
    }

    public StructuredValue makeStructuredValue(Classifier classifier) {
        StructuredValue structuredValue = null;
        if (classifier instanceof DataType) {
            structuredValue = new DataValue();
            ((DataValue)structuredValue).type = (DataType)classifier;
            structuredValue.createFeatureValues();
        } else if (classifier instanceof Class_) {
            structuredValue = new Reference();
            ((Reference)structuredValue).referent = this.locus.instantiate((Class_)classifier);
        } else if (classifier instanceof Signal) {
            structuredValue = new SignalInstance();
            ((SignalInstance)structuredValue).type = (Signal)classifier;
            structuredValue.createFeatureValues();
        }
        FeatureValueList featureValues = structuredValue.getFeatureValues();
        for (int i = 0; i < featureValues.size(); ++i) {
            StructuralFeature feature = featureValues.getValue((int)i).feature;
            if (!(feature instanceof Property) || ((Property)feature).association != null) continue;
            ValueList valueList = new ValueList();
            valueList.addValue(this.makeValue((Classifier)feature.typedElement.type));
            structuredValue.setFeatureValue(feature, valueList, 0);
        }
        return structuredValue;
    }

    public Value makeValue(Classifier type) {
        if (type == null) {
            return this.makePrimitiveValue(this.String);
        }
        if (type instanceof PrimitiveType) {
            return this.makePrimitiveValue(type);
        }
        if (type instanceof Enumeration) {
            return this.makeEnumerationValue(type);
        }
        return this.makeStructuredValue(type);
    }
}

