/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.activities;

import fuml.Debug;
import fuml.semantics.activities.ActivityNodeActivation;
import fuml.semantics.activities.ObjectToken;
import fuml.semantics.loci.ChoiceStrategy;
import fuml.semantics.values.Value;
import fuml.syntax.activities.ExceptionHandler;
import fuml.syntax.activities.ExceptionHandlerList;
import fuml.syntax.activities.ExecutableNode;

public abstract class ExecutableNodeActivation
extends ActivityNodeActivation {
    public void propagateException(Value exception) {
        ExceptionHandlerList matchingExceptionHandlers = this.getMatchingExceptionHandlers(exception);
        if (matchingExceptionHandlers.size() == 0) {
            this.terminate();
            if (this.group.containingNodeActivation != null) {
                this.group.containingNodeActivation.propagateException(exception);
            } else {
                this.group.activityExecution.propagateException(exception);
            }
        } else {
            ChoiceStrategy strategy = (ChoiceStrategy)this.getExecutionLocus().factory.getStrategy("choice");
            ExceptionHandler handler = matchingExceptionHandlers.getValue(strategy.choose(matchingExceptionHandlers.size()) - 1);
            this.handle(exception, handler);
        }
    }

    public ExceptionHandlerList getMatchingExceptionHandlers(Value exception) {
        ExceptionHandlerList handlers = ((ExecutableNode)this.node).handler;
        ExceptionHandlerList matchingHandlers = new ExceptionHandlerList();
        for (int i = 0; i < handlers.size(); ++i) {
            ExceptionHandler handler = handlers.getValue(i);
            boolean noMatch = true;
            int j = 1;
            while (noMatch & j <= handler.exceptionType.size()) {
                if (exception.isInstanceOf(handler.exceptionType.getValue(j - 1))) {
                    matchingHandlers.addValue(handler);
                    noMatch = false;
                }
                ++j;
            }
        }
        return matchingHandlers;
    }

    public void handle(Value exception, ExceptionHandler handler) {
        Debug.println("[handle] action = " + this.node.name + ", exception = " + exception);
        ActivityNodeActivation handlerBodyActivation = this.group.getNodeActivation(handler.handlerBody);
        ActivityNodeActivation inputActivation = handlerBodyActivation.group.getNodeActivation(handler.exceptionInput);
        ObjectToken token = new ObjectToken();
        token.value = exception;
        inputActivation.addToken(token);
        handlerBodyActivation.receiveOffer();
    }
}

