/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.actions;

import fuml.Debug;
import fuml.semantics.actions.CallActionActivation;
import fuml.semantics.actions.PinActivation;
import fuml.semantics.activities.Token;
import fuml.semantics.activities.TokenList;
import fuml.semantics.commonbehavior.StreamingParameterValue;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.actions.Pin;

public class InputPinActivation
extends PinActivation {
    public StreamingParameterValue streamingParameterValue = null;

    @Override
    public void receiveOffer() {
        if (this.isStreaming()) {
            super.receiveOffer();
        } else {
            this.actionActivation.receiveOffer();
        }
    }

    @Override
    public void fire(TokenList incomingTokens) {
        super.fire(incomingTokens);
        if (this.isStreaming() & incomingTokens.size() > 0) {
            ValueList values = new ValueList();
            for (int i = 0; i < incomingTokens.size(); ++i) {
                Token token = incomingTokens.getValue(i);
                Value value = token.getValue();
                if (value == null) continue;
                values.addValue(value);
            }
            this.streamingParameterValue.post(values);
            if (this.streamingIsTerminated() && this.actionActivation instanceof CallActionActivation) {
                ((CallActionActivation)this.actionActivation).completeStreamingCall();
            }
        }
    }

    @Override
    public boolean isReady() {
        boolean ready = super.isReady();
        if (ready) {
            int minimum = ((Pin)this.node).multiplicityElement.lower;
            if (this.isStreaming() && minimum > 0) {
                minimum = 1;
            }
            ready = this.getTotalValueCount() >= minimum;
        }
        return ready;
    }

    public boolean isReadyForStreaming() {
        return super.isReady() & (((Pin)this.node).multiplicityElement.lower == 0 | this.getTotalValueCount() >= 1);
    }

    public boolean isStreaming() {
        return this.streamingParameterValue != null;
    }

    public boolean streamingIsTerminated() {
        boolean isTerminated = false;
        InputPinActivation._beginIsolation();
        isTerminated = this.streamingParameterValue.isTerminated();
        Debug.println("[streamingIsTerminated] isTerminated = " + isTerminated);
        InputPinActivation._endIsolation();
        return isTerminated;
    }

    public int getTotalValueCount() {
        return this.countUnofferedTokens() + this.countOfferedValues();
    }
}

