/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.actions;

import fuml.Debug;
import fuml.semantics.actions.ActionActivation;
import fuml.semantics.simpleclassifiers.FeatureValue;
import fuml.semantics.simpleclassifiers.FeatureValueList;
import fuml.semantics.structuredclassifiers.ExtensionalValue;
import fuml.semantics.structuredclassifiers.ExtensionalValueList;
import fuml.semantics.structuredclassifiers.Link;
import fuml.semantics.structuredclassifiers.Reference;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.actions.DestroyObjectAction;
import fuml.syntax.classification.AggregationKind;
import fuml.syntax.classification.Property;

public class DestroyObjectActionActivation
extends ActionActivation {
    @Override
    public void doAction() {
        DestroyObjectAction action = (DestroyObjectAction)this.node;
        Value value = this.takeTokens(action.target).getValue(0);
        this.destroyObject(value, action.isDestroyLinks, action.isDestroyOwnedObjects);
    }

    public void destroyObject(Value value, boolean isDestroyLinks, boolean isDestroyOwnedObjects) {
        if (value instanceof Reference) {
            int i;
            Reference reference = (Reference)value;
            Debug.println("[destroyObject] object = " + reference.referent.identifier);
            if (isDestroyLinks | isDestroyOwnedObjects) {
                ExtensionalValueList extensionalValues = this.getExecutionLocus().extensionalValues;
                for (i = 0; i < extensionalValues.size(); ++i) {
                    Value compositeValue;
                    Link link;
                    ExtensionalValue extensionalValue = extensionalValues.getValue(i);
                    if (!(extensionalValue instanceof Link) || !this.valueParticipatesInLink(reference, link = (Link)extensionalValue)) continue;
                    if (isDestroyOwnedObjects && (compositeValue = this.getCompositeValue(reference, link)) != null) {
                        Debug.println("[destroyObject] Destroying (linked) owned object ...");
                        this.destroyObject(compositeValue, isDestroyLinks, isDestroyOwnedObjects);
                    }
                    if (!(isDestroyLinks & !link.getTypes().isEmpty())) continue;
                    link.destroy();
                }
            }
            if (isDestroyOwnedObjects) {
                FeatureValueList objectFeatureValues = reference.getFeatureValues();
                for (i = 0; i < objectFeatureValues.size(); ++i) {
                    FeatureValue featureValue = objectFeatureValues.getValue(i);
                    if (((Property)featureValue.feature).aggregation != AggregationKind.composite) continue;
                    Debug.println("[destroyObject] Destroying owned objects...");
                    ValueList values = featureValue.values;
                    for (int j = 0; j < values.size(); ++j) {
                        Value ownedValue = values.getValue(j);
                        this.destroyObject(ownedValue, isDestroyLinks, isDestroyOwnedObjects);
                    }
                }
            }
            reference.destroy();
        }
    }

    public Value getCompositeValue(Reference reference, Link link) {
        FeatureValueList linkFeatureValues = link.getFeatureValues();
        Value compositeValue = null;
        int i = 1;
        while (compositeValue == null & i <= linkFeatureValues.size()) {
            FeatureValue featureValue = linkFeatureValues.getValue(i - 1);
            Value value = featureValue.values.getValue(0);
            if (!value.equals(reference) & ((Property)featureValue.feature).aggregation == AggregationKind.composite) {
                compositeValue = value;
            }
            ++i;
        }
        return compositeValue;
    }
}

