/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.model;

import fuml.syntax.classification.Property;
import fuml.syntax.packages.Package;
import fuml.syntax.simpleclassifiers.Enumeration;
import fuml.syntax.simpleclassifiers.EnumerationLiteral;
import fuml.syntax.structuredclassifiers.Association;
import fuml.syntax.structuredclassifiers.Class_;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.config.Artifact;
import org.modeldriven.fuml.repository.model.ModelAssembler;
import org.modeldriven.fuml.repository.model.ModelFactory;

public class UMLAssembler
extends ModelAssembler
implements RepositoryArtifact {
    private static Log log = LogFactory.getLog(UMLAssembler.class);
    private ModelFactory factory;

    public UMLAssembler(Artifact artifact, RepositoryMapping mapping, Repository model) {
        super(artifact, mapping, model);
        this.factory = new ModelFactory(mapping, model);
        this.construct();
    }

    private void construct() {
        log.info((Object)"initializing...");
        this.constructPackages();
        this.constructPrimitiveTypes();
        this.constructEnumerations();
        this.constructClasses();
        this.constructProperties();
        this.constructGeneralizations();
        this.constructAssociations();
    }

    @Override
    public String getURN() {
        return this.artifact.getUrn();
    }

    @Override
    public String getNamespaceURI() {
        return this.artifact.getNamespaceURI();
    }

    private void constructPackages() {
        Package pkg = null;
        pkg = this.factory.createPackage("UML", "UML", "_0", this);
        this.mapping.mapPackage(pkg, null, this);
        pkg = this.factory.createPackage("Activities", "UML.Activities", "Activities", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Values", "UML.Values", "Values", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("UseCases", "UML.UseCases", "UseCases", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("StructuredClassifiers", "UML.StructuredClassifiers", "StructuredClassifiers", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("StateMachines", "UML.StateMachines", "StateMachines", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("SimpleClassifiers", "UML.SimpleClassifiers", "SimpleClassifiers", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Packages", "UML.Packages", "Packages", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Interactions", "UML.Interactions", "Interactions", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("InformationFlows", "UML.InformationFlows", "InformationFlows", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Deployments", "UML.Deployments", "Deployments", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("CommonStructure", "UML.CommonStructure", "CommonStructure", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("CommonBehavior", "UML.CommonBehavior", "CommonBehavior", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Classification", "UML.Classification", "Classification", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Actions", "UML.Actions", "Actions", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
    }

    private void constructPrimitiveTypes() {
        Object pkg = null;
        Object packageId = null;
        Object type = null;
    }

    private void constructClasses() {
        Package pkg = null;
        String packageId = null;
        Class_ clss = null;
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Activity", "Activity", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityEdge", "ActivityEdge", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityFinalNode", "ActivityFinalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityGroup", "ActivityGroup", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityNode", "ActivityNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityParameterNode", "ActivityParameterNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityPartition", "ActivityPartition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CentralBufferNode", "CentralBufferNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ControlFlow", "ControlFlow", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ControlNode", "ControlNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DataStoreNode", "DataStoreNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DecisionNode", "DecisionNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExceptionHandler", "ExceptionHandler", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutableNode", "ExecutableNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FinalNode", "FinalNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FlowFinalNode", "FlowFinalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ForkNode", "ForkNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InitialNode", "InitialNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InterruptibleActivityRegion", "InterruptibleActivityRegion", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("JoinNode", "JoinNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MergeNode", "MergeNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ObjectFlow", "ObjectFlow", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ObjectNode", "ObjectNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Variable", "Variable", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Duration", "Duration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DurationConstraint", "DurationConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DurationInterval", "DurationInterval", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DurationObservation", "DurationObservation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Expression", "Expression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interval", "Interval", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("IntervalConstraint", "IntervalConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralBoolean", "LiteralBoolean", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralInteger", "LiteralInteger", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralNull", "LiteralNull", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralReal", "LiteralReal", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralSpecification", "LiteralSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralString", "LiteralString", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralUnlimitedNatural", "LiteralUnlimitedNatural", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Observation", "Observation", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueExpression", "OpaqueExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StringExpression", "StringExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeConstraint", "TimeConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeExpression", "TimeExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeInterval", "TimeInterval", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeObservation", "TimeObservation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "Values";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValueSpecification", "ValueSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Values", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Actor", "Actor", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Extend", "Extend", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExtensionPoint", "ExtensionPoint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Include", "Include", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("UseCase", "UseCase", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Association", "Association", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AssociationClass", "AssociationClass", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Collaboration", "Collaboration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CollaborationUse", "CollaborationUse", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Component", "Component", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ComponentRealization", "ComponentRealization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectableElement", "ConnectableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectableElementTemplateParameter", "ConnectableElementTemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Connector", "Connector", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectorEnd", "ConnectorEnd", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("EncapsulatedClassifier", "EncapsulatedClassifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Port", "Port", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuredClassifier", "StructuredClassifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.StructuredClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectionPointReference", "ConnectionPointReference", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FinalState", "FinalState", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProtocolConformance", "ProtocolConformance", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProtocolStateMachine", "ProtocolStateMachine", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProtocolTransition", "ProtocolTransition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Pseudostate", "Pseudostate", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Region", "Region", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("State", "State", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StateMachine", "StateMachine", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Transition", "Transition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Vertex", "Vertex", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.StateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioredClassifier", "BehavioredClassifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DataType", "DataType", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Enumeration", "Enumeration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("EnumerationLiteral", "EnumerationLiteral", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interface", "Interface", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InterfaceRealization", "InterfaceRealization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PrimitiveType", "PrimitiveType", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Reception", "Reception", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Signal", "Signal", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.SimpleClassifiers", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Extension", "Extension", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExtensionEnd", "ExtensionEnd", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Image", "Image", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Model", "Model", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Package", "Package", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageMerge", "PackageMerge", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Profile", "Profile", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProfileApplication", "ProfileApplication", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Packages";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Stereotype", "Stereotype", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Packages", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActionExecutionSpecification", "ActionExecutionSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehaviorExecutionSpecification", "BehaviorExecutionSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CombinedFragment", "CombinedFragment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConsiderIgnoreFragment", "ConsiderIgnoreFragment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Continuation", "Continuation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DestructionOccurrenceSpecification", "DestructionOccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutionOccurrenceSpecification", "ExecutionOccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutionSpecification", "ExecutionSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Gate", "Gate", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("GeneralOrdering", "GeneralOrdering", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interaction", "Interaction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionConstraint", "InteractionConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionFragment", "InteractionFragment", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionOperand", "InteractionOperand", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionUse", "InteractionUse", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Lifeline", "Lifeline", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Message", "Message", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MessageEnd", "MessageEnd", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MessageOccurrenceSpecification", "MessageOccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OccurrenceSpecification", "OccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PartDecomposition", "PartDecomposition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StateInvariant", "StateInvariant", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions", this);
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InformationFlow", "InformationFlow", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.InformationFlows", this);
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InformationItem", "InformationItem", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.InformationFlows", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Artifact", "Artifact", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CommunicationPath", "CommunicationPath", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DeployedArtifact", "DeployedArtifact", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Deployment", "Deployment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DeploymentSpecification", "DeploymentSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DeploymentTarget", "DeploymentTarget", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Device", "Device", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutionEnvironment", "ExecutionEnvironment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Manifestation", "Manifestation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Node", "Node", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Abstraction", "Abstraction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Comment", "Comment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Constraint", "Constraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Dependency", "Dependency", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DirectedRelationship", "DirectedRelationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Element", "Element", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ElementImport", "ElementImport", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MultiplicityElement", "MultiplicityElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Namespace", "Namespace", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageableElement", "PackageableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageImport", "PackageImport", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ParameterableElement", "ParameterableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Realization", "Realization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Relationship", "Relationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateableElement", "TemplateableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateBinding", "TemplateBinding", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateParameter", "TemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateParameterSubstitution", "TemplateParameterSubstitution", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateSignature", "TemplateSignature", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Type", "Type", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TypedElement", "TypedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Usage", "Usage", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonStructure", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AnyReceiveEvent", "AnyReceiveEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Behavior", "Behavior", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallEvent", "CallEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ChangeEvent", "ChangeEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Event", "Event", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FunctionBehavior", "FunctionBehavior", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MessageEvent", "MessageEvent", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueBehavior", "OpaqueBehavior", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SignalEvent", "SignalEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeEvent", "TimeEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Trigger", "Trigger", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehavior", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Substitution", "Substitution", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioralFeature", "BehavioralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClassifierTemplateParameter", "ClassifierTemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Feature", "Feature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Generalization", "Generalization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("GeneralizationSet", "GeneralizationSet", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InstanceSpecification", "InstanceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InstanceValue", "InstanceValue", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Operation", "Operation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OperationTemplateParameter", "OperationTemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Parameter", "Parameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ParameterSet", "ParameterSet", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RedefinableElement", "RedefinableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RedefinableTemplateSignature", "RedefinableTemplateSignature", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Slot", "Slot", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Classification";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuralFeature", "StructuralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classification", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValueSpecificationAction", "ValueSpecificationAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("VariableAction", "VariableAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("WriteLinkAction", "WriteLinkAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("WriteStructuralFeatureAction", "WriteStructuralFeatureAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("WriteVariableAction", "WriteVariableAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AcceptCallAction", "AcceptCallAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AcceptEventAction", "AcceptEventAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Action", "Action", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActionInputPin", "ActionInputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AddStructuralFeatureValueAction", "AddStructuralFeatureValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AddVariableValueAction", "AddVariableValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BroadcastSignalAction", "BroadcastSignalAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallAction", "CallAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallBehaviorAction", "CallBehaviorAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallOperationAction", "CallOperationAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Clause", "Clause", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClearAssociationAction", "ClearAssociationAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClearStructuralFeatureAction", "ClearStructuralFeatureAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClearVariableAction", "ClearVariableAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConditionalNode", "ConditionalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CreateLinkAction", "CreateLinkAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CreateLinkObjectAction", "CreateLinkObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CreateObjectAction", "CreateObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DestroyLinkAction", "DestroyLinkAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DestroyObjectAction", "DestroyObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExpansionNode", "ExpansionNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExpansionRegion", "ExpansionRegion", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InputPin", "InputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InvocationAction", "InvocationAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkAction", "LinkAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkEndCreationData", "LinkEndCreationData", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkEndData", "LinkEndData", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkEndDestructionData", "LinkEndDestructionData", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LoopNode", "LoopNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueAction", "OpaqueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OutputPin", "OutputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Pin", "Pin", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("QualifierValue", "QualifierValue", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RaiseExceptionAction", "RaiseExceptionAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadExtentAction", "ReadExtentAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadIsClassifiedObjectAction", "ReadIsClassifiedObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadLinkAction", "ReadLinkAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadLinkObjectEndAction", "ReadLinkObjectEndAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadLinkObjectEndQualifierAction", "ReadLinkObjectEndQualifierAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadSelfAction", "ReadSelfAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadStructuralFeatureAction", "ReadStructuralFeatureAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadVariableAction", "ReadVariableAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReclassifyObjectAction", "ReclassifyObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReduceAction", "ReduceAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RemoveStructuralFeatureValueAction", "RemoveStructuralFeatureValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RemoveVariableValueAction", "RemoveVariableValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReplyAction", "ReplyAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SendObjectAction", "SendObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SendSignalAction", "SendSignalAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SequenceNode", "SequenceNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StartClassifierBehaviorAction", "StartClassifierBehaviorAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StartObjectBehaviorAction", "StartObjectBehaviorAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuralFeatureAction", "StructuralFeatureAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuredActivityNode", "StructuredActivityNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TestIdentityAction", "TestIdentityAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("UnmarshallAction", "UnmarshallAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValuePin", "ValuePin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions", this);
    }

    private void constructEnumerations() {
        Enumeration enumeration = null;
        EnumerationLiteral literal = null;
        enumeration = this.factory.createEnumeration("ObjectNodeOrderingKind", "ObjectNodeOrderingKind");
        this.mapping.mapEnumeration(enumeration, "UML.Activities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "unordered", "ObjectNodeOrderingKind-unordered");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "ordered", "ObjectNodeOrderingKind-ordered");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "LIFO", "ObjectNodeOrderingKind-LIFO");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "FIFO", "ObjectNodeOrderingKind-FIFO");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities", this);
        enumeration = this.factory.createEnumeration("ConnectorKind", "ConnectorKind");
        this.mapping.mapEnumeration(enumeration, "UML.StructuredClassifiers", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "assembly", "ConnectorKind-assembly");
        this.mapping.mapEnumerationLiteral(literal, "UML.StructuredClassifiers", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "delegation", "ConnectorKind-delegation");
        this.mapping.mapEnumerationLiteral(literal, "UML.StructuredClassifiers", this);
        enumeration = this.factory.createEnumeration("PseudostateKind", "PseudostateKind");
        this.mapping.mapEnumeration(enumeration, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "initial", "PseudostateKind-initial");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "deepHistory", "PseudostateKind-deepHistory");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "shallowHistory", "PseudostateKind-shallowHistory");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "join", "PseudostateKind-join");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "fork", "PseudostateKind-fork");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "junction", "PseudostateKind-junction");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "choice", "PseudostateKind-choice");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "entryPoint", "PseudostateKind-entryPoint");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "exitPoint", "PseudostateKind-exitPoint");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "terminate", "PseudostateKind-terminate");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        enumeration = this.factory.createEnumeration("TransitionKind", "TransitionKind");
        this.mapping.mapEnumeration(enumeration, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "internal", "TransitionKind-internal");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "local", "TransitionKind-local");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "external", "TransitionKind-external");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines", this);
        enumeration = this.factory.createEnumeration("InteractionOperatorKind", "InteractionOperatorKind");
        this.mapping.mapEnumeration(enumeration, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "seq", "InteractionOperatorKind-seq");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "alt", "InteractionOperatorKind-alt");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "opt", "InteractionOperatorKind-opt");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "break", "InteractionOperatorKind-break");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "par", "InteractionOperatorKind-par");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "strict", "InteractionOperatorKind-strict");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "loop", "InteractionOperatorKind-loop");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "critical", "InteractionOperatorKind-critical");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "neg", "InteractionOperatorKind-neg");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "assert", "InteractionOperatorKind-assert");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "ignore", "InteractionOperatorKind-ignore");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "consider", "InteractionOperatorKind-consider");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        enumeration = this.factory.createEnumeration("MessageKind", "MessageKind");
        this.mapping.mapEnumeration(enumeration, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "complete", "MessageKind-complete");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "lost", "MessageKind-lost");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "found", "MessageKind-found");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "unknown", "MessageKind-unknown");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        enumeration = this.factory.createEnumeration("MessageSort", "MessageSort");
        this.mapping.mapEnumeration(enumeration, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "synchCall", "MessageSort-synchCall");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "asynchCall", "MessageSort-asynchCall");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "asynchSignal", "MessageSort-asynchSignal");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "createMessage", "MessageSort-createMessage");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "deleteMessage", "MessageSort-deleteMessage");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "reply", "MessageSort-reply");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions", this);
        enumeration = this.factory.createEnumeration("VisibilityKind", "VisibilityKind");
        this.mapping.mapEnumeration(enumeration, "UML.CommonStructure", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "public", "VisibilityKind-public");
        this.mapping.mapEnumerationLiteral(literal, "UML.CommonStructure", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "private", "VisibilityKind-private");
        this.mapping.mapEnumerationLiteral(literal, "UML.CommonStructure", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "protected", "VisibilityKind-protected");
        this.mapping.mapEnumerationLiteral(literal, "UML.CommonStructure", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "package", "VisibilityKind-package");
        this.mapping.mapEnumerationLiteral(literal, "UML.CommonStructure", this);
        enumeration = this.factory.createEnumeration("AggregationKind", "AggregationKind");
        this.mapping.mapEnumeration(enumeration, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "none", "AggregationKind-none");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "shared", "AggregationKind-shared");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "composite", "AggregationKind-composite");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        enumeration = this.factory.createEnumeration("CallConcurrencyKind", "CallConcurrencyKind");
        this.mapping.mapEnumeration(enumeration, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "sequential", "CallConcurrencyKind-sequential");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "guarded", "CallConcurrencyKind-guarded");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "concurrent", "CallConcurrencyKind-concurrent");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        enumeration = this.factory.createEnumeration("ParameterDirectionKind", "ParameterDirectionKind");
        this.mapping.mapEnumeration(enumeration, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "in", "ParameterDirectionKind-in");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "inout", "ParameterDirectionKind-inout");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "out", "ParameterDirectionKind-out");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "return", "ParameterDirectionKind-return");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        enumeration = this.factory.createEnumeration("ParameterEffectKind", "ParameterEffectKind");
        this.mapping.mapEnumeration(enumeration, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "create", "ParameterEffectKind-create");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "read", "ParameterEffectKind-read");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "update", "ParameterEffectKind-update");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "delete", "ParameterEffectKind-delete");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classification", this);
        enumeration = this.factory.createEnumeration("ExpansionKind", "ExpansionKind");
        this.mapping.mapEnumeration(enumeration, "UML.Actions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "parallel", "ExpansionKind-parallel");
        this.mapping.mapEnumerationLiteral(literal, "UML.Actions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "iterative", "ExpansionKind-iterative");
        this.mapping.mapEnumerationLiteral(literal, "UML.Actions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "stream", "ExpansionKind-stream");
        this.mapping.mapEnumerationLiteral(literal, "UML.Actions", this);
    }

    /*
     * Opcode count of 22566 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void constructProperties() {
        Class_ clss = null;
        Property prop = null;
        clss = (Class_)this.model.getElementById("Activity").getDelegate();
        prop = this.factory.createProperty(clss, "edge", "Activity-edge", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "group", "Activity-group", "ActivityGroup", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReadOnly", "Activity-isReadOnly", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activity-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isSingleExecution", "Activity-isSingleExecution", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activity-isSingleExecution-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "node", "Activity-node", "ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "partition", "Activity-partition", "ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "structuredNode", "Activity-structuredNode", "StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "variable", "Activity-variable", "Variable", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ActivityEdge").getDelegate();
        prop = this.factory.createProperty(clss, "activity", "ActivityEdge-activity", "Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "guard", "ActivityEdge-guard", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inGroup", "ActivityEdge-inGroup", "ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inPartition", "ActivityEdge-inPartition", "ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inStructuredNode", "ActivityEdge-inStructuredNode", "StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interrupts", "ActivityEdge-interrupts", "InterruptibleActivityRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedEdge", "ActivityEdge-redefinedEdge", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "source", "ActivityEdge-source", "ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "ActivityEdge-target", "ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "weight", "ActivityEdge-weight", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ActivityFinalNode").getDelegate();
        clss = (Class_)this.model.getElementById("ActivityGroup").getDelegate();
        prop = this.factory.createProperty(clss, "containedEdge", "ActivityGroup-containedEdge", "ActivityEdge", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "containedNode", "ActivityGroup-containedNode", "ActivityNode", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inActivity", "ActivityGroup-inActivity", "Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subgroup", "ActivityGroup-subgroup", "ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superGroup", "ActivityGroup-superGroup", "ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "activity", "ActivityNode-activity", "Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inGroup", "ActivityNode-inGroup", "ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inInterruptibleRegion", "ActivityNode-inInterruptibleRegion", "InterruptibleActivityRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inPartition", "ActivityNode-inPartition", "ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inStructuredNode", "ActivityNode-inStructuredNode", "StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "incoming", "ActivityNode-incoming", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "outgoing", "ActivityNode-outgoing", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedNode", "ActivityNode-redefinedNode", "ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ActivityParameterNode").getDelegate();
        prop = this.factory.createProperty(clss, "parameter", "ActivityParameterNode-parameter", "Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ActivityPartition").getDelegate();
        prop = this.factory.createProperty(clss, "edge", "ActivityPartition-edge", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDimension", "ActivityPartition-isDimension", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ActivityPartition-isDimension-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isExternal", "ActivityPartition-isExternal", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ActivityPartition-isExternal-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "node", "ActivityPartition-node", "ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "represents", "ActivityPartition-represents", "Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subpartition", "ActivityPartition-subpartition", "ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superPartition", "ActivityPartition-superPartition", "ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CentralBufferNode").getDelegate();
        clss = (Class_)this.model.getElementById("ControlFlow").getDelegate();
        clss = (Class_)this.model.getElementById("ControlNode").getDelegate();
        clss = (Class_)this.model.getElementById("DataStoreNode").getDelegate();
        clss = (Class_)this.model.getElementById("DecisionNode").getDelegate();
        prop = this.factory.createProperty(clss, "decisionInput", "DecisionNode-decisionInput", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "decisionInputFlow", "DecisionNode-decisionInputFlow", "ObjectFlow", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ExceptionHandler").getDelegate();
        prop = this.factory.createProperty(clss, "exceptionInput", "ExceptionHandler-exceptionInput", "ObjectNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "exceptionType", "ExceptionHandler-exceptionType", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "handlerBody", "ExceptionHandler-handlerBody", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "protectedNode", "ExceptionHandler-protectedNode", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ExecutableNode").getDelegate();
        prop = this.factory.createProperty(clss, "handler", "ExecutableNode-handler", "ExceptionHandler", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("FinalNode").getDelegate();
        clss = (Class_)this.model.getElementById("FlowFinalNode").getDelegate();
        clss = (Class_)this.model.getElementById("ForkNode").getDelegate();
        clss = (Class_)this.model.getElementById("InitialNode").getDelegate();
        clss = (Class_)this.model.getElementById("InterruptibleActivityRegion").getDelegate();
        prop = this.factory.createProperty(clss, "interruptingEdge", "InterruptibleActivityRegion-interruptingEdge", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "node", "InterruptibleActivityRegion-node", "ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("JoinNode").getDelegate();
        prop = this.factory.createProperty(clss, "isCombineDuplicate", "JoinNode-isCombineDuplicate", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "JoinNode-isCombineDuplicate-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "joinSpec", "JoinNode-joinSpec", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("MergeNode").getDelegate();
        clss = (Class_)this.model.getElementById("ObjectFlow").getDelegate();
        prop = this.factory.createProperty(clss, "isMulticast", "ObjectFlow-isMulticast", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ObjectFlow-isMulticast-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isMultireceive", "ObjectFlow-isMultireceive", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ObjectFlow-isMultireceive-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "selection", "ObjectFlow-selection", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "transformation", "ObjectFlow-transformation", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ObjectNode").getDelegate();
        prop = this.factory.createProperty(clss, "inState", "ObjectNode-inState", "State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isControlType", "ObjectNode-isControlType", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ObjectNode-isControlType-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ordering", "ObjectNode-ordering", "ObjectNodeOrderingKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "ObjectNodeOrderingKind-FIFO", "ObjectNode-ordering-_defaultValue", "uml:InstanceValue", "ObjectNodeOrderingKind");
        prop = this.factory.createProperty(clss, "selection", "ObjectNode-selection", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upperBound", "ObjectNode-upperBound", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Variable").getDelegate();
        prop = this.factory.createProperty(clss, "activityScope", "Variable-activityScope", "Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "scope", "Variable-scope", "StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Duration").getDelegate();
        prop = this.factory.createProperty(clss, "expr", "Duration-expr", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "observation", "Duration-observation", "Observation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DurationConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "firstEvent", "DurationConstraint-firstEvent", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "DurationConstraint-specification", "DurationInterval", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DurationInterval").getDelegate();
        prop = this.factory.createProperty(clss, "max", "DurationInterval-max", "Duration", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "min", "DurationInterval-min", "Duration", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DurationObservation").getDelegate();
        prop = this.factory.createProperty(clss, "event", "DurationObservation-event", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "firstEvent", "DurationObservation-firstEvent", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Expression").getDelegate();
        prop = this.factory.createProperty(clss, "operand", "Expression-operand", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "symbol", "Expression-symbol", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interval").getDelegate();
        prop = this.factory.createProperty(clss, "max", "Interval-max", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "min", "Interval-min", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("IntervalConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "specification", "IntervalConstraint-specification", "Interval", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("LiteralBoolean").getDelegate();
        prop = this.factory.createProperty(clss, "value", "LiteralBoolean-value", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "LiteralBoolean-value-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("LiteralInteger").getDelegate();
        prop = this.factory.createProperty(clss, "value", "LiteralInteger-value", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Integer", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(0), "", "LiteralInteger-value-_defaultValue", "uml:LiteralInteger", "");
        clss = (Class_)this.model.getElementById("LiteralNull").getDelegate();
        clss = (Class_)this.model.getElementById("LiteralReal").getDelegate();
        prop = this.factory.createProperty(clss, "value", "LiteralReal-value", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Real", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("LiteralSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("LiteralString").getDelegate();
        prop = this.factory.createProperty(clss, "value", "LiteralString-value", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("LiteralUnlimitedNatural").getDelegate();
        prop = this.factory.createProperty(clss, "value", "LiteralUnlimitedNatural-value", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#UnlimitedNatural", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "", "LiteralUnlimitedNatural-value-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Observation").getDelegate();
        clss = (Class_)this.model.getElementById("OpaqueExpression").getDelegate();
        prop = this.factory.createProperty(clss, "behavior", "OpaqueExpression-behavior", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "body", "OpaqueExpression-body", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "OpaqueExpression-language", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "OpaqueExpression-result", "Parameter", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StringExpression").getDelegate();
        prop = this.factory.createProperty(clss, "owningExpression", "StringExpression-owningExpression", "StringExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subExpression", "StringExpression-subExpression", "StringExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TimeConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "firstEvent", "TimeConstraint-firstEvent", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "TimeConstraint-firstEvent-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "specification", "TimeConstraint-specification", "TimeInterval", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TimeExpression").getDelegate();
        prop = this.factory.createProperty(clss, "expr", "TimeExpression-expr", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "observation", "TimeExpression-observation", "Observation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TimeInterval").getDelegate();
        prop = this.factory.createProperty(clss, "max", "TimeInterval-max", "TimeExpression", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "min", "TimeInterval-min", "TimeExpression", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TimeObservation").getDelegate();
        prop = this.factory.createProperty(clss, "event", "TimeObservation-event", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "firstEvent", "TimeObservation-firstEvent", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "TimeObservation-firstEvent-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("ValueSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Actor").getDelegate();
        clss = (Class_)this.model.getElementById("Extend").getDelegate();
        prop = this.factory.createProperty(clss, "condition", "Extend-condition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extendedCase", "Extend-extendedCase", "UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extension", "Extend-extension", "UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extensionLocation", "Extend-extensionLocation", "ExtensionPoint", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ExtensionPoint").getDelegate();
        prop = this.factory.createProperty(clss, "useCase", "ExtensionPoint-useCase", "UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Include").getDelegate();
        prop = this.factory.createProperty(clss, "addition", "Include-addition", "UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "includingCase", "Include-includingCase", "UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("UseCase").getDelegate();
        prop = this.factory.createProperty(clss, "extend", "UseCase-extend", "Extend", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extensionPoint", "UseCase-extensionPoint", "ExtensionPoint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "include", "UseCase-include", "Include", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subject", "UseCase-subject", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Association").getDelegate();
        prop = this.factory.createProperty(clss, "endType", "Association-endType", "Type", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDerived", "Association-isDerived", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Association-isDerived-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "memberEnd", "Association-memberEnd", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "navigableOwnedEnd", "Association-navigableOwnedEnd", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedEnd", "Association-ownedEnd", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AssociationClass").getDelegate();
        clss = (Class_)this.model.getElementById("Class").getDelegate();
        prop = this.factory.createProperty(clss, "extension", "Class-extension", "Extension", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isAbstract", "Class-isAbstract", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Class-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isActive", "Class-isActive", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Class-isActive-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "nestedClassifier", "Class-nestedClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedAttribute", "Class-ownedAttribute", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Class-ownedOperation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedReception", "Class-ownedReception", "Reception", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superClass", "Class-superClass", "Class", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Collaboration").getDelegate();
        prop = this.factory.createProperty(clss, "collaborationRole", "Collaboration-collaborationRole", "ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CollaborationUse").getDelegate();
        prop = this.factory.createProperty(clss, "roleBinding", "CollaborationUse-roleBinding", "Dependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "CollaborationUse-type", "Collaboration", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Component").getDelegate();
        prop = this.factory.createProperty(clss, "isIndirectlyInstantiated", "Component-isIndirectlyInstantiated", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Component-isIndirectlyInstantiated-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "packagedElement", "Component-packagedElement", "PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "provided", "Component-provided", "Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realization", "Component-realization", "ComponentRealization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "required", "Component-required", "Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ComponentRealization").getDelegate();
        prop = this.factory.createProperty(clss, "abstraction", "ComponentRealization-abstraction", "Component", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingClassifier", "ComponentRealization-realizingClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ConnectableElement").getDelegate();
        prop = this.factory.createProperty(clss, "end", "ConnectableElement-end", "ConnectorEnd", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateParameter", "ConnectableElement-templateParameter", "ConnectableElementTemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ConnectableElementTemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "parameteredElement", "ConnectableElementTemplateParameter-parameteredElement", "ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Connector").getDelegate();
        prop = this.factory.createProperty(clss, "contract", "Connector-contract", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "end", "Connector-end", "ConnectorEnd", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "kind", "Connector-kind", "ConnectorKind", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedConnector", "Connector-redefinedConnector", "Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "Connector-type", "Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ConnectorEnd").getDelegate();
        prop = this.factory.createProperty(clss, "definingEnd", "ConnectorEnd-definingEnd", "Property", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "partWithPort", "ConnectorEnd-partWithPort", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "role", "ConnectorEnd-role", "ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("EncapsulatedClassifier").getDelegate();
        prop = this.factory.createProperty(clss, "ownedPort", "EncapsulatedClassifier-ownedPort", "Port", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Port").getDelegate();
        prop = this.factory.createProperty(clss, "isBehavior", "Port-isBehavior", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Port-isBehavior-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isConjugated", "Port-isConjugated", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Port-isConjugated-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isService", "Port-isService", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Port-isService-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "protocol", "Port-protocol", "ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "provided", "Port-provided", "Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedPort", "Port-redefinedPort", "Port", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "required", "Port-required", "Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StructuredClassifier").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "StructuredClassifier-ownedAttribute", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedConnector", "StructuredClassifier-ownedConnector", "Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "part", "StructuredClassifier-part", "Property", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "role", "StructuredClassifier-role", "ConnectableElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ConnectionPointReference").getDelegate();
        prop = this.factory.createProperty(clss, "entry", "ConnectionPointReference-entry", "Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "exit", "ConnectionPointReference-exit", "Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "state", "ConnectionPointReference-state", "State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("FinalState").getDelegate();
        clss = (Class_)this.model.getElementById("ProtocolConformance").getDelegate();
        prop = this.factory.createProperty(clss, "generalMachine", "ProtocolConformance-generalMachine", "ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specificMachine", "ProtocolConformance-specificMachine", "ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ProtocolStateMachine").getDelegate();
        prop = this.factory.createProperty(clss, "conformance", "ProtocolStateMachine-conformance", "ProtocolConformance", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ProtocolTransition").getDelegate();
        prop = this.factory.createProperty(clss, "postCondition", "ProtocolTransition-postCondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "preCondition", "ProtocolTransition-preCondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "referred", "ProtocolTransition-referred", "Operation", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Pseudostate").getDelegate();
        prop = this.factory.createProperty(clss, "kind", "Pseudostate-kind", "PseudostateKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "PseudostateKind-initial", "Pseudostate-kind-_defaultValue", "uml:InstanceValue", "PseudostateKind");
        prop = this.factory.createProperty(clss, "state", "Pseudostate-state", "State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "stateMachine", "Pseudostate-stateMachine", "StateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Region").getDelegate();
        prop = this.factory.createProperty(clss, "extendedRegion", "Region-extendedRegion", "Region", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "Region-redefinitionContext", "Classifier", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "state", "Region-state", "State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "stateMachine", "Region-stateMachine", "StateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subvertex", "Region-subvertex", "Vertex", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "transition", "Region-transition", "Transition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("State").getDelegate();
        prop = this.factory.createProperty(clss, "connection", "State-connection", "ConnectionPointReference", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "connectionPoint", "State-connectionPoint", "Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "deferrableTrigger", "State-deferrableTrigger", "Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "doActivity", "State-doActivity", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "entry", "State-entry", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "exit", "State-exit", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isComposite", "State-isComposite", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isOrthogonal", "State-isOrthogonal", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isSimple", "State-isSimple", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isSubmachineState", "State-isSubmachineState", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "region", "State-region", "Region", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "stateInvariant", "State-stateInvariant", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "submachine", "State-submachine", "StateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachine").getDelegate();
        prop = this.factory.createProperty(clss, "connectionPoint", "StateMachine-connectionPoint", "Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extendedStateMachine", "StateMachine-extendedStateMachine", "StateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "region", "StateMachine-region", "Region", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "submachineState", "StateMachine-submachineState", "State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Transition").getDelegate();
        prop = this.factory.createProperty(clss, "container", "Transition-container", "Region", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "effect", "Transition-effect", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "guard", "Transition-guard", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "kind", "Transition-kind", "TransitionKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "TransitionKind-external", "Transition-kind-_defaultValue", "uml:InstanceValue", "TransitionKind");
        prop = this.factory.createProperty(clss, "redefinedTransition", "Transition-redefinedTransition", "Transition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "Transition-redefinitionContext", "Classifier", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "source", "Transition-source", "Vertex", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Transition-target", "Vertex", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "trigger", "Transition-trigger", "Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Vertex").getDelegate();
        prop = this.factory.createProperty(clss, "container", "Vertex-container", "Region", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "incoming", "Vertex-incoming", "Transition", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "outgoing", "Vertex-outgoing", "Transition", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "State-redefinitionContext", "Classifier", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedVertex", "State-redefinedState", "Vertex", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("BehavioredClassifier").getDelegate();
        prop = this.factory.createProperty(clss, "classifierBehavior", "BehavioredClassifier-classifierBehavior", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interfaceRealization", "BehavioredClassifier-interfaceRealization", "InterfaceRealization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedBehavior", "BehavioredClassifier-ownedBehavior", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DataType").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "DataType-ownedAttribute", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "DataType-ownedOperation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Enumeration").getDelegate();
        prop = this.factory.createProperty(clss, "ownedLiteral", "Enumeration-ownedLiteral", "EnumerationLiteral", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("EnumerationLiteral").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "EnumerationLiteral-classifier", "Enumeration", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "enumeration", "EnumerationLiteral-enumeration", "Enumeration", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interface").getDelegate();
        prop = this.factory.createProperty(clss, "nestedClassifier", "Interface-nestedClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedAttribute", "Interface-ownedAttribute", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Interface-ownedOperation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedReception", "Interface-ownedReception", "Reception", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "protocol", "Interface-protocol", "ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedInterface", "Interface-redefinedInterface", "Interface", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InterfaceRealization").getDelegate();
        prop = this.factory.createProperty(clss, "contract", "InterfaceRealization-contract", "Interface", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "implementingClassifier", "InterfaceRealization-implementingClassifier", "BehavioredClassifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("PrimitiveType").getDelegate();
        clss = (Class_)this.model.getElementById("Reception").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "Reception-signal", "Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Signal").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "Signal-ownedAttribute", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Extension").getDelegate();
        prop = this.factory.createProperty(clss, "isRequired", "Extension-isRequired", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "metaclass", "Extension-metaclass", "Class", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedEnd", "Extension-ownedEnd", "ExtensionEnd", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ExtensionEnd").getDelegate();
        prop = this.factory.createProperty(clss, "lower", "ExtensionEnd-lower", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Integer", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "ExtensionEnd-type", "Stereotype", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Image").getDelegate();
        prop = this.factory.createProperty(clss, "content", "Image-content", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "format", "Image-format", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "location", "Image-location", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Model").getDelegate();
        prop = this.factory.createProperty(clss, "viewpoint", "Model-viewpoint", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Package").getDelegate();
        prop = this.factory.createProperty(clss, "URI", "Package-URI", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestedPackage", "Package-nestedPackage", "Package", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestingPackage", "Package-nestingPackage", "Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedStereotype", "Package-ownedStereotype", "Stereotype", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedType", "Package-ownedType", "Type", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packageMerge", "Package-packageMerge", "PackageMerge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packagedElement", "Package-packagedElement", "PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "profileApplication", "Package-profileApplication", "ProfileApplication", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("PackageMerge").getDelegate();
        prop = this.factory.createProperty(clss, "mergedPackage", "PackageMerge-mergedPackage", "Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "receivingPackage", "PackageMerge-receivingPackage", "Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Profile").getDelegate();
        prop = this.factory.createProperty(clss, "metaclassReference", "Profile-metaclassReference", "ElementImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "metamodelReference", "Profile-metamodelReference", "PackageImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ProfileApplication").getDelegate();
        prop = this.factory.createProperty(clss, "appliedProfile", "ProfileApplication-appliedProfile", "Profile", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "applyingPackage", "ProfileApplication-applyingPackage", "Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isStrict", "ProfileApplication-isStrict", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ProfileApplication-isStrict-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Stereotype").getDelegate();
        prop = this.factory.createProperty(clss, "icon", "Stereotype-icon", "Image", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "profile", "Stereotype-profile", "Profile", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ActionExecutionSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "action", "ActionExecutionSpecification-action", "Action", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("BehaviorExecutionSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "behavior", "BehaviorExecutionSpecification-behavior", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CombinedFragment").getDelegate();
        prop = this.factory.createProperty(clss, "cfragmentGate", "CombinedFragment-cfragmentGate", "Gate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interactionOperator", "CombinedFragment-interactionOperator", "InteractionOperatorKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "InteractionOperatorKind-seq", "CombinedFragment-interactionOperator-_defaultValue", "uml:InstanceValue", "InteractionOperatorKind");
        prop = this.factory.createProperty(clss, "operand", "CombinedFragment-operand", "InteractionOperand", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ConsiderIgnoreFragment").getDelegate();
        prop = this.factory.createProperty(clss, "message", "ConsiderIgnoreFragment-message", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Continuation").getDelegate();
        prop = this.factory.createProperty(clss, "setting", "Continuation-setting", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Continuation-setting-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("DestructionOccurrenceSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("ExecutionOccurrenceSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "execution", "ExecutionOccurrenceSpecification-execution", "ExecutionSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ExecutionSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "finish", "ExecutionSpecification-finish", "OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "start", "ExecutionSpecification-start", "OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Gate").getDelegate();
        clss = (Class_)this.model.getElementById("GeneralOrdering").getDelegate();
        prop = this.factory.createProperty(clss, "after", "GeneralOrdering-after", "OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "before", "GeneralOrdering-before", "OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interaction").getDelegate();
        prop = this.factory.createProperty(clss, "action", "Interaction-action", "Action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "formalGate", "Interaction-formalGate", "Gate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "fragment", "Interaction-fragment", "InteractionFragment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "lifeline", "Interaction-lifeline", "Lifeline", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "message", "Interaction-message", "Message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InteractionConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "maxint", "InteractionConstraint-maxint", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "minint", "InteractionConstraint-minint", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InteractionFragment").getDelegate();
        prop = this.factory.createProperty(clss, "covered", "InteractionFragment-covered", "Lifeline", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "enclosingInteraction", "InteractionFragment-enclosingInteraction", "Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "enclosingOperand", "InteractionFragment-enclosingOperand", "InteractionOperand", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "generalOrdering", "InteractionFragment-generalOrdering", "GeneralOrdering", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InteractionOperand").getDelegate();
        prop = this.factory.createProperty(clss, "fragment", "InteractionOperand-fragment", "InteractionFragment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "guard", "InteractionOperand-guard", "InteractionConstraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InteractionUse").getDelegate();
        prop = this.factory.createProperty(clss, "actualGate", "InteractionUse-actualGate", "Gate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "argument", "InteractionUse-argument", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "refersTo", "InteractionUse-refersTo", "Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "returnValue", "InteractionUse-returnValue", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "returnValueRecipient", "InteractionUse-returnValueRecipient", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Lifeline").getDelegate();
        prop = this.factory.createProperty(clss, "coveredBy", "Lifeline-coveredBy", "InteractionFragment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "decomposedAs", "Lifeline-decomposedAs", "PartDecomposition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interaction", "Lifeline-interaction", "Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "represents", "Lifeline-represents", "ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "selector", "Lifeline-selector", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Message").getDelegate();
        prop = this.factory.createProperty(clss, "argument", "Message-argument", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "connector", "Message-connector", "Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interaction", "Message-interaction", "Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "messageKind", "Message-messageKind", "MessageKind", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "messageSort", "Message-messageSort", "MessageSort", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "MessageSort-synchCall", "Message-messageSort-_defaultValue", "uml:InstanceValue", "MessageSort");
        prop = this.factory.createProperty(clss, "receiveEvent", "Message-receiveEvent", "MessageEnd", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "sendEvent", "Message-sendEvent", "MessageEnd", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "signature", "Message-signature", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("MessageEnd").getDelegate();
        prop = this.factory.createProperty(clss, "message", "MessageEnd-message", "Message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("MessageOccurrenceSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("OccurrenceSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "covered", "OccurrenceSpecification-covered", "Lifeline", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "toAfter", "OccurrenceSpecification-toAfter", "GeneralOrdering", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "toBefore", "OccurrenceSpecification-toBefore", "GeneralOrdering", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("PartDecomposition").getDelegate();
        clss = (Class_)this.model.getElementById("StateInvariant").getDelegate();
        prop = this.factory.createProperty(clss, "covered", "StateInvariant-covered", "Lifeline", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "invariant", "StateInvariant-invariant", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InformationFlow").getDelegate();
        prop = this.factory.createProperty(clss, "conveyed", "InformationFlow-conveyed", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "informationSource", "InformationFlow-informationSource", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "informationTarget", "InformationFlow-informationTarget", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realization", "InformationFlow-realization", "Relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingActivityEdge", "InformationFlow-realizingActivityEdge", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingConnector", "InformationFlow-realizingConnector", "Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingMessage", "InformationFlow-realizingMessage", "Message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InformationItem").getDelegate();
        prop = this.factory.createProperty(clss, "represented", "InformationItem-represented", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Artifact").getDelegate();
        prop = this.factory.createProperty(clss, "fileName", "Artifact-fileName", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "manifestation", "Artifact-manifestation", "Manifestation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestedArtifact", "Artifact-nestedArtifact", "Artifact", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedAttribute", "Artifact-ownedAttribute", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Artifact-ownedOperation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommunicationPath").getDelegate();
        clss = (Class_)this.model.getElementById("DeployedArtifact").getDelegate();
        clss = (Class_)this.model.getElementById("Deployment").getDelegate();
        prop = this.factory.createProperty(clss, "configuration", "Deployment-configuration", "DeploymentSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "deployedArtifact", "Deployment-deployedArtifact", "DeployedArtifact", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "location", "Deployment-location", "DeploymentTarget", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DeploymentSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "deployment", "DeploymentSpecification-deployment", "Deployment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "deploymentLocation", "DeploymentSpecification-deploymentLocation", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "executionLocation", "DeploymentSpecification-executionLocation", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DeploymentTarget").getDelegate();
        prop = this.factory.createProperty(clss, "deployedElement", "DeploymentTarget-deployedElement", "PackageableElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "deployment", "DeploymentTarget-deployment", "Deployment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Device").getDelegate();
        clss = (Class_)this.model.getElementById("ExecutionEnvironment").getDelegate();
        clss = (Class_)this.model.getElementById("Manifestation").getDelegate();
        prop = this.factory.createProperty(clss, "utilizedElement", "Manifestation-utilizedElement", "PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Node").getDelegate();
        prop = this.factory.createProperty(clss, "nestedNode", "Node-nestedNode", "Node", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Abstraction").getDelegate();
        prop = this.factory.createProperty(clss, "mapping", "Abstraction-mapping", "OpaqueExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Comment").getDelegate();
        prop = this.factory.createProperty(clss, "annotatedElement", "Comment-annotatedElement", "Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "body", "Comment-body", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Constraint").getDelegate();
        prop = this.factory.createProperty(clss, "constrainedElement", "Constraint-constrainedElement", "Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "context", "Constraint-context", "Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "Constraint-specification", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Dependency").getDelegate();
        prop = this.factory.createProperty(clss, "client", "Dependency-client", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "supplier", "Dependency-supplier", "NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DirectedRelationship").getDelegate();
        prop = this.factory.createProperty(clss, "source", "DirectedRelationship-source", "Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "DirectedRelationship-target", "Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Element").getDelegate();
        prop = this.factory.createProperty(clss, "ownedComment", "Element-ownedComment", "Comment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedElement", "Element-ownedElement", "Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owner", "Element-owner", "Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ElementImport").getDelegate();
        prop = this.factory.createProperty(clss, "alias", "ElementImport-alias", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importedElement", "ElementImport-importedElement", "PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importingNamespace", "ElementImport-importingNamespace", "Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "ElementImport-visibility", "VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "VisibilityKind-public", "ElementImport-visibility-_defaultValue", "uml:InstanceValue", "VisibilityKind");
        clss = (Class_)this.model.getElementById("MultiplicityElement").getDelegate();
        prop = this.factory.createProperty(clss, "isOrdered", "MultiplicityElement-isOrdered", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "MultiplicityElement-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "MultiplicityElement-isUnique", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "MultiplicityElement-isUnique-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "lower", "MultiplicityElement-lower", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Integer", "", false, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "lowerValue", "MultiplicityElement-lowerValue", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upper", "MultiplicityElement-upper", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#UnlimitedNatural", "", false, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upperValue", "MultiplicityElement-upperValue", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "clientDependency", "NamedElement-clientDependency", "Dependency", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "name", "NamedElement-name", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nameExpression", "NamedElement-nameExpression", "StringExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "namespace", "NamedElement-namespace", "Namespace", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifiedName", "NamedElement-qualifiedName", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "NamedElement-visibility", "VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Namespace").getDelegate();
        prop = this.factory.createProperty(clss, "elementImport", "Namespace-elementImport", "ElementImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importedMember", "Namespace-importedMember", "PackageableElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "member", "Namespace-member", "NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedMember", "Namespace-ownedMember", "NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedRule", "Namespace-ownedRule", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packageImport", "Namespace-packageImport", "PackageImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("PackageableElement").getDelegate();
        prop = this.factory.createProperty(clss, "visibility", "PackageableElement-visibility", "VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "VisibilityKind-public", "PackageableElement-visibility-_defaultValue", "uml:InstanceValue", "VisibilityKind");
        clss = (Class_)this.model.getElementById("PackageImport").getDelegate();
        prop = this.factory.createProperty(clss, "importedPackage", "PackageImport-importedPackage", "Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importingNamespace", "PackageImport-importingNamespace", "Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "PackageImport-visibility", "VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "VisibilityKind-public", "PackageImport-visibility-_defaultValue", "uml:InstanceValue", "VisibilityKind");
        clss = (Class_)this.model.getElementById("ParameterableElement").getDelegate();
        prop = this.factory.createProperty(clss, "owningTemplateParameter", "ParameterableElement-owningTemplateParameter", "TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateParameter", "ParameterableElement-templateParameter", "TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Realization").getDelegate();
        clss = (Class_)this.model.getElementById("Relationship").getDelegate();
        prop = this.factory.createProperty(clss, "relatedElement", "Relationship-relatedElement", "Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TemplateableElement").getDelegate();
        prop = this.factory.createProperty(clss, "ownedTemplateSignature", "TemplateableElement-ownedTemplateSignature", "TemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateBinding", "TemplateableElement-templateBinding", "TemplateBinding", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TemplateBinding").getDelegate();
        prop = this.factory.createProperty(clss, "boundElement", "TemplateBinding-boundElement", "TemplateableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameterSubstitution", "TemplateBinding-parameterSubstitution", "TemplateParameterSubstitution", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "signature", "TemplateBinding-signature", "TemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "default", "TemplateParameter-default", "ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedDefault", "TemplateParameter-ownedDefault", "ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedParameteredElement", "TemplateParameter-ownedParameteredElement", "ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameteredElement", "TemplateParameter-parameteredElement", "ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "signature", "TemplateParameter-signature", "TemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TemplateParameterSubstitution").getDelegate();
        prop = this.factory.createProperty(clss, "actual", "TemplateParameterSubstitution-actual", "ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "formal", "TemplateParameterSubstitution-formal", "TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedActual", "TemplateParameterSubstitution-ownedActual", "ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateBinding", "TemplateParameterSubstitution-templateBinding", "TemplateBinding", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TemplateSignature").getDelegate();
        prop = this.factory.createProperty(clss, "ownedParameter", "TemplateSignature-ownedParameter", "TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameter", "TemplateSignature-parameter", "TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "template", "TemplateSignature-template", "TemplateableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Type").getDelegate();
        prop = this.factory.createProperty(clss, "package", "Type-package", "Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TypedElement").getDelegate();
        prop = this.factory.createProperty(clss, "type", "TypedElement-type", "Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Usage").getDelegate();
        clss = (Class_)this.model.getElementById("AnyReceiveEvent").getDelegate();
        clss = (Class_)this.model.getElementById("Behavior").getDelegate();
        prop = this.factory.createProperty(clss, "context", "Behavior-context", "BehavioredClassifier", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReentrant", "Behavior-isReentrant", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Behavior-isReentrant-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ownedParameter", "Behavior-ownedParameter", "Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedParameterSet", "Behavior-ownedParameterSet", "ParameterSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "postcondition", "Behavior-postcondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "precondition", "Behavior-precondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "Behavior-specification", "BehavioralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedBehavior", "Behavior-redefinedBehavior", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CallEvent").getDelegate();
        prop = this.factory.createProperty(clss, "operation", "CallEvent-operation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ChangeEvent").getDelegate();
        prop = this.factory.createProperty(clss, "changeExpression", "ChangeEvent-changeExpression", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Event").getDelegate();
        clss = (Class_)this.model.getElementById("FunctionBehavior").getDelegate();
        clss = (Class_)this.model.getElementById("MessageEvent").getDelegate();
        clss = (Class_)this.model.getElementById("OpaqueBehavior").getDelegate();
        prop = this.factory.createProperty(clss, "body", "OpaqueBehavior-body", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "OpaqueBehavior-language", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("SignalEvent").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "SignalEvent-signal", "Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TimeEvent").getDelegate();
        prop = this.factory.createProperty(clss, "isRelative", "TimeEvent-isRelative", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "TimeEvent-isRelative-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "when", "TimeEvent-when", "TimeExpression", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Trigger").getDelegate();
        prop = this.factory.createProperty(clss, "event", "Trigger-event", "Event", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "port", "Trigger-port", "Port", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Substitution").getDelegate();
        prop = this.factory.createProperty(clss, "contract", "Substitution-contract", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "substitutingClassifier", "Substitution-substitutingClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("BehavioralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "concurrency", "BehavioralFeature-concurrency", "CallConcurrencyKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "CallConcurrencyKind-sequential", "BehavioralFeature-concurrency-_defaultValue", "uml:InstanceValue", "CallConcurrencyKind");
        prop = this.factory.createProperty(clss, "isAbstract", "BehavioralFeature-isAbstract", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "BehavioralFeature-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "method", "BehavioralFeature-method", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedParameter", "BehavioralFeature-ownedParameter", "Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedParameterSet", "BehavioralFeature-ownedParameterSet", "ParameterSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "raisedException", "BehavioralFeature-raisedException", "Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "attribute", "Classifier-attribute", "Property", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "collaborationUse", "Classifier-collaborationUse", "CollaborationUse", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "feature", "Classifier-feature", "Feature", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "general", "Classifier-general", "Classifier", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "generalization", "Classifier-generalization", "Generalization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inheritedMember", "Classifier-inheritedMember", "NamedElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isAbstract", "Classifier-isAbstract", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classifier-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isFinalSpecialization", "Classifier-isFinalSpecialization", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classifier-isFinalSpecialization-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ownedTemplateSignature", "Classifier-ownedTemplateSignature", "RedefinableTemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedUseCase", "Classifier-ownedUseCase", "UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "powertypeExtent", "Classifier-powertypeExtent", "GeneralizationSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedClassifier", "Classifier-redefinedClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "representation", "Classifier-representation", "CollaborationUse", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "substitution", "Classifier-substitution", "Substitution", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateParameter", "Classifier-templateParameter", "ClassifierTemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "useCase", "Classifier-useCase", "UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ClassifierTemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "allowSubstitutable", "ClassifierTemplateParameter-allowSubstitutable", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "ClassifierTemplateParameter-allowSubstitutable-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "constrainingClassifier", "ClassifierTemplateParameter-constrainingClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameteredElement", "ClassifierTemplateParameter-parameteredElement", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Feature").getDelegate();
        prop = this.factory.createProperty(clss, "featuringClassifier", "Feature-featuringClassifier", "Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isStatic", "Feature-isStatic", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Feature-isStatic-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Generalization").getDelegate();
        prop = this.factory.createProperty(clss, "general", "Generalization-general", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "generalizationSet", "Generalization-generalizationSet", "GeneralizationSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isSubstitutable", "Generalization-isSubstitutable", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Generalization-isSubstitutable-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "specific", "Generalization-specific", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("GeneralizationSet").getDelegate();
        prop = this.factory.createProperty(clss, "generalization", "GeneralizationSet-generalization", "Generalization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isCovering", "GeneralizationSet-isCovering", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "GeneralizationSet-isCovering-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDisjoint", "GeneralizationSet-isDisjoint", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "GeneralizationSet-isDisjoint-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "powertype", "GeneralizationSet-powertype", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InstanceSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "InstanceSpecification-classifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "slot", "InstanceSpecification-slot", "Slot", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "InstanceSpecification-specification", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InstanceValue").getDelegate();
        prop = this.factory.createProperty(clss, "instance", "InstanceValue-instance", "InstanceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Operation").getDelegate();
        prop = this.factory.createProperty(clss, "bodyCondition", "Operation-bodyCondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "class", "Operation-class", "Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "datatype", "Operation-datatype", "DataType", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interface", "Operation-interface", "Interface", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isOrdered", "Operation-isOrdered", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isQuery", "Operation-isQuery", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Operation-isQuery-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "Operation-isUnique", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "lower", "Operation-lower", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Integer", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedParameter", "Operation-ownedParameter", "Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "postcondition", "Operation-postcondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "precondition", "Operation-precondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "raisedException", "Operation-raisedException", "Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedOperation", "Operation-redefinedOperation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateParameter", "Operation-templateParameter", "OperationTemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "Operation-type", "Type", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upper", "Operation-upper", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#UnlimitedNatural", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("OperationTemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "parameteredElement", "OperationTemplateParameter-parameteredElement", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Parameter").getDelegate();
        prop = this.factory.createProperty(clss, "default", "Parameter-default", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "defaultValue", "Parameter-defaultValue", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "direction", "Parameter-direction", "ParameterDirectionKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "ParameterDirectionKind-in", "Parameter-direction-_defaultValue", "uml:InstanceValue", "ParameterDirectionKind");
        prop = this.factory.createProperty(clss, "effect", "Parameter-effect", "ParameterEffectKind", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isException", "Parameter-isException", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Parameter-isException-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isStream", "Parameter-isStream", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Parameter-isStream-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "operation", "Parameter-operation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameterSet", "Parameter-parameterSet", "ParameterSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ParameterSet").getDelegate();
        prop = this.factory.createProperty(clss, "condition", "ParameterSet-condition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameter", "ParameterSet-parameter", "Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Property").getDelegate();
        prop = this.factory.createProperty(clss, "aggregation", "Property-aggregation", "AggregationKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "AggregationKind-none", "Property-aggregation-_defaultValue", "uml:InstanceValue", "AggregationKind");
        prop = this.factory.createProperty(clss, "association", "Property-association", "Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "associationEnd", "Property-associationEnd", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "class", "Property-class", "Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "datatype", "Property-datatype", "DataType", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "defaultValue", "Property-defaultValue", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interface", "Property-interface", "Interface", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isComposite", "Property-isComposite", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Property-isComposite-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDerived", "Property-isDerived", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Property-isDerived-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDerivedUnion", "Property-isDerivedUnion", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Property-isDerivedUnion-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isID", "Property-isID", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Property-isID-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "opposite", "Property-opposite", "Property", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owningAssociation", "Property-owningAssociation", "Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifier", "Property-qualifier", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedProperty", "Property-redefinedProperty", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subsettedProperty", "Property-subsettedProperty", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("RedefinableElement").getDelegate();
        prop = this.factory.createProperty(clss, "isLeaf", "RedefinableElement-isLeaf", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "RedefinableElement-isLeaf-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "redefinedElement", "RedefinableElement-redefinedElement", "RedefinableElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "RedefinableElement-redefinitionContext", "Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("RedefinableTemplateSignature").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "RedefinableTemplateSignature-classifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extendedSignature", "RedefinableTemplateSignature-extendedSignature", "RedefinableTemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inheritedParameter", "RedefinableTemplateSignature-inheritedParameter", "TemplateParameter", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Slot").getDelegate();
        prop = this.factory.createProperty(clss, "definingFeature", "Slot-definingFeature", "StructuralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owningInstance", "Slot-owningInstance", "InstanceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "Slot-value", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StructuralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "isReadOnly", "StructuralFeature-isReadOnly", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "StructuralFeature-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("ValueSpecificationAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "ValueSpecificationAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "ValueSpecificationAction-value", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("VariableAction").getDelegate();
        prop = this.factory.createProperty(clss, "variable", "VariableAction-variable", "Variable", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("WriteLinkAction").getDelegate();
        clss = (Class_)this.model.getElementById("WriteStructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "WriteStructuralFeatureAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "WriteStructuralFeatureAction-value", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("WriteVariableAction").getDelegate();
        prop = this.factory.createProperty(clss, "value", "WriteVariableAction-value", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AcceptCallAction").getDelegate();
        prop = this.factory.createProperty(clss, "returnInformation", "AcceptCallAction-returnInformation", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AcceptEventAction").getDelegate();
        prop = this.factory.createProperty(clss, "isUnmarshall", "AcceptEventAction-isUnmarshall", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "AcceptEventAction-isUnmarshall-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "result", "AcceptEventAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "trigger", "AcceptEventAction-trigger", "Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Action").getDelegate();
        prop = this.factory.createProperty(clss, "context", "Action-context", "Classifier", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "input", "Action-input", "InputPin", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isLocallyReentrant", "Action-isLocallyReentrant", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Action-isLocallyReentrant-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "localPostcondition", "Action-localPostcondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "localPrecondition", "Action-localPrecondition", "Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "output", "Action-output", "OutputPin", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ActionInputPin").getDelegate();
        prop = this.factory.createProperty(clss, "fromAction", "ActionInputPin-fromAction", "Action", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AddStructuralFeatureValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "insertAt", "AddStructuralFeatureValueAction-insertAt", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReplaceAll", "AddStructuralFeatureValueAction-isReplaceAll", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "AddStructuralFeatureValueAction-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("AddVariableValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "insertAt", "AddVariableValueAction-insertAt", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReplaceAll", "AddVariableValueAction-isReplaceAll", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "AddVariableValueAction-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("BroadcastSignalAction").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "BroadcastSignalAction-signal", "Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CallAction").getDelegate();
        prop = this.factory.createProperty(clss, "isSynchronous", "CallAction-isSynchronous", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "CallAction-isSynchronous-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "result", "CallAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CallBehaviorAction").getDelegate();
        prop = this.factory.createProperty(clss, "behavior", "CallBehaviorAction-behavior", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CallOperationAction").getDelegate();
        prop = this.factory.createProperty(clss, "operation", "CallOperationAction-operation", "Operation", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "CallOperationAction-target", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Clause").getDelegate();
        prop = this.factory.createProperty(clss, "body", "Clause-body", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "bodyOutput", "Clause-bodyOutput", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "decider", "Clause-decider", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "predecessorClause", "Clause-predecessorClause", "Clause", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "successorClause", "Clause-successorClause", "Clause", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "test", "Clause-test", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ClearAssociationAction").getDelegate();
        prop = this.factory.createProperty(clss, "association", "ClearAssociationAction-association", "Association", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "object", "ClearAssociationAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ClearStructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "ClearStructuralFeatureAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ClearVariableAction").getDelegate();
        clss = (Class_)this.model.getElementById("ConditionalNode").getDelegate();
        prop = this.factory.createProperty(clss, "clause", "ConditionalNode-clause", "Clause", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isAssured", "ConditionalNode-isAssured", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ConditionalNode-isAssured-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDeterminate", "ConditionalNode-isDeterminate", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ConditionalNode-isDeterminate-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "result", "ConditionalNode-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CreateLinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "endData", "CreateLinkAction-endData", "LinkEndCreationData", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CreateLinkObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "CreateLinkObjectAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CreateObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "CreateObjectAction-classifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "CreateObjectAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DestroyLinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "endData", "DestroyLinkAction-endData", "LinkEndDestructionData", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("DestroyObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "isDestroyLinks", "DestroyObjectAction-isDestroyLinks", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "DestroyObjectAction-isDestroyLinks-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDestroyOwnedObjects", "DestroyObjectAction-isDestroyOwnedObjects", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "DestroyObjectAction-isDestroyOwnedObjects-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "target", "DestroyObjectAction-target", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ExpansionNode").getDelegate();
        prop = this.factory.createProperty(clss, "regionAsInput", "ExpansionNode-regionAsInput", "ExpansionRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "regionAsOutput", "ExpansionNode-regionAsOutput", "ExpansionRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ExpansionRegion").getDelegate();
        prop = this.factory.createProperty(clss, "inputElement", "ExpansionRegion-inputElement", "ExpansionNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "mode", "ExpansionRegion-mode", "ExpansionKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "ExpansionKind-iterative", "ExpansionRegion-mode-_defaultValue", "uml:InstanceValue", "ExpansionKind");
        prop = this.factory.createProperty(clss, "outputElement", "ExpansionRegion-outputElement", "ExpansionNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("InputPin").getDelegate();
        clss = (Class_)this.model.getElementById("InvocationAction").getDelegate();
        prop = this.factory.createProperty(clss, "argument", "InvocationAction-argument", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "onPort", "InvocationAction-onPort", "Port", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("LinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "endData", "LinkAction-endData", "LinkEndData", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inputValue", "LinkAction-inputValue", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("LinkEndCreationData").getDelegate();
        prop = this.factory.createProperty(clss, "insertAt", "LinkEndCreationData-insertAt", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReplaceAll", "LinkEndCreationData-isReplaceAll", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "LinkEndCreationData-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("LinkEndData").getDelegate();
        prop = this.factory.createProperty(clss, "end", "LinkEndData-end", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifier", "LinkEndData-qualifier", "QualifierValue", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "LinkEndData-value", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("LinkEndDestructionData").getDelegate();
        prop = this.factory.createProperty(clss, "destroyAt", "LinkEndDestructionData-destroyAt", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDestroyDuplicates", "LinkEndDestructionData-isDestroyDuplicates", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "LinkEndDestructionData-isDestroyDuplicates-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("LoopNode").getDelegate();
        prop = this.factory.createProperty(clss, "bodyOutput", "LoopNode-bodyOutput", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "bodyPart", "LoopNode-bodyPart", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "decider", "LoopNode-decider", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isTestedFirst", "LoopNode-isTestedFirst", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "LoopNode-isTestedFirst-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "loopVariable", "LoopNode-loopVariable", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "loopVariableInput", "LoopNode-loopVariableInput", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "LoopNode-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "setupPart", "LoopNode-setupPart", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "test", "LoopNode-test", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("OpaqueAction").getDelegate();
        prop = this.factory.createProperty(clss, "body", "OpaqueAction-body", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inputValue", "OpaqueAction-inputValue", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "OpaqueAction-language", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "outputValue", "OpaqueAction-outputValue", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("OutputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Pin").getDelegate();
        prop = this.factory.createProperty(clss, "isControl", "Pin-isControl", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Pin-isControl-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("QualifierValue").getDelegate();
        prop = this.factory.createProperty(clss, "qualifier", "QualifierValue-qualifier", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "QualifierValue-value", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("RaiseExceptionAction").getDelegate();
        prop = this.factory.createProperty(clss, "exception", "RaiseExceptionAction-exception", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadExtentAction").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "ReadExtentAction-classifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "ReadExtentAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadIsClassifiedObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "ReadIsClassifiedObjectAction-classifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDirect", "ReadIsClassifiedObjectAction-isDirect", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ReadIsClassifiedObjectAction-isDirect-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "object", "ReadIsClassifiedObjectAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "ReadIsClassifiedObjectAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadLinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "ReadLinkAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadLinkObjectEndAction").getDelegate();
        prop = this.factory.createProperty(clss, "end", "ReadLinkObjectEndAction-end", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "object", "ReadLinkObjectEndAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "ReadLinkObjectEndAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadLinkObjectEndQualifierAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "ReadLinkObjectEndQualifierAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifier", "ReadLinkObjectEndQualifierAction-qualifier", "Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "ReadLinkObjectEndQualifierAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadSelfAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "ReadSelfAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadStructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "ReadStructuralFeatureAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReadVariableAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "ReadVariableAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReclassifyObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "isReplaceAll", "ReclassifyObjectAction-isReplaceAll", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ReclassifyObjectAction-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "newClassifier", "ReclassifyObjectAction-newClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "object", "ReclassifyObjectAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "oldClassifier", "ReclassifyObjectAction-oldClassifier", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReduceAction").getDelegate();
        prop = this.factory.createProperty(clss, "collection", "ReduceAction-collection", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isOrdered", "ReduceAction-isOrdered", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "ReduceAction-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "reducer", "ReduceAction-reducer", "Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "ReduceAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("RemoveStructuralFeatureValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "isRemoveDuplicates", "RemoveStructuralFeatureValueAction-isRemoveDuplicates", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "RemoveStructuralFeatureValueAction-isRemoveDuplicates-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "removeAt", "RemoveStructuralFeatureValueAction-removeAt", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("RemoveVariableValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "isRemoveDuplicates", "RemoveVariableValueAction-isRemoveDuplicates", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "RemoveVariableValueAction-isRemoveDuplicates-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "removeAt", "RemoveVariableValueAction-removeAt", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ReplyAction").getDelegate();
        prop = this.factory.createProperty(clss, "replyToCall", "ReplyAction-replyToCall", "Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "replyValue", "ReplyAction-replyValue", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "returnInformation", "ReplyAction-returnInformation", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("SendObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "request", "SendObjectAction-request", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "SendObjectAction-target", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("SendSignalAction").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "SendSignalAction-signal", "Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "SendSignalAction-target", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("SequenceNode").getDelegate();
        prop = this.factory.createProperty(clss, "executableNode", "SequenceNode-executableNode", "ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StartClassifierBehaviorAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "StartClassifierBehaviorAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StartObjectBehaviorAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "StartObjectBehaviorAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "StructuralFeatureAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "structuralFeature", "StructuralFeatureAction-structuralFeature", "StructuralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StructuredActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "activity", "StructuredActivityNode-activity", "Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "edge", "StructuredActivityNode-edge", "ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "mustIsolate", "StructuredActivityNode-mustIsolate", "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "StructuredActivityNode-mustIsolate-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "node", "StructuredActivityNode-node", "ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "structuredNodeInput", "StructuredActivityNode-structuredNodeInput", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "structuredNodeOutput", "StructuredActivityNode-structuredNodeOutput", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "variable", "StructuredActivityNode-variable", "Variable", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("TestIdentityAction").getDelegate();
        prop = this.factory.createProperty(clss, "first", "TestIdentityAction-first", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "TestIdentityAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "second", "TestIdentityAction-second", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("UnmarshallAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "UnmarshallAction-object", "InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "UnmarshallAction-result", "OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "unmarshallType", "UnmarshallAction-unmarshallType", "Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("ValuePin").getDelegate();
        prop = this.factory.createProperty(clss, "value", "ValuePin-value", "ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
    }

    private void constructGeneralizations() {
        Class_ clss = null;
        clss = (Class_)this.model.getElementById("Activity").getDelegate();
        this.factory.createGeneralization(clss, "Behavior");
        clss = (Class_)this.model.getElementById("ActivityEdge").getDelegate();
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("ActivityFinalNode").getDelegate();
        this.factory.createGeneralization(clss, "FinalNode");
        clss = (Class_)this.model.getElementById("ActivityGroup").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("ActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("ActivityParameterNode").getDelegate();
        this.factory.createGeneralization(clss, "ObjectNode");
        clss = (Class_)this.model.getElementById("ActivityPartition").getDelegate();
        this.factory.createGeneralization(clss, "ActivityGroup");
        clss = (Class_)this.model.getElementById("CentralBufferNode").getDelegate();
        this.factory.createGeneralization(clss, "ObjectNode");
        clss = (Class_)this.model.getElementById("ControlFlow").getDelegate();
        this.factory.createGeneralization(clss, "ActivityEdge");
        clss = (Class_)this.model.getElementById("ControlNode").getDelegate();
        this.factory.createGeneralization(clss, "ActivityNode");
        clss = (Class_)this.model.getElementById("DataStoreNode").getDelegate();
        this.factory.createGeneralization(clss, "CentralBufferNode");
        clss = (Class_)this.model.getElementById("DecisionNode").getDelegate();
        this.factory.createGeneralization(clss, "ControlNode");
        clss = (Class_)this.model.getElementById("ExceptionHandler").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("ExecutableNode").getDelegate();
        this.factory.createGeneralization(clss, "ActivityNode");
        clss = (Class_)this.model.getElementById("FinalNode").getDelegate();
        this.factory.createGeneralization(clss, "ControlNode");
        clss = (Class_)this.model.getElementById("FlowFinalNode").getDelegate();
        this.factory.createGeneralization(clss, "FinalNode");
        clss = (Class_)this.model.getElementById("ForkNode").getDelegate();
        this.factory.createGeneralization(clss, "ControlNode");
        clss = (Class_)this.model.getElementById("InitialNode").getDelegate();
        this.factory.createGeneralization(clss, "ControlNode");
        clss = (Class_)this.model.getElementById("InterruptibleActivityRegion").getDelegate();
        this.factory.createGeneralization(clss, "ActivityGroup");
        clss = (Class_)this.model.getElementById("JoinNode").getDelegate();
        this.factory.createGeneralization(clss, "ControlNode");
        clss = (Class_)this.model.getElementById("MergeNode").getDelegate();
        this.factory.createGeneralization(clss, "ControlNode");
        clss = (Class_)this.model.getElementById("ObjectFlow").getDelegate();
        this.factory.createGeneralization(clss, "ActivityEdge");
        clss = (Class_)this.model.getElementById("ObjectNode").getDelegate();
        this.factory.createGeneralization(clss, "TypedElement");
        this.factory.createGeneralization(clss, "ActivityNode");
        clss = (Class_)this.model.getElementById("Variable").getDelegate();
        this.factory.createGeneralization(clss, "ConnectableElement");
        this.factory.createGeneralization(clss, "MultiplicityElement");
        clss = (Class_)this.model.getElementById("Duration").getDelegate();
        this.factory.createGeneralization(clss, "ValueSpecification");
        clss = (Class_)this.model.getElementById("DurationConstraint").getDelegate();
        this.factory.createGeneralization(clss, "IntervalConstraint");
        clss = (Class_)this.model.getElementById("DurationInterval").getDelegate();
        this.factory.createGeneralization(clss, "Interval");
        clss = (Class_)this.model.getElementById("DurationObservation").getDelegate();
        this.factory.createGeneralization(clss, "Observation");
        clss = (Class_)this.model.getElementById("Expression").getDelegate();
        this.factory.createGeneralization(clss, "ValueSpecification");
        clss = (Class_)this.model.getElementById("Interval").getDelegate();
        this.factory.createGeneralization(clss, "ValueSpecification");
        clss = (Class_)this.model.getElementById("IntervalConstraint").getDelegate();
        this.factory.createGeneralization(clss, "Constraint");
        clss = (Class_)this.model.getElementById("LiteralBoolean").getDelegate();
        this.factory.createGeneralization(clss, "LiteralSpecification");
        clss = (Class_)this.model.getElementById("LiteralInteger").getDelegate();
        this.factory.createGeneralization(clss, "LiteralSpecification");
        clss = (Class_)this.model.getElementById("LiteralNull").getDelegate();
        this.factory.createGeneralization(clss, "LiteralSpecification");
        clss = (Class_)this.model.getElementById("LiteralReal").getDelegate();
        this.factory.createGeneralization(clss, "LiteralSpecification");
        clss = (Class_)this.model.getElementById("LiteralSpecification").getDelegate();
        this.factory.createGeneralization(clss, "ValueSpecification");
        clss = (Class_)this.model.getElementById("LiteralString").getDelegate();
        this.factory.createGeneralization(clss, "LiteralSpecification");
        clss = (Class_)this.model.getElementById("LiteralUnlimitedNatural").getDelegate();
        this.factory.createGeneralization(clss, "LiteralSpecification");
        clss = (Class_)this.model.getElementById("Observation").getDelegate();
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("OpaqueExpression").getDelegate();
        this.factory.createGeneralization(clss, "ValueSpecification");
        clss = (Class_)this.model.getElementById("StringExpression").getDelegate();
        this.factory.createGeneralization(clss, "TemplateableElement");
        this.factory.createGeneralization(clss, "Expression");
        clss = (Class_)this.model.getElementById("TimeConstraint").getDelegate();
        this.factory.createGeneralization(clss, "IntervalConstraint");
        clss = (Class_)this.model.getElementById("TimeExpression").getDelegate();
        this.factory.createGeneralization(clss, "ValueSpecification");
        clss = (Class_)this.model.getElementById("TimeInterval").getDelegate();
        this.factory.createGeneralization(clss, "Interval");
        clss = (Class_)this.model.getElementById("TimeObservation").getDelegate();
        this.factory.createGeneralization(clss, "Observation");
        clss = (Class_)this.model.getElementById("ValueSpecification").getDelegate();
        this.factory.createGeneralization(clss, "TypedElement");
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("Actor").getDelegate();
        this.factory.createGeneralization(clss, "BehavioredClassifier");
        clss = (Class_)this.model.getElementById("Extend").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("ExtensionPoint").getDelegate();
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("Include").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("UseCase").getDelegate();
        this.factory.createGeneralization(clss, "BehavioredClassifier");
        clss = (Class_)this.model.getElementById("Association").getDelegate();
        this.factory.createGeneralization(clss, "Relationship");
        this.factory.createGeneralization(clss, "Classifier");
        clss = (Class_)this.model.getElementById("AssociationClass").getDelegate();
        this.factory.createGeneralization(clss, "Class");
        this.factory.createGeneralization(clss, "Association");
        clss = (Class_)this.model.getElementById("Class").getDelegate();
        this.factory.createGeneralization(clss, "BehavioredClassifier");
        this.factory.createGeneralization(clss, "EncapsulatedClassifier");
        clss = (Class_)this.model.getElementById("Collaboration").getDelegate();
        this.factory.createGeneralization(clss, "StructuredClassifier");
        this.factory.createGeneralization(clss, "BehavioredClassifier");
        clss = (Class_)this.model.getElementById("CollaborationUse").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Component").getDelegate();
        this.factory.createGeneralization(clss, "Class");
        clss = (Class_)this.model.getElementById("ComponentRealization").getDelegate();
        this.factory.createGeneralization(clss, "Realization");
        clss = (Class_)this.model.getElementById("ConnectableElement").getDelegate();
        this.factory.createGeneralization(clss, "TypedElement");
        this.factory.createGeneralization(clss, "ParameterableElement");
        clss = (Class_)this.model.getElementById("ConnectableElementTemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "TemplateParameter");
        clss = (Class_)this.model.getElementById("Connector").getDelegate();
        this.factory.createGeneralization(clss, "Feature");
        clss = (Class_)this.model.getElementById("ConnectorEnd").getDelegate();
        this.factory.createGeneralization(clss, "MultiplicityElement");
        clss = (Class_)this.model.getElementById("EncapsulatedClassifier").getDelegate();
        this.factory.createGeneralization(clss, "StructuredClassifier");
        clss = (Class_)this.model.getElementById("Port").getDelegate();
        this.factory.createGeneralization(clss, "Property");
        clss = (Class_)this.model.getElementById("StructuredClassifier").getDelegate();
        this.factory.createGeneralization(clss, "Classifier");
        clss = (Class_)this.model.getElementById("ConnectionPointReference").getDelegate();
        this.factory.createGeneralization(clss, "Vertex");
        clss = (Class_)this.model.getElementById("FinalState").getDelegate();
        this.factory.createGeneralization(clss, "State");
        clss = (Class_)this.model.getElementById("ProtocolConformance").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("ProtocolStateMachine").getDelegate();
        this.factory.createGeneralization(clss, "StateMachine");
        clss = (Class_)this.model.getElementById("ProtocolTransition").getDelegate();
        this.factory.createGeneralization(clss, "Transition");
        clss = (Class_)this.model.getElementById("Pseudostate").getDelegate();
        this.factory.createGeneralization(clss, "Vertex");
        clss = (Class_)this.model.getElementById("Region").getDelegate();
        this.factory.createGeneralization(clss, "Namespace");
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("State").getDelegate();
        this.factory.createGeneralization(clss, "Namespace");
        this.factory.createGeneralization(clss, "Vertex");
        clss = (Class_)this.model.getElementById("StateMachine").getDelegate();
        this.factory.createGeneralization(clss, "Behavior");
        clss = (Class_)this.model.getElementById("Transition").getDelegate();
        this.factory.createGeneralization(clss, "Namespace");
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("Vertex").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("BehavioredClassifier").getDelegate();
        this.factory.createGeneralization(clss, "Classifier");
        clss = (Class_)this.model.getElementById("DataType").getDelegate();
        this.factory.createGeneralization(clss, "Classifier");
        clss = (Class_)this.model.getElementById("Enumeration").getDelegate();
        this.factory.createGeneralization(clss, "DataType");
        clss = (Class_)this.model.getElementById("EnumerationLiteral").getDelegate();
        this.factory.createGeneralization(clss, "InstanceSpecification");
        clss = (Class_)this.model.getElementById("Interface").getDelegate();
        this.factory.createGeneralization(clss, "Classifier");
        clss = (Class_)this.model.getElementById("InterfaceRealization").getDelegate();
        this.factory.createGeneralization(clss, "Realization");
        clss = (Class_)this.model.getElementById("PrimitiveType").getDelegate();
        this.factory.createGeneralization(clss, "DataType");
        clss = (Class_)this.model.getElementById("Reception").getDelegate();
        this.factory.createGeneralization(clss, "BehavioralFeature");
        clss = (Class_)this.model.getElementById("Signal").getDelegate();
        this.factory.createGeneralization(clss, "Classifier");
        clss = (Class_)this.model.getElementById("Extension").getDelegate();
        this.factory.createGeneralization(clss, "Association");
        clss = (Class_)this.model.getElementById("ExtensionEnd").getDelegate();
        this.factory.createGeneralization(clss, "Property");
        clss = (Class_)this.model.getElementById("Image").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("Model").getDelegate();
        this.factory.createGeneralization(clss, "Package");
        clss = (Class_)this.model.getElementById("Package").getDelegate();
        this.factory.createGeneralization(clss, "PackageableElement");
        this.factory.createGeneralization(clss, "TemplateableElement");
        this.factory.createGeneralization(clss, "Namespace");
        clss = (Class_)this.model.getElementById("PackageMerge").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("Profile").getDelegate();
        this.factory.createGeneralization(clss, "Package");
        clss = (Class_)this.model.getElementById("ProfileApplication").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("Stereotype").getDelegate();
        this.factory.createGeneralization(clss, "Class");
        clss = (Class_)this.model.getElementById("ActionExecutionSpecification").getDelegate();
        this.factory.createGeneralization(clss, "ExecutionSpecification");
        clss = (Class_)this.model.getElementById("BehaviorExecutionSpecification").getDelegate();
        this.factory.createGeneralization(clss, "ExecutionSpecification");
        clss = (Class_)this.model.getElementById("CombinedFragment").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        clss = (Class_)this.model.getElementById("ConsiderIgnoreFragment").getDelegate();
        this.factory.createGeneralization(clss, "CombinedFragment");
        clss = (Class_)this.model.getElementById("Continuation").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        clss = (Class_)this.model.getElementById("DestructionOccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "MessageOccurrenceSpecification");
        clss = (Class_)this.model.getElementById("ExecutionOccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "OccurrenceSpecification");
        clss = (Class_)this.model.getElementById("ExecutionSpecification").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        clss = (Class_)this.model.getElementById("Gate").getDelegate();
        this.factory.createGeneralization(clss, "MessageEnd");
        clss = (Class_)this.model.getElementById("GeneralOrdering").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Interaction").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        this.factory.createGeneralization(clss, "Behavior");
        clss = (Class_)this.model.getElementById("InteractionConstraint").getDelegate();
        this.factory.createGeneralization(clss, "Constraint");
        clss = (Class_)this.model.getElementById("InteractionFragment").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("InteractionOperand").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        this.factory.createGeneralization(clss, "Namespace");
        clss = (Class_)this.model.getElementById("InteractionUse").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        clss = (Class_)this.model.getElementById("Lifeline").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Message").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("MessageEnd").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("MessageOccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "MessageEnd");
        this.factory.createGeneralization(clss, "OccurrenceSpecification");
        clss = (Class_)this.model.getElementById("OccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        clss = (Class_)this.model.getElementById("PartDecomposition").getDelegate();
        this.factory.createGeneralization(clss, "InteractionUse");
        clss = (Class_)this.model.getElementById("StateInvariant").getDelegate();
        this.factory.createGeneralization(clss, "InteractionFragment");
        clss = (Class_)this.model.getElementById("InformationFlow").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("InformationItem").getDelegate();
        this.factory.createGeneralization(clss, "Classifier");
        clss = (Class_)this.model.getElementById("Artifact").getDelegate();
        this.factory.createGeneralization(clss, "Classifier");
        this.factory.createGeneralization(clss, "DeployedArtifact");
        clss = (Class_)this.model.getElementById("CommunicationPath").getDelegate();
        this.factory.createGeneralization(clss, "Association");
        clss = (Class_)this.model.getElementById("DeployedArtifact").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Deployment").getDelegate();
        this.factory.createGeneralization(clss, "Dependency");
        clss = (Class_)this.model.getElementById("DeploymentSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Artifact");
        clss = (Class_)this.model.getElementById("DeploymentTarget").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Device").getDelegate();
        this.factory.createGeneralization(clss, "Node");
        clss = (Class_)this.model.getElementById("ExecutionEnvironment").getDelegate();
        this.factory.createGeneralization(clss, "Node");
        clss = (Class_)this.model.getElementById("Manifestation").getDelegate();
        this.factory.createGeneralization(clss, "Abstraction");
        clss = (Class_)this.model.getElementById("Node").getDelegate();
        this.factory.createGeneralization(clss, "Class");
        this.factory.createGeneralization(clss, "DeploymentTarget");
        clss = (Class_)this.model.getElementById("Abstraction").getDelegate();
        this.factory.createGeneralization(clss, "Dependency");
        clss = (Class_)this.model.getElementById("Comment").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("Constraint").getDelegate();
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("Dependency").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("DirectedRelationship").getDelegate();
        this.factory.createGeneralization(clss, "Relationship");
        clss = (Class_)this.model.getElementById("Element").getDelegate();
        clss = (Class_)this.model.getElementById("ElementImport").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("MultiplicityElement").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("Namespace").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("PackageableElement").getDelegate();
        this.factory.createGeneralization(clss, "ParameterableElement");
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("PackageImport").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("ParameterableElement").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("Realization").getDelegate();
        this.factory.createGeneralization(clss, "Abstraction");
        clss = (Class_)this.model.getElementById("Relationship").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("TemplateableElement").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("TemplateBinding").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("TemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("TemplateParameterSubstitution").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("TemplateSignature").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("Type").getDelegate();
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("TypedElement").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Usage").getDelegate();
        this.factory.createGeneralization(clss, "Dependency");
        clss = (Class_)this.model.getElementById("AnyReceiveEvent").getDelegate();
        this.factory.createGeneralization(clss, "MessageEvent");
        clss = (Class_)this.model.getElementById("Behavior").getDelegate();
        this.factory.createGeneralization(clss, "Class");
        clss = (Class_)this.model.getElementById("CallEvent").getDelegate();
        this.factory.createGeneralization(clss, "MessageEvent");
        clss = (Class_)this.model.getElementById("ChangeEvent").getDelegate();
        this.factory.createGeneralization(clss, "Event");
        clss = (Class_)this.model.getElementById("Event").getDelegate();
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("FunctionBehavior").getDelegate();
        this.factory.createGeneralization(clss, "OpaqueBehavior");
        clss = (Class_)this.model.getElementById("MessageEvent").getDelegate();
        this.factory.createGeneralization(clss, "Event");
        clss = (Class_)this.model.getElementById("OpaqueBehavior").getDelegate();
        this.factory.createGeneralization(clss, "Behavior");
        clss = (Class_)this.model.getElementById("SignalEvent").getDelegate();
        this.factory.createGeneralization(clss, "MessageEvent");
        clss = (Class_)this.model.getElementById("TimeEvent").getDelegate();
        this.factory.createGeneralization(clss, "Event");
        clss = (Class_)this.model.getElementById("Trigger").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Substitution").getDelegate();
        this.factory.createGeneralization(clss, "Realization");
        clss = (Class_)this.model.getElementById("BehavioralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Feature");
        this.factory.createGeneralization(clss, "Namespace");
        clss = (Class_)this.model.getElementById("Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Namespace");
        this.factory.createGeneralization(clss, "Type");
        this.factory.createGeneralization(clss, "TemplateableElement");
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("ClassifierTemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "TemplateParameter");
        clss = (Class_)this.model.getElementById("Feature").getDelegate();
        this.factory.createGeneralization(clss, "RedefinableElement");
        clss = (Class_)this.model.getElementById("Generalization").getDelegate();
        this.factory.createGeneralization(clss, "DirectedRelationship");
        clss = (Class_)this.model.getElementById("GeneralizationSet").getDelegate();
        this.factory.createGeneralization(clss, "PackageableElement");
        clss = (Class_)this.model.getElementById("InstanceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "DeploymentTarget");
        this.factory.createGeneralization(clss, "PackageableElement");
        this.factory.createGeneralization(clss, "DeployedArtifact");
        clss = (Class_)this.model.getElementById("InstanceValue").getDelegate();
        this.factory.createGeneralization(clss, "ValueSpecification");
        clss = (Class_)this.model.getElementById("Operation").getDelegate();
        this.factory.createGeneralization(clss, "TemplateableElement");
        this.factory.createGeneralization(clss, "ParameterableElement");
        this.factory.createGeneralization(clss, "BehavioralFeature");
        clss = (Class_)this.model.getElementById("OperationTemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "TemplateParameter");
        clss = (Class_)this.model.getElementById("Parameter").getDelegate();
        this.factory.createGeneralization(clss, "MultiplicityElement");
        this.factory.createGeneralization(clss, "ConnectableElement");
        clss = (Class_)this.model.getElementById("ParameterSet").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("Property").getDelegate();
        this.factory.createGeneralization(clss, "ConnectableElement");
        this.factory.createGeneralization(clss, "DeploymentTarget");
        this.factory.createGeneralization(clss, "StructuralFeature");
        clss = (Class_)this.model.getElementById("RedefinableElement").getDelegate();
        this.factory.createGeneralization(clss, "NamedElement");
        clss = (Class_)this.model.getElementById("RedefinableTemplateSignature").getDelegate();
        this.factory.createGeneralization(clss, "RedefinableElement");
        this.factory.createGeneralization(clss, "TemplateSignature");
        clss = (Class_)this.model.getElementById("Slot").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("StructuralFeature").getDelegate();
        this.factory.createGeneralization(clss, "MultiplicityElement");
        this.factory.createGeneralization(clss, "TypedElement");
        this.factory.createGeneralization(clss, "Feature");
        clss = (Class_)this.model.getElementById("ValueSpecificationAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("VariableAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("WriteLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "LinkAction");
        clss = (Class_)this.model.getElementById("WriteStructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "StructuralFeatureAction");
        clss = (Class_)this.model.getElementById("WriteVariableAction").getDelegate();
        this.factory.createGeneralization(clss, "VariableAction");
        clss = (Class_)this.model.getElementById("AcceptCallAction").getDelegate();
        this.factory.createGeneralization(clss, "AcceptEventAction");
        clss = (Class_)this.model.getElementById("AcceptEventAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("Action").getDelegate();
        this.factory.createGeneralization(clss, "ExecutableNode");
        clss = (Class_)this.model.getElementById("ActionInputPin").getDelegate();
        this.factory.createGeneralization(clss, "InputPin");
        clss = (Class_)this.model.getElementById("AddStructuralFeatureValueAction").getDelegate();
        this.factory.createGeneralization(clss, "WriteStructuralFeatureAction");
        clss = (Class_)this.model.getElementById("AddVariableValueAction").getDelegate();
        this.factory.createGeneralization(clss, "WriteVariableAction");
        clss = (Class_)this.model.getElementById("BroadcastSignalAction").getDelegate();
        this.factory.createGeneralization(clss, "InvocationAction");
        clss = (Class_)this.model.getElementById("CallAction").getDelegate();
        this.factory.createGeneralization(clss, "InvocationAction");
        clss = (Class_)this.model.getElementById("CallBehaviorAction").getDelegate();
        this.factory.createGeneralization(clss, "CallAction");
        clss = (Class_)this.model.getElementById("CallOperationAction").getDelegate();
        this.factory.createGeneralization(clss, "CallAction");
        clss = (Class_)this.model.getElementById("Clause").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("ClearAssociationAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ClearStructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "StructuralFeatureAction");
        clss = (Class_)this.model.getElementById("ClearVariableAction").getDelegate();
        this.factory.createGeneralization(clss, "VariableAction");
        clss = (Class_)this.model.getElementById("ConditionalNode").getDelegate();
        this.factory.createGeneralization(clss, "StructuredActivityNode");
        clss = (Class_)this.model.getElementById("CreateLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "WriteLinkAction");
        clss = (Class_)this.model.getElementById("CreateLinkObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "CreateLinkAction");
        clss = (Class_)this.model.getElementById("CreateObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("DestroyLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "WriteLinkAction");
        clss = (Class_)this.model.getElementById("DestroyObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ExpansionNode").getDelegate();
        this.factory.createGeneralization(clss, "ObjectNode");
        clss = (Class_)this.model.getElementById("ExpansionRegion").getDelegate();
        this.factory.createGeneralization(clss, "StructuredActivityNode");
        clss = (Class_)this.model.getElementById("InputPin").getDelegate();
        this.factory.createGeneralization(clss, "Pin");
        clss = (Class_)this.model.getElementById("InvocationAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("LinkAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("LinkEndCreationData").getDelegate();
        this.factory.createGeneralization(clss, "LinkEndData");
        clss = (Class_)this.model.getElementById("LinkEndData").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("LinkEndDestructionData").getDelegate();
        this.factory.createGeneralization(clss, "LinkEndData");
        clss = (Class_)this.model.getElementById("LoopNode").getDelegate();
        this.factory.createGeneralization(clss, "StructuredActivityNode");
        clss = (Class_)this.model.getElementById("OpaqueAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("OutputPin").getDelegate();
        this.factory.createGeneralization(clss, "Pin");
        clss = (Class_)this.model.getElementById("Pin").getDelegate();
        this.factory.createGeneralization(clss, "ObjectNode");
        this.factory.createGeneralization(clss, "MultiplicityElement");
        clss = (Class_)this.model.getElementById("QualifierValue").getDelegate();
        this.factory.createGeneralization(clss, "Element");
        clss = (Class_)this.model.getElementById("RaiseExceptionAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ReadExtentAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ReadIsClassifiedObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ReadLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "LinkAction");
        clss = (Class_)this.model.getElementById("ReadLinkObjectEndAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ReadLinkObjectEndQualifierAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ReadSelfAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ReadStructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "StructuralFeatureAction");
        clss = (Class_)this.model.getElementById("ReadVariableAction").getDelegate();
        this.factory.createGeneralization(clss, "VariableAction");
        clss = (Class_)this.model.getElementById("ReclassifyObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ReduceAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("RemoveStructuralFeatureValueAction").getDelegate();
        this.factory.createGeneralization(clss, "WriteStructuralFeatureAction");
        clss = (Class_)this.model.getElementById("RemoveVariableValueAction").getDelegate();
        this.factory.createGeneralization(clss, "WriteVariableAction");
        clss = (Class_)this.model.getElementById("ReplyAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("SendObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "InvocationAction");
        clss = (Class_)this.model.getElementById("SendSignalAction").getDelegate();
        this.factory.createGeneralization(clss, "InvocationAction");
        clss = (Class_)this.model.getElementById("SequenceNode").getDelegate();
        this.factory.createGeneralization(clss, "StructuredActivityNode");
        clss = (Class_)this.model.getElementById("StartClassifierBehaviorAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("StartObjectBehaviorAction").getDelegate();
        this.factory.createGeneralization(clss, "CallAction");
        clss = (Class_)this.model.getElementById("StructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("StructuredActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "Namespace");
        this.factory.createGeneralization(clss, "ActivityGroup");
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("TestIdentityAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("UnmarshallAction").getDelegate();
        this.factory.createGeneralization(clss, "Action");
        clss = (Class_)this.model.getElementById("ValuePin").getDelegate();
        this.factory.createGeneralization(clss, "InputPin");
    }

    /*
     * Opcode count of 26718 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void constructAssociations() {
        String packageId = null;
        Association assoc = null;
        Property prop = null;
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_0 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_selection_objectNode", "A_selection_objectNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "objectNode", "A_selection_objectNode-objectNode", "ObjectNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ObjectNode-selection A_selection_objectNode-objectNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_1 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inState_objectNode", "A_inState_objectNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "objectNode", "A_inState_objectNode-objectNode", "ObjectNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ObjectNode-inState A_inState_objectNode-objectNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_2 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_upperBound_objectNode", "A_upperBound_objectNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "objectNode", "A_upperBound_objectNode-objectNode", "ObjectNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ObjectNode-upperBound A_upperBound_objectNode-objectNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_3 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_transformation_objectFlow", "A_transformation_objectFlow");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "objectFlow", "A_transformation_objectFlow-objectFlow", "ObjectFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ObjectFlow-transformation A_transformation_objectFlow-objectFlow ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_4 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_selection_objectFlow", "A_selection_objectFlow");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "objectFlow", "A_selection_objectFlow-objectFlow", "ObjectFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ObjectFlow-selection A_selection_objectFlow-objectFlow ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_5 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_joinSpec_joinNode", "A_joinSpec_joinNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "joinNode", "A_joinSpec_joinNode-joinNode", "JoinNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "JoinNode-joinSpec A_joinSpec_joinNode-joinNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_6 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_interruptingEdge_interrupts", "A_interruptingEdge_interrupts");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "InterruptibleActivityRegion-interruptingEdge ActivityEdge-interrupts ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_7 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_handler_protectedNode", "A_handler_protectedNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ExecutableNode-handler ExceptionHandler-protectedNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_8 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_handlerBody_exceptionHandler", "A_handlerBody_exceptionHandler");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "exceptionHandler", "A_handlerBody_exceptionHandler-exceptionHandler", "ExceptionHandler", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ExceptionHandler-handlerBody A_handlerBody_exceptionHandler-exceptionHandler ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_9 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exceptionType_exceptionHandler", "A_exceptionType_exceptionHandler");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "exceptionHandler", "A_exceptionType_exceptionHandler-exceptionHandler", "ExceptionHandler", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ExceptionHandler-exceptionType A_exceptionType_exceptionHandler-exceptionHandler ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_10 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exceptionInput_exceptionHandler", "A_exceptionInput_exceptionHandler");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "exceptionHandler", "A_exceptionInput_exceptionHandler-exceptionHandler", "ExceptionHandler", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ExceptionHandler-exceptionInput A_exceptionInput_exceptionHandler-exceptionHandler ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_11 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decisionInput_decisionNode", "A_decisionInput_decisionNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "decisionNode", "A_decisionInput_decisionNode-decisionNode", "DecisionNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DecisionNode-decisionInput A_decisionInput_decisionNode-decisionNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_12 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decisionInputFlow_decisionNode", "A_decisionInputFlow_decisionNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "decisionNode", "A_decisionInputFlow_decisionNode-decisionNode", "DecisionNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DecisionNode-decisionInputFlow A_decisionInputFlow_decisionNode-decisionNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_13 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_represents_activityPartition", "A_represents_activityPartition");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "activityPartition", "A_represents_activityPartition-activityPartition", "ActivityPartition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActivityPartition-represents A_represents_activityPartition-activityPartition ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_14 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subpartition_superPartition", "A_subpartition_superPartition");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityPartition-subpartition ActivityPartition-superPartition ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_15 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_edge_inPartition", "A_edge_inPartition");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityPartition-edge ActivityEdge-inPartition ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_16 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameter_activityParameterNode", "A_parameter_activityParameterNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "activityParameterNode", "A_parameter_activityParameterNode-activityParameterNode", "ActivityParameterNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActivityParameterNode-parameter A_parameter_activityParameterNode-activityParameterNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_17 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inInterruptibleRegion_node", "A_inInterruptibleRegion_node");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityNode-inInterruptibleRegion InterruptibleActivityRegion-node ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_18 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inPartition_node", "A_inPartition_node");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityNode-inPartition ActivityPartition-node ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_19 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_incoming_target_node", "A_incoming_target_node");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityNode-incoming ActivityEdge-target ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_20 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outgoing_source_node", "A_outgoing_source_node");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityNode-outgoing ActivityEdge-source ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_21 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedNode_activityNode", "A_redefinedNode_activityNode");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "activityNode", "A_redefinedNode_activityNode-activityNode", "ActivityNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActivityNode-redefinedNode A_redefinedNode_activityNode-activityNode ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_22 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedEdge_inGroup", "A_containedEdge_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityGroup-containedEdge ActivityEdge-inGroup ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_23 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedNode_inGroup", "A_containedNode_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityGroup-containedNode ActivityNode-inGroup ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_24 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subgroup_superGroup", "A_subgroup_superGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "ActivityGroup-subgroup ActivityGroup-superGroup ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_25 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedEdge_activityEdge", "A_redefinedEdge_activityEdge");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "activityEdge", "A_redefinedEdge_activityEdge-activityEdge", "ActivityEdge", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActivityEdge-redefinedEdge A_redefinedEdge_activityEdge-activityEdge ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_26 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_weight_activityEdge", "A_weight_activityEdge");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "activityEdge", "A_weight_activityEdge-activityEdge", "ActivityEdge", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActivityEdge-weight A_weight_activityEdge-activityEdge ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_27 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_guard_activityEdge", "A_guard_activityEdge");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "activityEdge", "A_guard_activityEdge-activityEdge", "ActivityEdge", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActivityEdge-guard A_guard_activityEdge-activityEdge ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_28 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuredNode_activity", "A_structuredNode_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "Activity-structuredNode StructuredActivityNode-activity ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_29 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_group_inActivity", "A_group_inActivity");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "Activity-group ActivityGroup-inActivity ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_30 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_node_activity", "A_node_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "Activity-node ActivityNode-activity ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_31 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_variable_activityScope", "A_variable_activityScope");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "Activity-variable Variable-activityScope ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_32 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_edge_activity", "A_edge_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        this.factory.createAssociationEnds(assoc, "Activity-edge ActivityEdge-activity ");
        packageId = this.artifact.getUrn() + "#" + "Activities";
        Package cfr_ignored_33 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_partition_activity", "A_partition_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities", this);
        prop = this.factory.createProperty(assoc, "activity", "A_partition_activity-activity", "Activity", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activity-partition A_partition_activity-activity ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_34 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_event_timeObservation", "A_event_timeObservation");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "timeObservation", "A_event_timeObservation-timeObservation", "TimeObservation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TimeObservation-event A_event_timeObservation-timeObservation ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_35 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_max_timeInterval", "A_max_timeInterval");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "timeInterval", "A_max_timeInterval-timeInterval", "TimeInterval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TimeInterval-max A_max_timeInterval-timeInterval ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_36 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_min_timeInterval", "A_min_timeInterval");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "timeInterval", "A_min_timeInterval-timeInterval", "TimeInterval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TimeInterval-min A_min_timeInterval-timeInterval ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_37 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_expr_timeExpression", "A_expr_timeExpression");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "timeExpression", "A_expr_timeExpression-timeExpression", "TimeExpression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TimeExpression-expr A_expr_timeExpression-timeExpression ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_38 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_observation_timeExpression", "A_observation_timeExpression");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "timeExpression", "A_observation_timeExpression-timeExpression", "TimeExpression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TimeExpression-observation A_observation_timeExpression-timeExpression ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_39 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_timeConstraint", "A_specification_timeConstraint");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "timeConstraint", "A_specification_timeConstraint-timeConstraint", "TimeConstraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TimeConstraint-specification A_specification_timeConstraint-timeConstraint ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_40 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subExpression_owningExpression", "A_subExpression_owningExpression");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        this.factory.createAssociationEnds(assoc, "StringExpression-subExpression StringExpression-owningExpression ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_41 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_opaqueExpression", "A_result_opaqueExpression");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "opaqueExpression", "A_result_opaqueExpression-opaqueExpression", "OpaqueExpression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "OpaqueExpression-result A_result_opaqueExpression-opaqueExpression ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_42 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_behavior_opaqueExpression", "A_behavior_opaqueExpression");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "opaqueExpression", "A_behavior_opaqueExpression-opaqueExpression", "OpaqueExpression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "OpaqueExpression-behavior A_behavior_opaqueExpression-opaqueExpression ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_43 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_intervalConstraint", "A_specification_intervalConstraint");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "intervalConstraint", "A_specification_intervalConstraint-intervalConstraint", "IntervalConstraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "IntervalConstraint-specification A_specification_intervalConstraint-intervalConstraint ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_44 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_max_interval", "A_max_interval");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "interval", "A_max_interval-interval", "Interval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interval-max A_max_interval-interval ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_45 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_min_interval", "A_min_interval");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "interval", "A_min_interval-interval", "Interval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interval-min A_min_interval-interval ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_46 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operand_expression", "A_operand_expression");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "expression", "A_operand_expression-expression", "Expression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Expression-operand A_operand_expression-expression ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_47 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_event_durationObservation", "A_event_durationObservation");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "durationObservation", "A_event_durationObservation-durationObservation", "DurationObservation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DurationObservation-event A_event_durationObservation-durationObservation ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_48 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_max_durationInterval", "A_max_durationInterval");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "durationInterval", "A_max_durationInterval-durationInterval", "DurationInterval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DurationInterval-max A_max_durationInterval-durationInterval ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_49 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_min_durationInterval", "A_min_durationInterval");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "durationInterval", "A_min_durationInterval-durationInterval", "DurationInterval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DurationInterval-min A_min_durationInterval-durationInterval ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_50 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_durationConstraint", "A_specification_durationConstraint");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "durationConstraint", "A_specification_durationConstraint-durationConstraint", "DurationConstraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DurationConstraint-specification A_specification_durationConstraint-durationConstraint ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_51 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_expr_duration", "A_expr_duration");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "duration", "A_expr_duration-duration", "Duration", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Duration-expr A_expr_duration-duration ");
        packageId = this.artifact.getUrn() + "#" + "Values";
        Package cfr_ignored_52 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_observation_duration", "A_observation_duration");
        this.mapping.mapAssociation(assoc, "UML.Values", this);
        prop = this.factory.createProperty(assoc, "duration", "A_observation_duration-duration", "Duration", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Duration-observation A_observation_duration-duration ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_53 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extensionPoint_useCase", "A_extensionPoint_useCase");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCase-extensionPoint ExtensionPoint-useCase ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_54 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_include_includingCase", "A_include_includingCase");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCase-include Include-includingCase ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_55 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subject_useCase", "A_subject_useCase");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCase-subject Classifier-useCase ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_56 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extend_extension", "A_extend_extension");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCase-extend Extend-extension ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_57 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_addition_include", "A_addition_include");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "include", "A_addition_include-include", "Include", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Include-addition A_addition_include-include ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_58 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extensionLocation_extension", "A_extensionLocation_extension");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "extension", "A_extensionLocation_extension-extension", "Extend", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Extend-extensionLocation A_extensionLocation_extension-extension ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_59 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_condition_extend", "A_condition_extend");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "extend", "A_condition_extend-extend", "Extend", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Extend-condition A_condition_extend-extend ");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_60 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedCase_extend", "A_extendedCase_extend");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "extend", "A_extendedCase_extend-extend", "Extend", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Extend-extendedCase A_extendedCase_extend-extend ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_61 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_part_structuredClassifier", "A_part_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "A_part_structuredClassifier-structuredClassifier", "StructuredClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuredClassifier-part A_part_structuredClassifier-structuredClassifier ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_62 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedConnector_structuredClassifier", "A_ownedConnector_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "A_ownedConnector_structuredClassifier-structuredClassifier", "StructuredClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuredClassifier-ownedConnector A_ownedConnector_structuredClassifier-structuredClassifier ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_63 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_structuredClassifier", "A_ownedAttribute_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "A_ownedAttribute_structuredClassifier-structuredClassifier", "StructuredClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuredClassifier-ownedAttribute A_ownedAttribute_structuredClassifier-structuredClassifier ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_64 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_role_structuredClassifier", "A_role_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "A_role_structuredClassifier-structuredClassifier", "StructuredClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuredClassifier-role A_role_structuredClassifier-structuredClassifier ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_65 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_protocol_port", "A_protocol_port");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "port", "A_protocol_port-port", "Port", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Port-protocol A_protocol_port-port ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_66 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_required_port", "A_required_port");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "port", "A_required_port-port", "Port", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Port-required A_required_port-port ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_67 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedPort_port", "A_redefinedPort_port");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "port", "A_redefinedPort_port-port", "Port", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Port-redefinedPort A_redefinedPort_port-port ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_68 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_provided_port", "A_provided_port");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "port", "A_provided_port-port", "Port", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Port-provided A_provided_port-port ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_69 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedPort_encapsulatedClassifier", "A_ownedPort_encapsulatedClassifier");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "encapsulatedClassifier", "A_ownedPort_encapsulatedClassifier-encapsulatedClassifier", "EncapsulatedClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "EncapsulatedClassifier-ownedPort A_ownedPort_encapsulatedClassifier-encapsulatedClassifier ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_70 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_partWithPort_connectorEnd", "A_partWithPort_connectorEnd");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "connectorEnd", "A_partWithPort_connectorEnd-connectorEnd", "ConnectorEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ConnectorEnd-partWithPort A_partWithPort_connectorEnd-connectorEnd ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_71 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_definingEnd_connectorEnd", "A_definingEnd_connectorEnd");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "connectorEnd", "A_definingEnd_connectorEnd-connectorEnd", "ConnectorEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ConnectorEnd-definingEnd A_definingEnd_connectorEnd-connectorEnd ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_72 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_connector", "A_end_connector");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "connector", "A_end_connector-connector", "Connector", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Connector-end A_end_connector-connector ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_73 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedConnector_connector", "A_redefinedConnector_connector");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "connector", "A_redefinedConnector_connector-connector", "Connector", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Connector-redefinedConnector A_redefinedConnector_connector-connector ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_74 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_contract_connector", "A_contract_connector");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "connector", "A_contract_connector-connector", "Connector", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Connector-contract A_contract_connector-connector ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_75 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_connector", "A_type_connector");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "connector", "A_type_connector-connector", "Connector", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Connector-type A_type_connector-connector ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_76 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connectableElement_templateParameter_parameteredElement", "A_connectableElement_templateParameter_parameteredElement");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "ConnectableElement-templateParameter ConnectableElementTemplateParameter-parameteredElement ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_77 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_role", "A_end_role");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "ConnectableElement-end ConnectorEnd-role ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_78 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingClassifier_componentRealization", "A_realizingClassifier_componentRealization");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "componentRealization", "A_realizingClassifier_componentRealization-componentRealization", "ComponentRealization", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ComponentRealization-realizingClassifier A_realizingClassifier_componentRealization-componentRealization ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_79 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_required_component", "A_required_component");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "component", "A_required_component-component", "Component", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Component-required A_required_component-component ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_80 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packagedElement_component", "A_packagedElement_component");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "component", "A_packagedElement_component-component", "Component", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Component-packagedElement A_packagedElement_component-component ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_81 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realization_abstraction_component", "A_realization_abstraction_component");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Component-realization ComponentRealization-abstraction ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_82 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_provided_component", "A_provided_component");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "component", "A_provided_component-component", "Component", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Component-provided A_provided_component-component ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_83 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_collaborationUse", "A_type_collaborationUse");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "collaborationUse", "A_type_collaborationUse-collaborationUse", "CollaborationUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CollaborationUse-type A_type_collaborationUse-collaborationUse ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_84 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_roleBinding_collaborationUse", "A_roleBinding_collaborationUse");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "collaborationUse", "A_roleBinding_collaborationUse-collaborationUse", "CollaborationUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CollaborationUse-roleBinding A_roleBinding_collaborationUse-collaborationUse ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_85 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_collaborationRole_collaboration", "A_collaborationRole_collaboration");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "collaboration", "A_collaborationRole_collaboration-collaboration", "Collaboration", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Collaboration-collaborationRole A_collaborationRole_collaboration-collaboration ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_86 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_class", "A_ownedOperation_class");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Class-ownedOperation Operation-class ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_87 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_superClass_class", "A_superClass_class");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "class", "A_superClass_class-class", "Class", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Class-superClass A_superClass_class-class ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_88 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extension_metaclass", "A_extension_metaclass");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Class-extension Extension-metaclass ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_89 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_class", "A_ownedAttribute_class");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Class-ownedAttribute Property-class ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_90 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedClassifier_nestingClass", "A_nestedClassifier_nestingClass");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "nestingClass", "A_nestedClassifier_nestingClass-nestingClass", "Class", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Class-nestedClassifier A_nestedClassifier_nestingClass-nestingClass ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_91 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedReception_class", "A_ownedReception_class");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "class", "A_ownedReception_class-class", "Class", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Class-ownedReception A_ownedReception_class-class ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_92 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_memberEnd_association", "A_memberEnd_association");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Association-memberEnd Property-association ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_93 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endType_association", "A_endType_association");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "association", "A_endType_association-association", "Association", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Association-endType A_endType_association-association ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_94 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedEnd_owningAssociation", "A_ownedEnd_owningAssociation");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Association-ownedEnd Property-owningAssociation ");
        packageId = this.artifact.getUrn() + "#" + "StructuredClassifiers";
        Package cfr_ignored_95 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_navigableOwnedEnd_association", "A_navigableOwnedEnd_association");
        this.mapping.mapAssociation(assoc, "UML.StructuredClassifiers", this);
        prop = this.factory.createProperty(assoc, "association", "A_navigableOwnedEnd_association-association", "Association", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Association-navigableOwnedEnd A_navigableOwnedEnd_association-association ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_96 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_incoming_target_vertex", "A_incoming_target_vertex");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "Vertex-incoming Transition-target ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_97 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outgoing_source_vertex", "A_outgoing_source_vertex");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "Vertex-outgoing Transition-source ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_98 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_trigger_transition", "A_trigger_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "A_trigger_transition-transition", "Transition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Transition-trigger A_trigger_transition-transition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_99 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_guard_transition", "A_guard_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "A_guard_transition-transition", "Transition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Transition-guard A_guard_transition-transition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_100 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedTransition_transition", "A_redefinedTransition_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "A_redefinedTransition_transition-transition", "Transition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Transition-redefinedTransition A_redefinedTransition_transition-transition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_101 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_transition", "A_redefinitionContext_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "A_redefinitionContext_transition-transition", "Transition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Transition-redefinitionContext A_redefinitionContext_transition-transition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_102 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_effect_transition", "A_effect_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "A_effect_transition-transition", "Transition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Transition-effect A_effect_transition-transition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_103 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_submachineState_submachine", "A_submachineState_submachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachine-submachineState State-submachine ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_104 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connectionPoint_stateMachine", "A_connectionPoint_stateMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachine-connectionPoint Pseudostate-stateMachine ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_105 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_region_stateMachine", "A_region_stateMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachine-region Region-stateMachine ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_106 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedStateMachine_stateMachine", "A_extendedStateMachine_stateMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "stateMachine", "A_extendedStateMachine_stateMachine-stateMachine", "StateMachine", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachine-extendedStateMachine A_extendedStateMachine_stateMachine-stateMachine ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_107 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_vertex", "A_redefinitionContext_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "vertex", "A_redefinitionContext_state-state", "Vertex", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "State-redefinitionContext A_redefinitionContext_state-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_108 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_region_state", "A_region_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "State-region Region-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_109 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_stateInvariant_owningState", "A_stateInvariant_owningState");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "owningState", "A_stateInvariant_owningState-owningState", "State", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "State-stateInvariant A_stateInvariant_owningState-owningState ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_110 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedVertex_vertex", "A_redefinedState_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "vertex", "A_redefinedState_state-state", "Vertex", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "State-redefinedState A_redefinedState_state-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_111 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deferrableTrigger_state", "A_deferrableTrigger_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "A_deferrableTrigger_state-state", "State", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "State-deferrableTrigger A_deferrableTrigger_state-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_112 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connection_state", "A_connection_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "State-connection ConnectionPointReference-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_113 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_entry_state", "A_entry_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "A_entry_state-state", "State", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "State-entry A_entry_state-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_114 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connectionPoint_state", "A_connectionPoint_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "State-connectionPoint Pseudostate-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_115 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_doActivity_state", "A_doActivity_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "A_doActivity_state-state", "State", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "State-doActivity A_doActivity_state-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_116 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exit_state", "A_exit_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "A_exit_state-state", "State", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "State-exit A_exit_state-state ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_117 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedRegion_region", "A_extendedRegion_region");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "region", "A_extendedRegion_region-region", "Region", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Region-extendedRegion A_extendedRegion_region-region ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_118 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subvertex_container", "A_subvertex_container");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "Region-subvertex Vertex-container ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_119 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_region", "A_redefinitionContext_region");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "region", "A_redefinitionContext_region-region", "Region", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Region-redefinitionContext A_redefinitionContext_region-region ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_120 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_transition_container", "A_transition_container");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "Region-transition Transition-container ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_121 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_referred_protocolTransition", "A_referred_protocolTransition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "protocolTransition", "A_referred_protocolTransition-protocolTransition", "ProtocolTransition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ProtocolTransition-referred A_referred_protocolTransition-protocolTransition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_122 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_preCondition_protocolTransition", "A_preCondition_protocolTransition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "protocolTransition", "A_preCondition_protocolTransition-protocolTransition", "ProtocolTransition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ProtocolTransition-preCondition A_preCondition_protocolTransition-protocolTransition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_123 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_postCondition_owningTransition", "A_postCondition_owningTransition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "owningTransition", "A_postCondition_owningTransition-owningTransition", "ProtocolTransition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ProtocolTransition-postCondition A_postCondition_owningTransition-owningTransition ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_124 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_conformance_specificMachine", "A_conformance_specificMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        this.factory.createAssociationEnds(assoc, "ProtocolStateMachine-conformance ProtocolConformance-specificMachine ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_125 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalMachine_protocolConformance", "A_generalMachine_protocolConformance");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "protocolConformance", "A_generalMachine_protocolConformance-protocolConformance", "ProtocolConformance", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ProtocolConformance-generalMachine A_generalMachine_protocolConformance-protocolConformance ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_126 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_entry_connectionPointReference", "A_entry_connectionPointReference");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "connectionPointReference", "A_entry_connectionPointReference-connectionPointReference", "ConnectionPointReference", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ConnectionPointReference-entry A_entry_connectionPointReference-connectionPointReference ");
        packageId = this.artifact.getUrn() + "#" + "StateMachines";
        Package cfr_ignored_127 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exit_connectionPointReference", "A_exit_connectionPointReference");
        this.mapping.mapAssociation(assoc, "UML.StateMachines", this);
        prop = this.factory.createProperty(assoc, "connectionPointReference", "A_exit_connectionPointReference-connectionPointReference", "ConnectionPointReference", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ConnectionPointReference-exit A_exit_connectionPointReference-connectionPointReference ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_128 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_owningSignal", "A_ownedAttribute_owningSignal");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "owningSignal", "A_ownedAttribute_owningSignal-owningSignal", "Signal", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Signal-ownedAttribute A_ownedAttribute_owningSignal-owningSignal ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_129 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_reception", "A_signal_reception");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "reception", "A_signal_reception-reception", "Reception", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Reception-signal A_signal_reception-reception ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_130 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_contract_interfaceRealization", "A_contract_interfaceRealization");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "interfaceRealization", "A_contract_interfaceRealization-interfaceRealization", "InterfaceRealization", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InterfaceRealization-contract A_contract_interfaceRealization-interfaceRealization ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_131 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_protocol_interface", "A_protocol_interface");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "interface", "A_protocol_interface-interface", "Interface", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interface-protocol A_protocol_interface-interface ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_132 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedReception_interface", "A_ownedReception_interface");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "interface", "A_ownedReception_interface-interface", "Interface", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interface-ownedReception A_ownedReception_interface-interface ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_133 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedInterface_interface", "A_redefinedInterface_interface");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "interface", "A_redefinedInterface_interface-interface", "Interface", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interface-redefinedInterface A_redefinedInterface_interface-interface ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_134 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedClassifier_interface", "A_nestedClassifier_interface");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "interface", "A_nestedClassifier_interface-interface", "Interface", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interface-nestedClassifier A_nestedClassifier_interface-interface ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_135 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_interface", "A_ownedOperation_interface");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Interface-ownedOperation Operation-interface ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_136 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_interface", "A_ownedAttribute_interface");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Interface-ownedAttribute Property-interface ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_137 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_enumerationLiteral", "A_classifier_enumerationLiteral");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "enumerationLiteral", "A_classifier_enumerationLiteral-enumerationLiteral", "EnumerationLiteral", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "EnumerationLiteral-classifier A_classifier_enumerationLiteral-enumerationLiteral ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_138 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedLiteral_enumeration", "A_ownedLiteral_enumeration");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        this.factory.createAssociationEnds(assoc, "Enumeration-ownedLiteral EnumerationLiteral-enumeration ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_139 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_datatype", "A_ownedAttribute_datatype");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        this.factory.createAssociationEnds(assoc, "DataType-ownedAttribute Property-datatype ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_140 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_datatype", "A_ownedOperation_datatype");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        this.factory.createAssociationEnds(assoc, "DataType-ownedOperation Operation-datatype ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_141 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedBehavior_behavioredClassifier", "A_ownedBehavior_behavioredClassifier");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "behavioredClassifier", "A_ownedBehavior_behavioredClassifier-behavioredClassifier", "BehavioredClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "BehavioredClassifier-ownedBehavior A_ownedBehavior_behavioredClassifier-behavioredClassifier ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_142 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifierBehavior_behavioredClassifier", "A_classifierBehavior_behavioredClassifier");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        prop = this.factory.createProperty(assoc, "behavioredClassifier", "A_classifierBehavior_behavioredClassifier-behavioredClassifier", "BehavioredClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "BehavioredClassifier-classifierBehavior A_classifierBehavior_behavioredClassifier-behavioredClassifier ");
        packageId = this.artifact.getUrn() + "#" + "SimpleClassifiers";
        Package cfr_ignored_143 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_interfaceRealization_implementingClassifier", "A_interfaceRealization_implementingClassifier");
        this.mapping.mapAssociation(assoc, "UML.SimpleClassifiers", this);
        this.factory.createAssociationEnds(assoc, "BehavioredClassifier-interfaceRealization InterfaceRealization-implementingClassifier ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_144 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_profile_stereotype", "A_profile_stereotype");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "stereotype", "A_profile_stereotype-stereotype", "Stereotype", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Stereotype-profile A_profile_stereotype-stereotype ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_145 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_icon_stereotype", "A_icon_stereotype");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "stereotype", "A_icon_stereotype-stereotype", "Stereotype", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Stereotype-icon A_icon_stereotype-stereotype ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_146 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_appliedProfile_profileApplication", "A_appliedProfile_profileApplication");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "profileApplication", "A_appliedProfile_profileApplication-profileApplication", "ProfileApplication", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ProfileApplication-appliedProfile A_appliedProfile_profileApplication-profileApplication ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_147 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_metaclassReference_profile", "A_metaclassReference_profile");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "profile", "A_metaclassReference_profile-profile", "Profile", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profile-metaclassReference A_metaclassReference_profile-profile ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_148 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_metamodelReference_profile", "A_metamodelReference_profile");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "profile", "A_metamodelReference_profile-profile", "Profile", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profile-metamodelReference A_metamodelReference_profile-profile ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_149 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_mergedPackage_packageMerge", "A_mergedPackage_packageMerge");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "packageMerge", "A_mergedPackage_packageMerge-packageMerge", "PackageMerge", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "PackageMerge-mergedPackage A_mergedPackage_packageMerge-packageMerge ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_150 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packagedElement_owningPackage", "A_packagedElement_owningPackage");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "owningPackage", "A_packagedElement_owningPackage-owningPackage", "Package", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Package-packagedElement A_packagedElement_owningPackage-owningPackage ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_151 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packageMerge_receivingPackage", "A_packageMerge_receivingPackage");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        this.factory.createAssociationEnds(assoc, "Package-packageMerge PackageMerge-receivingPackage ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_152 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedPackage_nestingPackage", "A_nestedPackage_nestingPackage");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        this.factory.createAssociationEnds(assoc, "Package-nestedPackage Package-nestingPackage ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_153 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_profileApplication_applyingPackage", "A_profileApplication_applyingPackage");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        this.factory.createAssociationEnds(assoc, "Package-profileApplication ProfileApplication-applyingPackage ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_154 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedType_package", "A_ownedType_package");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        this.factory.createAssociationEnds(assoc, "Package-ownedType Type-package ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_155 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedStereotype_owningPackage", "A_ownedStereotype_owningPackage");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "owningPackage", "A_ownedStereotype_owningPackage-owningPackage", "Package", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Package-ownedStereotype A_ownedStereotype_owningPackage-owningPackage ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_156 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_extensionEnd", "A_type_extensionEnd");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "extensionEnd", "A_type_extensionEnd-extensionEnd", "ExtensionEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ExtensionEnd-type A_type_extensionEnd-extensionEnd ");
        packageId = this.artifact.getUrn() + "#" + "Packages";
        Package cfr_ignored_157 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedEnd_extension", "A_ownedEnd_extension");
        this.mapping.mapAssociation(assoc, "UML.Packages", this);
        prop = this.factory.createProperty(assoc, "extension", "A_ownedEnd_extension-extension", "Extension", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Extension-ownedEnd A_ownedEnd_extension-extension ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_158 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_invariant_stateInvariant", "A_invariant_stateInvariant");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "stateInvariant", "A_invariant_stateInvariant-stateInvariant", "StateInvariant", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateInvariant-invariant A_invariant_stateInvariant-stateInvariant ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_159 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_covered_stateInvariant", "A_covered_stateInvariant");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "stateInvariant", "A_covered_stateInvariant-stateInvariant", "StateInvariant", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateInvariant-covered A_covered_stateInvariant-stateInvariant ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_160 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_covered_events", "A_covered_events");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "events", "A_covered_events-events", "OccurrenceSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "OccurrenceSpecification-covered A_covered_events-events ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_161 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_toBefore_after", "A_toBefore_after");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        this.factory.createAssociationEnds(assoc, "OccurrenceSpecification-toBefore GeneralOrdering-after ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_162 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_message_messageEnd", "A_message_messageEnd");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "messageEnd", "A_message_messageEnd-messageEnd", "MessageEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "MessageEnd-message A_message_messageEnd-messageEnd ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_163 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signature_message", "A_signature_message");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "message", "A_signature_message-message", "Message", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Message-signature A_signature_message-message ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_164 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connector_message", "A_connector_message");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "message", "A_connector_message-message", "Message", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Message-connector A_connector_message-message ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_165 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_receiveEvent_endMessage", "A_receiveEvent_endMessage");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "endMessage", "A_receiveEvent_endMessage-endMessage", "Message", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Message-receiveEvent A_receiveEvent_endMessage-endMessage ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_166 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_sendEvent_endMessage", "A_sendEvent_endMessage");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "endMessage", "A_sendEvent_endMessage-endMessage", "Message", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Message-sendEvent A_sendEvent_endMessage-endMessage ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_167 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_argument_message", "A_argument_message");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "message", "A_argument_message-message", "Message", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Message-argument A_argument_message-message ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_168 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_selector_lifeline", "A_selector_lifeline");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "lifeline", "A_selector_lifeline-lifeline", "Lifeline", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Lifeline-selector A_selector_lifeline-lifeline ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_169 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decomposedAs_lifeline", "A_decomposedAs_lifeline");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "lifeline", "A_decomposedAs_lifeline-lifeline", "Lifeline", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Lifeline-decomposedAs A_decomposedAs_lifeline-lifeline ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_170 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_represents_lifeline", "A_represents_lifeline");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "lifeline", "A_represents_lifeline-lifeline", "Lifeline", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Lifeline-represents A_represents_lifeline-lifeline ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_171 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnValueRecipient_interactionUse", "A_returnValueRecipient_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "A_returnValueRecipient_interactionUse-interactionUse", "InteractionUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionUse-returnValueRecipient A_returnValueRecipient_interactionUse-interactionUse ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_172 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_refersTo_interactionUse", "A_refersTo_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "A_refersTo_interactionUse-interactionUse", "InteractionUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionUse-refersTo A_refersTo_interactionUse-interactionUse ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_173 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnValue_interactionUse", "A_returnValue_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "A_returnValue_interactionUse-interactionUse", "InteractionUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionUse-returnValue A_returnValue_interactionUse-interactionUse ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_174 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_argument_interactionUse", "A_argument_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "A_argument_interactionUse-interactionUse", "InteractionUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionUse-argument A_argument_interactionUse-interactionUse ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_175 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_actualGate_interactionUse", "A_actualGate_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "A_actualGate_interactionUse-interactionUse", "InteractionUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionUse-actualGate A_actualGate_interactionUse-interactionUse ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_176 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_fragment_enclosingOperand", "A_fragment_enclosingOperand");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        this.factory.createAssociationEnds(assoc, "InteractionOperand-fragment InteractionFragment-enclosingOperand ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_177 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_guard_interactionOperand", "A_guard_interactionOperand");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionOperand", "A_guard_interactionOperand-interactionOperand", "InteractionOperand", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionOperand-guard A_guard_interactionOperand-interactionOperand ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_178 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalOrdering_interactionFragment", "A_generalOrdering_interactionFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionFragment", "A_generalOrdering_interactionFragment-interactionFragment", "InteractionFragment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionFragment-generalOrdering A_generalOrdering_interactionFragment-interactionFragment ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_179 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_covered_coveredBy", "A_covered_coveredBy");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        this.factory.createAssociationEnds(assoc, "InteractionFragment-covered Lifeline-coveredBy ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_180 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_minint_interactionConstraint", "A_minint_interactionConstraint");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionConstraint", "A_minint_interactionConstraint-interactionConstraint", "InteractionConstraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionConstraint-minint A_minint_interactionConstraint-interactionConstraint ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_181 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_maxint_interactionConstraint", "A_maxint_interactionConstraint");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interactionConstraint", "A_maxint_interactionConstraint-interactionConstraint", "InteractionConstraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InteractionConstraint-maxint A_maxint_interactionConstraint-interactionConstraint ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_182 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_action_interaction", "A_action_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interaction", "A_action_interaction-interaction", "Interaction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interaction-action A_action_interaction-interaction ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_183 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_formalGate_interaction", "A_formalGate_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "interaction", "A_formalGate_interaction-interaction", "Interaction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interaction-formalGate A_formalGate_interaction-interaction ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_184 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_lifeline_interaction", "A_lifeline_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        this.factory.createAssociationEnds(assoc, "Interaction-lifeline Lifeline-interaction ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_185 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_fragment_enclosingInteraction", "A_fragment_enclosingInteraction");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        this.factory.createAssociationEnds(assoc, "Interaction-fragment InteractionFragment-enclosingInteraction ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_186 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_message_interaction", "A_message_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        this.factory.createAssociationEnds(assoc, "Interaction-message Message-interaction ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_187 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_before_toAfter", "A_before_toAfter");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        this.factory.createAssociationEnds(assoc, "GeneralOrdering-before OccurrenceSpecification-toAfter ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_188 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_finish_executionSpecification", "A_finish_executionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "executionSpecification", "A_finish_executionSpecification-executionSpecification", "ExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ExecutionSpecification-finish A_finish_executionSpecification-executionSpecification ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_189 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_start_executionSpecification", "A_start_executionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "executionSpecification", "A_start_executionSpecification-executionSpecification", "ExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ExecutionSpecification-start A_start_executionSpecification-executionSpecification ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_190 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_execution_executionOccurrenceSpecification", "A_execution_executionOccurrenceSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "executionOccurrenceSpecification", "A_execution_executionOccurrenceSpecification-executionOccurrenceSpecification", "ExecutionOccurrenceSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ExecutionOccurrenceSpecification-execution A_execution_executionOccurrenceSpecification-executionOccurrenceSpecification ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_191 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_message_considerIgnoreFragment", "A_message_considerIgnoreFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "considerIgnoreFragment", "A_message_considerIgnoreFragment-considerIgnoreFragment", "ConsiderIgnoreFragment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ConsiderIgnoreFragment-message A_message_considerIgnoreFragment-considerIgnoreFragment ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_192 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_cfragmentGate_combinedFragment", "A_cfragmentGate_combinedFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "combinedFragment", "A_cfragmentGate_combinedFragment-combinedFragment", "CombinedFragment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CombinedFragment-cfragmentGate A_cfragmentGate_combinedFragment-combinedFragment ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_193 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operand_combinedFragment", "A_operand_combinedFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "combinedFragment", "A_operand_combinedFragment-combinedFragment", "CombinedFragment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CombinedFragment-operand A_operand_combinedFragment-combinedFragment ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_194 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_behavior_behaviorExecutionSpecification", "A_behavior_behaviorExecutionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "behaviorExecutionSpecification", "A_behavior_behaviorExecutionSpecification-behaviorExecutionSpecification", "BehaviorExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "BehaviorExecutionSpecification-behavior A_behavior_behaviorExecutionSpecification-behaviorExecutionSpecification ");
        packageId = this.artifact.getUrn() + "#" + "Interactions";
        Package cfr_ignored_195 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_action_actionExecutionSpecification", "A_action_actionExecutionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions", this);
        prop = this.factory.createProperty(assoc, "actionExecutionSpecification", "A_action_actionExecutionSpecification-actionExecutionSpecification", "ActionExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActionExecutionSpecification-action A_action_actionExecutionSpecification-actionExecutionSpecification ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_196 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_represented_representation", "A_represented_representation");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "representation", "A_represented_representation-representation", "InformationItem", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationItem-represented A_represented_representation-representation ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_197 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_conveyed_conveyingFlow", "A_conveyed_conveyingFlow");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "conveyingFlow", "A_conveyed_conveyingFlow-conveyingFlow", "InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationFlow-conveyed A_conveyed_conveyingFlow-conveyingFlow ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_198 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingActivityEdge_informationFlow", "A_realizingActivityEdge_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "A_realizingActivityEdge_informationFlow-informationFlow", "InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationFlow-realizingActivityEdge A_realizingActivityEdge_informationFlow-informationFlow ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_199 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingMessage_informationFlow", "A_realizingMessage_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "A_realizingMessage_informationFlow-informationFlow", "InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationFlow-realizingMessage A_realizingMessage_informationFlow-informationFlow ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_200 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_informationSource_informationFlow", "A_informationSource_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "A_informationSource_informationFlow-informationFlow", "InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationFlow-informationSource A_informationSource_informationFlow-informationFlow ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_201 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realization_abstraction_flow", "A_realization_abstraction_flow");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "abstraction", "A_realization_abstraction_flow-abstraction", "InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationFlow-realization A_realization_abstraction_flow-abstraction ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_202 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingConnector_informationFlow", "A_realizingConnector_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "A_realizingConnector_informationFlow-informationFlow", "InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationFlow-realizingConnector A_realizingConnector_informationFlow-informationFlow ");
        packageId = this.artifact.getUrn() + "#" + "InformationFlows";
        Package cfr_ignored_203 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_informationTarget_informationFlow", "A_informationTarget_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "A_informationTarget_informationFlow-informationFlow", "InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InformationFlow-informationTarget A_informationTarget_informationFlow-informationFlow ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_204 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedNode_node", "A_nestedNode_node");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "node", "A_nestedNode_node-node", "Node", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Node-nestedNode A_nestedNode_node-node ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_205 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_utilizedElement_manifestation", "A_utilizedElement_manifestation");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "manifestation", "A_utilizedElement_manifestation-manifestation", "Manifestation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Manifestation-utilizedElement A_utilizedElement_manifestation-manifestation ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_206 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deployedElement_deploymentTarget", "A_deployedElement_deploymentTarget");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "deploymentTarget", "A_deployedElement_deploymentTarget-deploymentTarget", "DeploymentTarget", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DeploymentTarget-deployedElement A_deployedElement_deploymentTarget-deploymentTarget ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_207 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deployment_location", "A_deployment_location");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        this.factory.createAssociationEnds(assoc, "DeploymentTarget-deployment Deployment-location ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_208 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deployedArtifact_deploymentForArtifact", "A_deployedArtifact_deploymentForArtifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "deploymentForArtifact", "A_deployedArtifact_deploymentForArtifact-deploymentForArtifact", "Deployment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployment-deployedArtifact A_deployedArtifact_deploymentForArtifact-deploymentForArtifact ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_209 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_configuration_deployment", "A_configuration_deployment");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        this.factory.createAssociationEnds(assoc, "Deployment-configuration DeploymentSpecification-deployment ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_210 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_artifact", "A_ownedAttribute_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "artifact", "A_ownedAttribute_artifact-artifact", "Artifact", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Artifact-ownedAttribute A_ownedAttribute_artifact-artifact ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_211 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_artifact", "A_ownedOperation_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "artifact", "A_ownedOperation_artifact-artifact", "Artifact", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Artifact-ownedOperation A_ownedOperation_artifact-artifact ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_212 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedArtifact_artifact", "A_nestedArtifact_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "artifact", "A_nestedArtifact_artifact-artifact", "Artifact", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Artifact-nestedArtifact A_nestedArtifact_artifact-artifact ");
        packageId = this.artifact.getUrn() + "#" + "Deployments";
        Package cfr_ignored_213 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_manifestation_artifact", "A_manifestation_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments", this);
        prop = this.factory.createProperty(assoc, "artifact", "A_manifestation_artifact-artifact", "Artifact", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Artifact-manifestation A_manifestation_artifact-artifact ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_214 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_typedElement", "A_type_typedElement");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "typedElement", "A_type_typedElement-typedElement", "TypedElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TypedElement-type A_type_typedElement-typedElement ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_215 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_signature", "A_ownedParameter_signature");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "TemplateSignature-ownedParameter TemplateParameter-signature ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_216 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameter_templateSignature", "A_parameter_templateSignature");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "templateSignature", "A_parameter_templateSignature-templateSignature", "TemplateSignature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TemplateSignature-parameter A_parameter_templateSignature-templateSignature ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_217 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_actual_templateParameterSubstitution", "A_actual_templateParameterSubstitution");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "templateParameterSubstitution", "A_actual_templateParameterSubstitution-templateParameterSubstitution", "TemplateParameterSubstitution", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TemplateParameterSubstitution-actual A_actual_templateParameterSubstitution-templateParameterSubstitution ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_218 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedActual_owningTemplateParameterSubstitution", "A_ownedActual_owningTemplateParameterSubstitution");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "owningTemplateParameterSubstitution", "A_ownedActual_owningTemplateParameterSubstitution-owningTemplateParameterSubstitution", "TemplateParameterSubstitution", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TemplateParameterSubstitution-ownedActual A_ownedActual_owningTemplateParameterSubstitution-owningTemplateParameterSubstitution ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_219 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_formal_templateParameterSubstitution", "A_formal_templateParameterSubstitution");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "templateParameterSubstitution", "A_formal_templateParameterSubstitution-templateParameterSubstitution", "TemplateParameterSubstitution", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TemplateParameterSubstitution-formal A_formal_templateParameterSubstitution-templateParameterSubstitution ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_220 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedDefault_templateParameter", "A_ownedDefault_templateParameter");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "templateParameter", "A_ownedDefault_templateParameter-templateParameter", "TemplateParameter", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TemplateParameter-ownedDefault A_ownedDefault_templateParameter-templateParameter ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_221 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameteredElement_owningTemplateParameter", "A_ownedParameteredElement_owningTemplateParameter");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "TemplateParameter-ownedParameteredElement ParameterableElement-owningTemplateParameter ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_222 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_default_templateParameter", "A_default_templateParameter");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "templateParameter", "A_default_templateParameter-templateParameter", "TemplateParameter", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TemplateParameter-default A_default_templateParameter-templateParameter ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_223 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameteredElement_templateParameter", "A_parameteredElement_templateParameter");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "TemplateParameter-parameteredElement ParameterableElement-templateParameter ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_224 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signature_templateBinding", "A_signature_templateBinding");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "templateBinding", "A_signature_templateBinding-templateBinding", "TemplateBinding", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TemplateBinding-signature A_signature_templateBinding-templateBinding ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_225 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameterSubstitution_templateBinding", "A_parameterSubstitution_templateBinding");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "TemplateBinding-parameterSubstitution TemplateParameterSubstitution-templateBinding ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_226 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_templateBinding_boundElement", "A_templateBinding_boundElement");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "TemplateableElement-templateBinding TemplateBinding-boundElement ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_227 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedTemplateSignature_template", "A_ownedTemplateSignature_template");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "TemplateableElement-ownedTemplateSignature TemplateSignature-template ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_228 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_relatedElement_relationship", "A_relatedElement_relationship");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "relationship", "A_relatedElement_relationship-relationship", "Relationship", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Relationship-relatedElement A_relatedElement_relationship-relationship ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_229 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedPackage_packageImport", "A_importedPackage_packageImport");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "packageImport", "A_importedPackage_packageImport-packageImport", "PackageImport", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "PackageImport-importedPackage A_importedPackage_packageImport-packageImport ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_230 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_elementImport_importingNamespace", "A_elementImport_importingNamespace");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "Namespace-elementImport ElementImport-importingNamespace ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_231 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedMember_namespace", "A_ownedMember_namespace");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "Namespace-ownedMember NamedElement-namespace ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_232 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedRule_context", "A_ownedRule_context");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "Namespace-ownedRule Constraint-context ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_233 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packageImport_importingNamespace", "A_packageImport_importingNamespace");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "Namespace-packageImport PackageImport-importingNamespace ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_234 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_member_memberNamespace", "A_member_memberNamespace");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "memberNamespace", "A_member_memberNamespace-memberNamespace", "Namespace", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Namespace-member A_member_memberNamespace-memberNamespace ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_235 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedMember_namespace", "A_importedMember_namespace");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "namespace", "A_importedMember_namespace-namespace", "Namespace", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Namespace-importedMember A_importedMember_namespace-namespace ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_236 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nameExpression_namedElement", "A_nameExpression_namedElement");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "namedElement", "A_nameExpression_namedElement-namedElement", "NamedElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "NamedElement-nameExpression A_nameExpression_namedElement-namedElement ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_237 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_clientDependency_client", "A_clientDependency_client");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "NamedElement-clientDependency Dependency-client ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_238 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_lowerValue_owningLower", "A_lowerValue_owningLower");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "owningLower", "A_lowerValue_owningLower-owningLower", "MultiplicityElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "MultiplicityElement-lowerValue A_lowerValue_owningLower-owningLower ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_239 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_upperValue_owningUpper", "A_upperValue_owningUpper");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "owningUpper", "A_upperValue_owningUpper-owningUpper", "MultiplicityElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "MultiplicityElement-upperValue A_upperValue_owningUpper-owningUpper ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_240 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedElement_import", "A_importedElement_import");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "import", "A_importedElement_import-import", "ElementImport", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ElementImport-importedElement A_importedElement_import-import ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_241 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedElement_owner", "A_ownedElement_owner");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        this.factory.createAssociationEnds(assoc, "Element-ownedElement Element-owner ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_242 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedComment_owningElement", "A_ownedComment_owningElement");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "owningElement", "A_ownedComment_owningElement-owningElement", "Element", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Element-ownedComment A_ownedComment_owningElement-owningElement ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_243 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_source_directedRelationship", "A_source_directedRelationship");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "A_source_directedRelationship-directedRelationship", "DirectedRelationship", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DirectedRelationship-source A_source_directedRelationship-directedRelationship ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_244 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_directedRelationship", "A_target_directedRelationship");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "A_target_directedRelationship-directedRelationship", "DirectedRelationship", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DirectedRelationship-target A_target_directedRelationship-directedRelationship ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_245 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_supplier_supplierDependency", "A_supplier_supplierDependency");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "supplierDependency", "A_supplier_supplierDependency-supplierDependency", "Dependency", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Dependency-supplier A_supplier_supplierDependency-supplierDependency ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_246 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_constrainedElement_constraint", "A_constrainedElement_constraint");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "constraint", "A_constrainedElement_constraint-constraint", "Constraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Constraint-constrainedElement A_constrainedElement_constraint-constraint ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_247 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_owningConstraint", "A_specification_owningConstraint");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "owningConstraint", "A_specification_owningConstraint-owningConstraint", "Constraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Constraint-specification A_specification_owningConstraint-owningConstraint ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_248 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_annotatedElement_comment", "A_annotatedElement_comment");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "comment", "A_annotatedElement_comment-comment", "Comment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Comment-annotatedElement A_annotatedElement_comment-comment ");
        packageId = this.artifact.getUrn() + "#" + "CommonStructure";
        Package cfr_ignored_249 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_mapping_abstraction", "A_mapping_abstraction");
        this.mapping.mapAssociation(assoc, "UML.CommonStructure", this);
        prop = this.factory.createProperty(assoc, "abstraction", "A_mapping_abstraction-abstraction", "Abstraction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Abstraction-mapping A_mapping_abstraction-abstraction ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_250 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_event_trigger", "A_event_trigger");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "trigger", "A_event_trigger-trigger", "Trigger", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Trigger-event A_event_trigger-trigger ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_251 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_port_trigger", "A_port_trigger");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "trigger", "A_port_trigger-trigger", "Trigger", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Trigger-port A_port_trigger-trigger ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_252 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_when_timeEvent", "A_when_timeEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "timeEvent", "A_when_timeEvent-timeEvent", "TimeEvent", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TimeEvent-when A_when_timeEvent-timeEvent ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_253 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_signalEvent", "A_signal_signalEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "signalEvent", "A_signal_signalEvent-signalEvent", "SignalEvent", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "SignalEvent-signal A_signal_signalEvent-signalEvent ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_254 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_changeExpression_changeEvent", "A_changeExpression_changeEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "changeEvent", "A_changeExpression_changeEvent-changeEvent", "ChangeEvent", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ChangeEvent-changeExpression A_changeExpression_changeEvent-changeEvent ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_255 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operation_callEvent", "A_operation_callEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "callEvent", "A_operation_callEvent-callEvent", "CallEvent", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CallEvent-operation A_operation_callEvent-callEvent ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_256 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameterSet_behavior", "A_ownedParameterSet_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "behavior", "A_ownedParameterSet_behavior-behavior", "Behavior", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Behavior-ownedParameterSet A_ownedParameterSet_behavior-behavior ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_257 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_context_behavior", "A_context_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "behavior", "A_context_behavior-behavior", "Behavior", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Behavior-context A_context_behavior-behavior ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_258 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_precondition_behavior", "A_precondition_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "behavior", "A_precondition_behavior-behavior", "Behavior", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Behavior-precondition A_precondition_behavior-behavior ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_259 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_postcondition_behavior", "A_postcondition_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "behavior", "A_postcondition_behavior-behavior", "Behavior", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Behavior-postcondition A_postcondition_behavior-behavior ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_260 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedBehavior_behavior", "A_redefinedBehavior_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "behavior", "A_redefinedBehavior_behavior-behavior", "Behavior", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Behavior-redefinedBehavior A_redefinedBehavior_behavior-behavior ");
        packageId = this.artifact.getUrn() + "#" + "CommonBehavior";
        Package cfr_ignored_261 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_behavior", "A_ownedParameter_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehavior", this);
        prop = this.factory.createProperty(assoc, "behavior", "A_ownedParameter_behavior-behavior", "Behavior", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Behavior-ownedParameter A_ownedParameter_behavior-behavior ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_262 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_definingFeature_slot", "A_definingFeature_slot");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "slot", "A_definingFeature_slot-slot", "Slot", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Slot-definingFeature A_definingFeature_slot-slot ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_263 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_owningSlot", "A_value_owningSlot");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "owningSlot", "A_value_owningSlot-owningSlot", "Slot", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Slot-value A_value_owningSlot-owningSlot ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_264 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedSignature_redefinableTemplateSignature", "A_extendedSignature_redefinableTemplateSignature");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "redefinableTemplateSignature", "A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature", "RedefinableTemplateSignature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "RedefinableTemplateSignature-extendedSignature A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_265 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inheritedParameter_redefinableTemplateSignature", "A_inheritedParameter_redefinableTemplateSignature");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "redefinableTemplateSignature", "A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature", "RedefinableTemplateSignature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "RedefinableTemplateSignature-inheritedParameter A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_266 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_redefinableElement", "A_redefinitionContext_redefinableElement");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "A_redefinitionContext_redefinableElement-redefinableElement", "RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "RedefinableElement-redefinitionContext A_redefinitionContext_redefinableElement-redefinableElement ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_267 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedElement_redefinableElement", "A_redefinedElement_redefinableElement");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "A_redefinedElement_redefinableElement-redefinableElement", "RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "RedefinableElement-redefinedElement A_redefinedElement_redefinableElement-redefinableElement ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_268 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_associationEnd", "A_qualifier_associationEnd");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Property-qualifier Property-associationEnd ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_269 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedProperty_property", "A_redefinedProperty_property");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "property", "A_redefinedProperty_property-property", "Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Property-redefinedProperty A_redefinedProperty_property-property ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_270 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_defaultValue_owningProperty", "A_defaultValue_owningProperty");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "owningProperty", "A_defaultValue_owningProperty-owningProperty", "Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Property-defaultValue A_defaultValue_owningProperty-owningProperty ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_271 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_opposite_property", "A_opposite_property");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "property", "A_opposite_property-property", "Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Property-opposite A_opposite_property-property ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_272 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subsettedProperty_property", "A_subsettedProperty_property");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "property", "A_subsettedProperty_property-property", "Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Property-subsettedProperty A_subsettedProperty_property-property ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_273 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_condition_parameterSet", "A_condition_parameterSet");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "parameterSet", "A_condition_parameterSet-parameterSet", "ParameterSet", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ParameterSet-condition A_condition_parameterSet-parameterSet ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_274 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameterSet_parameter", "A_parameterSet_parameter");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Parameter-parameterSet ParameterSet-parameter ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_275 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_defaultValue_owningParameter", "A_defaultValue_owningParameter");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "owningParameter", "A_defaultValue_owningParameter-owningParameter", "Parameter", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Parameter-defaultValue A_defaultValue_owningParameter-owningParameter ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_276 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_operation", "A_type_operation");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "operation", "A_type_operation-operation", "Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Operation-type A_type_operation-operation ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_277 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operation_templateParameter_parameteredElement", "A_operation_templateParameter_parameteredElement");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Operation-templateParameter OperationTemplateParameter-parameteredElement ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_278 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyCondition_bodyContext", "A_bodyCondition_bodyContext");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "bodyContext", "A_bodyCondition_bodyContext-bodyContext", "Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Operation-bodyCondition A_bodyCondition_bodyContext-bodyContext ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_279 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_postcondition_postContext", "A_postcondition_postContext");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "postContext", "A_postcondition_postContext-postContext", "Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Operation-postcondition A_postcondition_postContext-postContext ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_280 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedOperation_operation", "A_redefinedOperation_operation");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "operation", "A_redefinedOperation_operation-operation", "Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Operation-redefinedOperation A_redefinedOperation_operation-operation ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_281 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_raisedException_operation", "A_raisedException_operation");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "operation", "A_raisedException_operation-operation", "Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Operation-raisedException A_raisedException_operation-operation ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_282 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_precondition_preContext", "A_precondition_preContext");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "preContext", "A_precondition_preContext-preContext", "Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Operation-precondition A_precondition_preContext-preContext ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_283 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_operation", "A_ownedParameter_operation");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Operation-ownedParameter Parameter-operation ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_284 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_instance_instanceValue", "A_instance_instanceValue");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "instanceValue", "A_instance_instanceValue-instanceValue", "InstanceValue", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InstanceValue-instance A_instance_instanceValue-instanceValue ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_285 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_instanceSpecification", "A_classifier_instanceSpecification");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "instanceSpecification", "A_classifier_instanceSpecification-instanceSpecification", "InstanceSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InstanceSpecification-classifier A_classifier_instanceSpecification-instanceSpecification ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_286 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_slot_owningInstance", "A_slot_owningInstance");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "InstanceSpecification-slot Slot-owningInstance ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_287 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_owningInstanceSpec", "A_specification_owningInstanceSpec");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "owningInstanceSpec", "A_specification_owningInstanceSpec-owningInstanceSpec", "InstanceSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InstanceSpecification-specification A_specification_owningInstanceSpec-owningInstanceSpec ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_288 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalizationSet_generalization", "A_generalizationSet_generalization");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Generalization-generalizationSet GeneralizationSet-generalization ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_289 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_generalization", "A_general_generalization");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "generalization", "A_general_generalization-generalization", "Generalization", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Generalization-general A_general_generalization-generalization ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_290 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_constrainingClassifier_classifierTemplateParameter", "A_constrainingClassifier_classifierTemplateParameter");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "classifierTemplateParameter", "A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter", "ClassifierTemplateParameter", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ClassifierTemplateParameter-constrainingClassifier A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_291 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_templateParameter_parameteredElement", "A_classifier_templateParameter_parameteredElement");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Classifier-templateParameter ClassifierTemplateParameter-parameteredElement ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_292 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_powertypeExtent_powertype", "A_powertypeExtent_powertype");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Classifier-powertypeExtent GeneralizationSet-powertype ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_293 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalization_specific", "A_generalization_specific");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Classifier-generalization Generalization-specific ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_294 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_classifier", "A_general_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "classifier", "A_general_classifier-classifier", "Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classifier-general A_general_classifier-classifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_295 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_feature_featuringClassifier", "A_feature_featuringClassifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Classifier-feature Feature-featuringClassifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_296 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_substitution_substitutingClassifier", "A_substitution_substitutingClassifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Classifier-substitution Substitution-substitutingClassifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_297 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_representation_classifier", "A_representation_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "classifier", "A_representation_classifier-classifier", "Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classifier-representation A_representation_classifier-classifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_298 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedTemplateSignature_classifier", "A_ownedTemplateSignature_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "Classifier-ownedTemplateSignature RedefinableTemplateSignature-classifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_299 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inheritedMember_inheritingClassifier", "A_inheritedMember_inheritingClassifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "inheritingClassifier", "A_inheritedMember_inheritingClassifier-inheritingClassifier", "Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classifier-inheritedMember A_inheritedMember_inheritingClassifier-inheritingClassifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_300 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedClassifier_classifier", "A_redefinedClassifier_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "classifier", "A_redefinedClassifier_classifier-classifier", "Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classifier-redefinedClassifier A_redefinedClassifier_classifier-classifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_301 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_collaborationUse_classifier", "A_collaborationUse_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "classifier", "A_collaborationUse_classifier-classifier", "Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classifier-collaborationUse A_collaborationUse_classifier-classifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_302 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_attribute_classifier", "A_attribute_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "classifier", "A_attribute_classifier-classifier", "Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classifier-attribute A_attribute_classifier-classifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_303 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedUseCase_classifier", "A_ownedUseCase_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "classifier", "A_ownedUseCase_classifier-classifier", "Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classifier-ownedUseCase A_ownedUseCase_classifier-classifier ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_304 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_ownerFormalParam", "A_ownedParameter_ownerFormalParam");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "ownerFormalParam", "A_ownedParameter_ownerFormalParam-ownerFormalParam", "BehavioralFeature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "BehavioralFeature-ownedParameter A_ownedParameter_ownerFormalParam-ownerFormalParam ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_305 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_raisedException_behavioralFeature", "A_raisedException_behavioralFeature");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "behavioralFeature", "A_raisedException_behavioralFeature-behavioralFeature", "BehavioralFeature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "BehavioralFeature-raisedException A_raisedException_behavioralFeature-behavioralFeature ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_306 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameterSet_behavioralFeature", "A_ownedParameterSet_behavioralFeature");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "behavioralFeature", "A_ownedParameterSet_behavioralFeature-behavioralFeature", "BehavioralFeature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "BehavioralFeature-ownedParameterSet A_ownedParameterSet_behavioralFeature-behavioralFeature ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_307 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_method_specification", "A_method_specification");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        this.factory.createAssociationEnds(assoc, "BehavioralFeature-method Behavior-specification ");
        packageId = this.artifact.getUrn() + "#" + "Classification";
        Package cfr_ignored_308 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_contract_substitution", "A_contract_substitution");
        this.mapping.mapAssociation(assoc, "UML.Classification", this);
        prop = this.factory.createProperty(assoc, "substitution", "A_contract_substitution-substitution", "Substitution", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Substitution-contract A_contract_substitution-substitution ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_309 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_valuePin", "A_value_valuePin");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "valuePin", "A_value_valuePin-valuePin", "ValuePin", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ValuePin-value A_value_valuePin-valuePin ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_310 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_unmarshallAction", "A_result_unmarshallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "unmarshallAction", "A_result_unmarshallAction-unmarshallAction", "UnmarshallAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UnmarshallAction-result A_result_unmarshallAction-unmarshallAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_311 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_unmarshallType_unmarshallAction", "A_unmarshallType_unmarshallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "unmarshallAction", "A_unmarshallType_unmarshallAction-unmarshallAction", "UnmarshallAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UnmarshallAction-unmarshallType A_unmarshallType_unmarshallAction-unmarshallAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_312 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_unmarshallAction", "A_object_unmarshallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "unmarshallAction", "A_object_unmarshallAction-unmarshallAction", "UnmarshallAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UnmarshallAction-object A_object_unmarshallAction-unmarshallAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_313 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_first_testIdentityAction", "A_first_testIdentityAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "testIdentityAction", "A_first_testIdentityAction-testIdentityAction", "TestIdentityAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TestIdentityAction-first A_first_testIdentityAction-testIdentityAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_314 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_second_testIdentityAction", "A_second_testIdentityAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "testIdentityAction", "A_second_testIdentityAction-testIdentityAction", "TestIdentityAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TestIdentityAction-second A_second_testIdentityAction-testIdentityAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_315 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_testIdentityAction", "A_result_testIdentityAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "testIdentityAction", "A_result_testIdentityAction-testIdentityAction", "TestIdentityAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "TestIdentityAction-result A_result_testIdentityAction-testIdentityAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_316 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuredNodeOutput_structuredActivityNode", "A_structuredNodeOutput_structuredActivityNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "structuredActivityNode", "A_structuredNodeOutput_structuredActivityNode-structuredActivityNode", "StructuredActivityNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuredActivityNode-structuredNodeOutput A_structuredNodeOutput_structuredActivityNode-structuredActivityNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_317 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuredNodeInput_structuredActivityNode", "A_structuredNodeInput_structuredActivityNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "structuredActivityNode", "A_structuredNodeInput_structuredActivityNode-structuredActivityNode", "StructuredActivityNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuredActivityNode-structuredNodeInput A_structuredNodeInput_structuredActivityNode-structuredActivityNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_318 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_edge_inStructuredNode", "A_edge_inStructuredNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        this.factory.createAssociationEnds(assoc, "StructuredActivityNode-edge ActivityEdge-inStructuredNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_319 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_node_inStructuredNode", "A_node_inStructuredNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        this.factory.createAssociationEnds(assoc, "StructuredActivityNode-node ActivityNode-inStructuredNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_320 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_variable_scope", "A_variable_scope");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        this.factory.createAssociationEnds(assoc, "StructuredActivityNode-variable Variable-scope ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_321 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_structuralFeatureAction", "A_object_structuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "structuralFeatureAction", "A_object_structuralFeatureAction-structuralFeatureAction", "StructuralFeatureAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuralFeatureAction-object A_object_structuralFeatureAction-structuralFeatureAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_322 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuralFeature_structuralFeatureAction", "A_structuralFeature_structuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "structuralFeatureAction", "A_structuralFeature_structuralFeatureAction-structuralFeatureAction", "StructuralFeatureAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StructuralFeatureAction-structuralFeature A_structuralFeature_structuralFeatureAction-structuralFeatureAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_323 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_startObjectBehaviorAction", "A_object_startObjectBehaviorAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "startObjectBehaviorAction", "A_object_startObjectBehaviorAction-startObjectBehaviorAction", "StartObjectBehaviorAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StartObjectBehaviorAction-object A_object_startObjectBehaviorAction-startObjectBehaviorAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_324 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_startClassifierBehaviorAction", "A_object_startClassifierBehaviorAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "startClassifierBehaviorAction", "A_object_startClassifierBehaviorAction-startClassifierBehaviorAction", "StartClassifierBehaviorAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StartClassifierBehaviorAction-object A_object_startClassifierBehaviorAction-startClassifierBehaviorAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_325 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_executableNode_sequenceNode", "A_executableNode_sequenceNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "sequenceNode", "A_executableNode_sequenceNode-sequenceNode", "SequenceNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "SequenceNode-executableNode A_executableNode_sequenceNode-sequenceNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_326 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_sendSignalAction", "A_signal_sendSignalAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "sendSignalAction", "A_signal_sendSignalAction-sendSignalAction", "SendSignalAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "SendSignalAction-signal A_signal_sendSignalAction-sendSignalAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_327 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_sendSignalAction", "A_target_sendSignalAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "sendSignalAction", "A_target_sendSignalAction-sendSignalAction", "SendSignalAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "SendSignalAction-target A_target_sendSignalAction-sendSignalAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_328 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_request_sendObjectAction", "A_request_sendObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "sendObjectAction", "A_request_sendObjectAction-sendObjectAction", "SendObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "SendObjectAction-request A_request_sendObjectAction-sendObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_329 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_sendObjectAction", "A_target_sendObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "sendObjectAction", "A_target_sendObjectAction-sendObjectAction", "SendObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "SendObjectAction-target A_target_sendObjectAction-sendObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_330 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnInformation_replyAction", "A_returnInformation_replyAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "replyAction", "A_returnInformation_replyAction-replyAction", "ReplyAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReplyAction-returnInformation A_returnInformation_replyAction-replyAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_331 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_replyToCall_replyAction", "A_replyToCall_replyAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "replyAction", "A_replyToCall_replyAction-replyAction", "ReplyAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReplyAction-replyToCall A_replyToCall_replyAction-replyAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_332 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_replyValue_replyAction", "A_replyValue_replyAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "replyAction", "A_replyValue_replyAction-replyAction", "ReplyAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReplyAction-replyValue A_replyValue_replyAction-replyAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_333 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_removeAt_removeVariableValueAction", "A_removeAt_removeVariableValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "removeVariableValueAction", "A_removeAt_removeVariableValueAction-removeVariableValueAction", "RemoveVariableValueAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "RemoveVariableValueAction-removeAt A_removeAt_removeVariableValueAction-removeVariableValueAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_334 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_removeAt_removeStructuralFeatureValueAction", "A_removeAt_removeStructuralFeatureValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "removeStructuralFeatureValueAction", "A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction", "RemoveStructuralFeatureValueAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "RemoveStructuralFeatureValueAction-removeAt A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_335 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_collection_reduceAction", "A_collection_reduceAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "reduceAction", "A_collection_reduceAction-reduceAction", "ReduceAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReduceAction-collection A_collection_reduceAction-reduceAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_336 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_reducer_reduceAction", "A_reducer_reduceAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "reduceAction", "A_reducer_reduceAction-reduceAction", "ReduceAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReduceAction-reducer A_reducer_reduceAction-reduceAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_337 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_reduceAction", "A_result_reduceAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "reduceAction", "A_result_reduceAction-reduceAction", "ReduceAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReduceAction-result A_result_reduceAction-reduceAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_338 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_reclassifyObjectAction", "A_object_reclassifyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "reclassifyObjectAction", "A_object_reclassifyObjectAction-reclassifyObjectAction", "ReclassifyObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReclassifyObjectAction-object A_object_reclassifyObjectAction-reclassifyObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_339 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_newClassifier_reclassifyObjectAction", "A_newClassifier_reclassifyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "reclassifyObjectAction", "A_newClassifier_reclassifyObjectAction-reclassifyObjectAction", "ReclassifyObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReclassifyObjectAction-newClassifier A_newClassifier_reclassifyObjectAction-reclassifyObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_340 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_oldClassifier_reclassifyObjectAction", "A_oldClassifier_reclassifyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "reclassifyObjectAction", "A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction", "ReclassifyObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReclassifyObjectAction-oldClassifier A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_341 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readVariableAction", "A_result_readVariableAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readVariableAction", "A_result_readVariableAction-readVariableAction", "ReadVariableAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadVariableAction-result A_result_readVariableAction-readVariableAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_342 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readStructuralFeatureAction", "A_result_readStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readStructuralFeatureAction", "A_result_readStructuralFeatureAction-readStructuralFeatureAction", "ReadStructuralFeatureAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadStructuralFeatureAction-result A_result_readStructuralFeatureAction-readStructuralFeatureAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_343 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readSelfAction", "A_result_readSelfAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readSelfAction", "A_result_readSelfAction-readSelfAction", "ReadSelfAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadSelfAction-result A_result_readSelfAction-readSelfAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_344 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_readLinkObjectEndQualifierAction", "A_qualifier_readLinkObjectEndQualifierAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndQualifierAction", "A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction", "ReadLinkObjectEndQualifierAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadLinkObjectEndQualifierAction-qualifier A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_345 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_readLinkObjectEndQualifierAction", "A_object_readLinkObjectEndQualifierAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndQualifierAction", "A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction", "ReadLinkObjectEndQualifierAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadLinkObjectEndQualifierAction-object A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_346 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readLinkObjectEndQualifierAction", "A_result_readLinkObjectEndQualifierAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndQualifierAction", "A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction", "ReadLinkObjectEndQualifierAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadLinkObjectEndQualifierAction-result A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_347 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_readLinkObjectEndAction", "A_object_readLinkObjectEndAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndAction", "A_object_readLinkObjectEndAction-readLinkObjectEndAction", "ReadLinkObjectEndAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadLinkObjectEndAction-object A_object_readLinkObjectEndAction-readLinkObjectEndAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_348 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_readLinkObjectEndAction", "A_end_readLinkObjectEndAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndAction", "A_end_readLinkObjectEndAction-readLinkObjectEndAction", "ReadLinkObjectEndAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadLinkObjectEndAction-end A_end_readLinkObjectEndAction-readLinkObjectEndAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_349 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readLinkObjectEndAction", "A_result_readLinkObjectEndAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndAction", "A_result_readLinkObjectEndAction-readLinkObjectEndAction", "ReadLinkObjectEndAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadLinkObjectEndAction-result A_result_readLinkObjectEndAction-readLinkObjectEndAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_350 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readLinkAction", "A_result_readLinkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readLinkAction", "A_result_readLinkAction-readLinkAction", "ReadLinkAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadLinkAction-result A_result_readLinkAction-readLinkAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_351 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_readIsClassifiedObjectAction", "A_classifier_readIsClassifiedObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readIsClassifiedObjectAction", "A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction", "ReadIsClassifiedObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadIsClassifiedObjectAction-classifier A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_352 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readIsClassifiedObjectAction", "A_result_readIsClassifiedObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readIsClassifiedObjectAction", "A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction", "ReadIsClassifiedObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadIsClassifiedObjectAction-result A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_353 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_readIsClassifiedObjectAction", "A_object_readIsClassifiedObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readIsClassifiedObjectAction", "A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction", "ReadIsClassifiedObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadIsClassifiedObjectAction-object A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_354 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readExtentAction", "A_result_readExtentAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readExtentAction", "A_result_readExtentAction-readExtentAction", "ReadExtentAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadExtentAction-result A_result_readExtentAction-readExtentAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_355 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_readExtentAction", "A_classifier_readExtentAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "readExtentAction", "A_classifier_readExtentAction-readExtentAction", "ReadExtentAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ReadExtentAction-classifier A_classifier_readExtentAction-readExtentAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_356 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exception_raiseExceptionAction", "A_exception_raiseExceptionAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "raiseExceptionAction", "A_exception_raiseExceptionAction-raiseExceptionAction", "RaiseExceptionAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "RaiseExceptionAction-exception A_exception_raiseExceptionAction-raiseExceptionAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_357 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_qualifierValue", "A_qualifier_qualifierValue");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "qualifierValue", "A_qualifier_qualifierValue-qualifierValue", "QualifierValue", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "QualifierValue-qualifier A_qualifier_qualifierValue-qualifierValue ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_358 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_qualifierValue", "A_value_qualifierValue");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "qualifierValue", "A_value_qualifierValue-qualifierValue", "QualifierValue", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "QualifierValue-value A_value_qualifierValue-qualifierValue ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_359 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outputValue_opaqueAction", "A_outputValue_opaqueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "opaqueAction", "A_outputValue_opaqueAction-opaqueAction", "OpaqueAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "OpaqueAction-outputValue A_outputValue_opaqueAction-opaqueAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_360 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inputValue_opaqueAction", "A_inputValue_opaqueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "opaqueAction", "A_inputValue_opaqueAction-opaqueAction", "OpaqueAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "OpaqueAction-inputValue A_inputValue_opaqueAction-opaqueAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_361 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_setupPart_loopNode", "A_setupPart_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_setupPart_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-setupPart A_setupPart_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_362 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyPart_loopNode", "A_bodyPart_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_bodyPart_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-bodyPart A_bodyPart_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_363 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_loopVariable_loopNode", "A_loopVariable_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_loopVariable_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-loopVariable A_loopVariable_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_364 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_loopNode", "A_result_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_result_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-result A_result_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_365 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyOutput_loopNode", "A_bodyOutput_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_bodyOutput_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-bodyOutput A_bodyOutput_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_366 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_loopVariableInput_loopNode", "A_loopVariableInput_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_loopVariableInput_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-loopVariableInput A_loopVariableInput_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_367 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_test_loopNode", "A_test_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_test_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-test A_test_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_368 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decider_loopNode", "A_decider_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "loopNode", "A_decider_loopNode-loopNode", "LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LoopNode-decider A_decider_loopNode-loopNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_369 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_destroyAt_linkEndDestructionData", "A_destroyAt_linkEndDestructionData");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "linkEndDestructionData", "A_destroyAt_linkEndDestructionData-linkEndDestructionData", "LinkEndDestructionData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LinkEndDestructionData-destroyAt A_destroyAt_linkEndDestructionData-linkEndDestructionData ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_370 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_linkEndData", "A_value_linkEndData");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "linkEndData", "A_value_linkEndData-linkEndData", "LinkEndData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LinkEndData-value A_value_linkEndData-linkEndData ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_371 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_linkEndData", "A_end_linkEndData");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "linkEndData", "A_end_linkEndData-linkEndData", "LinkEndData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LinkEndData-end A_end_linkEndData-linkEndData ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_372 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_linkEndData", "A_qualifier_linkEndData");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "linkEndData", "A_qualifier_linkEndData-linkEndData", "LinkEndData", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LinkEndData-qualifier A_qualifier_linkEndData-linkEndData ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_373 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_insertAt_linkEndCreationData", "A_insertAt_linkEndCreationData");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "linkEndCreationData", "A_insertAt_linkEndCreationData-linkEndCreationData", "LinkEndCreationData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LinkEndCreationData-insertAt A_insertAt_linkEndCreationData-linkEndCreationData ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_374 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inputValue_linkAction", "A_inputValue_linkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "linkAction", "A_inputValue_linkAction-linkAction", "LinkAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LinkAction-inputValue A_inputValue_linkAction-linkAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_375 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endData_linkAction", "A_endData_linkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "linkAction", "A_endData_linkAction-linkAction", "LinkAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "LinkAction-endData A_endData_linkAction-linkAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_376 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_argument_invocationAction", "A_argument_invocationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "invocationAction", "A_argument_invocationAction-invocationAction", "InvocationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InvocationAction-argument A_argument_invocationAction-invocationAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_377 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_onPort_invocationAction", "A_onPort_invocationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "invocationAction", "A_onPort_invocationAction-invocationAction", "InvocationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "InvocationAction-onPort A_onPort_invocationAction-invocationAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_378 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inputElement_regionAsInput", "A_inputElement_regionAsInput");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        this.factory.createAssociationEnds(assoc, "ExpansionRegion-inputElement ExpansionNode-regionAsInput ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_379 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outputElement_regionAsOutput", "A_outputElement_regionAsOutput");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        this.factory.createAssociationEnds(assoc, "ExpansionRegion-outputElement ExpansionNode-regionAsOutput ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_380 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_destroyObjectAction", "A_target_destroyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "destroyObjectAction", "A_target_destroyObjectAction-destroyObjectAction", "DestroyObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DestroyObjectAction-target A_target_destroyObjectAction-destroyObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_381 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endData_destroyLinkAction", "A_endData_destroyLinkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "destroyLinkAction", "A_endData_destroyLinkAction-destroyLinkAction", "DestroyLinkAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "DestroyLinkAction-endData A_endData_destroyLinkAction-destroyLinkAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_382 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_createObjectAction", "A_classifier_createObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "createObjectAction", "A_classifier_createObjectAction-createObjectAction", "CreateObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CreateObjectAction-classifier A_classifier_createObjectAction-createObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_383 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_createObjectAction", "A_result_createObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "createObjectAction", "A_result_createObjectAction-createObjectAction", "CreateObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CreateObjectAction-result A_result_createObjectAction-createObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_384 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_createLinkObjectAction", "A_result_createLinkObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "createLinkObjectAction", "A_result_createLinkObjectAction-createLinkObjectAction", "CreateLinkObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CreateLinkObjectAction-result A_result_createLinkObjectAction-createLinkObjectAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_385 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endData_createLinkAction", "A_endData_createLinkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "createLinkAction", "A_endData_createLinkAction-createLinkAction", "CreateLinkAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CreateLinkAction-endData A_endData_createLinkAction-createLinkAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_386 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_clause_conditionalNode", "A_clause_conditionalNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "conditionalNode", "A_clause_conditionalNode-conditionalNode", "ConditionalNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ConditionalNode-clause A_clause_conditionalNode-conditionalNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_387 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_conditionalNode", "A_result_conditionalNode");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "conditionalNode", "A_result_conditionalNode-conditionalNode", "ConditionalNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ConditionalNode-result A_result_conditionalNode-conditionalNode ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_388 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_clearStructuralFeatureAction", "A_result_clearStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "clearStructuralFeatureAction", "A_result_clearStructuralFeatureAction-clearStructuralFeatureAction", "ClearStructuralFeatureAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ClearStructuralFeatureAction-result A_result_clearStructuralFeatureAction-clearStructuralFeatureAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_389 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_clearAssociationAction", "A_object_clearAssociationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "clearAssociationAction", "A_object_clearAssociationAction-clearAssociationAction", "ClearAssociationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ClearAssociationAction-object A_object_clearAssociationAction-clearAssociationAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_390 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_association_clearAssociationAction", "A_association_clearAssociationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "clearAssociationAction", "A_association_clearAssociationAction-clearAssociationAction", "ClearAssociationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ClearAssociationAction-association A_association_clearAssociationAction-clearAssociationAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_391 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decider_clause", "A_decider_clause");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "clause", "A_decider_clause-clause", "Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Clause-decider A_decider_clause-clause ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_392 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyOutput_clause", "A_bodyOutput_clause");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "clause", "A_bodyOutput_clause-clause", "Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Clause-bodyOutput A_bodyOutput_clause-clause ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_393 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_test_clause", "A_test_clause");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "clause", "A_test_clause-clause", "Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Clause-test A_test_clause-clause ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_394 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_body_clause", "A_body_clause");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "clause", "A_body_clause-clause", "Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Clause-body A_body_clause-clause ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_395 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_predecessorClause_successorClause", "A_predecessorClause_successorClause");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        this.factory.createAssociationEnds(assoc, "Clause-predecessorClause Clause-successorClause ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_396 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_callOperationAction", "A_target_callOperationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "callOperationAction", "A_target_callOperationAction-callOperationAction", "CallOperationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CallOperationAction-target A_target_callOperationAction-callOperationAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_397 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operation_callOperationAction", "A_operation_callOperationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "callOperationAction", "A_operation_callOperationAction-callOperationAction", "CallOperationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CallOperationAction-operation A_operation_callOperationAction-callOperationAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_398 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_behavior_callBehaviorAction", "A_behavior_callBehaviorAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "callBehaviorAction", "A_behavior_callBehaviorAction-callBehaviorAction", "CallBehaviorAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CallBehaviorAction-behavior A_behavior_callBehaviorAction-callBehaviorAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_399 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_callAction", "A_result_callAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "callAction", "A_result_callAction-callAction", "CallAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CallAction-result A_result_callAction-callAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_400 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_broadcastSignalAction", "A_signal_broadcastSignalAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "broadcastSignalAction", "A_signal_broadcastSignalAction-broadcastSignalAction", "BroadcastSignalAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "BroadcastSignalAction-signal A_signal_broadcastSignalAction-broadcastSignalAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_401 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_insertAt_addVariableValueAction", "A_insertAt_addVariableValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "addVariableValueAction", "A_insertAt_addVariableValueAction-addVariableValueAction", "AddVariableValueAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AddVariableValueAction-insertAt A_insertAt_addVariableValueAction-addVariableValueAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_402 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_insertAt_addStructuralFeatureValueAction", "A_insertAt_addStructuralFeatureValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "addStructuralFeatureValueAction", "A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction", "AddStructuralFeatureValueAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AddStructuralFeatureValueAction-insertAt A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_403 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_fromAction_actionInputPin", "A_fromAction_actionInputPin");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "actionInputPin", "A_fromAction_actionInputPin-actionInputPin", "ActionInputPin", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ActionInputPin-fromAction A_fromAction_actionInputPin-actionInputPin ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_404 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_output_action", "A_output_action");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "action", "A_output_action-action", "Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Action-output A_output_action-action ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_405 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_context_action", "A_context_action");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "action", "A_context_action-action", "Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Action-context A_context_action-action ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_406 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_input_action", "A_input_action");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "action", "A_input_action-action", "Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Action-input A_input_action-action ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_407 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_localPrecondition_action", "A_localPrecondition_action");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "action", "A_localPrecondition_action-action", "Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Action-localPrecondition A_localPrecondition_action-action ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_408 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_localPostcondition_action", "A_localPostcondition_action");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "action", "A_localPostcondition_action-action", "Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Action-localPostcondition A_localPostcondition_action-action ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_409 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_trigger_acceptEventAction", "A_trigger_acceptEventAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "acceptEventAction", "A_trigger_acceptEventAction-acceptEventAction", "AcceptEventAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AcceptEventAction-trigger A_trigger_acceptEventAction-acceptEventAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_410 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_acceptEventAction", "A_result_acceptEventAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "acceptEventAction", "A_result_acceptEventAction-acceptEventAction", "AcceptEventAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AcceptEventAction-result A_result_acceptEventAction-acceptEventAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_411 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnInformation_acceptCallAction", "A_returnInformation_acceptCallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "acceptCallAction", "A_returnInformation_acceptCallAction-acceptCallAction", "AcceptCallAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AcceptCallAction-returnInformation A_returnInformation_acceptCallAction-acceptCallAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_412 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_writeVariableAction", "A_value_writeVariableAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "writeVariableAction", "A_value_writeVariableAction-writeVariableAction", "WriteVariableAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "WriteVariableAction-value A_value_writeVariableAction-writeVariableAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_413 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_writeStructuralFeatureAction", "A_result_writeStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "writeStructuralFeatureAction", "A_result_writeStructuralFeatureAction-writeStructuralFeatureAction", "WriteStructuralFeatureAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "WriteStructuralFeatureAction-result A_result_writeStructuralFeatureAction-writeStructuralFeatureAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_414 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_writeStructuralFeatureAction", "A_value_writeStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "writeStructuralFeatureAction", "A_value_writeStructuralFeatureAction-writeStructuralFeatureAction", "WriteStructuralFeatureAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "WriteStructuralFeatureAction-value A_value_writeStructuralFeatureAction-writeStructuralFeatureAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_415 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_variable_variableAction", "A_variable_variableAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "variableAction", "A_variable_variableAction-variableAction", "VariableAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "VariableAction-variable A_variable_variableAction-variableAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_416 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_valueSpecificationAction", "A_result_valueSpecificationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "valueSpecificationAction", "A_result_valueSpecificationAction-valueSpecificationAction", "ValueSpecificationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ValueSpecificationAction-result A_result_valueSpecificationAction-valueSpecificationAction ");
        packageId = this.artifact.getUrn() + "#" + "Actions";
        Package cfr_ignored_417 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_valueSpecificationAction", "A_value_valueSpecificationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions", this);
        prop = this.factory.createProperty(assoc, "valueSpecificationAction", "A_value_valueSpecificationAction-valueSpecificationAction", "ValueSpecificationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "ValueSpecificationAction-value A_value_valueSpecificationAction-valueSpecificationAction ");
    }
}

