/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.activities;

import fuml.Debug;
import fuml.semantics.activities.ActivityEdgeInstance;
import fuml.semantics.activities.ActivityEdgeInstanceList;
import fuml.semantics.activities.ControlNodeActivation;
import fuml.semantics.activities.Token;
import fuml.semantics.activities.TokenList;
import fuml.semantics.commonbehavior.Execution;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.commonbehavior.ParameterValueList;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.activities.ActivityEdge;
import fuml.syntax.activities.DecisionNode;
import fuml.syntax.activities.ObjectFlow;
import fuml.syntax.classification.Parameter;
import fuml.syntax.classification.ParameterDirectionKind;
import fuml.syntax.commonbehavior.Behavior;
import fuml.syntax.values.ValueSpecification;

public class DecisionNodeActivation
extends ControlNodeActivation {
    public Execution decisionInputExecution = null;

    @Override
    public void fire(TokenList incomingTokens) {
        Debug.println("[fire] Decision node " + this.node.name + "...");
        TokenList removedControlTokens = this.removeJoinedControlTokens(incomingTokens);
        ValueList decisionValues = this.getDecisionValues(incomingTokens);
        ActivityEdgeInstanceList outgoingEdges = this.outgoingEdges;
        for (int i = 0; i < outgoingEdges.size(); ++i) {
            int j;
            ActivityEdgeInstance edgeInstance = outgoingEdges.getValue(i);
            ValueSpecification guard = edgeInstance.edge.guard;
            TokenList offeredTokens = new TokenList();
            for (j = 0; j < incomingTokens.size(); ++j) {
                Token incomingToken = incomingTokens.getValue(j);
                Value decisionValue = decisionValues.getValue(j);
                if (!this.test(guard, decisionValue)) continue;
                offeredTokens.addValue(incomingToken);
            }
            if (offeredTokens.size() <= 0) continue;
            for (j = 0; j < removedControlTokens.size(); ++j) {
                Token removedControlToken = removedControlTokens.getValue(j);
                offeredTokens.addValue(removedControlToken);
            }
            edgeInstance.sendOffer(offeredTokens);
        }
    }

    public ValueList getDecisionValues(TokenList incomingTokens) {
        int i;
        Value decisionInputValue = this.getDecisionInputFlowValue();
        ValueList decisionValues = new ValueList();
        for (i = 0; i < incomingTokens.size(); ++i) {
            Token incomingToken = incomingTokens.getValue(i);
            Value value = this.executeDecisionInputBehavior(incomingToken.getValue(), decisionInputValue);
            decisionValues.addValue(value);
        }
        for (i = 0; i < decisionValues.size(); ++i) {
            Value decisionValue = decisionValues.getValue(i);
            Debug.println("[getDecisionValues] decisionValues[" + i + "] = " + decisionValue);
        }
        return decisionValues;
    }

    public Value executeDecisionInputBehavior(Value inputValue, Value decisionInputValue) {
        Debug.println("[executeDecisionBehavior] inputValue = " + inputValue);
        Behavior decisionInputBehavior = ((DecisionNode)this.node).decisionInput;
        Value decisionInputResult = null;
        if (decisionInputBehavior == null) {
            decisionInputResult = decisionInputValue != null ? decisionInputValue : inputValue;
        } else {
            this.decisionInputExecution = this.getExecutionLocus().factory.createExecution(decisionInputBehavior, this.getExecutionContext());
            int i = 1;
            int j = 0;
            while ((j == 0 | j == 1 & decisionInputValue != null) & i <= decisionInputBehavior.ownedParameter.size()) {
                Parameter parameter = decisionInputBehavior.ownedParameter.getValue(i - 1);
                if (parameter.direction.equals((Object)ParameterDirectionKind.in) | parameter.direction.equals((Object)ParameterDirectionKind.inout)) {
                    ParameterValue inputParameterValue = new ParameterValue();
                    inputParameterValue.parameter = parameter;
                    if (++j == 1 && inputValue != null) {
                        inputParameterValue.values.addValue(inputValue);
                    } else {
                        inputParameterValue.values.addValue(decisionInputValue);
                    }
                    this.decisionInputExecution.setParameterValue(inputParameterValue);
                }
                ++i;
            }
            this.decisionInputExecution.execute();
            ParameterValueList outputParameterValues = this.decisionInputExecution.getOutputParameterValues();
            this.decisionInputExecution.destroy();
            decisionInputResult = outputParameterValues.getValue((int)0).values.getValue(0);
        }
        return decisionInputResult;
    }

    @Override
    public void terminate() {
        if (this.decisionInputExecution != null) {
            this.decisionInputExecution.terminate();
        }
        super.terminate();
    }

    @Override
    public boolean isReady() {
        int i = 1;
        boolean ready = true;
        while (ready & i <= this.incomingEdges.size()) {
            ready = this.incomingEdges.getValue(i - 1).hasOffer();
            ++i;
        }
        return ready;
    }

    @Override
    public TokenList takeOfferedTokens() {
        ObjectFlow decisionInputFlow = ((DecisionNode)this.node).decisionInputFlow;
        TokenList allTokens = new TokenList();
        ActivityEdgeInstanceList incomingEdges = this.incomingEdges;
        for (int i = 0; i < incomingEdges.size(); ++i) {
            ActivityEdgeInstance edgeInstance = incomingEdges.getValue(i);
            if (edgeInstance.edge == decisionInputFlow) continue;
            TokenList tokens = edgeInstance.takeOfferedTokens();
            for (int j = 0; j < tokens.size(); ++j) {
                allTokens.addValue(tokens.getValue(j));
            }
        }
        return allTokens;
    }

    public Value getDecisionInputFlowValue() {
        TokenList tokens;
        ActivityEdgeInstance decisionInputFlowInstance = this.getDecisionInputFlowInstance();
        Value value = null;
        if (decisionInputFlowInstance != null && (tokens = decisionInputFlowInstance.takeOfferedTokens()).size() > 0) {
            value = tokens.getValue(0).getValue();
        }
        return value;
    }

    public ActivityEdgeInstance getDecisionInputFlowInstance() {
        ObjectFlow decisionInputFlow = ((DecisionNode)this.node).decisionInputFlow;
        ActivityEdgeInstance edgeInstance = null;
        if (decisionInputFlow != null) {
            int i = 1;
            while (edgeInstance == null & i <= this.incomingEdges.size()) {
                ActivityEdgeInstance incomingEdge = this.incomingEdges.getValue(i - 1);
                if (incomingEdge.edge == decisionInputFlow) {
                    edgeInstance = incomingEdge;
                }
                ++i;
            }
        }
        return edgeInstance;
    }

    public boolean test(ValueSpecification guard, Value value) {
        boolean guardResult = true;
        if (guard != null) {
            Value guardValue = this.getExecutionLocus().executor.evaluate(guard);
            guardResult = guardValue.equals(value);
        }
        return guardResult;
    }

    public TokenList removeJoinedControlTokens(TokenList incomingTokens) {
        TokenList removedControlTokens = new TokenList();
        if (this.hasObjectFlowInput()) {
            for (int i = 1; i <= incomingTokens.size(); ++i) {
                Token token = incomingTokens.getValue(i - 1);
                if (!token.isControl()) continue;
                removedControlTokens.addValue(token);
                incomingTokens.removeValue(i - 1);
                --i;
            }
        }
        return removedControlTokens;
    }

    public boolean hasObjectFlowInput() {
        ObjectFlow decisionInputFlow = ((DecisionNode)this.node).decisionInputFlow;
        boolean isObjectFlow = false;
        int i = 1;
        while (!isObjectFlow & i <= this.incomingEdges.size()) {
            ActivityEdge edge = this.incomingEdges.getValue((int)(i - 1)).edge;
            isObjectFlow = edge != decisionInputFlow & edge instanceof ObjectFlow;
            ++i;
        }
        return isObjectFlow;
    }
}

