/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.config.ImportExemption;
import org.modeldriven.fuml.config.ImportExemptionType;
import org.modeldriven.fuml.config.NamespaceDomain;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiNodeVisitor;
import org.modeldriven.fuml.xmi.XmiNodeVisitorStatus;
import org.modeldriven.fuml.xmi.stream.StreamContext;
import org.modeldriven.fuml.xmi.stream.StreamLocation;

public class StreamNode
implements XmiNode {
    private static Log log = LogFactory.getLog(StreamNode.class);
    private XMLEvent startElementEvent;
    private List<XMLEvent> characterEvents;
    private StreamContext context;
    private Location location;
    private List<XmiNode> nodes;
    private XmiNode parent;

    private StreamNode() {
    }

    public StreamNode(XMLEvent startElement, XmiNode parent, StreamContext context) {
        this.startElementEvent = startElement;
        this.parent = parent;
        this.context = context;
        this.location = new StreamLocation(startElement.getLocation());
        if (log.isDebugEnabled()) {
            log.debug((Object)("created '" + this.getLocation() + "' node (" + this.getXmiId() + ")"));
        }
    }

    public StreamNode(XMLEvent startElement, StreamContext context) {
        this(startElement, null, context);
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getLocalName() {
        return this.startElementEvent.asStartElement().getName().getLocalPart();
    }

    @Override
    public String getNamespaceURI() {
        QName name = this.startElementEvent.asStartElement().getName();
        String uri = name.getNamespaceURI();
        if (uri == null || uri.trim().length() == 0) {
            return this.context.getDefaultNamespace().getNamespaceURI();
        }
        return name.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        QName name = this.startElementEvent.asStartElement().getName();
        String uri = name.getNamespaceURI();
        if (uri == null || uri.trim().length() == 0) {
            return this.context.getDefaultNamespace().getPrefix();
        }
        return name.getPrefix();
    }

    @Override
    public String getData() {
        if (this.characterEvents != null) {
            StringBuffer buf = new StringBuffer();
            Iterator<XMLEvent> events = this.characterEvents.iterator();
            while (events.hasNext()) {
                buf.append(events.next().asCharacters().getData());
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    public String getXmiType() {
        QName typeAttrib = new QName(this.context.getXmiNamespace().getNamespaceURI(), "type");
        Attribute attrib = this.startElementEvent.asStartElement().getAttributeByName(typeAttrib);
        if (attrib != null) {
            String value = attrib.getValue();
            return value.substring(this.context.getUmlNamespace().getPrefix().length() + 1);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(QName name) {
        Attribute attrib = this.startElementEvent.asStartElement().getAttributeByName(name);
        return attrib != null;
    }

    public boolean hasAttributes() {
        if (this.startElementEvent != null) {
            Iterator<Attribute> attributes = this.startElementEvent.asStartElement().getAttributes();
            return attributes.hasNext();
        }
        return false;
    }

    public Iterator<Attribute> getAttributes() {
        if (this.startElementEvent != null) {
            Iterator<Attribute> attributes = this.startElementEvent.asStartElement().getAttributes();
            return attributes;
        }
        return null;
    }

    public Attribute getAttribute(QName name) {
        if (this.startElementEvent != null) {
            Attribute attrib = this.startElementEvent.asStartElement().getAttributeByName(name);
            return attrib;
        }
        return null;
    }

    public Attribute getAttribute(String name) {
        if (this.startElementEvent != null) {
            Attribute attrib = this.startElementEvent.asStartElement().getAttributeByName(new QName(name));
            return attrib;
        }
        return null;
    }

    @Override
    public String getAttributeValue(QName name) {
        Attribute attrib;
        if (this.startElementEvent != null && (attrib = this.startElementEvent.asStartElement().getAttributeByName(name)) != null) {
            return attrib.getValue();
        }
        return null;
    }

    public String getAttributeValue(String name) {
        Attribute attrib;
        if (this.startElementEvent != null && (attrib = this.startElementEvent.asStartElement().getAttributeByName(new QName(name))) != null) {
            return attrib.getValue();
        }
        return null;
    }

    @Override
    public boolean hasXmiType() {
        String xmiType = this.getXmiType();
        return xmiType != null && xmiType.length() > 0;
    }

    @Override
    public String getXmiId() {
        QName typeAttrib = new QName(this.context.getXmiNamespace().getNamespaceURI(), "id");
        Attribute attrib = this.startElementEvent.asStartElement().getAttributeByName(typeAttrib);
        if (attrib != null) {
            String value = attrib.getValue();
            return value;
        }
        return null;
    }

    @Override
    public int getLineNumber() {
        return this.location.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.location.getColumnNumber();
    }

    public void add(StreamNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<XmiNode>();
        }
        this.nodes.add(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("added '" + node.getLocalName() + "' (" + node.getXmiId() + ") child node to " + this.getLocation() + "' parent node (" + this.getXmiId() + ")"));
        }
    }

    public XmiNode getParent() {
        return this.parent;
    }

    public void setParent(XmiNode parent) {
        this.parent = parent;
    }

    @Override
    public List<XmiNode> getNodes() {
        return this.nodes;
    }

    @Override
    public boolean hasNodes() {
        return this.nodes != null;
    }

    public XmiNode findChildByName(String name) {
        if (this.nodes != null) {
            for (XmiNode child : this.nodes) {
                if (!child.getLocalName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public XmiNode findChildById(String id) {
        if (this.nodes != null) {
            for (XmiNode child : this.nodes) {
                if (!child.getXmiId().equals(id)) continue;
                return child;
            }
        }
        return null;
    }

    public boolean removeChild(XmiNode child) {
        boolean removed = this.nodes.remove(child);
        if (log.isDebugEnabled()) {
            log.debug((Object)("removed '" + child.getLocalName() + "' (" + child.getXmiId() + ") child node to " + this.getLocation() + "' parent node (" + this.getXmiId() + ")"));
        }
        return removed;
    }

    public XMLEvent getStartElementEvent() {
        return this.startElementEvent;
    }

    @Override
    public void accept(XmiNodeVisitor visitor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getClass().getSimpleName());
        }
        this.accept(visitor, this, null, null, this, new HashMap<XmiNode, XmiNode>(), new XmiNodeVisitorStatus(), 0);
    }

    private void accept(XmiNodeVisitor visitor, XmiNode target, XmiNode source, String sourceKey, XmiNode root, Map<XmiNode, XmiNode> visited, XmiNodeVisitorStatus status, int level) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("accept: " + target.getLocalName()));
        }
        if (visited.get(target) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ignoring, " + target.getClass().getName()));
            }
            return;
        }
        visited.put(target, target);
        visitor.visit(target, source, sourceKey, status, level);
        if (status.getStatus() == 2) {
            return;
        }
        List<XmiNode> nodes = target.getNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                XmiNode child = nodes.get(i);
                if (((StreamNode)child).isIgnored()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"ignoring XMI 'Extension' node");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processing node: " + child.getLocalName()));
                }
                this.accept(visitor, child, target, child.getLocalName(), root, visited, status, level++);
            }
        }
    }

    public StreamContext getContext() {
        return this.context;
    }

    public void addCharactersEvent(XMLEvent charactersEvent) {
        if (this.characterEvents == null) {
            this.characterEvents = new ArrayList<XMLEvent>();
        }
        this.characterEvents.add(charactersEvent);
    }

    @Override
    public boolean hasCharacters() {
        return this.characterEvents != null && this.characterEvents.size() > 0;
    }

    public boolean isIgnored() {
        ImportExemption importExemption;
        if (this.startElementEvent == null) {
            return false;
        }
        String uri = this.startElementEvent.asStartElement().getName().getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            uri = this.context.getDefaultNamespace().getNamespaceURI();
        }
        if ((importExemption = FumlConfiguration.getInstance().findImportExemptionByElement(this.getLocalName())) != null) {
            NamespaceDomain domain = FumlConfiguration.getInstance().getNamespaceDomain(uri);
            if (importExemption.getType().ordinal() == ImportExemptionType.ELEMENT.ordinal() && importExemption.getDomain().ordinal() == domain.ordinal()) {
                return true;
            }
        }
        return false;
    }
}

