/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.environment;

import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.commonbehavior.ParameterValueList;
import fuml.semantics.values.Value;
import fuml.syntax.classification.Classifier;
import fuml.syntax.classification.ParameterDirectionKind;
import fuml.syntax.classification.ParameterList;
import fuml.syntax.commonbehavior.Behavior;
import fuml.syntax.commonstructure.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.environment.Environment;
import org.modeldriven.fuml.environment.EnvironmentException;

public class ExecutionEnvironment {
    private static Log log = LogFactory.getLog(ExecutionEnvironment.class);
    private Environment environment;

    private ExecutionEnvironment() {
    }

    public ExecutionEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ParameterValueList execute(Behavior behavior) {
        ParameterList parameters = behavior.ownedParameter;
        ParameterValueList parameterValues = this.createDefaultInputValues(parameters);
        if (parameterValues == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"executing the behavior...");
        }
        ParameterValueList outputParameterValues = this.environment.locus.executor.execute(behavior, null, parameterValues);
        for (int i = 0; i < outputParameterValues.size(); ++i) {
            ParameterValue outputParameterValue = outputParameterValues.getValue(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("output parameter '" + outputParameterValue.parameter.name + "' has " + outputParameterValue.values.size() + " value(s)"));
            }
            for (int j = 0; j < outputParameterValue.values.size(); ++j) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("value [" + j + "] = " + outputParameterValue.values.getValue(j)));
            }
        }
        return outputParameterValues;
    }

    protected ParameterValueList createDefaultInputValues(ParameterList parameters) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating " + parameters.size() + " parameter(s):"));
        }
        ParameterValueList parameterValues = new ParameterValueList();
        for (int i = 0; i < parameters.size(); ++i) {
            ParameterDirectionKind direction;
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking parameter '" + parameters.getValue((int)i).name + "'"));
            }
            if ((direction = parameters.getValue((int)i).direction) == null) {
                throw new EnvironmentException("expected 'direction' for parameter, '" + parameters.getValue((int)i).name + "'");
            }
            if (!direction.equals((Object)ParameterDirectionKind.in) && !direction.equals((Object)ParameterDirectionKind.inout)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("creating parameter value for parameter '" + parameters.getValue((int)i).name + "'"));
            }
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.parameter = parameters.getValue(i);
            Type type = parameters.getValue((int)i).type;
            Value value = this.environment.makeValue((Classifier)type);
            if (value == null) {
                log.error((Object)"expected parameter value");
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("value = " + value));
            }
            parameterValue.values.addValue(value);
            parameterValues.addValue(parameterValue);
        }
        return parameterValues;
    }
}

