/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.activities;

import fuml.semantics.activities.ActivityNodeActivation;
import fuml.semantics.activities.ActivityNodeActivationGroup;
import fuml.semantics.activities.Offer;
import fuml.semantics.activities.OfferList;
import fuml.semantics.activities.Token;
import fuml.semantics.activities.TokenList;
import fuml.syntax.activities.ActivityEdge;
import org.modeldriven.fuml.FumlObject;

public class ActivityEdgeInstance
extends FumlObject {
    public ActivityEdge edge = null;
    public ActivityNodeActivationGroup group = null;
    public ActivityNodeActivation source = null;
    public ActivityNodeActivation target = null;
    public OfferList offers = new OfferList();

    public void sendOffer(TokenList tokens) {
        Offer offer = new Offer();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.getValue(i);
            offer.offeredTokens.addValue(token);
        }
        this.offers.addValue(offer);
        this.target.receiveOffer();
    }

    public int countOfferedValues() {
        int count = 0;
        OfferList offers = this.offers;
        for (int i = 0; i < offers.size(); ++i) {
            count += offers.getValue(i).countOfferedValues();
        }
        return count;
    }

    public TokenList takeOfferedTokens() {
        TokenList tokens = new TokenList();
        while (this.offers.size() > 0) {
            TokenList offeredTokens = this.offers.getValue(0).getOfferedTokens();
            for (int i = 0; i < offeredTokens.size(); ++i) {
                tokens.addValue(offeredTokens.getValue(i));
            }
            this.offers.removeValue(0);
        }
        return tokens;
    }

    public TokenList takeOfferedTokens(int maxCount) {
        TokenList tokens = new TokenList();
        int remainingCount = maxCount;
        while (this.offers.size() > 0 & remainingCount > 0) {
            int i;
            Offer offer = this.offers.getValue(0);
            TokenList offeredTokens = offer.getOfferedTokens();
            int count = offer.countOfferedValues();
            if (count <= remainingCount) {
                for (i = 0; i < offeredTokens.size(); ++i) {
                    tokens.addValue(offeredTokens.getValue(i));
                }
                remainingCount -= count;
                this.offers.removeValue(0);
                continue;
            }
            for (i = 0; i < remainingCount; ++i) {
                Token token = offeredTokens.getValue(i);
                if (token.getValue() == null) continue;
                tokens.addValue(token);
            }
            offer.removeOfferedValues(remainingCount);
            remainingCount = 0;
        }
        return tokens;
    }

    public TokenList getOfferedTokens() {
        TokenList tokens = new TokenList();
        OfferList offers = this.offers;
        for (int i = 0; i < offers.size(); ++i) {
            TokenList offeredTokens = offers.getValue(i).getOfferedTokens();
            for (int j = 0; j < offeredTokens.size(); ++j) {
                tokens.addValue(offeredTokens.getValue(j));
            }
        }
        return tokens;
    }

    public boolean hasOffer() {
        boolean hasTokens = false;
        int i = 1;
        while (!hasTokens & i <= this.offers.size()) {
            hasTokens = this.offers.getValue(i - 1).hasTokens();
            ++i;
        }
        return hasTokens;
    }
}

