/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi.validation;

import org.modeldriven.fuml.xmi.validation.ErrorCategory;

public enum ErrorCode {
    INVALID_REFERENCE("INVALID_REFERENCE", ErrorCategory.DOCUMENT_COMPLIANCE_ID_CORRELATION),
    INVALID_EXTERNAL_REFERENCE("INVALID_EXTERNAL_REFERENCE", ErrorCategory.DOCUMENT_COMPLIANCE_ID_CORRELATION),
    DUPLICATE_REFERENCE("DUPLICATE_REFERENCE", ErrorCategory.DOCUMENT_COMPLIANCE_ID_CORRELATION),
    UNDRESOLVED_URI("UNDRESOLVED_URI", ErrorCategory.DOCUMENT_COMPLIANCE_URI_CORRELATION),
    INVALID_NAMESPACE("INVALID_NAMESPACE", ErrorCategory.DOCUMENT_COMPLIANCE_NAMESPACE_CORRELATION),
    NAMESPACE_REQUIRED("NAMESPACE_REQUIRED", ErrorCategory.DOCUMENT_COMPLIANCE_NAMESPACE_CORRELATION),
    MALFORMED_DOCUMENT("MALFORMED_DOCUMENT", ErrorCategory.DOCUMENT_COMPLIANCE_WELL_FORMED),
    MALFORMED_ELEMENT("MALFORMED_ELEMENT", ErrorCategory.DOCUMENT_COMPLIANCE_WELL_FORMED),
    PROPERTY_REQUIRED("PROPERTY_REQUIRED", ErrorCategory.MODEL_COMPLIANCE_MULTIPLICITY),
    PROPERTY_RANGE_ERROR("PROPERTY_RANGE_ERROR", ErrorCategory.MODEL_COMPLIANCE_MULTIPLICITY),
    UNDEFINED_PROPERTY("UNDEFINED_PROPERTY", ErrorCategory.MODEL_COMPLIANCE_NAME_CORRELATION),
    UNDEFINED_CLASS("UNDEFINED_CLASS", ErrorCategory.MODEL_COMPLIANCE_NAME_CORRELATION),
    INVALID_TYPE("INVALID_TYPE", ErrorCategory.MODEL_COMPLIANCE_TYPE_CORRELATION),
    ABSTRACT_CLASS_INSTANTIATION("ABSTRACT_CLASS_INSTANTIATION", ErrorCategory.MODEL_COMPLIANCE_TYPE_CORRELATION),
    INVALID_STEREOTYPE_APPLICATION("INVALID_STEREOTYPE_APPLICATION", ErrorCategory.MODEL_COMPLIANCE_STEREOTYPE_CORRELATION),
    DERIVED_PROPERTY_INSTANTIATION("DERIVED_PROPERTY_INSTANTIATION", ErrorCategory.MODEL_COMPLIANCE_WELL_FORMED);

    private final String value;
    private final ErrorCategory category;

    public ErrorCategory getCategory() {
        return this.category;
    }

    private ErrorCode(String v, ErrorCategory category) {
        this.value = v;
        this.category = category;
    }

    public String value() {
        return this.value;
    }

    public static ErrorCode fromValue(String v) {
        for (ErrorCode c : ErrorCode.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }
}

