/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.classification;

import fuml.Debug;
import fuml.semantics.simpleclassifiers.DataValue;
import fuml.semantics.simpleclassifiers.EnumerationValue;
import fuml.semantics.simpleclassifiers.StructuredValue;
import fuml.semantics.structuredclassifiers.Object_;
import fuml.semantics.structuredclassifiers.Reference;
import fuml.semantics.values.Evaluation;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.classification.Classifier;
import fuml.syntax.classification.ClassifierList;
import fuml.syntax.classification.InstanceSpecification;
import fuml.syntax.classification.InstanceValue;
import fuml.syntax.classification.Slot;
import fuml.syntax.classification.SlotList;
import fuml.syntax.commonbehavior.Behavior;
import fuml.syntax.simpleclassifiers.DataType;
import fuml.syntax.simpleclassifiers.Enumeration;
import fuml.syntax.simpleclassifiers.EnumerationLiteral;
import fuml.syntax.structuredclassifiers.Class_;
import fuml.syntax.values.ValueSpecification;
import fuml.syntax.values.ValueSpecificationList;

public class InstanceValueEvaluation
extends Evaluation {
    @Override
    public Value evaluate() {
        Value value;
        InstanceSpecification instance = ((InstanceValue)this.specification).instance;
        ClassifierList types = instance.classifier;
        Classifier myType = types.getValue(0);
        Debug.println("[evaluate] type = " + myType.name);
        if (instance instanceof EnumerationLiteral) {
            EnumerationValue enumerationValue = new EnumerationValue();
            enumerationValue.type = (Enumeration)myType;
            enumerationValue.literal = (EnumerationLiteral)instance;
            value = enumerationValue;
        } else {
            StructuredValue structuredValue = null;
            if (myType instanceof DataType) {
                DataValue dataValue = new DataValue();
                dataValue.type = (DataType)myType;
                structuredValue = dataValue;
            } else {
                Object_ object = null;
                if (myType instanceof Behavior) {
                    object = this.locus.factory.createExecution((Behavior)myType, null);
                } else {
                    object = new Object_();
                    for (int i = 0; i < types.size(); ++i) {
                        Classifier type = types.getValue(i);
                        object.types.addValue((Class_)type);
                    }
                }
                this.locus.add(object);
                Reference reference = new Reference();
                reference.referent = object;
                structuredValue = reference;
            }
            structuredValue.createFeatureValues();
            SlotList instanceSlots = instance.slot;
            for (int i = 0; i < instanceSlots.size(); ++i) {
                Slot slot = instanceSlots.getValue(i);
                ValueList values = new ValueList();
                ValueSpecificationList slotValues = slot.value;
                for (int j = 0; j < slotValues.size(); ++j) {
                    ValueSpecification slotValue = slotValues.getValue(j);
                    values.addValue(this.locus.executor.evaluate(slotValue));
                }
                structuredValue.setFeatureValue(slot.definingFeature, values, 0);
            }
            value = structuredValue;
        }
        return value;
    }
}

