/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.assembly.adapter;

import UMLPrimitiveTypes.UnlimitedNatural;
import fuml.syntax.commonstructure.Element;
import fuml.syntax.values.LiteralBoolean;
import fuml.syntax.values.LiteralInteger;
import fuml.syntax.values.LiteralString;
import fuml.syntax.values.LiteralUnlimitedNatural;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.assembly.AssemblyAdapter;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.stream.StreamNode;

public class OpaqueExpressionAdapter
implements AssemblyAdapter {
    private static Log log = LogFactory.getLog(OpaqueExpressionAdapter.class);

    @Override
    public Element assembleElement(StreamNode opaqueExpressionNode) {
        LiteralString literal = new LiteralString();
        XmiNode bodyNode = opaqueExpressionNode.findChildByName("body");
        String bodyContent = null;
        if (bodyNode != null) {
            bodyContent = bodyNode.getData();
        } else {
            Attribute bodyAttrib = opaqueExpressionNode.getAttribute("body");
            if (bodyAttrib != null) {
                bodyContent = bodyAttrib.getValue();
            }
        }
        if (bodyContent != null && (bodyContent = bodyContent.trim()).startsWith("\"") && bodyContent.endsWith("\"")) {
            bodyContent = bodyContent.substring(1, bodyContent.length() - 1);
            literal.setValue(bodyContent);
            return literal;
        }
        literal.setValue(bodyContent);
        if ("true".equalsIgnoreCase(bodyContent) || "false".equalsIgnoreCase(bodyContent)) {
            LiteralBoolean literalBoolean = new LiteralBoolean();
            literalBoolean.setValue(Boolean.valueOf(bodyContent));
            return literalBoolean;
        }
        if ("*".equals(bodyContent)) {
            LiteralUnlimitedNatural literalUnlimitedNatural = new LiteralUnlimitedNatural();
            UnlimitedNatural value = new UnlimitedNatural();
            value.naturalValue = -1;
            literalUnlimitedNatural.setValue(value);
            return literalUnlimitedNatural;
        }
        String type = this.findResultPinType(opaqueExpressionNode);
        if ("UnlimitedNatural".equals(type)) {
            int intValue = 0;
            try {
                intValue = Integer.valueOf(bodyContent);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("could not parse content as unlimited-natural integer '" + bodyContent + "'"));
            }
            LiteralUnlimitedNatural literalUnlimitedNatural = new LiteralUnlimitedNatural();
            UnlimitedNatural value = new UnlimitedNatural();
            value.naturalValue = intValue;
            literalUnlimitedNatural.setValue(value);
            return literalUnlimitedNatural;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("parsing expression: '" + bodyContent + "'"));
            }
            LiteralInteger literalInt = new LiteralInteger();
            literalInt.setValue(Integer.valueOf(bodyContent));
            return literalInt;
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("invalid number format: " + e.getMessage()));
            }
            literal.setValue(bodyContent);
            return literal;
        }
    }

    private String findResultPinType(StreamNode opaqueExpressionNode) {
        QName name;
        String href;
        StreamNode typeNode;
        String result = null;
        StreamNode parent = (StreamNode)opaqueExpressionNode.getParent();
        if (parent == null) {
            log.warn((Object)"expected parent node");
            return null;
        }
        StreamNode resultNode = (StreamNode)parent.findChildByName("result");
        if (resultNode != null && (typeNode = (StreamNode)resultNode.findChildByName("type")) != null && (href = typeNode.getAttributeValue(name = new QName("href"))) != null) {
            if (href.endsWith("Integer")) {
                result = "Integer";
            } else if (href.endsWith("String")) {
                result = "String";
            } else if (href.endsWith("Boolean")) {
                result = "Boolean";
            } else if (href.endsWith("UnlimitedNatural")) {
                result = "UnlimitedNatural";
            }
        }
        return result;
    }

    @Override
    public Classifier getClassifier(StreamNode node) {
        throw new IllegalStateException("OpaqueExpression should have no classifier");
    }
}

