/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.library.libraryclass;

import fuml.semantics.commonbehavior.Execution;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.classification.Operation;
import fuml.syntax.classification.Parameter;
import fuml.syntax.classification.ParameterDirectionKind;
import fuml.syntax.commonbehavior.Behavior;
import fuml.syntax.commonbehavior.OpaqueBehavior;
import org.modeldriven.fuml.library.libraryclass.ImplementationObject;

public class OperationExecution
extends Execution {
    public void set(ImplementationObject context, Operation operation) {
        this.context = context;
        OpaqueBehavior method = new OpaqueBehavior();
        method.specification = operation;
        for (Parameter operationParameter : operation.ownedParameter) {
            Parameter methodParameter = new Parameter();
            methodParameter.name = operationParameter.name;
            methodParameter.direction = operationParameter.direction;
            methodParameter.type = operationParameter.type;
            methodParameter.multiplicityElement = operationParameter.multiplicityElement;
            method.ownedParameter.addValue(methodParameter);
        }
        this.types.addValue(method);
    }

    @Override
    public Value new_() {
        return new OperationExecution();
    }

    @Override
    public void execute() {
        for (Parameter parameter : this.getBehavior().ownedParameter) {
            if (parameter.direction != ParameterDirectionKind.out && parameter.direction != ParameterDirectionKind.return_) continue;
            this.setParameterValue(parameter, new ValueList());
        }
        ((ImplementationObject)this.context).execute(this);
    }

    public String getOperationName() {
        return this.getBehavior().specification.name;
    }

    public Parameter getParameter(String parameterName) {
        Behavior method = this.getBehavior();
        for (Parameter parameter : method.ownedParameter) {
            if (!parameter.name.equals(parameterName)) continue;
            return parameter;
        }
        return null;
    }

    public ParameterValue getParameterValue(String parameterName) {
        return this.getParameterValue(this.getParameter(parameterName));
    }

    public void setParameterValue(Parameter parameter, ValueList values) {
        if (parameter != null) {
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.parameter = parameter;
            parameterValue.values = values;
            this.setParameterValue(parameterValue);
        }
    }

    public void setParameterValue(String parameterName, ValueList values) {
        this.setParameterValue(this.getParameter(parameterName), values);
    }

    public void setParameterValue(String parameterName, Value value) {
        ValueList valueList = new ValueList();
        valueList.addValue(value);
        this.setParameterValue(parameterName, valueList);
    }

    public void setReturnParameterValue(ValueList values) {
        Behavior method = this.getBehavior();
        for (Parameter parameter : method.ownedParameter) {
            if (parameter.direction != ParameterDirectionKind.return_) continue;
            this.setParameterValue(parameter, values);
            return;
        }
    }

    public void setReturnParameterValue(Value value) {
        ValueList valueList = new ValueList();
        valueList.addValue(value);
        this.setReturnParameterValue(valueList);
    }
}

