/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.commonbehavior;

import fuml.Debug;
import fuml.semantics.commonbehavior.CallEventBehavior;
import fuml.semantics.commonbehavior.CallEventOccurrence;
import fuml.semantics.commonbehavior.EventOccurrence;
import fuml.semantics.commonbehavior.Execution;
import fuml.semantics.commonbehavior.ExecutionQueue;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.commonbehavior.ParameterValueList;
import fuml.semantics.structuredclassifiers.Reference;
import fuml.semantics.values.Value;
import fuml.syntax.classification.Operation;
import fuml.syntax.classification.Parameter;
import fuml.syntax.classification.ParameterDirectionKind;
import fuml.syntax.classification.ParameterList;

public class CallEventExecution
extends Execution {
    public boolean callerSuspended = false;

    public boolean isCallerSuspended() {
        CallEventExecution._beginIsolation();
        boolean isSuspended = this.callerSuspended;
        Debug.println("[isCallerSuspended] operation = " + this.getOperation().name + ", callerSuspended = " + isSuspended);
        CallEventExecution._endIsolation();
        return isSuspended;
    }

    public void setCallerSuspended(boolean callerSuspended) {
        CallEventExecution._beginIsolation();
        this.callerSuspended = callerSuspended;
        Debug.println("[setCallerSuspended] operation = " + this.getOperation().name + ", callerSuspended = " + callerSuspended);
        CallEventExecution._endIsolation();
    }

    public void suspendCaller() {
        while (this.isCallerSuspended()) {
            this.wait_();
        }
    }

    public void releaseCaller() {
        this.setCallerSuspended(false);
    }

    @Override
    public void execute() {
        this.setCallerSuspended(true);
        this.makeCall();
        this.suspendCaller();
    }

    public void makeCall() {
        Reference reference = new Reference();
        reference.referent = this.context;
        this.createEventOccurrence().sendTo(reference);
    }

    public EventOccurrence createEventOccurrence() {
        CallEventOccurrence eventOccurrence = new CallEventOccurrence();
        eventOccurrence.execution = this;
        return eventOccurrence;
    }

    public Operation getOperation() {
        return ((CallEventBehavior)this.getBehavior()).operation;
    }

    public ParameterValueList getInputParameterValues() {
        ParameterValueList parameterValues = new ParameterValueList();
        for (int i = 0; i < this.parameterValues.size(); ++i) {
            ParameterValue parameterValue = (ParameterValue)this.parameterValues.get(i);
            if (!(parameterValue.parameter.direction == ParameterDirectionKind.in | parameterValue.parameter.direction == ParameterDirectionKind.inout)) continue;
            parameterValues.addValue(parameterValue);
        }
        return parameterValues;
    }

    public void setOutputParameterValues(ParameterValueList parameterValues) {
        ParameterList parameters = this.getBehavior().ownedParameter;
        int j = 1;
        for (int i = 1; i <= parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i - 1);
            if (!(parameter.direction == ParameterDirectionKind.inout | parameter.direction == ParameterDirectionKind.out | parameter.direction == ParameterDirectionKind.return_)) continue;
            ParameterValue parameterValue = (ParameterValue)parameterValues.get(j - 1);
            parameterValue.parameter = parameter;
            this.setParameterValue(parameterValue);
            ++j;
        }
    }

    @Override
    public Value new_() {
        return new CallEventExecution();
    }

    @Override
    public Value copy() {
        CallEventExecution copy = (CallEventExecution)super.copy();
        copy.callerSuspended = false;
        return copy;
    }

    public void wait_() {
        Debug.println(!ExecutionQueue.step(), "[wait] Stuck!");
    }
}

