/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.activities;

import fuml.Debug;
import fuml.semantics.activities.ObjectNodeActivation;
import fuml.semantics.activities.ObjectToken;
import fuml.semantics.activities.TokenList;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.activities.ActivityParameterNode;
import fuml.syntax.classification.Parameter;

public class ActivityParameterNodeActivation
extends ObjectNodeActivation {
    @Override
    public void fire(TokenList incomingTokens) {
        if (this.node.incoming.size() == 0) {
            Debug.println("[fire] Input activity parameter node " + this.node.name + "...");
            Parameter parameter = ((ActivityParameterNode)this.node).parameter;
            ParameterValue parameterValue = this.getActivityExecution().getParameterValue(parameter);
            if (parameterValue != null) {
                Debug.println("[fire] Parameter has " + parameterValue.values.size() + " value(s).");
                TokenList tokens = new TokenList();
                ValueList values = parameterValue.values;
                for (int i = 0; i < values.size(); ++i) {
                    Value value = values.getValue(i);
                    ObjectToken token = new ObjectToken();
                    token.value = value;
                    this.addToken(token);
                }
                this.sendUnofferedTokens();
            }
        } else {
            Debug.println("[fire] Output activity parameter node " + this.node.name + "...");
            this.addTokens(incomingTokens);
        }
    }

    @Override
    public void clearTokens() {
        if (this.node.incoming.size() == 0) {
            super.clearTokens();
        }
    }
}

