/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.values;

import fuml.semantics.loci.SemanticVisitor;
import fuml.syntax.classification.Classifier;
import fuml.syntax.classification.ClassifierList;
import fuml.syntax.values.ValueSpecification;

public abstract class Value
extends SemanticVisitor {
    public abstract ValueSpecification specify();

    public boolean equals(Value otherValue) {
        ClassifierList myTypes = this.getTypes();
        ClassifierList otherTypes = otherValue.getTypes();
        boolean isEqual = true;
        if (myTypes.size() != otherTypes.size()) {
            isEqual = false;
        } else {
            int i = 1;
            while (isEqual & i <= myTypes.size()) {
                boolean matched = false;
                int j = 1;
                while (!matched & j <= otherTypes.size()) {
                    matched = otherTypes.getValue(j - 1) == myTypes.getValue(i - 1);
                    ++j;
                }
                isEqual = matched;
                ++i;
            }
        }
        return isEqual;
    }

    public Value copy() {
        return this.new_();
    }

    protected abstract Value new_();

    public abstract ClassifierList getTypes();

    public boolean hasType(Classifier type) {
        ClassifierList types = this.getTypes();
        boolean found = false;
        int i = 1;
        while (!found & i <= types.size()) {
            found = types.getValue(i - 1) == type;
            ++i;
        }
        return found;
    }

    public boolean isInstanceOf(Classifier classifier) {
        ClassifierList types = this.getTypes();
        boolean isInstance = this.hasType(classifier);
        int i = 1;
        while (!isInstance & i <= types.size()) {
            isInstance = this.checkAllParents(types.getValue(i - 1), classifier);
            ++i;
        }
        return isInstance;
    }

    public boolean checkAllParents(Classifier type, Classifier classifier) {
        ClassifierList directParents = type.general;
        boolean matched = false;
        int i = 1;
        while (!matched & i <= directParents.size()) {
            Classifier directParent = directParents.getValue(i - 1);
            matched = directParent == classifier ? true : this.checkAllParents(directParent, classifier);
            ++i;
        }
        return matched;
    }

    public abstract String toString();
}

