/*
 * Initial version copyright 2008 Lockheed Martin Corporation, except
 * as stated in the file entitled Licensing-Information.
 *
 * Modifications:
 * Copyright 2009 Data Access Technologies, Inc.
 * Copyright 2013 Ivar Jacobson International SA
 *
 * Licensed under the Academic Free License version 3.0
 * (http://www.opensource.org/licenses/afl-3.0.php), except as stated
 * in the file entitled Licensing-Information.
 *
 * Contributors:
 *   MDS - initial API and implementation
 *   IJI
 *
 */
package org.modeldriven.fuml.test.load.profile;

public enum ConcurrencyType {

	/**
	 * Indicates a UML Property stores information related optimistic
	 * concurrency for its containing UML Class and participates in optimistic
	 * concurrency control operations and strategies. Informs SDO Data Access
	 * Services performing optimistic concurrency control checks and operations.
	 */
	optimistic,
	/**
	 * Indicates a UML Property stores information related to a pessimistic
	 * concurrency control strategy (often termed locking) and participates in
	 * pessimistic concurrency control operations. Informs SDO Data Access
	 * Services performing pessimistic concurrency control checks and
	 * operations.
	 */
	pessimistic,
	/**
	 * Indicates a UML Property stores origination information for its
	 * containing UML Class. Informs Data Access Services (DAS) performing
	 * concurrent operations involving origination.
	 */
	origination,
}
