/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.model;

import UMLPrimitiveTypes.UnlimitedNatural;
import fuml.syntax.classification.Generalization;
import fuml.syntax.classification.InstanceSpecification;
import fuml.syntax.classification.InstanceValue;
import fuml.syntax.packages.Package;
import fuml.syntax.simpleclassifiers.Enumeration;
import fuml.syntax.simpleclassifiers.EnumerationLiteral;
import fuml.syntax.simpleclassifiers.PrimitiveType;
import fuml.syntax.structuredclassifiers.Association;
import fuml.syntax.structuredclassifiers.Class_;
import fuml.syntax.values.LiteralBoolean;
import fuml.syntax.values.LiteralInteger;
import fuml.syntax.values.LiteralSpecification;
import fuml.syntax.values.LiteralString;
import fuml.syntax.values.LiteralUnlimitedNatural;
import fuml.syntax.values.ValueSpecification;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Property;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryException;
import org.modeldriven.fuml.repository.RepositoryMapping;

public class ModelFactory {
    private static Log log = LogFactory.getLog(ModelFactory.class);
    protected RepositoryMapping mapping;
    protected Repository model;

    private ModelFactory() {
    }

    public ModelFactory(RepositoryMapping mapping, Repository model) {
        this.mapping = mapping;
        this.model = model;
    }

    public Package createPackage(String name, String qualifiedName, String id, RepositoryArtifact artifact) {
        return this.createPackage(name, qualifiedName, id, null, artifact);
    }

    public Package createPackage(String name, String qualifiedName, String id, Package parent, RepositoryArtifact artifact) {
        Package p = new Package();
        p.name = name;
        p.qualifiedName = qualifiedName;
        p.setHref(artifact.getURN() + "#" + p.qualifiedName);
        p.setXmiId(id);
        if (parent != null) {
            parent.addPackagedElement(p);
        }
        if (parent != null) {
            parent.nestedPackage.add(p);
            p.nestingPackage = parent;
        }
        return p;
    }

    public Class_ createClass(String name, String id, Package pkg) {
        Class_ c = new Class_();
        c.name = name;
        c.qualifiedName = pkg.qualifiedName + "." + c.name;
        c.setXmiId(id);
        pkg.addPackagedElement(c);
        c.package_ = pkg;
        return c;
    }

    public Enumeration createEnumeration(String name, String id) {
        Enumeration e = new Enumeration();
        e.name = name;
        e.setXmiId(id);
        return e;
    }

    public PrimitiveType createPrimitiveType(String name, String id) {
        PrimitiveType t = new PrimitiveType();
        t.name = name;
        t.setXmiId(id);
        return t;
    }

    public PrimitiveType createPrimitiveType(String name, String id, Package pkg) {
        PrimitiveType t = new PrimitiveType();
        pkg.addPackagedElement(t);
        t.name = name;
        t.qualifiedName = pkg.qualifiedName + "." + t.name;
        t.setXmiId(id);
        return t;
    }

    public Association createAssociation(String name, String id, fuml.syntax.classification.Property[] members) {
        Association a = new Association();
        a.name = name;
        a.setXmiId(id);
        for (int i = 0; i < members.length; ++i) {
            a.memberEnd.add(members[i]);
        }
        return a;
    }

    public Association createAssociation(String name, String id) {
        Association a = new Association();
        a.name = name;
        a.setXmiId(id);
        return a;
    }

    public fuml.syntax.classification.Property[] createAssociationEnds(Association assoc, String ends) {
        ArrayList<fuml.syntax.classification.Property> props = new ArrayList<fuml.syntax.classification.Property>();
        StringTokenizer st = new StringTokenizer(ends);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Property prop = (Property)this.model.getElementById(token);
            if (prop.getAssociation() != null && !prop.getAssociation().getXmiId().equals(assoc.getXmiId())) {
                log.warn((Object)("found existing association (" + prop.getAssociation().getXmiId() + ") on property (" + prop.getXmiId() + ") - overwriting with association (" + assoc.getXmiId() + ")"));
            }
            prop.setAssociation(assoc);
            props.add(prop.getDelegate());
            if (assoc.memberEnd.contains(prop)) continue;
            assoc.memberEnd.add(prop.getDelegate());
        }
        fuml.syntax.classification.Property[] result = new fuml.syntax.classification.Property[props.size()];
        props.toArray(result);
        return result;
    }

    public Generalization createGeneralization(Class_ c, String general) {
        Generalization g = new Generalization();
        Classifier classifier = (Classifier)this.model.getElementById(general);
        g.general = classifier.getDelegate();
        c.generalization.add(g);
        return g;
    }

    public fuml.syntax.classification.Property createProperty(Class_ c, String name, String id, String typeName, String redefinedProperty, boolean readOnly, boolean derived, boolean derivedUnion) {
        fuml.syntax.classification.Property p = this.createProperty(name, id, typeName, redefinedProperty, readOnly, derived, derivedUnion);
        p.class_ = c;
        c.ownedAttribute.add(p);
        return p;
    }

    public fuml.syntax.classification.Property createProperty(Association assoc, String name, String id, String typeName, String subsettedProperty, String redefinedProperty, boolean readOnly, boolean derived, boolean derivedUnion) {
        fuml.syntax.classification.Property p = this.createProperty(name, id, typeName, redefinedProperty, readOnly, derived, derivedUnion);
        p.association = assoc;
        assoc.ownedEnd.add(p);
        p.owningAssociation = assoc;
        return p;
    }

    public fuml.syntax.classification.Property createProperty(String name, String id, String typeName, String redefinedProperty, boolean readOnly, boolean derived, boolean derivedUnion) {
        fuml.syntax.classification.Property p = new fuml.syntax.classification.Property();
        p.setName(name);
        p.setXmiId(id);
        p.isDerived = derived;
        p.setIsReadOnly(readOnly);
        p.isDerivedUnion = derivedUnion;
        if (!(typeName != null && typeName.length() != 0 || redefinedProperty != null && redefinedProperty.length() != 0)) {
            throw new RepositoryException("no type or redefinedProperty found for property '" + name + "' (" + id + ")");
        }
        if (typeName != null && typeName.length() > 0) {
            Classifier typeClassifier = (Classifier)this.model.findElementById(typeName);
            if (typeClassifier == null) {
                log.error((Object)("could not find type '" + typeName + "' for property '" + name + "' (" + id + ")"));
            } else {
                p.typedElement.type = typeClassifier.getDelegate();
            }
        } else {
            Property redefinedProp = (Property)this.model.getElementById(redefinedProperty);
            if (redefinedProp == null) {
                throw new RepositoryException("could not find redefinedProperty '" + redefinedProperty + "' for property '" + name + "' (" + id + ")");
            }
            fuml.syntax.classification.Property redefined = redefinedProp.getDelegate();
            p.typedElement.type = redefined.typedElement.type;
        }
        return p;
    }

    public LiteralInteger createLowerValue(fuml.syntax.classification.Property p, boolean hasLowerValue, String value) {
        LiteralInteger lowerValue = new LiteralInteger();
        p.setLowerValue(lowerValue);
        lowerValue.value = "1".equals(value) ? 1 : (value != null && value.length() > 0 ? 1 : (hasLowerValue ? 0 : 1));
        return lowerValue;
    }

    public LiteralSpecification createUpperValue(fuml.syntax.classification.Property p, boolean hasUpperValue, String value) {
        LiteralSpecification result = null;
        if ("*".equals(value)) {
            UnlimitedNatural unlimitedNatural;
            LiteralUnlimitedNatural upperValue = new LiteralUnlimitedNatural();
            upperValue.value = unlimitedNatural = new UnlimitedNatural();
            p.setUpperValue(upperValue);
            result = upperValue;
        } else if (value != null && value.length() > 0) {
            int intValue = Integer.parseInt(value);
            LiteralInteger upperValue = new LiteralInteger();
            upperValue.value = intValue;
            p.setUpperValue(upperValue);
            result = upperValue;
        } else if (hasUpperValue) {
            LiteralInteger upperValue = new LiteralInteger();
            upperValue.value = 1;
            p.setUpperValue(upperValue);
            result = upperValue;
        } else {
            LiteralInteger upperValue = new LiteralInteger();
            upperValue.value = 1;
            p.setUpperValue(upperValue);
            result = upperValue;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValueSpecification createDefault(fuml.syntax.classification.Property prop, Object value, String instance, String id, String xmiType, String typeId) {
        void var7_14;
        LiteralUnlimitedNatural literalUnlimitedNatural;
        Object var7_7 = null;
        String typeName = xmiType.substring(4);
        fuml.syntax.classification.Classifier type = null;
        if (typeId != null && typeId.length() > 0) {
            Classifier typeClassifier = (Classifier)this.model.getElementById(typeId);
            type = typeClassifier.getDelegate();
        }
        if (LiteralString.class.getSimpleName().equals(typeName)) {
            LiteralString literalString = new LiteralString();
            literalString.type = type != null ? type : this.model.getClassifierByName("String").getDelegate();
            literalString.value = String.valueOf(value);
            LiteralString literalString2 = literalString;
        } else if (LiteralBoolean.class.getSimpleName().equals(typeName)) {
            LiteralBoolean literalBoolean = new LiteralBoolean();
            literalBoolean.type = type != null ? type : this.model.getClassifierByName("Boolean").getDelegate();
            literalBoolean.value = value != null ? Boolean.valueOf(String.valueOf(value)) : false;
            LiteralBoolean literalBoolean2 = literalBoolean;
        } else if (LiteralInteger.class.getSimpleName().equals(typeName)) {
            LiteralInteger literalInteger = new LiteralInteger();
            literalInteger.type = type != null ? type : this.model.getClassifierByName("Integer").getDelegate();
            literalInteger.value = value != null && String.valueOf(value).length() > 0 ? Integer.valueOf(String.valueOf(value)) : 0;
            LiteralInteger literalInteger2 = literalInteger;
        } else if (LiteralUnlimitedNatural.class.getSimpleName().equals(typeName)) {
            literalUnlimitedNatural = new LiteralUnlimitedNatural();
            literalUnlimitedNatural.type = type != null ? type : this.model.getClassifierByName("UnlimitedNatural").getDelegate();
            literalUnlimitedNatural.value = value instanceof UnlimitedNatural ? (UnlimitedNatural)value : new UnlimitedNatural();
            LiteralUnlimitedNatural literalUnlimitedNatural2 = literalUnlimitedNatural;
        } else if ("OpaqueExpression".equals(typeName)) {
            if (value == null) {
                throw new RepositoryException("expected default value - cannot create OpaqueExpression default for property '" + prop.class_.name + "." + prop.name + "'");
            }
            if (!(value instanceof UnlimitedNatural)) throw new RepositoryException("expected UnlimitedNatural value from OpaqueExpression default for property '" + prop.class_.name + "." + prop.name + "'");
            literalUnlimitedNatural = new LiteralUnlimitedNatural();
            literalUnlimitedNatural.value = (UnlimitedNatural)value;
            LiteralUnlimitedNatural literalUnlimitedNatural3 = literalUnlimitedNatural;
        } else {
            if (!InstanceValue.class.getSimpleName().equals(typeName)) throw new RepositoryException("unknown type, '" + typeName + "'");
            InstanceValue instanceValue = new InstanceValue();
            if (type == null) {
                throw new RepositoryException("can't derive type for InstanceValue");
            }
            instanceValue.type = type;
            InstanceValue instanceValue2 = instanceValue;
            if (instance == null || instance.length() == 0) {
                throw new RepositoryException("required InstanceValue.instance ");
            }
            instanceValue.instance = (InstanceSpecification)this.model.getElementById(instance).getDelegate();
            if (instanceValue.instance == null) {
                log.warn((Object)("could not lookup reference for instance by id, '" + instance + "'"));
            }
        }
        prop.defaultValue = var7_14;
        return var7_14;
    }

    public EnumerationLiteral createEnumerationLiteral(Enumeration enumeration, String name, String id) {
        EnumerationLiteral literal = new EnumerationLiteral();
        literal.name = name;
        literal.setXmiId(id);
        enumeration.ownedLiteral.add(literal);
        return literal;
    }
}

