/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.actions;

import fuml.Debug;
import fuml.semantics.actions.ActionActivation;
import fuml.semantics.simpleclassifiers.FeatureValue;
import fuml.semantics.simpleclassifiers.FeatureValueList;
import fuml.semantics.structuredclassifiers.ExtensionalValue;
import fuml.semantics.structuredclassifiers.ExtensionalValueList;
import fuml.semantics.structuredclassifiers.Link;
import fuml.semantics.structuredclassifiers.Reference;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.actions.DestroyObjectAction;
import fuml.syntax.classification.AggregationKind;
import fuml.syntax.classification.Property;

public class DestroyObjectActionActivation
extends ActionActivation {
    @Override
    public void doAction() {
        DestroyObjectAction action = (DestroyObjectAction)this.node;
        Value value = this.takeTokens(action.target).getValue(0);
        this.destroyObject(value, action.isDestroyLinks, action.isDestroyOwnedObjects);
    }

    public void destroyObject(Value value, boolean isDestroyLinks, boolean isDestroyOwnedObjects) {
        if (value instanceof Reference) {
            int i;
            Reference reference = (Reference)value;
            if (isDestroyLinks | isDestroyOwnedObjects) {
                Debug.println("[destroyObject] Destroying links...");
                ExtensionalValueList extensionalValues = this.getExecutionLocus().extensionalValues;
                for (i = 0; i < extensionalValues.size(); ++i) {
                    Link link;
                    ExtensionalValue extensionalValue = extensionalValues.getValue(i);
                    if (!(extensionalValue instanceof Link) || !this.valueParticipatesInLink(reference, link = (Link)extensionalValue) || !(isDestroyLinks | this.objectIsComposite(reference, link))) continue;
                    link.destroy();
                }
            }
            if (isDestroyOwnedObjects) {
                Debug.println("[destroyObject] Destroying owned objects...");
                FeatureValueList objectFeatureValues = reference.getFeatureValues();
                for (i = 0; i < objectFeatureValues.size(); ++i) {
                    FeatureValue featureValue = objectFeatureValues.getValue(i);
                    if (((Property)featureValue.feature).aggregation != AggregationKind.composite) continue;
                    ValueList values = featureValue.values;
                    for (int j = 0; j < values.size(); ++j) {
                        Value ownedValue = values.getValue(j);
                        this.destroyObject(ownedValue, isDestroyLinks, isDestroyOwnedObjects);
                    }
                }
            }
            reference.destroy();
        }
    }

    public boolean objectIsComposite(Reference reference, Link link) {
        FeatureValueList linkFeatureValues = link.getFeatureValues();
        boolean isComposite = false;
        int i = 1;
        while (!isComposite & i <= linkFeatureValues.size()) {
            FeatureValue featureValue = linkFeatureValues.getValue(i - 1);
            if (!featureValue.values.getValue(0).equals(reference) & ((Property)featureValue.feature).aggregation == AggregationKind.composite) {
                isComposite = true;
            }
            ++i;
        }
        return isComposite;
    }
}

