/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.model;

import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Syntax.Classes.Kernel.Association;
import fUML.Syntax.Classes.Kernel.DataType;
import fUML.Syntax.Classes.Kernel.Generalization;
import fUML.Syntax.Classes.Kernel.InstanceValue;
import fUML.Syntax.Classes.Kernel.LiteralBoolean;
import fUML.Syntax.Classes.Kernel.LiteralInteger;
import fUML.Syntax.Classes.Kernel.LiteralNull;
import fUML.Syntax.Classes.Kernel.LiteralString;
import fUML.Syntax.Classes.Kernel.LiteralUnlimitedNatural;
import fUML.Syntax.Classes.Kernel.PackageableElement;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import fUML.Syntax.Classes.Kernel.ValueSpecification;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlObject;
import org.modeldriven.fuml.common.reflect.ReflectionUtils;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.config.NamespaceDomain;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Element;
import org.modeldriven.fuml.repository.Extension;
import org.modeldriven.fuml.repository.NamedElement;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.RepositorylException;
import org.modeldriven.fuml.repository.Stereotype;
import org.modeldriven.fuml.repository.merge.PackageGraphNode;
import org.modeldriven.fuml.repository.model.Enumeration;
import org.modeldriven.fuml.repository.model.EnumerationLiteral;
import org.modeldriven.fuml.repository.model.Package;
import org.modeldriven.fuml.repository.model.Property;

public class InMemoryMapping
implements RepositoryMapping {
    private Log log = LogFactory.getLog(InMemoryMapping.class);
    protected Map<String, Element> elementIdToElementMap = new HashMap<String, Element>();
    protected Map<String, NamedElement> elementNameToElementMap = new HashMap<String, NamedElement>();
    protected Map<String, NamedElement> qualifiedElementNameToElementMap = new HashMap<String, NamedElement>();
    protected Map<String, Classifier> classifierNameToClassifierMap = new HashMap<String, Classifier>();
    protected Map<String, String> classifierNameToPackageNameMap = new HashMap<String, String>();
    protected Map<String, Classifier> qualifiedClassifierNameToClassifierMap = new HashMap<String, Classifier>();
    protected Map<String, String> qualifiedClassifierNameToPackageNameMap = new HashMap<String, String>();
    protected Map<String, List<Classifier>> classifierIdToSpecializationClassifierMap = new HashMap<String, List<Classifier>>();
    protected Map<String, org.modeldriven.fuml.repository.Package> qualifiedPackageNameToPackageMap = new HashMap<String, org.modeldriven.fuml.repository.Package>();
    protected Map<String, PackageGraphNode> packageIdToPackageMergeMap = new HashMap<String, PackageGraphNode>();
    protected Map<String, List<org.modeldriven.fuml.repository.Package>> artifactURIToPackagesMap = new HashMap<String, List<org.modeldriven.fuml.repository.Package>>();
    protected Map<String, List<Extension>> elementToExtensionListMap = new HashMap<String, List<Extension>>();
    protected Map<String, List<Stereotype>> elementToStereotypeListMap = new HashMap<String, List<Stereotype>>();
    protected Map<Class<?>, List<Stereotype>> classToStereotypeListMap = new HashMap();

    protected InMemoryMapping() {
    }

    public Element getElementById(String id) {
        Element result = this.elementIdToElementMap.get(id);
        if (result != null) {
            return result;
        }
        throw new RepositorylException("could not get element from XMI ID, '" + id + "'");
    }

    public Element findElementById(String id) {
        return this.elementIdToElementMap.get(id);
    }

    public Element getElementByName(String name) {
        Element result = this.elementNameToElementMap.get(name);
        if (result != null) {
            return result;
        }
        throw new RepositorylException("could not get element from name, '" + name + "'");
    }

    public Element findElementByName(String name) {
        return this.elementNameToElementMap.get(name);
    }

    public Element getElementByQualifiedName(String qualifiedName) {
        Element result = this.qualifiedElementNameToElementMap.get(qualifiedName);
        if (result != null) {
            return result;
        }
        throw new RepositorylException("could not get element from qualified name, '" + qualifiedName + "'");
    }

    public Element findElementByQualifiedName(String qualifiedName) {
        return this.qualifiedElementNameToElementMap.get(qualifiedName);
    }

    public int getElementCount(Class<? extends fUML.Syntax.Classes.Kernel.Element> clss) {
        int result = 0;
        Iterator<String> keys = this.elementNameToElementMap.keySet().iterator();
        while (keys.hasNext()) {
            Element element = this.elementNameToElementMap.get(keys.next());
            if (!clss.isAssignableFrom(element.getDelegate().getClass())) continue;
            ++result;
        }
        return result;
    }

    public String[] getElementNames(Class<? extends fUML.Syntax.Classes.Kernel.Element> clss) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> keys = this.elementNameToElementMap.keySet().iterator();
        while (keys.hasNext()) {
            Element element = this.elementNameToElementMap.get(keys.next());
            if (!clss.isAssignableFrom(element.getDelegate().getClass())) continue;
            list.add(((fUML.Syntax.Classes.Kernel.NamedElement)element.getDelegate()).name);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public Classifier getClassifierByName(String name) {
        return this.classifierNameToClassifierMap.get(name);
    }

    public Classifier getClassifierByQualifiedName(String qualifiedName) {
        return this.qualifiedClassifierNameToClassifierMap.get(qualifiedName);
    }

    public org.modeldriven.fuml.repository.Package getPackageByQualifiedName(String qualifiedName) {
        org.modeldriven.fuml.repository.Package result = this.qualifiedPackageNameToPackageMap.get(qualifiedName);
        if (result != null) {
            return result;
        }
        throw new RepositorylException("could not get package from qualified name, '" + qualifiedName + "'");
    }

    @Override
    public void mapElementById(fUML.Syntax.Classes.Kernel.Element element, RepositoryArtifact artifact) {
        org.modeldriven.fuml.repository.model.Element elem = new org.modeldriven.fuml.repository.model.Element(element, artifact);
        this.elementIdToElementMap.put(element.getXmiId(), elem);
        String globalId = artifact.getURN() + "#" + element.getXmiId();
        if (this.elementIdToElementMap.get(globalId) != null) {
            throw new RepositorylException("found existing reference, '" + globalId + "'");
        }
        this.elementIdToElementMap.put(globalId, elem);
    }

    @Override
    public void mapElementByName(fUML.Syntax.Classes.Kernel.NamedElement element, RepositoryArtifact artifact) {
        if (element instanceof fUML.Syntax.Classes.Kernel.Class_) {
            org.modeldriven.fuml.repository.model.Class_ clss = new org.modeldriven.fuml.repository.model.Class_((fUML.Syntax.Classes.Kernel.Class_)element, artifact);
            this.elementNameToElementMap.put(element.name, clss);
            this.classifierNameToClassifierMap.put(element.name, clss);
            if (element.qualifiedName != null) {
                this.qualifiedElementNameToElementMap.put(element.qualifiedName, clss);
                this.qualifiedClassifierNameToClassifierMap.put(element.qualifiedName, clss);
            }
        } else if (element instanceof fUML.Syntax.Classes.Kernel.Classifier) {
            org.modeldriven.fuml.repository.model.Classifier classifier = new org.modeldriven.fuml.repository.model.Classifier((fUML.Syntax.Classes.Kernel.Classifier)element, artifact);
            this.elementNameToElementMap.put(element.name, classifier);
            this.classifierNameToClassifierMap.put(element.name, classifier);
            if (element.qualifiedName != null) {
                this.qualifiedElementNameToElementMap.put(element.qualifiedName, classifier);
                this.qualifiedClassifierNameToClassifierMap.put(element.qualifiedName, classifier);
            }
        } else {
            org.modeldriven.fuml.repository.model.NamedElement elem = new org.modeldriven.fuml.repository.model.NamedElement(element, artifact);
            this.elementNameToElementMap.put(element.name, elem);
            if (element.qualifiedName != null) {
                this.qualifiedElementNameToElementMap.put(element.qualifiedName, elem);
            }
        }
    }

    @Override
    public void mapPackage(fUML.Syntax.Classes.Kernel.Package p, String currentPackageName, RepositoryArtifact artifact) {
        List<org.modeldriven.fuml.repository.Package> artifactPackages;
        String qualifiedName = null;
        if (currentPackageName != null) {
            qualifiedName = currentPackageName + "." + p.name;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping package, " + artifact.getURN() + "#" + p.name + "(" + currentPackageName + ")"));
        }
        Package pkg = new Package(p, artifact);
        if (qualifiedName != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("mapping package, " + artifact.getURN() + "#" + p.name + " by package qualified name: " + qualifiedName));
            }
            if (this.qualifiedPackageNameToPackageMap.get(qualifiedName) != null) {
                throw new RepositorylException("found existing package, '" + qualifiedName + ".");
            }
            this.qualifiedPackageNameToPackageMap.put(qualifiedName, pkg);
        }
        if ((artifactPackages = this.artifactURIToPackagesMap.get(artifact.getURN())) == null) {
            artifactPackages = new ArrayList<org.modeldriven.fuml.repository.Package>();
            this.artifactURIToPackagesMap.put(artifact.getURN(), artifactPackages);
        }
        artifactPackages.add(pkg);
        if (this.elementIdToElementMap.get(p.getXmiId()) != null) {
            throw new RepositorylException("found existing package reference, '" + p.getXmiId() + ".");
        }
        this.elementIdToElementMap.put(p.getXmiId(), pkg);
        String globalId = artifact.getURN() + "#" + p.getXmiId();
        if (this.elementIdToElementMap.get(globalId) != null) {
            throw new RepositorylException("found existing package reference, '" + globalId + "'");
        }
        this.elementIdToElementMap.put(globalId, pkg);
    }

    @Override
    public void mapPackageMerge(fUML.Syntax.Classes.Kernel.Package p, String sourcePackageXmiId) {
        PackageGraphNode source;
        PackageGraphNode target;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping package merge, " + p.qualifiedName + "->" + sourcePackageXmiId));
        }
        if ((target = this.packageIdToPackageMergeMap.get(p.getXmiId())) == null) {
            target = new PackageGraphNode(p.getXmiId());
            this.packageIdToPackageMergeMap.put(p.getXmiId(), target);
        }
        if ((source = this.packageIdToPackageMergeMap.get(sourcePackageXmiId)) == null) {
            source = new PackageGraphNode(sourcePackageXmiId);
            this.packageIdToPackageMergeMap.put(sourcePackageXmiId, source);
        }
        if (target.contains(source)) {
            throw new RepositorylException("found existing merge node (" + sourcePackageXmiId + ") in target, " + p.qualifiedName + " (" + p.getXmiId() + ")");
        }
        target.addNode(source);
    }

    @Override
    public void mapClass(fUML.Syntax.Classes.Kernel.Class_ clss, String currentPackageName, RepositoryArtifact artifact) {
        org.modeldriven.fuml.repository.model.Class_ repositoryClass = new org.modeldriven.fuml.repository.model.Class_(clss, artifact);
        this.mapClassifier(clss, repositoryClass, currentPackageName, artifact);
    }

    @Override
    public void mapClassifier(fUML.Syntax.Classes.Kernel.Classifier classifier, String currentPackageName, RepositoryArtifact artifact) {
        org.modeldriven.fuml.repository.model.Classifier repositoryClassifier = new org.modeldriven.fuml.repository.model.Classifier(classifier, artifact);
        this.mapClassifier(classifier, repositoryClassifier, currentPackageName, artifact);
    }

    private void mapClassifier(fUML.Syntax.Classes.Kernel.Classifier classifier, Classifier repositoryClassifier, String currentPackageName, RepositoryArtifact artifact) {
        String packageQualifiedName = null;
        packageQualifiedName = currentPackageName != null ? currentPackageName + "." + classifier.name : classifier.name;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping class, " + artifact.getURN() + "#" + packageQualifiedName));
        }
        if (this.qualifiedClassifierNameToClassifierMap.get(packageQualifiedName) != null) {
            throw new RepositorylException("found existing classifier by package qualified name, '" + packageQualifiedName + "' while mapping artifact, " + artifact.getURN());
        }
        this.qualifiedClassifierNameToClassifierMap.put(packageQualifiedName, repositoryClassifier);
        this.qualifiedClassifierNameToPackageNameMap.put(packageQualifiedName, currentPackageName);
        this.qualifiedElementNameToElementMap.put(packageQualifiedName, repositoryClassifier);
        if (artifact.getNamespaceURI() != null) {
            String artifactNamespaceQualifiedName = artifact.getNamespaceURI() + "#" + classifier.name;
            if (this.qualifiedClassifierNameToClassifierMap.get(artifactNamespaceQualifiedName) != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("found existing classifier by artifact qualified name, '" + artifactNamespaceQualifiedName + "' while mapping artifact, " + artifact.getURN()));
            }
            this.qualifiedClassifierNameToClassifierMap.put(artifactNamespaceQualifiedName, repositoryClassifier);
        } else {
            this.log.warn((Object)("missing artifact URI - could not map classifier '" + classifier.name + "' as externally referencable by artifact URI"));
        }
        if (this.elementIdToElementMap.get(classifier.getXmiId()) != null) {
            throw new RepositorylException("found existing classifier reference, '" + classifier.getXmiId() + "' while mapping artifact, " + artifact.getURN());
        }
        this.elementIdToElementMap.put(classifier.getXmiId(), repositoryClassifier);
        String globalId = artifact.getURN() + "#" + classifier.getXmiId();
        if (this.elementIdToElementMap.get(globalId) != null) {
            throw new RepositorylException("found existing classifier reference, '" + globalId + "' while mapping artifact, " + artifact.getURN());
        }
        this.elementIdToElementMap.put(globalId, repositoryClassifier);
        if (artifact.getNamespaceURI() != null) {
            String artifactNamespaceQualifiedName = artifact.getNamespaceURI() + "#" + classifier.name;
            if (this.elementIdToElementMap.get(artifactNamespaceQualifiedName) != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("found existing classifier, '" + artifactNamespaceQualifiedName + "' while mapping artifact, " + artifact.getURN()));
            }
            this.elementIdToElementMap.put(artifactNamespaceQualifiedName, repositoryClassifier);
        } else {
            this.log.warn((Object)("missing artifact URI - could not map element '" + classifier.name + "' as externally referencable by artifact URI"));
        }
        for (Generalization generalization : classifier.generalization) {
            List<Classifier> list = this.classifierIdToSpecializationClassifierMap.get(generalization.general.getXmiId());
            if (list == null) {
                list = new ArrayList<Classifier>();
                this.classifierIdToSpecializationClassifierMap.put(generalization.general.getXmiId(), list);
            }
            list.add(repositoryClassifier);
        }
    }

    @Override
    public void mapStereotype(org.modeldriven.fuml.repository.ext.Stereotype stereotype, String currentPackageName, RepositoryArtifact artifact) {
        String packageQualifiedName = null;
        packageQualifiedName = currentPackageName != null ? currentPackageName + "." + stereotype.name : stereotype.name;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping stereotype, " + artifact.getURN() + "#" + packageQualifiedName));
        }
        if (stereotype.getXmiNamespace() != null) {
            String xmiNamespaceQualifiedClassifierName = stereotype.getXmiNamespace() + "#" + stereotype.getClass().getSimpleName();
            Class_ stereotypeClassifier = (Class_)this.qualifiedClassifierNameToClassifierMap.get(xmiNamespaceQualifiedClassifierName);
            if (stereotypeClassifier != null && stereotypeClassifier instanceof Stereotype) {
                boolean foundExtension = false;
                for (fUML.Syntax.Classes.Kernel.Property prop : stereotypeClassifier.getDelegate().ownedAttribute) {
                    if (prop.name == null || !prop.name.startsWith("base_") || prop.association == null) continue;
                    Element assocElement = null;
                    assocElement = this.elementIdToElementMap.get(prop.association.getXmiId());
                    if (assocElement == null) {
                        throw new RepositorylException("could not find association reference, '" + prop.association.getXmiId() + "' while mapping artifact, " + artifact.getURN());
                    }
                    fUML.Syntax.Classes.Kernel.Element delegateElement = assocElement.getDelegate();
                    if (!(delegateElement instanceof org.modeldriven.fuml.repository.ext.Extension)) continue;
                    foundExtension = true;
                    org.modeldriven.fuml.repository.ext.Extension extension = (org.modeldriven.fuml.repository.ext.Extension)assocElement.getDelegate();
                    String targetClassAttributeName = prop.name;
                    try {
                        FumlObject targetElement = null;
                        try {
                            targetElement = (FumlObject)ReflectionUtils.invokePublicGetterOrField(stereotype, targetClassAttributeName);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        if (targetElement == null) {
                            throw new RepositorylException("no target element found linked to Stereotype instance, '" + stereotype.getXmiId() + "' by field '" + targetClassAttributeName + "' while mapping artifact, " + artifact.getURN());
                        }
                        List<Extension> list = this.elementToExtensionListMap.get(targetElement.getXmiId());
                        if (list == null) {
                            list = new ArrayList<Extension>();
                            this.elementToExtensionListMap.put(targetElement.getXmiId(), list);
                        }
                        list.add(new org.modeldriven.fuml.repository.model.Extension(extension, artifact));
                        List<Stereotype> elementStereotypeList = this.elementToStereotypeListMap.get(targetElement.getXmiId());
                        if (elementStereotypeList == null) {
                            elementStereotypeList = new ArrayList<Stereotype>();
                            this.elementToStereotypeListMap.put(targetElement.getXmiId(), elementStereotypeList);
                        }
                        org.modeldriven.fuml.repository.model.Stereotype repoStereotype = new org.modeldriven.fuml.repository.model.Stereotype(stereotype, artifact);
                        elementStereotypeList.add(repoStereotype);
                        List<Stereotype> classStereotypeList = this.classToStereotypeListMap.get(repoStereotype.getDelegate().getClass());
                        if (classStereotypeList == null) {
                            classStereotypeList = new ArrayList<Stereotype>();
                            this.classToStereotypeListMap.put(repoStereotype.getDelegate().getClass(), classStereotypeList);
                        }
                        classStereotypeList.add(repoStereotype);
                    }
                    catch (SecurityException e) {
                        throw new RepositorylException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RepositorylException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RepositorylException(e);
                    }
                }
                if (!foundExtension) {
                    throw new RepositorylException("could not find extension property for Stereotype, '" + stereotype.getXmiId() + "' while mapping artifact, " + artifact.getURN());
                }
            } else {
                if (this.qualifiedClassifierNameToClassifierMap.get(packageQualifiedName) != null) {
                    throw new RepositorylException("found existing classifier, '" + packageQualifiedName + "' while mapping artifact, " + artifact.getURN());
                }
                stereotypeClassifier = new org.modeldriven.fuml.repository.model.Stereotype(stereotype, artifact);
                this.qualifiedClassifierNameToClassifierMap.put(packageQualifiedName, stereotypeClassifier);
                this.qualifiedClassifierNameToPackageNameMap.put(packageQualifiedName, currentPackageName);
                this.qualifiedElementNameToElementMap.put(packageQualifiedName, stereotypeClassifier);
                if (artifact.getNamespaceURI() != null) {
                    String artifactNamespaceQualifiedName = artifact.getNamespaceURI() + "#" + stereotype.name;
                    if (this.qualifiedClassifierNameToClassifierMap.get(artifactNamespaceQualifiedName) != null && this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found existing classifier, '" + artifactNamespaceQualifiedName + "' while mapping artifact, " + artifact.getURN()));
                    }
                    this.qualifiedClassifierNameToClassifierMap.put(artifactNamespaceQualifiedName, stereotypeClassifier);
                } else {
                    this.log.warn((Object)("missing artifact URI - could not map classifier '" + stereotype.name + "' as externally referencable by artifact URI"));
                }
            }
        }
        if (this.elementIdToElementMap.get(stereotype.getXmiId()) != null) {
            throw new RepositorylException("found existing classifier reference, '" + stereotype.getXmiId() + "' while mapping artifact, " + artifact.getURN());
        }
        org.modeldriven.fuml.repository.model.Stereotype strtpe = new org.modeldriven.fuml.repository.model.Stereotype(stereotype, artifact);
        this.elementIdToElementMap.put(stereotype.getXmiId(), strtpe);
        String globalId = artifact.getURN() + "#" + stereotype.getXmiId();
        if (this.elementIdToElementMap.get(globalId) != null) {
            throw new RepositorylException("found existing classifier reference, '" + globalId + "' while mapping artifact, " + artifact.getURN());
        }
        this.elementIdToElementMap.put(globalId, strtpe);
        if (artifact.getNamespaceURI() != null) {
            String artifactNamespaceQualifiedName = artifact.getNamespaceURI() + "#" + stereotype.name;
            if (this.elementIdToElementMap.get(artifactNamespaceQualifiedName) != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("found existing classifier, '" + artifactNamespaceQualifiedName + "' while mapping artifact, " + artifact.getURN()));
            }
            this.elementIdToElementMap.put(artifactNamespaceQualifiedName, strtpe);
        } else {
            this.log.warn((Object)("missing artifact URI - could not map element '" + stereotype.name + "' as externally referencable by artifact URI"));
        }
    }

    @Override
    public void mapProperty(fUML.Syntax.Classes.Kernel.Classifier c, fUML.Syntax.Classes.Kernel.Property p, RepositoryArtifact artifact) {
        if (this.log.isDebugEnabled()) {
            if (c != null) {
                this.log.debug((Object)("mapping property, " + artifact.getURN() + "#" + c.name + "." + p.name));
            } else {
                this.log.debug((Object)("mapping property, " + artifact.getURN() + "#" + p.name));
            }
        }
        if (this.elementIdToElementMap.get(p.getXmiId()) != null) {
            throw new RepositorylException("found existing property reference, '" + p.getXmiId() + ".");
        }
        Property property = new Property(p, artifact);
        this.elementIdToElementMap.put(p.getXmiId(), property);
        String globalId = artifact.getURN() + "#" + p.getXmiId();
        if (this.elementIdToElementMap.get(globalId) != null) {
            throw new RepositorylException("found existing property reference, '" + globalId + ".");
        }
        this.elementIdToElementMap.put(globalId, property);
    }

    @Override
    public void mapPrimitiveType(PrimitiveType t, String currentPackageName, RepositoryArtifact artifact) {
        String[] uris;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping type, " + artifact.getURN() + "#" + currentPackageName + "." + t.getClass().getSimpleName()));
        }
        org.modeldriven.fuml.repository.model.Classifier classifier = new org.modeldriven.fuml.repository.model.Classifier(t, artifact);
        this.classifierNameToClassifierMap.put(t.name, classifier);
        this.qualifiedClassifierNameToClassifierMap.put(currentPackageName + "." + t.name, classifier);
        this.classifierNameToPackageNameMap.put(t.name, currentPackageName);
        this.qualifiedClassifierNameToPackageNameMap.put(currentPackageName + "." + t.name, currentPackageName);
        if (this.elementIdToElementMap.get(t.getXmiId()) != null) {
            throw new RepositorylException("found existing primitive type, '" + t.getXmiId() + ".");
        }
        this.elementIdToElementMap.put(t.getXmiId(), classifier);
        String globalId = artifact.getURN() + "#" + t.getXmiId();
        if (this.elementIdToElementMap.get(globalId) != null) {
            throw new RepositorylException("found existing primitive type, '" + globalId + ".");
        }
        this.elementIdToElementMap.put(globalId, classifier);
        this.elementIdToElementMap.put("pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml#" + t.name, classifier);
        for (String uri : uris = FumlConfiguration.getInstance().getSupportedNamespaceURIsForDomain(NamespaceDomain.UML)) {
            this.elementIdToElementMap.put(uri + "/" + "PrimitiveTypes.xmi" + "#" + t.name, classifier);
            this.elementIdToElementMap.put(uri + "/" + "uml.xml" + "#" + t.name, classifier);
        }
    }

    @Override
    public void mapDataType(DataType t, String currentPackageName, RepositoryArtifact artifact) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping datatype, " + artifact.getURN() + "#" + currentPackageName + "." + t.getClass().getSimpleName()));
        }
        org.modeldriven.fuml.repository.model.Classifier classifier = new org.modeldriven.fuml.repository.model.Classifier(t, artifact);
        if (t.name != null && currentPackageName != null) {
            this.qualifiedClassifierNameToClassifierMap.put(currentPackageName + "." + t.name, classifier);
            this.classifierNameToPackageNameMap.put(t.name, currentPackageName);
            this.qualifiedClassifierNameToPackageNameMap.put(currentPackageName + "." + t.name, currentPackageName);
        }
        if (this.elementIdToElementMap.get(t.getXmiId()) != null) {
            throw new RepositorylException("found existing datatype, '" + t.getXmiId() + ".");
        }
        this.elementIdToElementMap.put(t.getXmiId(), classifier);
        String globalId = artifact.getURN() + "#" + t.getXmiId();
        if (this.elementIdToElementMap.get(globalId) != null) {
            throw new RepositorylException("found existing datatype, '" + globalId + ".");
        }
        this.elementIdToElementMap.put(globalId, classifier);
        if (t.name != null) {
            if (artifact.getNamespaceURI() != null) {
                String artifactNamespaceQualifiedName = artifact.getNamespaceURI() + "#" + t.name;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("mapping datatype to artifact qualified name, " + artifactNamespaceQualifiedName));
                }
                if (this.qualifiedClassifierNameToClassifierMap.get(artifactNamespaceQualifiedName) != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("found existing datatype by artifact qualified name, '" + artifactNamespaceQualifiedName + "' while mapping artifact, " + artifact.getURN()));
                }
                this.qualifiedClassifierNameToClassifierMap.put(artifactNamespaceQualifiedName, classifier);
                if (this.elementIdToElementMap.get(artifactNamespaceQualifiedName) != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("found existing classifier, '" + artifactNamespaceQualifiedName + "' while mapping artifact, " + artifact.getURN()));
                }
                this.elementIdToElementMap.put(artifactNamespaceQualifiedName, classifier);
                String artifactNamespaceQualifiedUUID = artifact.getNamespaceURI() + "#" + t.getXmiId();
                if (this.elementIdToElementMap.get(artifactNamespaceQualifiedUUID) != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("found existing classifier, '" + artifactNamespaceQualifiedUUID + "' while mapping artifact, " + artifact.getURN()));
                }
                this.elementIdToElementMap.put(artifactNamespaceQualifiedUUID, classifier);
            } else {
                this.log.warn((Object)("missing artifact URI - could not map datatype '" + t.name + "' as externally referencable by artifact URI"));
            }
        }
    }

    @Override
    public void mapEnumeration(fUML.Syntax.Classes.Kernel.Enumeration e, String currentPackageName, RepositoryArtifact artifact) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping enumeration, " + currentPackageName + "." + e.name));
        }
        Enumeration classifier = new Enumeration(e, artifact);
        this.qualifiedClassifierNameToClassifierMap.put(currentPackageName + "." + e.name, classifier);
        this.classifierNameToPackageNameMap.put(e.name, currentPackageName);
        this.qualifiedClassifierNameToPackageNameMap.put(currentPackageName + "." + e.name, currentPackageName);
        if (this.elementIdToElementMap.get(e.getXmiId()) != null) {
            throw new RepositorylException("found existing enumeration, '" + e.getXmiId() + ".");
        }
        this.elementIdToElementMap.put(e.getXmiId(), classifier);
    }

    @Override
    public void mapEnumerationExternal(fUML.Syntax.Classes.Kernel.Enumeration e, String currentPackageName, RepositoryArtifact artifact) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping enumeration, " + currentPackageName + "." + e.name));
        }
        Enumeration classifier = new Enumeration(e, artifact);
        this.qualifiedClassifierNameToClassifierMap.put(currentPackageName + "." + e.name, classifier);
        this.qualifiedClassifierNameToPackageNameMap.put(currentPackageName + "." + e.name, currentPackageName);
        if (this.elementIdToElementMap.get(e.getXmiId()) != null) {
            throw new RepositorylException("found existing enumeration, '" + e.getXmiId() + ".");
        }
        this.elementIdToElementMap.put(e.getXmiId(), classifier);
    }

    @Override
    public void mapEnumerationLiteral(fUML.Syntax.Classes.Kernel.EnumerationLiteral literal, String currentPackageName, RepositoryArtifact artifact) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping enumeration literal, " + currentPackageName + "." + literal.name));
        }
        if (this.elementIdToElementMap.get(literal.getXmiId()) != null) {
            throw new RepositorylException("found existing enumeration literal, '" + literal.getXmiId() + ".");
        }
        EnumerationLiteral namedElement = new EnumerationLiteral(literal, artifact);
        this.elementIdToElementMap.put(literal.getXmiId(), namedElement);
    }

    @Override
    public void mapAssociation(Association assoc, String currentPackageName, RepositoryArtifact artifact) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mapping association, " + currentPackageName + "." + assoc.name));
        }
        if (this.elementIdToElementMap.get(assoc.getXmiId()) != null) {
            throw new RepositorylException("found existing association, '" + assoc.getXmiId() + ".");
        }
        org.modeldriven.fuml.repository.model.Classifier classifier = new org.modeldriven.fuml.repository.model.Classifier(assoc, artifact);
        this.elementIdToElementMap.put(assoc.getXmiId(), classifier);
    }

    public void mergePackage(fUML.Syntax.Classes.Kernel.Package target, fUML.Syntax.Classes.Kernel.Package source) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("merging package " + target.getHref() + " with " + source.getHref()));
        }
        for (PackageableElement sourceElement : source.packagedElement) {
            if (!(sourceElement instanceof fUML.Syntax.Classes.Kernel.Class_)) continue;
            fUML.Syntax.Classes.Kernel.Class_ sourceClass = (fUML.Syntax.Classes.Kernel.Class_)sourceElement;
            fUML.Syntax.Classes.Kernel.Class_ targetClass = this.findClass(target, sourceClass.name);
            if (targetClass != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("merging class (" + target.qualifiedName + ") " + targetClass.name + " with " + "(" + source.qualifiedName + ") " + sourceClass.name));
                }
                this.mergeClass(targetClass, sourceClass);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("adding class (" + source.qualifiedName + ") " + sourceClass.name + " to package " + target.qualifiedName));
            }
            target.packagedElement.add(sourceClass);
        }
    }

    private fUML.Syntax.Classes.Kernel.Class_ findClass(fUML.Syntax.Classes.Kernel.Package p, String name) {
        for (PackageableElement element : p.packagedElement) {
            if (!(element instanceof fUML.Syntax.Classes.Kernel.Class_)) continue;
            fUML.Syntax.Classes.Kernel.Class_ c = (fUML.Syntax.Classes.Kernel.Class_)element;
            if (!name.equals(c.name)) continue;
            return c;
        }
        return null;
    }

    private fUML.Syntax.Classes.Kernel.Property findProperty(fUML.Syntax.Classes.Kernel.Class_ c, String name) {
        for (fUML.Syntax.Classes.Kernel.Property p : c.ownedAttribute) {
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    public void mergeClass(fUML.Syntax.Classes.Kernel.Class_ target, fUML.Syntax.Classes.Kernel.Class_ source) {
        this.mergeProperties(target, source);
        this.mergeGeneralizations(target, source);
        target.general.clear();
        target.isAbstract = source.isAbstract;
        target.setIsAbstract(target.isAbstract);
    }

    public void mergeProperties(fUML.Syntax.Classes.Kernel.Class_ target, fUML.Syntax.Classes.Kernel.Class_ source) {
        for (fUML.Syntax.Classes.Kernel.Property sourceProp : source.ownedAttribute) {
            fUML.Syntax.Classes.Kernel.Property targetProp = this.findProperty(target, sourceProp.name);
            if (targetProp != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("merging property " + target.qualifiedName + "." + targetProp.name + " with " + source.qualifiedName + "." + sourceProp.name));
                }
                this.mergeProperty(targetProp, sourceProp);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("adding property " + source.qualifiedName + "." + sourceProp.name + " to " + target.name));
            }
            target.ownedAttribute.add(sourceProp);
        }
    }

    private void mergeGeneralizations(fUML.Syntax.Classes.Kernel.Class_ target, fUML.Syntax.Classes.Kernel.Class_ source) {
        for (Generalization sourceGeneralization : source.generalization) {
            boolean found = false;
            for (Generalization targetGeneralization : target.generalization) {
                if (!targetGeneralization.general.name.equals(sourceGeneralization.general.name)) continue;
                targetGeneralization.setXmiId(sourceGeneralization.getXmiId());
                found = true;
                break;
            }
            if (found) continue;
            target.generalization.add(sourceGeneralization);
        }
    }

    private void mergeGenerals(fUML.Syntax.Classes.Kernel.Class_ target, fUML.Syntax.Classes.Kernel.Class_ source) {
        for (fUML.Syntax.Classes.Kernel.Classifier sourceGeneral : source.general) {
            boolean found = false;
            for (fUML.Syntax.Classes.Kernel.Classifier targetGeneral : target.general) {
                if (!targetGeneral.name.equals(sourceGeneral.name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            target.general.add(sourceGeneral);
        }
    }

    protected void mergeProperty(fUML.Syntax.Classes.Kernel.Property target, fUML.Syntax.Classes.Kernel.Property source) {
        ValueSpecification sourceUpper;
        ValueSpecification sourceLower;
        target.typedElement = source.typedElement;
        ValueSpecification sourceDefault = source.defaultValue;
        if (sourceDefault != null) {
            ValueSpecification targetDefault = target.defaultValue;
            if (targetDefault == null) {
                target.defaultValue = source.defaultValue;
            } else {
                this.mergeValueSpecification(targetDefault, sourceDefault);
            }
        }
        if ((sourceLower = source.multiplicityElement.lowerValue) != null) {
            ValueSpecification targetLower = target.multiplicityElement.lowerValue;
            if (targetLower == null) {
                target.setLowerValue(sourceLower);
            } else {
                this.mergeValueSpecification(targetLower, sourceLower);
            }
        }
        if ((sourceUpper = source.multiplicityElement.lowerValue) != null) {
            ValueSpecification targetUpper = target.multiplicityElement.lowerValue;
            if (targetUpper == null) {
                target.setUpperValue(sourceUpper);
            } else {
                this.mergeValueSpecification(targetUpper, sourceUpper);
            }
        }
    }

    private void mergeValueSpecification(ValueSpecification target, ValueSpecification source) {
        String sourceValue;
        if (!target.getClass().equals(source.getClass()) && this.log.isDebugEnabled()) {
            this.log.warn((Object)("merging unequal value specification classes, " + source.getClass().getSimpleName() + " to " + target.getClass().getSimpleName()));
        }
        if ((sourceValue = this.getValue(source)) != null && sourceValue.trim().length() > 0) {
            this.setValue(target, sourceValue);
        }
    }

    private String getValue(ValueSpecification valueSpec) {
        if (LiteralString.class.isAssignableFrom(valueSpec.getClass())) {
            return ((LiteralString)valueSpec).value;
        }
        if (LiteralInteger.class.isAssignableFrom(valueSpec.getClass())) {
            return String.valueOf(((LiteralInteger)valueSpec).value);
        }
        if (LiteralBoolean.class.isAssignableFrom(valueSpec.getClass())) {
            return String.valueOf(((LiteralBoolean)valueSpec).value);
        }
        if (LiteralNull.class.isAssignableFrom(valueSpec.getClass())) {
            return null;
        }
        if (LiteralUnlimitedNatural.class.isAssignableFrom(valueSpec.getClass())) {
            int naturalValue = ((LiteralUnlimitedNatural)valueSpec).value.naturalValue;
            return naturalValue == -1 ? "*" : String.valueOf(naturalValue);
        }
        if (InstanceValue.class.isAssignableFrom(valueSpec.getClass())) {
            return valueSpec.name;
        }
        throw new IllegalArgumentException("expected literal or instance value");
    }

    private void setValue(ValueSpecification valueSpec, String value) {
        if (LiteralString.class.isAssignableFrom(valueSpec.getClass())) {
            ((LiteralString)valueSpec).value = value;
        } else if (LiteralInteger.class.isAssignableFrom(valueSpec.getClass())) {
            ((LiteralInteger)valueSpec).value = Integer.parseInt(value);
        } else if (LiteralBoolean.class.isAssignableFrom(valueSpec.getClass())) {
            ((LiteralBoolean)valueSpec).value = Boolean.parseBoolean(value);
        } else if (LiteralUnlimitedNatural.class.isAssignableFrom(valueSpec.getClass())) {
            UnlimitedNatural un = new UnlimitedNatural();
            un.naturalValue = value.equals("*") ? -1 : Integer.parseInt(value);
            ((LiteralUnlimitedNatural)valueSpec).value = un;
        } else if (InstanceValue.class.isAssignableFrom(valueSpec.getClass())) {
            valueSpec.setName(value);
        } else {
            throw new IllegalArgumentException("expected literal or instance value");
        }
    }
}

