/*
 * Initial version copyright 2008 Lockheed Martin Corporation, except
 * as stated in the file entitled Licensing-Information.
 *
 * Modifications:
 * Copyright 2009 Data Access Technologies, Inc.
 * Copyright 2013 Ivar Jacobson International SA
 *
 * Licensed under the Academic Free License version 3.0
 * (http://www.opensource.org/licenses/afl-3.0.php), except as stated
 * in the file entitled Licensing-Information.
 *
 * Contributors:
 *   MDS - initial API and implementation
 *   IJI
 *
 */
package org.modeldriven.fuml.test.load.profile;

import org.modeldriven.fuml.repository.ext.Stereotype;

import fUML.Syntax.Classes.Kernel.NamedElement;

public class Alias extends Stereotype {

	public static final String BASE__NAMED_ELEMENT = "base_NamedElement";
	/**
	 * Associates a given UML element with a physical data store element. Where
	 * the physical data store is a relational database, this tag contains the
	 * name of a relational database table, schema, column or other relational
	 * database element.
	 */
	public static final String PHYSICAL_NAME = "physicalName";
	/**
	 * Associates a given UML element with a data transfer or transient storage
	 * element. Where the transfer medium is XML, this tag contains the name of
	 * an XML element or attribute.
	 */
	public static final String LOCAL_NAME = "localName";
	/**
	 * Associates a given UML element with a business specific, human readable
	 * name.
	 */
	public static final String BUSINESS_NAME = "businessName";

	private NamedElement base_NamedElement;
	/**
	 * Associates a given UML element with a physical data store element. Where
	 * the physical data store is a relational database, this tag contains the
	 * name of a relational database table, schema, column or other relational
	 * database element.
	 */
	private String physicalName;
	/**
	 * Associates a given UML element with a data transfer or transient storage
	 * element. Where the transfer medium is XML, this tag contains the name of
	 * an XML element or attribute.
	 */
	private String localName;
	/**
	 * Associates a given UML element with a business specific, human readable
	 * name.
	 */
	private String businessName;

	public NamedElement getBase_NamedElement() {
		return this.base_NamedElement;
	}

	public void setBase_NamedElement(NamedElement value) {
		this.base_NamedElement = value;
	}

	public String getPhysicalName() {
		return this.physicalName;
	}

	public void setPhysicalName(String value) {
		this.physicalName = value;
	}

	public String getLocalName() {
		return this.localName;
	}

	public void setLocalName(String value) {
		this.localName = value;
	}

	public String getBusinessName() {
		return this.businessName;
	}

	public void setBusinessName(String value) {
		this.businessName = value;
	}
}
