/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.assembly;

import fUML.Syntax.Classes.Kernel.Comment;
import fUML.Syntax.Classes.Kernel.Element;
import fUML.Syntax.Classes.Kernel.NamedElement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlObject;
import org.modeldriven.fuml.assembly.AssemblerResults;
import org.modeldriven.fuml.assembly.AssemblyException;
import org.modeldriven.fuml.assembly.ElementAssembler;
import org.modeldriven.fuml.assembly.ElementAssemblerEventListener;
import org.modeldriven.fuml.assembly.ElementAssemblerResultsEvent;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.xmi.ModelSupport;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.stream.StreamNode;

public class ElementStubAssembler
implements AssemblerResults {
    public static String STUB_TOKEN = "#STUB#";
    private static Log log = LogFactory.getLog(ElementStubAssembler.class);
    private Repository metadata = Repository.INSTANCE;
    private ElementAssembler result;
    private ModelSupport modelSupport = new ModelSupport();
    private XmiNode target;
    private List<ElementAssemblerEventListener> eventListeners;

    private ElementStubAssembler() {
    }

    public ElementStubAssembler(XmiNode xmiRoot) {
        this.target = xmiRoot;
    }

    public void start() {
        this.assemble();
    }

    public void clear() {
        this.result = null;
    }

    private void assemble() {
        StreamNode eventNode = (StreamNode)this.target;
        Classifier classifier = this.modelSupport.findClassifier(this.target);
        if (classifier == null) {
            classifier = this.metadata.findClassifier("Activity");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("identified element '" + this.target.getLocalName() + "' as classifier, " + classifier.getName()));
        }
        ElementAssembler assembler = new ElementAssembler(this.target, null, (Class_)classifier, null);
        assembler.assembleElementClass();
        if (assembler.getTarget() instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)assembler.getTarget();
            namedElement.name = "unknown";
            String name = this.target.getAttributeValue(new QName("name"));
            if (name != null && name.trim().length() > 0) {
                namedElement.name = name;
            }
        } else {
            throw new AssemblyException("expected instance of NamedElement as target");
        }
        Comment comment = new Comment();
        comment.body = STUB_TOKEN;
        assembler.getTarget().ownedComment.add(comment);
        this.result = assembler;
        if (this.eventListeners != null) {
            for (ElementAssemblerEventListener listener : this.eventListeners) {
                listener.elementStubAssembled(new ElementAssemblerResultsEvent(this));
            }
        }
    }

    public void addErrorText(String text) {
        Comment comment = new Comment();
        comment.body = text;
        this.result.getTarget().ownedComment.add(comment);
    }

    public void addEventListener(ElementAssemblerEventListener eventListener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList<ElementAssemblerEventListener>();
        }
        this.eventListeners.add(eventListener);
    }

    public void removeEventListener(ElementAssemblerEventListener eventListener) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.remove(eventListener);
    }

    public Element getResult() {
        return this.result.getTarget();
    }

    public String getResultId() {
        return this.result.getXmiId();
    }

    @Override
    public List<FumlObject> getResults() {
        ArrayList<FumlObject> results = new ArrayList<FumlObject>();
        results.add(this.result.getTarget());
        return results;
    }

    @Override
    public List<String> getResultsXmiIds() {
        ArrayList<String> results = new ArrayList<String>();
        results.add(this.result.getXmiId());
        return results;
    }

    @Override
    public Element lookupResult(String xmiId) {
        if (this.result.getXmiId().equals(xmiId)) {
            return this.result.getTarget();
        }
        return null;
    }
}

