/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.assembly;

import fUML.Syntax.Classes.Kernel.PrimitiveType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlObject;
import org.modeldriven.fuml.assembly.AssemblerNode;
import org.modeldriven.fuml.assembly.AssemblerResults;
import org.modeldriven.fuml.assembly.AssemblerVisitor;
import org.modeldriven.fuml.assembly.ElementAssembler;
import org.modeldriven.fuml.assembly.ElementAssemblerEvent;
import org.modeldriven.fuml.assembly.ElementAssemblerEventListener;
import org.modeldriven.fuml.assembly.ElementAssemblerResultsEvent;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.xmi.AbstractXmiNodeVisitor;
import org.modeldriven.fuml.xmi.XmiExternalReferenceElement;
import org.modeldriven.fuml.xmi.XmiInternalReferenceElement;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiNodeVisitor;
import org.modeldriven.fuml.xmi.XmiNodeVisitorStatus;
import org.modeldriven.fuml.xmi.stream.StreamNode;
import org.modeldriven.fuml.xmi.validation.ErrorCode;
import org.modeldriven.fuml.xmi.validation.ErrorSeverity;
import org.modeldriven.fuml.xmi.validation.ValidationError;

public class ElementGraphAssembler
extends AbstractXmiNodeVisitor
implements XmiNodeVisitor,
AssemblerResults {
    private static Log log = LogFactory.getLog(ElementGraphAssembler.class);
    private Repository metadata = Repository.INSTANCE;
    private Map<XmiNode, ElementAssembler> xmiNodeToAssemblerMap = new HashMap<XmiNode, ElementAssembler>();
    private Map<String, ElementAssembler> resultsAssemblerMap = new HashMap<String, ElementAssembler>();
    private List<ElementAssembler> roots = new ArrayList<ElementAssembler>();
    private boolean assembleExternalReferences = true;
    private List<ElementAssemblerEventListener> eventListeners;

    private ElementGraphAssembler() {
    }

    public ElementGraphAssembler(XmiNode xmiRoot, boolean assembleExternalReferences) {
        super(xmiRoot);
        this.assembleExternalReferences = assembleExternalReferences;
    }

    public ElementGraphAssembler(XmiNode xmiRoot) {
        this(xmiRoot, true);
    }

    public void start() {
        this.xmiRoot.accept(this);
        for (ElementAssembler root : this.roots) {
            root.acceptBreadthFirst(new ReferenceFeatureAssembler());
        }
        for (ElementAssembler root : this.roots) {
            root.acceptBreadthFirst(new ElementLinker());
        }
        for (ElementAssembler root : this.roots) {
            root.associateDeferredGeneralizations();
        }
        for (ElementAssembler root : this.roots) {
            root.acceptBreadthFirst(new LibraryRegistration());
        }
        for (ElementAssembler root : this.roots) {
            root.acceptBreadthFirst(new NotifyEventListeners());
        }
        if (this.eventListeners != null) {
            for (ElementAssemblerEventListener listener : this.eventListeners) {
                listener.elementGraphAssembled(new ElementAssemblerResultsEvent(this));
            }
        }
    }

    public void clear() {
        this.xmiNodeToAssemblerMap.clear();
        this.classifierMap.clear();
        this.references.clear();
        this.resultsAssemblerMap.clear();
        this.roots.clear();
    }

    public void addEventListener(ElementAssemblerEventListener eventListener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList<ElementAssemblerEventListener>();
        }
        this.eventListeners.add(eventListener);
    }

    public void removeEventListener(ElementAssemblerEventListener eventListener) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.remove(eventListener);
    }

    @Override
    public void visit(XmiNode target, XmiNode sourceXmiNode, String sourceKey, XmiNodeVisitorStatus status, int level) {
        if (sourceXmiNode == null && "XMI".equals(target.getLocalName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ignoring root XMI node");
            }
            return;
        }
        XmiNode source = sourceXmiNode;
        if (source != null && "XMI".equals(source.getLocalName())) {
            source = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"ignoring source XMI node as parent");
            }
        }
        if (log.isDebugEnabled()) {
            if (source != null) {
                log.debug((Object)("visit: " + target.getLocalName() + " \t\tsource: " + source.getLocalName()));
            } else {
                log.debug((Object)("visit: " + target.getLocalName()));
            }
        }
        StreamNode eventNode = (StreamNode)target;
        Classifier classifier = this.findClassifier(target, source);
        if (classifier == null) {
            classifier = this.findClassifierFromImportAdapter(target);
        }
        if (classifier == null) {
            ValidationError error = new ValidationError(eventNode, ErrorCode.UNDEFINED_CLASS, ErrorSeverity.WARN);
            log.warn((Object)error.toString());
            String xmiType = target.getXmiType();
            if (xmiType != null && xmiType.length() > 0) {
                log.warn((Object)("ignoring element, " + xmiType));
            } else {
                log.warn((Object)("ignoring element, " + target.getLocalName()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("identified element '" + target.getLocalName() + "' as classifier, " + classifier.getName()));
        }
        this.classifierMap.put(target, classifier);
        if (classifier.getDelegate() instanceof PrimitiveType) {
            return;
        }
        boolean hasAttributes = eventNode.hasAttributes();
        if (this.isNotReferenceElement(target, classifier, hasAttributes)) {
            return;
        }
        ElementAssembler sourceAssembler = null;
        if (source != null) {
            sourceAssembler = this.xmiNodeToAssemblerMap.get(source);
        }
        if (sourceAssembler != null) {
            if (this.isInternalReferenceElement(eventNode, classifier, hasAttributes)) {
                sourceAssembler.addReference(new XmiInternalReferenceElement(eventNode, classifier));
                return;
            }
            if (this.isExternalReferenceElement(eventNode, classifier, hasAttributes)) {
                sourceAssembler.addReference(new XmiExternalReferenceElement(eventNode, classifier));
                return;
            }
        }
        ElementAssembler assembler = new ElementAssembler(target, source, (Class_)classifier, this.resultsAssemblerMap);
        assembler.setAssembleExternalReferences(this.assembleExternalReferences);
        assembler.assembleElementClass();
        assembler.assembleFeatures();
        this.resultsAssemblerMap.put(assembler.getXmiId(), assembler);
        this.xmiNodeToAssemblerMap.put(target, assembler);
        if (sourceAssembler != null) {
            sourceAssembler.add(assembler);
            assembler.setParentAssembler(sourceAssembler);
        }
        if (source == null) {
            this.roots.add(assembler);
        }
    }

    @Override
    public List<FumlObject> getResults() {
        ArrayList<FumlObject> results = new ArrayList<FumlObject>();
        for (String key : this.resultsAssemblerMap.keySet()) {
            ElementAssembler assembler = this.resultsAssemblerMap.get(key);
            results.add(assembler.getTargetObject());
        }
        return results;
    }

    @Override
    public List<String> getResultsXmiIds() {
        ArrayList<String> results = new ArrayList<String>();
        for (String key : this.resultsAssemblerMap.keySet()) {
            results.add(key);
        }
        return results;
    }

    @Override
    public FumlObject lookupResult(String xmiId) {
        return this.resultsAssemblerMap.get(xmiId).getTargetObject();
    }

    public boolean isAssembleExternalReferences() {
        return this.assembleExternalReferences;
    }

    public void setAssembleExternalReferences(boolean assembleExternalReferences) {
        this.assembleExternalReferences = assembleExternalReferences;
    }

    class NotifyEventListeners
    implements AssemblerVisitor {
        private Log log = LogFactory.getLog(LibraryRegistration.class);

        NotifyEventListeners() {
        }

        @Override
        public void begin(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
            ElementAssembler targetAssembler = (ElementAssembler)target;
            if (ElementGraphAssembler.this.eventListeners != null) {
                for (ElementAssemblerEventListener listener : ElementGraphAssembler.this.eventListeners) {
                    listener.elementAssembled(new ElementAssemblerEvent(targetAssembler.getTarget()));
                }
            }
        }

        @Override
        public void end(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
        }
    }

    class LibraryRegistration
    implements AssemblerVisitor {
        private Log log = LogFactory.getLog(LibraryRegistration.class);

        LibraryRegistration() {
        }

        @Override
        public void begin(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
            ElementAssembler targetAssembler = (ElementAssembler)target;
            ElementAssembler sourceAssembler = (ElementAssembler)source;
            if (this.log.isDebugEnabled()) {
                if (source != null) {
                    this.log.debug((Object)("begin: " + targetAssembler.getTargetClass().getSimpleName() + " \t\tsource: " + sourceAssembler.getTargetClass().getSimpleName()));
                } else {
                    this.log.debug((Object)("begin: " + targetAssembler.getTargetClass().getSimpleName()));
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("postassemble: (" + targetAssembler.getTargetClass().getSimpleName() + ")" + " " + targetAssembler.getPrototype().getName()));
            }
            targetAssembler.registerElement();
        }

        @Override
        public void end(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
        }
    }

    class ElementLinker
    implements AssemblerVisitor {
        private Log log = LogFactory.getLog(ElementLinker.class);

        ElementLinker() {
        }

        @Override
        public void begin(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
            ElementAssembler targetAssembler = (ElementAssembler)target;
            ElementAssembler sourceAssembler = (ElementAssembler)source;
            if (this.log.isDebugEnabled()) {
                if (source != null) {
                    this.log.debug((Object)("begin: " + targetAssembler.getTargetClass().getSimpleName() + " \t\tsource: " + sourceAssembler.getTargetClass().getSimpleName()));
                } else {
                    this.log.debug((Object)("begin: " + targetAssembler.getTargetClass().getSimpleName()));
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("postassemble: (" + targetAssembler.getTargetClass().getSimpleName() + ")" + " " + targetAssembler.getPrototype().getName()));
            }
            if (sourceAssembler != null) {
                targetAssembler.associateElement(sourceAssembler);
            }
        }

        @Override
        public void end(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
        }
    }

    class ReferenceFeatureAssembler
    implements AssemblerVisitor {
        private Log log = LogFactory.getLog(ReferenceFeatureAssembler.class);

        ReferenceFeatureAssembler() {
        }

        @Override
        public void begin(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
            ElementAssembler targetAssembler = (ElementAssembler)target;
            ElementAssembler sourceAssembler = (ElementAssembler)source;
            if (this.log.isDebugEnabled()) {
                if (source != null) {
                    this.log.debug((Object)("begin: " + targetAssembler.getTargetClass().getSimpleName() + " \t\tsource: " + sourceAssembler.getTargetClass().getSimpleName()));
                } else {
                    this.log.debug((Object)("begin: " + targetAssembler.getTargetClass().getSimpleName()));
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("postassemble: (" + targetAssembler.getTargetClass().getSimpleName() + ")" + " " + targetAssembler.getPrototype().getName()));
            }
            targetAssembler.assembleReferenceFeatures();
        }

        @Override
        public void end(AssemblerNode target, AssemblerNode source, String sourceKey, int level) {
        }
    }
}

