/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.config.NamespaceDomain;
import org.modeldriven.fuml.xmi.XmiException;

public class StreamContext {
    private static Log log = LogFactory.getLog(StreamContext.class);
    private Namespace[] namespaces;
    private Namespace defaultNamespace;
    private Map<NamespaceDomain, Namespace> namespaceDomainMap = new HashMap<NamespaceDomain, Namespace>();
    private Map<String, Namespace> namespaceLocalNameMap = new HashMap<String, Namespace>();
    private Map<String, Namespace> namespaceURIMap = new HashMap<String, Namespace>();

    private StreamContext() {
    }

    public StreamContext(XMLEvent root) {
        this.loadNamespaces(root);
        this.loadDefaultNamespace(root);
    }

    private void loadDefaultNamespace(XMLEvent root) {
        this.defaultNamespace = this.getUmlNamespace();
    }

    private void loadNamespaces(XMLEvent root) {
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        Iterator<Namespace> namespaceIter = root.asStartElement().getNamespaces();
        while (namespaceIter.hasNext()) {
            Namespace namespace = namespaceIter.next();
            list.add(namespace);
            QName name = namespace.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("root namespace: " + name.toString()));
            }
            String uri = namespace.getValue();
            if (!"xmlns".equals(name.getPrefix())) continue;
            this.namespaceLocalNameMap.put(name.getLocalPart(), namespace);
            this.namespaceURIMap.put(namespace.getNamespaceURI(), namespace);
            NamespaceDomain domain = FumlConfiguration.getInstance().findNamespaceDomain(uri);
            if (domain == null) {
                log.debug((Object)("could not find domain for namespace '" + uri + "' - mapping only by local name"));
                continue;
            }
            Namespace existing = this.namespaceDomainMap.get((Object)domain);
            if (existing != null) {
                throw new XmiException("multiple " + domain.value() + " namespaces (" + existing.getNamespaceURI() + ", " + namespace.getNamespaceURI() + ")");
            }
            this.namespaceDomainMap.put(domain, namespace);
        }
        if (this.getXmiNamespace() == null) {
            throw new XmiException(this.createNamespaceMessge(NamespaceDomain.XMI));
        }
        if (this.getUmlNamespace() == null) {
            throw new XmiException(this.createNamespaceMessge(NamespaceDomain.UML));
        }
        this.namespaces = new Namespace[list.size()];
        list.toArray(this.namespaces);
    }

    private String createNamespaceMessge(NamespaceDomain domain) {
        String[] supported = FumlConfiguration.getInstance().getSupportedNamespaceURIsForDomain(domain);
        String msg = "no supported " + domain.value().toUpperCase() + " namespace found - expected one of [";
        for (int i = 0; i < supported.length; ++i) {
            if (i > 0) {
                msg = msg + ", ";
            }
            msg = msg + supported[i];
        }
        msg = msg + "] (remedy: use supported namespace or modify configuration file '" + FumlConfiguration.getInstance().getActiveConfigFileName() + "')";
        return msg;
    }

    public Namespace getXmiNamespace() {
        return this.namespaceDomainMap.get((Object)NamespaceDomain.XMI);
    }

    public Namespace getUmlNamespace() {
        return this.namespaceDomainMap.get((Object)NamespaceDomain.UML);
    }

    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Namespace getEcoreNamespace() {
        return this.namespaceDomainMap.get((Object)NamespaceDomain.ECORE);
    }

    public Namespace getMagicdrawNamespace() {
        return this.namespaceDomainMap.get((Object)NamespaceDomain.MAGICDRAW);
    }

    public Namespace getNamespaceByLocalName(String localName) {
        return this.namespaceLocalNameMap.get(localName);
    }

    public Namespace getNamespaceByURI(String uri) {
        return this.namespaceURIMap.get(uri);
    }

    public Namespace[] getNamespaces() {
        return this.namespaces;
    }
}

